// 入力タイプによって画像を変えるスプライト
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        class InputSprite extends Sprite {
            constructor() {
                super(...arguments);
                this._list = [];
            }
            set(list) {
                this._list = list;
            }
            update() {
                super.update();
                this.refresh();
            }
            refresh() {
                const data = this._list[Iz.IO.getLastInputType()];
                if (!data)
                    return;
                this.setAtlas(data.atlasKey, data.frameKey);
            }
        }
        Life.InputSprite = InputSprite;
        class AtlasImageSprite extends Sprite {
            set(inputKey) {
                this._key = inputKey;
            }
            update() {
                super.update();
                this.refresh();
            }
            refresh() {
                const data = Life.AtlasImageList.get(this._key);
                if (!data)
                    return;
                this.setAtlas(data.atlasKey, data.frameKey);
            }
        }
        Life.AtlasImageSprite = AtlasImageSprite;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        class Footer extends Sprite {
            constructor() {
                super();
                this.setAtlas(Life.ATLAS_KEY_MENU_COMMON, Life.FRAME_KEY_MENU_COMMON_FOOTTER);
                this.create();
            }
            get text() {
                return this._text;
            }
            update() {
                super.update();
                this._text.relativeAnchor.enable = true;
                this._text.relativeAnchor.ratio.x = 1;
                this._text.relativeAnchor.ratio.y = 0.5;
                this._text.relativeAnchor.offset.x = -24;
                this._text.setTextAlign(1, 0.5);
            }
            create() {
                this.createText();
            }
            createText() {
                this._text = new Sprite_TextEx(this.width, this.height);
                this._text.setFontSetting(Life.FONT_KEY_MENU_FOOTER);
                this.addChild(this._text);
            }
        }
        Life.Footer = Footer;
        function createUIFooter() {
            const footer = new Footer();
            footer.y = Graphics.height - footer.height;
            return footer;
        }
        Life.createUIFooter = createUIFooter;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=InputSprite.js.map