/*:
 * @target MZ
 * @plugindesc メッセージウィンドウ、選択肢ウィンドウ
 * @author INAZUMA GAMES
 *
 * @help
 *
 *
 *
 *
 * @command PopupEnable
 * @text 吹き出し有効化
 * @desc 吹き出し有効化
 *
 * @arg id
 * @text キャラクターID
 * @desc 吹き出し対象 [0]このイベント [1～]指定したIDのイベント
 *
 *
 * @command PopupDisable
 * @text 吹き出し無効化
 * @desc 吹き出し無効化
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        Life.MessagePadding = 22;
        Life.PopupPadding = 12;
        const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MESSAGE);
        class Window_Heart extends Window_Base {
            initialize(rect, ...args) {
                super.initialize(rect, ...args);
                this.openness = 0;
                this._backSprite.alpha = 0;
                this._frameSprite.alpha = 0;
            }
            start() {
                this.updatePlacement();
                this.createContents();
                this.refresh();
            }
            setMessageWindow(win) {
                this._messageWindow = win;
            }
            setNameBoxWindow(win) {
                this._nameBoxWindow = win;
            }
            updatePlacement() {
                this.width = atlas.getFrame(Life.FRAME_KEY_MESSAGE_HEART_1).width + this.padding * 2;
                this.height = this.fittingHeight(1);
                //
                const messageWindow = this._messageWindow;
                const offsetX = -32;
                const offsetY = 20;
                if ($gameMessage.isRTL()) {
                    this.x = messageWindow.x + messageWindow.width - this.width;
                }
                else {
                    this.x = messageWindow.x + this._nameBoxWindow.width + offsetX;
                }
                if (messageWindow.y > 0) {
                    this.y = messageWindow.y - this.height;
                }
                else {
                    this.y = messageWindow.y + messageWindow.height;
                }
                this.y += offsetY;
            }
            refresh() {
                this.contents.clear();
                const level = Life.Status.getLikabilityLevel(this.getActorId());
                const frame = atlas.getFrame(`heart_${level}`);
                this.contents.blt(atlas.getBitmap(), frame.x, frame.y, frame.width, frame.height, 0, 0);
            }
            itemHeight() {
                return atlas.getFrame(Life.FRAME_KEY_MESSAGE_HEART_1).height;
            }
            getActorId() {
                const results = this._nameBoxWindow._name.match(/\N\[(\d+)\]/g);
                if (!results || results.length > 1) {
                    return 0;
                }
                const result = this._nameBoxWindow._name.match(/\N\[(\d+)\]/);
                if (!result) {
                    return 0;
                }
                return Number.parseInt(result[1]);
            }
        }
        Life.Window_Heart = Window_Heart;
        Life.Popup = {
            enable: false,
            id: 0,
        };
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        class Sprite_Interrupt extends Sprite {
            constructor() {
                const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MESSAGE);
                const frame = atlas.getFrame(Life.FRAME_KEY_MESSAGE_BYTHEWAY);
                const bitmap = new Bitmap(frame.width, frame.height);
                // bitmap.fillAll("red");
                super(bitmap);
                this.create();
                this.anchor.set(0.5, 0.5);
            }
            create() {
                this._bg = new Sprite();
                this._bg.setAtlas(Life.ATLAS_KEY_MESSAGE, Life.FRAME_KEY_MESSAGE_BYTHEWAY);
                this._bg.anchor.set(0.5, 0.5);
                this.addChild(this._bg);
                this._sprite1 = new Sprite();
                this._sprite1.anchor.set(0.5, 0.5);
                this.addChild(this._sprite1);
                this._sprite2 = new Sprite();
                this._sprite2.anchor.set(0.5, 0.5);
                this.addChild(this._sprite2);
                this._text = new Sprite_Text(this.width, this.height);
                this._text.setAlign("center");
                this._text.setFontSetting(Life.FONT_KEY_MESSAGE_WINDOW_BYTHEWAY);
                this._text.setText(Iz.Text.get("MESSAGE_WINDOW_BYTHEWAY"));
                this._text.x = -96;
                this._text.y = -36;
                this._text.setAlign("center");
                this.addChild(this._text);
            }
            start() {
                const isKeyboard = Iz.IO.getLastInputType() === Iz.IO.InputType.Keyboard;
                if (isKeyboard) {
                    this._sprite1.setAtlas(Life.ATLAS_KEY_COMMON, Life.FRAME_KEY_COMMON_KEYBOARD_Q);
                    this._sprite2.setAtlas(Life.ATLAS_KEY_COMMON, Life.FRAME_KEY_COMMON_KEYBOARD_E);
                }
                else {
                    this._sprite1.setAtlas(Life.ATLAS_KEY_COMMON, Life.FRAME_KEY_COMMON_PAD_LB);
                    this._sprite2.setAtlas(Life.ATLAS_KEY_COMMON, Life.FRAME_KEY_COMMON_PAD_RB);
                }
                this._sprite1.x = -84;
                this._sprite1.y = -4;
                this._sprite2.x = -54;
                this._sprite2.y = -4;
            }
            updateAlpha(alpha) {
                super.update();
                this._bg.alpha = alpha;
            }
            setEnable(flg) {
                if (flg) {
                    this.setColorTone([0, 0, 0, 0]);
                    this.scale.set(1, 1);
                }
                else {
                    this.setColorTone([-68, -68, -68, 0]);
                    this.scale.set(0.95, 0.95);
                }
            }
            isTriggeredTouch() {
                return this.isBeingTouched() && TouchInput.isTriggered();
            }
            isBeingTouched() {
                const touchPos = new Point(TouchInput.x, TouchInput.y);
                const localPos = this.worldTransform.applyInverse(touchPos);
                return this.hitTest(localPos.x, localPos.y);
            }
            hitTest(x, y) {
                const rect = new Rectangle(-this.anchor.x * this.width, -this.anchor.y * this.height, this.width, this.height);
                return rect.contains(x, y);
            }
        }
        Life.Sprite_Interrupt = Sprite_Interrupt;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 会話関連
(function (Iz) {
    var Life;
    (function (Life) {
        let _startTalkActor;
        function getTalkStaringActor() {
            return _startTalkActor;
        }
        Life.getTalkStaringActor = getTalkStaringActor;
        function setTalkStartingActor(actorId) {
            _startTalkActor = actorId;
        }
        Life.setTalkStartingActor = setTalkStartingActor;
        function initializeTalk() {
            _startTalkActor = 0;
        }
        Life.initializeTalk = initializeTalk;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeTalk();
    };
    const _Game_Map_setupStartingMapEvent = Game_Map.prototype.setupStartingMapEvent;
    Game_Map.prototype.setupStartingMapEvent = function () {
        const result = _Game_Map_setupStartingMapEvent.call(this);
        if (result) {
            const eventId = this._interpreter.eventId();
            const event = this.event(eventId);
            if (event instanceof Iz.GlobalMap.MB_NonPlayer) {
                Iz.Life.setTalkStartingActor(event.characterId);
            }
        }
        return result;
    };
})();
// メッセージウィンドウ
(() => {
    "use strict";
    let startMapEventId = 0;
    const MessageWindowCornerSize = 40;
    const PopupWindowCornerSize = 20;
    PluginManagerEx.registerCommand(document.currentScript, "PopupEnable", (args) => {
        Iz.Life.Popup.enable = true;
        Iz.Life.Popup.id = args.id;
    });
    PluginManagerEx.registerCommand(document.currentScript, "PopupDisable", (args) => {
        Iz.Life.Popup.enable = false;
        Iz.Life.Popup.id = 0;
    });
    const _Game_Map_setupStartingMapEvent = Game_Map.prototype.setupStartingMapEvent;
    Game_Map.prototype.setupStartingMapEvent = function () {
        const result = _Game_Map_setupStartingMapEvent.call(this);
        startMapEventId = this._interpreter.eventId();
        return result;
    };
    Scene_Message.prototype.messageWindowRect = function () {
        const atlas = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_MESSAGE);
        const frame = atlas.getFrame(Iz.Life.FRAME_KEY_MESSAGE_WINDOW_BASE);
        const x = Math.floor((Graphics.boxWidth - frame.width) / 2);
        return new Rectangle(x, 0, frame.width, frame.height);
    };
    const _Scene_Message_createAllWindows = Scene_Message.prototype.createAllWindows;
    Scene_Message.prototype.createAllWindows = function () {
        _Scene_Message_createAllWindows.call(this);
        this.createHeartWindow();
        const messageWindow = this._messageWindow;
        messageWindow.setHeartWindow(this._heartWindow);
        this._heartWindow.setMessageWindow(messageWindow);
        this._heartWindow.setNameBoxWindow(this._nameBoxWindow);
    };
    Scene_Message.prototype.createHeartWindow = function () {
        this._heartWindow = new Iz.Life.Window_Heart(new Rectangle(0, 0, 0, 0));
        this.addChild(this._heartWindow);
    };
    const _Window_Message_initialize = Window_Message.prototype.initialize;
    Window_Message.prototype.initialize = function (rect, ...args) {
        this._defaultWindowRect = rect;
        _Window_Message_initialize.call(this, rect, ...args);
        this.createTailSprite();
        this.createInterruptSprite();
        this._backSprite.alpha = 0;
    };
    Window_Message.prototype.updatePadding = function () {
        if (Iz.Life.Popup.enable) {
            this.padding = Iz.Life.PopupPadding;
        }
        else {
            this.padding = Iz.Life.MessagePadding;
        }
    };
    Window_Message.prototype._refreshFrame = function () {
        const drect = { x: 0, y: 0, width: this._width, height: this._height };
        // const srect = { x: 96, y: 0, width: 96, height: 96 };
        const isPopup = Iz.Life.Popup.enable;
        const m = isPopup ? PopupWindowCornerSize : MessageWindowCornerSize;
        const atlas = Iz.Atlas.getAtlas(isPopup ? Iz.Life.ATLAS_KEY_COMMON : Iz.Life.ATLAS_KEY_MESSAGE);
        const srect = atlas.getFrame(isPopup
            ? Iz.Life.FRAME_KEY_COMMON_FUKIDASI_BASE
            : Iz.Life.FRAME_KEY_MESSAGE_WINDOW_BASE);
        for (const child of this._frameSprite.children) {
            // @ts-ignore
            child.bitmap = atlas.getBitmap();
        }
        this._setRectPartsGeometry(this._frameSprite, srect, drect, m);
    };
    Window_Message.prototype._createFrameSprite = function () {
        this._frameSprite = new Sprite();
        for (let i = 0; i < 9; i++) {
            this._frameSprite.addChild(new Sprite());
        }
        this._container.addChild(this._frameSprite);
    };
    Window_Message.prototype._refreshPauseSign = function () {
        const atlas = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_MESSAGE);
        const frame = atlas.getFrame(Iz.Life.FRAME_KEY_MESSAGE_ARROW);
        this._pauseSignSprite.bitmap = atlas.getBitmap();
        this._pauseSignSprite.anchor.x = 1;
        this._pauseSignSprite.anchor.y = 1;
        this._pauseSignSprite.move(this.width, this.height);
        this._pauseSignSprite.setFrame(frame.x, frame.y, frame.width, frame.height);
        this._pauseSignSprite.alpha = 0;
    };
    Object.defineProperty(Window_Message.prototype, "innerWidth", {
        get: function () {
            if (Iz.Life.Popup.enable) {
                return Math.max(0, this._width - this._padding * 2);
            }
            return Math.max(0, this._width - this._padding * 2 - MessageWindowCornerSize * 2);
        },
        configurable: true,
    });
    Object.defineProperty(Window_Message.prototype, "opacity", {
        get: function () {
            return this._container.alpha * 255;
        },
        set: function (value) {
            this._container.alpha = value.clamp(0, 255 * Iz.System.windowOpacityRate()) / 255;
        },
        configurable: true,
    });
    // const _Window_Message_newLineX = Window_Message.prototype.newLineX;
    Window_Message.prototype.newLineX = function (textState) {
        if (Iz.Life.Popup.enable) {
            return Math.floor((this.width - this.innerWidth) / 2);
        }
        const faceExists = $gameMessage.faceName() !== "";
        const faceWidth = ImageManager.faceWidth;
        const margin = faceExists
            ? faceWidth + this.padding + MessageWindowCornerSize
            : this.padding + MessageWindowCornerSize;
        const res = textState?.rtl ? this.innerWidth - margin : margin;
        return res;
    };
    Window_Message.prototype.lineHeight = function () {
        const popupOffset = 8;
        return Iz.Life.Popup.enable ? this.contents.fontSize + popupOffset : 42;
    };
    Window_Message.prototype.resetTextColor = function () {
        const BG_SKELTON = 2;
        if (this._background === BG_SKELTON) {
            // TODO: 背景が透明の時の仕様
            // this.setFontSetting(Iz.Life.FONT_KEY_MESSAGE_WINDOW_SKELTON);
        }
        else if (Iz.Life.Popup.enable) {
            this.setFontSetting(Iz.Life.FONT_KEY_MESSAGE_WINDOW_POPUP);
        }
        else {
            this.setFontSetting(Iz.Life.FONT_KEY_MESSAGE_WINDOW);
        }
    };
    Window_Message.prototype.updatePlacement = function () {
        const goldWindow = this._goldWindow;
        this._positionType = $gameMessage.positionType();
        this.y = (this._positionType * (Graphics.boxHeight - this.height)) / 2;
        this.y += (1 - this._positionType) * 24;
        if (goldWindow) {
            goldWindow.y = this.y > 0 ? 0 : Graphics.boxHeight - goldWindow.height;
        }
    };
    Window_Message.prototype.setHeartWindow = function (win) {
        this._heartWindow = win;
    };
    Window_Message.prototype.createTailSprite = function () {
        this._tailSprite = new Sprite();
        this._tailSprite.setAtlas(Iz.Life.ATLAS_KEY_COMMON, Iz.Life.FRAME_KEY_COMMON_FUKIDASI_SIPPO);
        this._tailSprite.anchor.set(0.5, 0);
        this.addChild(this._tailSprite);
    };
    Window_Message.prototype.createInterruptSprite = function () {
        this._interruptSprite = new Iz.Life.Sprite_Interrupt();
        this._interruptSprite.x = Math.floor(this.width - this._interruptSprite.width / 2 - 80);
        this._interruptSprite.y = 6;
        this._interruptSprite.visible = false;
        this.addChild(this._interruptSprite);
    };
    const _Window_Message_startMessage = Window_Message.prototype.startMessage;
    Window_Message.prototype.startMessage = function () {
        _Window_Message_startMessage.call(this);
        this._heartWindow.start();
        this._nameBoxWindow.visible = !Iz.Life.Popup.enable;
        this._pauseSignCount = -10;
        this._pauseSignSprite.alpha = 0;
        this.resetLayout();
        this.resetFontSettings();
        this._interruptSprite.start();
    };
    const _Window_Message_resetFontSettings = Window_Message.prototype.resetFontSettings;
    Window_Message.prototype.resetFontSettings = function () {
        if (Iz.Life.Popup.enable) {
            this.resetTextColor();
        }
        else {
            _Window_Message_resetFontSettings.call(this);
        }
    };
    Window_Message.prototype.resetLayout = function () {
        // Layout setting
        if (Iz.Life.Popup.enable) {
            const offsetX = 0;
            const estimate = this.createEstimateTextState($gameMessage.allText());
            this.width = Math.floor(estimate.outputWidth + this.padding * 2 + PopupWindowCornerSize * 2 + offsetX);
            this.height = Math.floor(estimate.outputHeight + this.padding * 2);
            this._tailSprite.x = Math.floor(this.width / 2);
            this._tailSprite.y = this.height - 8;
        }
        else {
            this.x = this._defaultWindowRect.x;
            // this.y = this._defaultWindowRect.y;
            this.width = this._defaultWindowRect.width;
            this.height = this._defaultWindowRect.height;
            this.updatePlacement();
        }
        this._heartWindow.visible = this.visibleHeartWindow();
        this._nameBoxWindow.updatePlacement();
        this._heartWindow.updatePlacement();
    };
    Window_Message.prototype.visibleHeartWindow = function () {
        if (Iz.Life.Popup.enable) {
            return false;
        }
        const actorId = this._heartWindow.getActorId();
        return Iz.Life.Status.isPartnerOption(actorId);
    };
    const _Window_Message_update = Window_Message.prototype.update;
    Window_Message.prototype.update = function () {
        _Window_Message_update.call(this);
        const baseAlpha = this._background === 0 ? 1 : 0;
        const windowOpacity = baseAlpha * Iz.System.windowOpacityRate();
        if (!Iz.Life.Popup.enable) {
            this._container.alpha = windowOpacity;
        }
        else {
            this._container.alpha = 1;
        }
        this._heartWindow.openness = this.openness;
        this._heartWindow.alpha = windowOpacity;
        if (this.openness > 0 && Iz.Life.Popup.enable) {
            let targetEventId = 0;
            if (Iz.Life.Popup.id > 0) {
                targetEventId = Iz.Life.Popup.id;
            }
            else {
                targetEventId = startMapEventId;
            }
            const target = $gameMap.event(targetEventId);
            if (target) {
                this.x = target.screenX() - this.width / 2; // - target.getWidthForPopup()/2;
                const offsetY = -8;
                this.y = target.screenY() - this.height - target.getHeightForPopup() + offsetY;
            }
            // 調整用？
            this.x -= 4;
            if (Graphics.boxWidth !== Graphics.width) {
                this.x += (Graphics.boxWidth - Graphics.width) / 2 + 3;
            }
            if (Graphics.boxHeight !== Graphics.height) {
                this.y += (Graphics.boxHeight - Graphics.height) / 2 + 3;
            }
        }
        if (Iz.Life.Popup.enable && this.isOpen()) {
            this._tailSprite.visible = true;
            this._tailSprite.alpha = this._container.alpha;
        }
        else {
            this._tailSprite.visible = false;
        }
        this._nameBoxWindow._bgSprite.alpha = windowOpacity;
        if (this.isOpen()) {
            this._interruptSprite.visible = Iz.Life.Message.enableSuspend();
        }
        else {
            this._interruptSprite.visible = false;
        }
        this._interruptSprite.updateAlpha(this._container.alpha);
        if (this._interruptSprite.visible) {
            this._interruptSprite.setEnable(Iz.Life.Message.suspended());
        }
        this._autoModeButton.alpha = windowOpacity;
        this._skipButton.alpha = windowOpacity;
        this._configButton.alpha = windowOpacity;
        this._screenButton.alpha = windowOpacity;
        this.updatePauseSignForMessageWindow();
    };
    Window_Message.prototype.isEnableUpdateInputButtons = function () {
        if (Iz.Life.Popup.enable)
            return false;
        if (!this.isOpen())
            return false;
        if (this._background === 2)
            return false;
        return true;
    };
    Window_Message.prototype.updateInputButtons = function () {
        return false;
    };
    const _Window_Message_updateInput = Window_Message.prototype.updateInput;
    Window_Message.prototype.updateInput = function () {
        if (this.isEnableUpdateInputButtons()) {
            const res = this.updateInputButtons();
            if (res) {
                return true;
            }
        }
        return _Window_Message_updateInput.call(this);
    };
    Window_Message.prototype._updatePauseSign = function () { };
    Window_Message.prototype.updatePauseSignForMessageWindow = function () {
        const sprite = this._pauseSignSprite;
        const offsetX = -32;
        const offsetY = -20;
        sprite.x = this.width + offsetX;
        sprite.y = this.height + offsetY;
        if (!this.pause) {
            sprite.alpha = 0;
        }
        else if (this.isOpen()) {
            ++this._pauseSignCount;
            if (this._pauseSignCount <= 0) {
            }
            else if (this._pauseSignCount > 0 && this._pauseSignCount <= 5) {
                this._pauseSignSprite.alpha = this._pauseSignCount / 5;
            }
            else if (this._pauseSignCount > 5 && this._pauseSignCount <= 35) {
                this._pauseSignSprite.alpha = 1;
            }
            else if (this._pauseSignCount > 35 && this._pauseSignCount <= 40) {
                this._pauseSignSprite.alpha = (40 - this._pauseSignCount) / 5;
            }
            else if (this._pauseSignCount > 40 && this._pauseSignCount <= 70) {
                this._pauseSignSprite.alpha = 0;
            }
            else {
                this._pauseSignCount = 0;
                this._pauseSignSprite.alpha = 0;
            }
            this._pauseSignSprite.alpha *= Iz.System.windowOpacityRate();
        }
        sprite.visible = this.isOpen() && !Iz.Life.Popup.enable;
    };
    Window_Message.prototype.createEstimateTextState = function (text) {
        this.resetFontSettings();
        const textState = this.createTextState(text, 0, 0, 0);
        textState.drawing = false;
        // textState.startX = this.newLineX(textState);
        this.newPage(textState);
        this.processAllText(textState);
        textState.outputWidth += textState.startX;
        return textState;
    };
    const _Window_NameBox_initialize = Window_NameBox.prototype.initialize;
    Window_NameBox.prototype.initialize = function () {
        _Window_NameBox_initialize.call(this);
        this._backSprite.alpha = 0;
        this._frameSprite.alpha = 0;
        this._bgSprite = new Sprite();
        this._bgSprite.setAtlas(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_WINDOW_NAME);
        this._bgSprite.x = 8;
        this._bgSprite.y = 16;
        this._container.addChild(this._bgSprite);
    };
    Window_NameBox.prototype.refresh = function () {
        this._bgSprite.visible = this.windowWidth() > 0;
        const rect = this.baseTextRect();
        const atlas = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_MESSAGE);
        const frame = atlas.getFrame(Iz.Life.FRAME_KEY_MESSAGE_WINDOW_NAME);
        this.contents.clear();
        const offsetY = 15;
        const maxWidth = frame.width - 48;
        const size = this.textSizeEx(this._name);
        const x = (rect.width - size.width) / 2;
        this.drawTextEx(this._name, x, rect.y + offsetY, maxWidth);
    };
    Window_NameBox.prototype.resetTextColor = function () {
        this.setFontSetting(Iz.Life.FONT_KEY_MESSAGE_WINDOW_CHARACTER);
    };
    Window_NameBox.prototype.itemHeight = function () {
        const atlas = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_MESSAGE);
        const frame = atlas.getFrame(Iz.Life.FRAME_KEY_MESSAGE_WINDOW_NAME);
        return frame.height;
    };
    Window_NameBox.prototype.windowWidth = function () {
        if (this._name) {
            const atlas = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_MESSAGE);
            const frame = atlas.getFrame(Iz.Life.FRAME_KEY_MESSAGE_WINDOW_NAME);
            const padding = this.padding + this.itemPadding();
            return frame.width + padding * 2;
        }
        return 0;
    };
    Window_NameBox.prototype.updatePlacement = function () {
        this.width = this.windowWidth();
        this.height = this.windowHeight();
        // @ts-ignore
        const messageWindow = this._messageWindow;
        if ($gameMessage.isRTL()) {
            this.x = messageWindow.x + messageWindow.width - this.width;
        }
        else {
            this.x = messageWindow.x;
        }
        const offset = 24;
        if (messageWindow.y > 0) {
            this.y = messageWindow.y - this.height + offset;
        }
        else {
            this.y = messageWindow.y + messageWindow.height + offset;
        }
    };
    Scene_Map.prototype.createNameBoxWindow = function () {
        // @ts-ignore
        this._nameBoxWindow = new Window_NameBox();
        // WIndowLayerのステンシルテストの対象とならないようにする
        this.addChild(this._nameBoxWindow);
    };
    const _Sprite_Character_updateBitmap = Sprite_Character.prototype.updateBitmap;
    Sprite_Character.prototype.updateBitmap = function () {
        if (this.isImageChanged())
            this._imageChange = true;
        _Sprite_Character_updateBitmap.call(this);
        if (this._imageChange) {
            // @ts-ignore
            this.bitmap.addLoadListener(() => {
                // @ts-ignore
                const width = this.bitmap.width === 1 ? $gameMap.tileWidth() : this.patternWidth();
                const height = 
                // @ts-ignore
                this.bitmap.height === 1 ? $gameMap.tileHeight() : this.patternHeight();
                this._character.setSizeForMessagePopup(width, height);
            });
            this._imageChange = false;
        }
    };
    const _Game_CharacterBase_initMembers = Game_CharacterBase.prototype.initMembers;
    Game_CharacterBase.prototype.initMembers = function () {
        _Game_CharacterBase_initMembers.call(this);
        this.setSizeForMessagePopup(0, 0);
    };
    Game_CharacterBase.prototype.setSizeForMessagePopup = function (width, height) {
        this._characterSize = { width: width, height: height };
    };
    Game_CharacterBase.prototype.getWidthForPopup = function () {
        return this._characterSize.width;
    };
    Game_CharacterBase.prototype.getHeightForPopup = function () {
        return this._characterSize.height;
    };
})();
// 選択肢ウィンドウ
(() => {
    const atlas = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_MESSAGE);
    const baseFrame = atlas.getFrame(Iz.Life.FRAME_KEY_MESSAGE_SELECTBUTTON_INACTIVE);
    const targetFrame = atlas.getFrame(Iz.Life.FRAME_KEY_MESSAGE_SELECTBUTTON_ACTIVE);
    const _Window_ChoiceList_initialize = Window_ChoiceList.prototype.initialize;
    Window_ChoiceList.prototype.initialize = function (...args) {
        _Window_ChoiceList_initialize.call(this, ...args);
        // this._container.visible = false;
        this._contentsBackSprite.visible = false;
        this.cursorVisible = false;
        this._spriteTargetArrow = new Sprite();
        this._spriteTargetArrow.setAtlas(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_CHOICE_TARGET);
        this._spriteTargetArrow.anchor.y = 0.5;
        this._spriteTargetArrow.visible = false;
        this.addChild(this._spriteTargetArrow);
    };
    const _Window_ChoiceList_start = Window_ChoiceList.prototype.start;
    Window_ChoiceList.prototype.start = function () {
        _Window_ChoiceList_start.call(this);
        // NOTE:
        // initialize()内で this._container.visible = false;
        // をしていたら、女神の泉で白く表示されてしまう
        // (visibleがよくない？)　回避策でalphaを0にする
        this._container.alpha = 0;
    };
    Window_ChoiceList.prototype.reselect = function () {
        this.select(this._index);
        this.ensureCursorVisible(true);
    };
    Window_ChoiceList.prototype.maxChoiceWidth = function () {
        return baseFrame.width;
    };
    Window_ChoiceList.prototype.itemHeight = function () {
        return baseFrame.height;
    };
    Window_ChoiceList.prototype.resetTextColor = function () {
        this.setFontSetting(Iz.Life.FONT_KEY_CHOICE_LIST);
    };
    Window_ChoiceList.prototype.drawItem = function (index) {
        this.changePaintOpacity(this.isCommandEnabled(index));
        const frame = this.index() === index ? targetFrame : baseFrame;
        const rect = this.itemRect(index);
        this.contents.blt(atlas.getBitmap(), frame.x, frame.y, frame.width, frame.height, 0, rect.y);
        const linerect = this.itemLineRect(index);
        const width = this.textSizeEx(this.commandName(index)).width;
        const x = Math.floor((rect.width - width) / 2);
        this.drawTextEx(this.commandName(index), x, linerect.y, linerect.width);
    };
    const _Window_ChoiceList_select = Window_ChoiceList.prototype.select;
    Window_ChoiceList.prototype.select = function (index) {
        const needRefresh = this._index !== index;
        _Window_ChoiceList_select.call(this, index);
        if (needRefresh) {
            this.refresh();
        }
    };
    Window_ChoiceList.prototype._updateTargetArrow = function () {
        const i = Math.max(0, this.index());
        const rect = this.itemRect(i);
        const visibleMaxRect = this.itemRect(Math.max(0, this.topIndex() + this.maxPageRows() - 1));
        const rectY = rect.y >= visibleMaxRect.y ? visibleMaxRect.y : rect.y;
        this._spriteTargetArrow.x = -6;
        this._spriteTargetArrow.y = this.padding + rectY + Math.floor(rect.height / 2);
        const visibleFlg = this.isOpen() &&
            this._index >= 0 &&
            this._spriteTargetArrow.y >= 0 &&
            this._spriteTargetArrow.y <= this.height;
        this._spriteTargetArrow.visible = visibleFlg;
    };
    const _Window_ChoiceList_updateTransform = Window_ChoiceList.prototype.updateTransform;
    Window_ChoiceList.prototype.updateTransform = function () {
        this._updateTargetArrow();
        _Window_ChoiceList_updateTransform.call(this);
    };
    Window_ChoiceList.prototype.windowY = function () {
        const messageY = this._messageWindow.y;
        const frame = atlas.getFrame(Iz.Life.FRAME_KEY_MESSAGE_WINDOW_NAME);
        const offset = 16; // メッセージウィンドウと被らないように調整
        if (messageY >= Graphics.boxHeight / 2) {
            return messageY - this.windowHeight() - frame.height + offset;
        }
        return messageY + this._messageWindow.height + frame.height - offset;
    };
})();
// ウィンドウ非表示
(() => {
    "use strict";
    const _Window_Message_updateInputButtons = Window_Message.prototype.updateInputButtons;
    Window_Message.prototype.updateInputButtons = function () {
        if (this.isMessageOnly()) {
            if (!this.suspend) {
                if (this.isTriggeredScreen()) {
                    this.setScreen(false);
                    return true;
                }
            }
            else if (this._disableVisible) {
                if (this.isTriggeredScreen() || this.isTriggered()) {
                    this.setScreen(true);
                }
                return true;
            }
        }
        return _Window_Message_updateInputButtons.call(this);
    };
    Window_Message.prototype.isMessageOnly = function () {
        return !this.isAnySubWindowActive();
    };
    Window_Message.prototype.setSuspend = function (flg) {
        this.suspend = flg;
    };
    Window_Message.prototype.setVisibleWindows = function (flg) {
        // this.alpha = flg ? 1 : 0;
        // NOTE: alphaを0にすると女神さまの泉で白くなってしまう（パーティクルに起因？）
        this.visible = flg;
        this._nameBoxWindow.alpha = flg ? 1 : 0;
        this._heartWindow.visible = flg ? this.visibleHeartWindow() : false;
    };
    Window_Message.prototype.setScreen = function (flg) {
        if (flg) {
            this.setSuspend(false);
            this.setVisibleWindows(true);
            this._disableVisible = false;
        }
        else {
            this.setSuspend(true);
            this.setVisibleWindows(false);
            this._disableVisible = true;
        }
    };
    Window_Message.prototype.isTriggeredScreen = function () {
        if (Input.isTriggered(Iz.IO.KEY_NAME_MESSAGE_WINDOW))
            return true;
        if (TouchInput.isCancelled())
            return true;
        return false;
    };
})();
// メッセージウィンドウ中オプション画面
(() => {
    "use strict";
    const _Scene_Message_createAllWindows = Scene_Message.prototype.createAllWindows;
    Scene_Message.prototype.createAllWindows = function () {
        _Scene_Message_createAllWindows.call(this);
        const getRect = () => {
            const maxCommands = Iz.System.WindowOptionCommandMax;
            const n = Math.min(maxCommands);
            const ww = 400;
            const wh = this.calcWindowHeight(n, true);
            const wx = (Graphics.boxWidth - ww) / 2;
            const wy = (Graphics.boxHeight - wh) / 2;
            return new Rectangle(wx, wy, ww, wh);
        };
        this._optionsWindow = new Window_Options(getRect());
        this._optionsWindow.deactivate();
        this._optionsWindow.visible = false;
        this._messageWindow._optionsWindow = this._optionsWindow;
        this.addWindow(this._optionsWindow);
        this._memoryOptionWindow = new Iz.Life.MemoryOptionWindow();
        this._memoryOptionWindow.deactivate();
        this._memoryOptionWindow.closeImmediate();
        this._memoryOptionWindow.visible = false;
        this._messageWindow._memoryOptionWindow = this._memoryOptionWindow;
        this.addChild(this._memoryOptionWindow);
    };
    const _Window_Message_initialize = Window_Message.prototype.initialize;
    Window_Message.prototype.initialize = function (rect, ...args) {
        _Window_Message_initialize.call(this, rect, ...args);
        this._sequenceController = new Iz.Life.MessageSequenceController(this);
    };
    const _Window_Message_updateInputButtons = Window_Message.prototype.updateInputButtons;
    Window_Message.prototype.updateInputButtons = function () {
        this._sequenceController.update();
        if (this._sequenceController.isBusy()) {
            return true;
        }
        return _Window_Message_updateInputButtons.call(this);
    };
    const _Window_Message_isAnySubWindowActive = Window_Message.prototype.isAnySubWindowActive;
    Window_Message.prototype.isAnySubWindowActive = function () {
        if (this._optionsWindow.active) {
            return true;
        }
        if (this._memoryOptionWindow.isActive()) {
            return true;
        }
        return _Window_Message_isAnySubWindowActive.call(this);
    };
    const _Window_Message_terminateMessage = Window_Message.prototype.terminateMessage;
    Window_Message.prototype.terminateMessage = function () {
        _Window_Message_terminateMessage.call(this);
        this._sequenceController.suspend();
    };
})();
// オートモード、スキップ等
(function (Iz) {
    var Life;
    (function (Life) {
        class MessageWindowProxy {
            constructor() {
                this.initialize();
            }
            get autoModeDisabled() {
                return this._data.autoMode.disable;
            }
            set autoModeDisabled(value) {
                this._data.autoMode.disable = value;
            }
            get autoModeOn() {
                return this._data.autoMode.on;
            }
            set autoModeOn(value) {
                this._data.autoMode.on = value;
            }
            get autoModeCountMax() {
                return this._data.autoMode.count;
            }
            set autoModeCountMax(value) {
                this._data.autoMode.count = value;
            }
            get skipDisabled() {
                return this._data.skip.disable;
            }
            set skipDisabled(value) {
                this._data.skip.disable = value;
            }
            get skipOn() {
                return this._data.skip.on;
            }
            set skipOn(value) {
                this._data.skip.on = value;
            }
            get skipOnTriggeredButton() {
                return this._data.skip.onTriggeredButton;
            }
            set skipOnTriggeredButton(value) {
                this._data.skip.onTriggeredButton = value;
            }
            initialize() {
                this._data = {
                    autoMode: {
                        disable: false,
                        on: false,
                        count: 300,
                    },
                    skip: {
                        disable: false,
                        on: false,
                        onTriggeredButton: false,
                    },
                };
            }
        }
        function initializeMessageWindowData() {
            Life.MessageWindow.initialize();
            Life.MessageWindow.autoModeCountMax = $parameter.system.auto_mode_count_min;
        }
        Life.initializeMessageWindowData = initializeMessageWindowData;
        Life.MessageWindow = new MessageWindowProxy();
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeMessageWindowData();
    };
    const _Window_Message_initialize = Window_Message.prototype.initialize;
    Window_Message.prototype.initialize = function (rect, ...args) {
        _Window_Message_initialize.call(this, rect, ...args);
        this._footerContainer = new Sprite();
        this._footerContainer.x = 352;
        this._footerContainer.y = 160;
        this.addChild(this._footerContainer);
        this.createAutoButton();
        this.createSkipButton();
        this.createConfigButton();
        this.createScreenButton();
        this.resetAutoModeCount();
    };
    Window_Message.prototype.createAutoButton = function () {
        this._autoModeButton = new Iz.SwitchButton(Iz.createButtonBitmapData(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_AUTO_ON), Iz.createButtonBitmapData(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_AUTO_OFF));
        this._autoModeButton.setInputKey(Iz.IO.KEY_NAME_MESSAGE_AUTO);
        this._autoModeButton.x = 0;
        this._autoModeButton.visible = false;
        this._autoModeButton.enable = false;
        this._autoModeButton.setHandler((isOn) => {
            Iz.Life.MessageWindow.autoModeOn = isOn;
        });
        const icon = new Iz.Life.AtlasImageSprite();
        icon.set(Iz.IO.KEY_NAME_MESSAGE_AUTO);
        icon.x = 26;
        icon.y = 8;
        this._autoModeButton.addChild(icon);
        this._footerContainer.addChild(this._autoModeButton);
    };
    Window_Message.prototype.createSkipButton = function () {
        this._skipButton = Iz.ButtonCreator.createPushButton({
            images: {
                default: Iz.createButtonBitmapData(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_SPEED_OFF),
                hovered: Iz.createButtonBitmapData(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_SPEED_ON),
                pressed: Iz.createButtonBitmapData(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_SPEED_ON),
            },
            inputKey: Iz.IO.KEY_NAME_MESSAGE_SKIP,
        });
        this._skipButton.x = 164 * 1;
        const icon = new Iz.Life.AtlasImageSprite();
        icon.set(Iz.IO.KEY_NAME_MESSAGE_SKIP);
        icon.x = 26;
        icon.y = 8;
        this._skipButton.addChild(icon);
        this._footerContainer.addChild(this._skipButton);
    };
    Window_Message.prototype.createConfigButton = function () {
        this._configButton = Iz.ButtonCreator.createPushButton({
            images: {
                default: Iz.createButtonBitmapData(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_CONFIG_OFF),
                hovered: Iz.createButtonBitmapData(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_CONFIG_ON),
                pressed: Iz.createButtonBitmapData(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_CONFIG_ON),
            },
            inputKey: "",
        });
        this._configButton.x = 164 * 2;
        this._configButton.setHandler(() => {
            this._sequenceController.toConfig();
        });
        const icon = new Iz.Life.AtlasImageSprite();
        icon.set(Iz.IO.KEY_NAME_MESSAGE_CONFIG);
        icon.x = 26;
        icon.y = 8;
        this._configButton.addChild(icon);
        this._footerContainer.addChild(this._configButton);
    };
    Window_Message.prototype.createScreenButton = function () {
        this._screenButton = Iz.ButtonCreator.createPushButton({
            images: {
                default: Iz.createButtonBitmapData(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_SCREEN_OFF),
                hovered: Iz.createButtonBitmapData(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_SCREEN_ON),
                pressed: Iz.createButtonBitmapData(Iz.Life.ATLAS_KEY_MESSAGE, Iz.Life.FRAME_KEY_MESSAGE_SCREEN_ON),
            },
            inputKey: "",
        });
        this._screenButton.x = 164 * 3;
        this._screenButton.setHandler(() => {
            this.setScreen(false);
        });
        const icon = new Iz.Life.AtlasImageSprite();
        icon.set(Iz.IO.KEY_NAME_MESSAGE_SCREEN);
        icon.x = 26;
        icon.y = 8;
        this._screenButton.addChild(icon);
        this._footerContainer.addChild(this._screenButton);
    };
    const _Window_Message_initMembers = Window_Message.prototype.initMembers;
    Window_Message.prototype.initMembers = function () {
        _Window_Message_initMembers.call(this);
        this._flushTextCount = 0;
    };
    const _Window_Message_StartMessage = Window_Message.prototype.startMessage;
    Window_Message.prototype.startMessage = function () {
        _Window_Message_StartMessage.call(this);
        this.resetAutoModeCount();
        this._autoModeButton.enable = false;
        this._skipButton.enable = false;
        this._configButton.enable = false;
        this._screenButton.enable = false;
        this._flushTextCount = 0;
    };
    const _Window_Message_update = Window_Message.prototype.update;
    Window_Message.prototype.update = function () {
        Iz.Life.MessageWindow.skipOn = false;
        _Window_Message_update.call(this);
        const visibleButtons = !Iz.Life.Popup.enable && this.isOpen();
        this._autoModeButton.visible = visibleButtons;
        if (this._autoModeButton.isOn !== Iz.Life.MessageWindow.autoModeOn) {
            this._autoModeButton.isOn = Iz.Life.MessageWindow.autoModeOn;
        }
        this._skipButton.visible = visibleButtons;
        this._configButton.visible = visibleButtons;
        this._screenButton.visible = visibleButtons;
    };
    const _Window_Message_updateInputButtons = Window_Message.prototype.updateInputButtons;
    Window_Message.prototype.updateInputButtons = function () {
        const operatable = !this.suspend && this.isMessageOnly();
        const resAutoMode = this.updateInputAutoMode(operatable);
        if (resAutoMode)
            return true;
        const resSkip = this.updateInputSkip(operatable);
        if (resSkip)
            return true;
        const resConfig = this.updateConfig(operatable);
        if (resConfig)
            return true;
        const resScreen = this.updateScreen(operatable);
        if (resScreen)
            return true;
        return _Window_Message_updateInputButtons.call(this);
    };
    Window_Message.prototype.updateInputAutoMode = function (operatable) {
        const operatableAutoMode = operatable && !Iz.Life.MessageWindow.autoModeDisabled;
        this._autoModeButton.enable = operatableAutoMode;
        if (operatableAutoMode) {
            if (this._autoModeButton.isTriggered()) {
                const autoMode = !Iz.Life.MessageWindow.autoModeOn;
                Iz.Life.MessageWindow.autoModeOn = autoMode;
                this.resetAutoModeCount();
                return true;
            }
            if (Iz.Life.MessageWindow.autoModeOn) {
                this._autoModeCount++;
            }
        }
        return false;
    };
    Window_Message.prototype.updateInputSkip = function (operatable) {
        this._skipButton.enable = operatable;
        if (operatable) {
            if (this._skipButton.isTriggered()) {
                if (this._skipButton.isTouchTriggered()) {
                    Iz.Life.MessageWindow.skipOnTriggeredButton = true;
                }
                return true;
            }
        }
        return false;
    };
    Window_Message.prototype.updateConfig = function (operatable) {
        this._configButton.enable = operatable;
        if (operatable) {
            if (this._configButton.isTriggered()) {
                return true;
            }
        }
        return false;
    };
    Window_Message.prototype.updateScreen = function (operatable) {
        this._screenButton.enable = operatable;
        if (operatable) {
            if (this._screenButton.isTriggered()) {
                return true;
            }
        }
        return false;
    };
    const _Window_Message_isTriggered = Window_Message.prototype.isTriggered;
    Window_Message.prototype.isTriggered = function () {
        if (this.isTriggeredButtons()) {
            return false;
        }
        if (this._autoModeCount >= Iz.Life.MessageWindow.autoModeCountMax) {
            this.resetAutoModeCount();
            return true;
        }
        if (this.isPressedSkip()) {
            return true;
        }
        return _Window_Message_isTriggered.call(this);
    };
    Window_Message.prototype.resetAutoModeCount = function () {
        this._autoModeCount = 0;
    };
    const _Window_Message_flushTextState = Window_Message.prototype.flushTextState;
    Window_Message.prototype.flushTextState = function (textState) {
        this._flushTextCount += textState.buffer.length;
        _Window_Message_flushTextState.call(this, textState);
    };
    const _Window_Message_onEndOfText = Window_Message.prototype.onEndOfText;
    Window_Message.prototype.onEndOfText = function () {
        const MinFrame = $parameter.system.auto_mode_count_min;
        const TextCountFrame = this._flushTextCount * 9;
        const frame = Math.max(MinFrame, TextCountFrame);
        Iz.Life.MessageWindow.autoModeCountMax = frame;
        _Window_Message_onEndOfText.call(this);
    };
    Window_Message.prototype.isTriggeredButtons = function () {
        //
        if (!Iz.Life.MessageWindow.autoModeDisabled) {
            if (this._autoModeButton.isTriggered()) {
                return true;
            }
        }
        return false;
    };
    Window_Message.prototype.isPressedSkip = function () {
        if (Iz.Life.getFastDisabled())
            return false;
        if (Iz.Life.MessageWindow.skipDisabled)
            return false;
        if (this.suspend)
            return false;
        return Input.isPressedSkip() || Iz.Life.MessageWindow.skipOnTriggeredButton;
    };
    const _Window_Message_updateWait = Window_Message.prototype.updateWait;
    Window_Message.prototype.updateWait = function () {
        if (this.isPressedSkip()) {
            this._waitCount = 0;
            Iz.Life.MessageWindow.skipOn = true;
            Iz.Life.MessageWindow.autoModeOn = false;
        }
        return _Window_Message_updateWait.call(this);
    };
    const _Window_Message_startPause = Window_Message.prototype.startPause;
    Window_Message.prototype.startPause = function () {
        _Window_Message_startPause.call(this);
        if (this.isPressedSkip())
            this.startWait(2);
    };
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
        const skip = Iz.Life.MessageWindow.skipOn;
        Iz.Life.setEnableFastForwardTimes(skip);
        _Scene_Map_update.call(this);
    };
    const _AudioManager_fadeOutBgm = AudioManager.fadeOutBgm;
    AudioManager.fadeOutBgm = function (duration) {
        // NOTE:
        // 音が2重に鳴らないように対応
        if (Iz.Life.MessageWindow.skipOn) {
            this.stopBgm();
            return;
        }
        _AudioManager_fadeOutBgm.call(this, duration);
    };
    const _TouchInput_onRelease = TouchInput._onRelease;
    TouchInput._onRelease = function (x, y) {
        _TouchInput_onRelease.call(this, x, y);
        Iz.Life.MessageWindow.skipOnTriggeredButton = false;
    };
})();
(function (Iz) {
    var Life;
    (function (Life) {
        const SequenceState = {
            None: "none",
            Memory: "memory",
            Option: "option",
        };
        class MessageSequenceController {
            constructor(w) {
                this._window = w;
                this._behaviour = new Iz.RootSequence();
                {
                    const sequence = new NoneSequence(this);
                    this._behaviour.set(SequenceState.None, sequence, [
                        { dstSequence: SequenceState.Memory },
                        { dstSequence: SequenceState.Option },
                    ]);
                }
                {
                    const sequence = new MemorySequence(this);
                    this._behaviour.set(SequenceState.Memory, sequence, [
                        { dstSequence: SequenceState.None },
                        { dstSequence: SequenceState.Option },
                    ]);
                }
                {
                    const sequence = new OptionSequence(this);
                    this._behaviour.set(SequenceState.Option, sequence, [
                        { dstSequence: SequenceState.None },
                    ]);
                }
                this._currentState = SequenceState.None;
                this._behaviour.start({});
            }
            update() {
                this._behaviour.update();
            }
            suspend() {
                this._behaviour.suspend();
            }
            isBusy() {
                return this._currentState !== SequenceState.None;
            }
            getWindow() {
                return this._window;
            }
            getState() {
                return this._currentState;
            }
            setState(value) {
                this._currentState = value;
            }
            toConfig() {
                this._window.setSuspend(true);
                if (Life.MemoryUtil.isMemoryScene()) {
                    this._currentState = SequenceState.Memory;
                }
                else {
                    this._currentState = SequenceState.Option;
                }
            }
        }
        Life.MessageSequenceController = MessageSequenceController;
        class SequenceBase {
            constructor(accessor) {
                this._accessor = accessor;
            }
            get messageWindow() {
                return this._accessor.getWindow();
            }
            get state() {
                return this._accessor.getState();
            }
            set state(value) {
                this._accessor.setState(value);
            }
            toConfig() {
                this._accessor.toConfig();
            }
        }
        class NoneSequence extends SequenceBase {
            onStart(arg) {
                this.messageWindow.setSuspend(false);
            }
            onUpdate() {
                const w = this.messageWindow;
                if (w.isMessageOnly() && !w.suspend) {
                    if (Input.isTriggered(Iz.IO.KEY_NAME_MESSAGE_WINDOW_OPTION)) {
                        this.toConfig();
                        return true;
                    }
                }
                return this.state !== SequenceState.None;
            }
            onFinish() { }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: this.state,
                    output: {},
                };
            }
        }
        class MemorySequence extends SequenceBase {
            get memoryWindow() {
                return this.messageWindow._memoryOptionWindow;
            }
            onStart(arg) {
                this.memoryWindow.grid.setHandler(Iz.GridEventType.Ok, () => {
                    this.onOk();
                });
                this.memoryWindow.grid.setHandler(Iz.GridEventType.Cancel, () => {
                    this.onCancel();
                });
                this.memoryWindow.open(true);
                this.memoryWindow.activate();
                this.memoryWindow.visible = true;
            }
            onUpdate() {
                return this.state !== SequenceState.Memory;
            }
            onFinish() {
                this.memoryWindow.deactivate();
                this.memoryWindow.visible = false;
            }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: this.state,
                    output: {},
                };
            }
            onOk() {
                switch (this.memoryWindow.grid.index) {
                    case OptionType.Option:
                        SoundManager.playOk();
                        this.state = SequenceState.Option;
                        break;
                    case OptionType.ToMemoryRoom: {
                        SoundManager.playOk();
                        SceneManager.goto(Life.StoreScene);
                        const s = new Sprite(SceneManager.snap());
                        SceneManager.prepareNextScene(s);
                        break;
                    }
                    case OptionType.Cancel:
                        SoundManager.playCancel();
                        this.state = SequenceState.None;
                        break;
                }
            }
            onCancel() {
                SoundManager.playCancel();
                this.memoryWindow.deactivate();
                this.memoryWindow.close();
                this.state = SequenceState.None;
            }
        }
        class OptionSequence extends SequenceBase {
            get optionWindow() {
                return this.messageWindow._optionsWindow;
            }
            onStart(arg) {
                this.optionWindow.activate();
                this.optionWindow.visible = true;
                this.optionWindow.setHandler("cancel", () => {
                    this.toNone(true);
                });
            }
            onUpdate() {
                if (Input.isTriggered(Iz.IO.KEY_NAME_MESSAGE_WINDOW_OPTION)) {
                    this.toNone(false);
                }
                return this.state !== SequenceState.Option;
            }
            onFinish() {
                this.optionWindow.deactivate();
                this.optionWindow.visible = false;
            }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: this.state,
                    output: {},
                };
            }
            toNone(onCancel) {
                this.state = SequenceState.None;
            }
        }
        const OptionType = {
            Option: 0,
            ToMemoryRoom: 1,
            Cancel: 2,
        };
        const OptionTypeMax = 3;
        class MemoryOptionWindow extends Iz.WindowBase {
            constructor() {
                super(new Rectangle(0, 0, 0, 0), new Iz.EasingOpenness(Iz.Easing.easeOutQuint, Iz.Easing.easeOutQuint));
                this.createGrid();
                this.bitmap = new Bitmap(this._gridWindow.width, this._gridWindow.height);
                this.anchor.set(0.5, 0.5);
                this.position.set(Math.floor(Graphics.width / 2), Math.floor(Graphics.height / 2));
                this.opennessData.closeOffset = 0.2;
            }
            get grid() {
                return this._gridWindow.grid;
            }
            createGrid() {
                const frameWidth = 240;
                const frameHeight = 40;
                const option = {
                    emptyCellCreator: () => {
                        return new Iz.Life.CommonGridElement(frameWidth, frameHeight);
                    },
                    cellUpdater: (cell, index) => {
                        switch (index) {
                            case OptionType.Option:
                                cell.set(Iz.Text.get("MEMORY_SCENE_OPTION_CONFIG"));
                                break;
                            case OptionType.ToMemoryRoom:
                                cell.set(Iz.Text.get("MEMORY_SCENE_OPTION_MEMORY_ROOM"));
                                break;
                            case OptionType.Cancel:
                                cell.set(Iz.Text.get("MEMORY_SCENE_OPTION_CANCEL"));
                                break;
                        }
                    },
                    maxItems: OptionTypeMax,
                    frameWidth: frameWidth,
                    frameHeight: frameHeight,
                    col: 1,
                    row: OptionTypeMax,
                };
                const g = Iz.Life.createCommonGridWindow(option);
                g.relativeAnchor.enable = true;
                this._gridWindow = g;
                this.addChild(g);
            }
            update() {
                super.update();
                const cell = this.grid.cell();
                if (cell) {
                    cell.cursorSprite.alpha = this._gridWindow.cursorAlpha;
                }
            }
            activate() {
                this._gridWindow.activate();
            }
            deactivate() {
                this._gridWindow.deactivate();
            }
            isActive() {
                return this._gridWindow.isActive();
            }
        }
        Life.MemoryOptionWindow = MemoryOptionWindow;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=MessageWindow.js.map