/*:
 * @target MZ
 * @plugindesc 画面タッチ関連
 *
 * @help
 * タッチ対象のオブジェクトを管理する
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        function isAnyButtonPressedMap() {
            const scene = SceneManager._scene;
            if (scene instanceof Scene_Map) {
                return scene.isAnyButtonPressed();
            }
            return false;
        }
        Life.isAnyButtonPressedMap = isAnyButtonPressedMap;
        function isTouchOk() {
            return TouchInput.isTriggered() && !isAnyButtonPressedMap();
        }
        Life.isTouchOk = isTouchOk;
        function isTouchCancel() {
            return TouchInput.isCancelled() && !isAnyButtonPressedMap();
        }
        Life.isTouchCancel = isTouchCancel;
        function isInputOk() {
            return Input.isTriggered(Iz.IO.KEY_NAME_OK) || isTouchOk();
        }
        Life.isInputOk = isInputOk;
        function isInputCancel() {
            return Input.isTriggered(Iz.IO.KEY_NAME_CANCEL) || isTouchCancel();
        }
        Life.isInputCancel = isInputCancel;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    const _Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;
    Scene_Map.prototype.createDisplayObjects = function () {
        _Scene_Map_createDisplayObjects.call(this);
        this._touchObjects = [];
        this._touchObjects.push(this._hudWindow);
        this._touchObjects.push(this._footerWindow);
        this._touchObjects.push(this._chronusWindow);
        this._touchObjects.push(this._itemSlotWindow);
    };
    Scene_Map.prototype.isHitTouchObject = function () {
        return this._touchObjects.some((o) => {
            if (!o.visible || o.alpha === 0) {
                return false;
            }
            if (o instanceof Window_Base) {
                if (!o.active) {
                    return false;
                }
            }
            return o.isTouched();
        });
    };
    const _Scene_Map_isAnyButtonPressed = Scene_Map.prototype.isAnyButtonPressed;
    Scene_Map.prototype.isAnyButtonPressed = function () {
        const res = _Scene_Map_isAnyButtonPressed.call(this);
        if (res)
            return true;
        return this.isHitTouchObject();
    };
})();
//# sourceMappingURL=TouchControl.js.map