/*:
 * @target MZ
 * @plugindesc ウィンドウ関連の処理
 * @author INAZUMA GAMES
 *
 * @help
 *
 *
 *
 */
// 共通
(() => {
    "use strict";
    const FRAME_CORNER_SIZE = 20;
    const FRAME_SIZE = 108;
    Window.prototype._refreshFrame = function () {
        const atlasFrame = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_COMMON).getFrame(Iz.Life.FRAME_KEY_COMMON_FRAME);
        const drect = { x: 0, y: 0, width: this._width, height: this._height };
        const srect = atlasFrame;
        const m = FRAME_CORNER_SIZE;
        for (const child of this._frameSprite.children) {
            // @ts-ignore
            child.bitmap = this._windowskin;
        }
        this._setRectPartsGeometry(this._frameSprite, srect, drect, m);
    };
    Window_Base.prototype.loadWindowskin = function () {
        this.windowskin = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_COMMON).getBitmap();
    };
    Window_Base.prototype.updateBackOpacity = function () {
        // @ts-ignore
        const opacity = $gameSystem.windowOpacity();
        this.backOpacity = opacity;
        this._frameSprite.alpha = this._backSprite.alpha;
    };
    Window.prototype._refreshBack = function () {
        const m = FRAME_CORNER_SIZE;
        const w = Math.max(0, this._width - m * 2);
        const h = Math.max(0, this._height - m * 2);
        const sprite = this._backSprite;
        const tilingSprite = sprite.children[0];
        sprite.bitmap = this._windowskin;
        sprite.setFrame(0, 0, 0, 0);
        sprite.move(m, m);
        const TilingSize = FRAME_SIZE - FRAME_CORNER_SIZE * 2;
        sprite.scale.x = w / TilingSize;
        sprite.scale.y = h / TilingSize;
        // @ts-ignore
        tilingSprite.bitmap = this._windowskin;
        const atlasFrame = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_COMMON).getFrame(Iz.Life.FRAME_KEY_COMMON_FRAME);
        // @ts-ignore
        tilingSprite.setFrame(atlasFrame.x + FRAME_CORNER_SIZE, atlasFrame.y + FRAME_CORNER_SIZE, FRAME_CORNER_SIZE, FRAME_CORNER_SIZE);
        // @ts-ignore
        tilingSprite.move(0, 0, w, h);
        tilingSprite.scale.x = sprite.scale.x ? 1 / sprite.scale.x : 0;
        tilingSprite.scale.y = sprite.scale.y ? 1 / sprite.scale.y : 0;
        // sprite.setColorTone(this._colorTone);
    };
    Window.prototype._refreshCursor = function () {
        const atlasFrame = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_COMMON).getFrame(Iz.Life.FRAME_KEY_COMMON_BUTTON2);
        const drect = this._cursorRect.clone();
        const srect = atlasFrame;
        const m = 12;
        for (const child of this._cursorSprite.children) {
            // @ts-ignore
            child.bitmap = this._windowskin;
        }
        this._setRectPartsGeometry(this._cursorSprite, srect, drect, m);
    };
    Window.prototype._refreshArrows = function () {
        const w = this._width;
        const h = this._height;
        const p = 24;
        const q = p / 2;
        const frameDown = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_COMMON).getFrame(Iz.Life.FRAME_KEY_COMMON_ARROW_DOWN);
        const frameUp = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_COMMON).getFrame(Iz.Life.FRAME_KEY_COMMON_ARROW_UP);
        this._downArrowSprite.bitmap = this._windowskin;
        this._downArrowSprite.anchor.x = 0.5;
        this._downArrowSprite.anchor.y = 0.5;
        this._downArrowSprite.setFrame(frameDown.x, frameDown.y, frameDown.width, frameDown.height);
        this._downArrowSprite.move(w / 2, h - q);
        this._upArrowSprite.bitmap = this._windowskin;
        this._upArrowSprite.anchor.x = 0.5;
        this._upArrowSprite.anchor.y = 0.5;
        this._upArrowSprite.setFrame(frameUp.x, frameUp.y, frameUp.width, frameUp.height);
        this._upArrowSprite.move(w / 2, q);
    };
    Window_Selectable.prototype.drawItemBackground = function (index) {
        // 背景の矩形は描画しない
    };
})();
// padding関連
// 縦横個別設定を可能にする
(() => {
    "use strict";
    const _Window_initialize = Window.prototype.initialize;
    Window.prototype.initialize = function (...args) {
        _Window_initialize.call(this, ...args);
        this._pad = { x: this._padding, y: this._padding };
    };
    Window.prototype._updateClientArea = function () {
        const pad = this._pad;
        this._clientArea.move(pad.x, pad.y);
        this._clientArea.x = pad.x - this.origin.x;
        this._clientArea.y = pad.y - this.origin.y;
        if (this.innerWidth > 0 && this.innerHeight > 0) {
            this._clientArea.visible = this.isOpen();
        }
        else {
            this._clientArea.visible = false;
        }
    };
    Object.defineProperty(Window.prototype, "padding", {
        get: function () {
            return this._pad.x;
        },
        set: function (value) {
            this._padding = value;
            this._pad.x = value;
            this._pad.y = value;
            this._refreshAllParts();
        },
        configurable: true,
    });
    Object.defineProperty(Window.prototype, "pad", {
        get: function () {
            return this._pad;
        },
        set: function (value) {
            this._padding = value.x;
            this._pad.x = value.x;
            this._pad.y = value.y;
            this._refreshAllParts();
        },
        configurable: true,
    });
    Object.defineProperty(Window.prototype, "innerWidth", {
        get: function () {
            return Math.max(0, this._width - this._pad.x * 2);
        },
        configurable: true,
    });
    Object.defineProperty(Window.prototype, "innerHeight", {
        get: function () {
            return Math.max(0, this._height - this._pad.y * 2);
        },
        configurable: true,
    });
    Object.defineProperty(Window.prototype, "innerRect", {
        get: function () {
            return new Rectangle(this._pad.x, this._pad.y, this.innerWidth, this.innerHeight);
        },
        configurable: true,
    });
    Window_Selectable.prototype.hitTest = function (x, y) {
        if (this.innerRect.contains(x, y)) {
            const cx = this.origin.x + x - this.pad.x;
            const cy = this.origin.y + y - this.pad.y;
            const topIndex = this.topIndex();
            for (let i = 0; i < this.maxVisibleItems(); i++) {
                const index = topIndex + i;
                if (index < this.maxItems()) {
                    const rect = this.itemRect(index);
                    if (rect.contains(cx, cy)) {
                        return index;
                    }
                }
            }
        }
        return -1;
    };
})();
// itemPadding関連
(() => {
    "use strict";
    Window_Base.prototype.itemPadding = function () {
        if (this._itemPad) {
            return this._itemPad.x;
        }
        return 8;
    };
    Object.defineProperty(Window_Base.prototype, "itemPad", {
        get: function () {
            return this._itemPad ?? { x: 8, y: 0 };
        },
        set: function (value) {
            this._itemPad = value.x;
            this._itemPad.x = value.x;
            this._itemPad.y = value.y;
            // this._refreshAllParts();
        },
        configurable: true,
    });
    Window_Selectable.prototype.itemRectWithPadding = function (index) {
        const rect = this.itemRect(index);
        const padding = this.itemPad;
        rect.x += padding.x;
        rect.width -= padding.x * 2;
        rect.y += padding.y;
        rect.height -= padding.y * 2;
        return rect;
    };
})();
// 汎用Scroll
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        class ScrollBase extends Window_Selectable {
            constructor(option) {
                const maxCol = option.maxCol ?? 1;
                const colSpacing = option.colSpacing ?? 8;
                const rowSpacing = option.rowSpacing ?? 4;
                const itemPadding = option.itemPad ?? { x: 8, y: 8 };
                const pad = option.pad ?? { x: 12, y: 12 };
                const width = pad.x * 2 + maxCol * (option.itemContentWidth + itemPadding.x * 2 + colSpacing);
                const height = option.height;
                super(new Rectangle(0, 0, width, height));
                this._maxCol = maxCol;
                this._colSpacing = colSpacing;
                this._rowSpacing = rowSpacing;
                this._itemContentWidth = option.itemContentWidth;
                this._itemContentHeight = option.itemContentHeight;
                this._itemPad = itemPadding;
                this.pad = pad;
                this.opacity = 0;
                this.cursorVisible = false;
                this.createContents();
                this._refreshAllParts();
            }
            maxCols() {
                return this._maxCol;
            }
            itemWidth() {
                return this._itemContentWidth + this.itemPad.x * 2 + this._colSpacing;
            }
            itemHeight() {
                return this._itemContentHeight + this.itemPad.y * 2 + this._rowSpacing;
            }
            colSpacing() {
                return this._colSpacing;
            }
            rowSpacing() {
                return this._rowSpacing;
            }
            select(index) {
                super.select(index);
                this.refresh();
                this._onSelectHandler?.(index);
            }
            setSelectHandler(handler) {
                this._onSelectHandler = handler;
            }
            _refreshArrows() {
                const w = this.width;
                const h = this.height;
                this._upArrowSprite.setAtlas(Life.ATLAS_KEY_MENU_COMMON, Life.FRAME_KEY_MENU_COMMON_ARROW_UP_HOVER);
                this._upArrowSprite.anchor.x = 0.5;
                this._upArrowSprite.anchor.y = 0.5;
                this._upArrowSprite.move(w / 2, this._upArrowSprite.height / 2 + this.padding / 2);
                this._downArrowSprite.setAtlas(Life.ATLAS_KEY_MENU_COMMON, Life.FRAME_KEY_MENU_COMMON_ARROW_DOWN_HOVER);
                this._downArrowSprite.anchor.x = 0.5;
                this._downArrowSprite.anchor.y = 0.5;
                this._downArrowSprite.move(w / 2, h - this._downArrowSprite.height / 2 - this.padding / 2);
            }
        }
        Life.ScrollBase = ScrollBase;
        Object.defineProperty(ScrollBase.prototype, "cursorVisible", {
            get: function () {
                return false;
            },
            set: function (value) { },
            configurable: true,
        });
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// タイトル
(() => {
    "use strict";
    Window_TitleCommand.prototype.resetFontSettings = function () {
        this.contents.fontFace = $gameSystem.mainFontFace();
        this.contents.fontSize = 22;
        this.resetTextColor();
    };
})();
// 汎用名前入力
(function (Iz) {
    var Life;
    (function (Life) {
        function createEditWindow(actor, maxLength) {
            const rect = editWindowRect();
            const editWindow = new Window_NameEdit(rect);
            editWindow.setup(actor, maxLength);
            return editWindow;
        }
        Life.createEditWindow = createEditWindow;
        function editWindowRect() {
            const inputWindowHeight = calcWindowHeight(9, true);
            const padding = $gameSystem.windowPadding();
            const ww = 600;
            const wh = ImageManager.standardFaceHeight + padding * 2;
            const wx = (Graphics.boxWidth - ww) / 2;
            const wy = (Graphics.boxHeight - (wh + inputWindowHeight + 8)) / 2;
            return new Rectangle(wx, wy, ww, wh);
        }
        function calcWindowHeight(numLines, selectable) {
            if (selectable) {
                return Window_Selectable.prototype.fittingHeight(numLines);
            }
            return Window_Base.prototype.fittingHeight(numLines);
        }
        function createInputWindow(editWindow, onOk) {
            const rect = inputWindowRect(editWindow.x, editWindow.y, editWindow.width, editWindow.height);
            const inputWindow = new Window_NameInput(rect);
            inputWindow.setEditWindow(editWindow);
            inputWindow.setHandler("ok", onOk);
            return inputWindow;
        }
        Life.createInputWindow = createInputWindow;
        function inputWindowRect(x, y, w, h) {
            const wx = x;
            const wy = y + h + 8;
            const ww = w;
            const wh = calcWindowHeight(9, true);
            return new Rectangle(wx, wy, ww, wh);
        }
        class NameEditJp extends Sprite {
            constructor(length) {
                super();
                this.create(length);
            }
            create(length) {
                this.createWindows(length);
            }
            createWindows(length) {
                const actor = $gameActors.actor(100);
                const edit = createEditWindow(actor, length);
                const input = createInputWindow(edit, () => {
                    this._okHandler?.();
                });
                this._edit = edit;
                this._input = input;
                // @ts-ignore
                this.addChild(edit);
                this.addChild(input);
                edit.refresh();
            }
            editName() {
                return this._edit.name();
            }
            setActive(flg) {
                if (flg) {
                    this._input.activate();
                }
                else {
                    this._input.deactivate();
                }
            }
            clearName() {
                this._edit._index = 0;
                this._edit._name = "";
                this._edit.refresh();
            }
            setHandler(handler) {
                this._okHandler = handler;
            }
            onUpdate() { }
        }
        const NameEditVariableId = 12;
        class NameEditLang {
            editName() {
                return `${$gameVariables.value(NameEditVariableId)}`;
            }
            setActive(flg) {
                if (flg) {
                    this._interpreter = new Game_Interpreter();
                    this._interpreter._inputForm(455, 300, NameEditVariableId, 8, 0, 0, 50, 24, "$");
                }
            }
            clearName() { }
            setHandler(handler) {
                this._okHandler = handler;
            }
            onUpdate() {
                if (!this._interpreter)
                    return;
                if (this._interpreter._waitMode)
                    return;
                this._okHandler?.();
                this._interpreter = undefined;
                $gameVariables.setValue(NameEditVariableId, 0);
            }
        }
        class NameEditWindow extends Sprite {
            constructor(length) {
                super();
                this.create(length);
            }
            get bg() {
                return this._bg;
            }
            get editName() {
                return this._nameEdit.editName();
            }
            create(length) {
                this.createBg();
                this.createNameEdit(length);
            }
            createBg() {
                this._bg = new Sprite();
                const filter = new PIXI.filters.BlurFilter();
                this._bg.filters = [filter];
                this.addChild(this._bg);
            }
            createNameEdit(length) {
                if (Iz.System.i18nUtil.isJP()) {
                    const n = new NameEditJp(length);
                    this._nameEdit = n;
                    this.addChild(n);
                    return;
                }
                this._nameEdit = new NameEditLang();
                return;
            }
            update() {
                super.update();
                this._nameEdit.onUpdate();
            }
            setBg(bitmap) {
                this._bg.bitmap = bitmap;
            }
            setActive(flg) {
                this._nameEdit.setActive(flg);
            }
            clearName() {
                this._nameEdit.clearName();
            }
            setHandler(handler) {
                this._nameEdit.setHandler(handler);
            }
        }
        Life.NameEditWindow = NameEditWindow;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=WindowEx.js.map