(function(){
  function PixelateFilter(size) {
    size = size || 10;
    const fragmentSrc = `
      varying vec2 vTextureCoord;
      uniform sampler2D uSampler;
      uniform float size;
      void main(void){
          vec2 coord = vTextureCoord;
          coord = floor(coord * size) / size;
          gl_FragColor = texture2D(uSampler, coord);
      }
    `;
    PIXI.Filter.call(this, null, fragmentSrc, { size: size });
  }

  PixelateFilter.prototype = Object.create(PIXI.Filter.prototype);
  PixelateFilter.prototype.constructor = PixelateFilter;

  Object.defineProperty(PixelateFilter.prototype, 'size', {
    get: function() {
      return this.uniforms.size;
    },
    set: function(value) {
      this.uniforms.size = value;
    }
  });

  // PIXI.filters に登録
  PIXI.filters = PIXI.filters || {};
  PIXI.filters.PixelateFilter = PixelateFilter;
})();
