//=============================================================================
// Change_Face_Right_MZ.js
//   Last update: 2024/09/22
//=============================================================================
// 更新っぽいもの
// 
// 2024/09/22 [v0.1.0]
// 初版

/*:
 * @target MZ
 * 
 * @plugindesc
 * [v0.1.0] Change!! Face_Right MZ.
 * 
 * @author Diamond
 * 
 * @help
 * Diamond use ruby, not use Java Script!!
 * Please use Ruby!! and RPG Tkool XP/VX/VX Ace.
 * ## Plugin command
 *
 * FaceAlign left/right # change of face align
 * 
 * @url https://diamond.iza-yoi.net/
 * 
 * @command FaceAlign
 * @text ????
 * @desc
 * English is not supported.
 * Please Use Japanese!!
 * 
 * @arg arg1
 * @text ????
 * @default left
 * @type select
 * @option left
 * @option right
 * @desc
 * English is not supported.
 * Please Use Japanese!!
 */

/*:ja
 * @target MZ
 * 
 * @plugindesc
 * [v0.1.0] 真（チェンジ！！）顔グラを右に MZ
 * 
 * @author 貪藻矢射妥←
 *
 * @help
 * Window_Messageで使用する顔グラフィック（とネームボックスウィンドウ）を
 * 右側に表示できるようにします。
 * 
 * なお $gameMessage.isRTL() がtrueになれば本プラグインなしでも右側表示が
 * 出来るのですが、やり方は不明です。
 * 
 * ※本プラグインはプラグインコマンドのみとなります。
 * 
 * ## プラグインコマンド
 *
 * 顔グラ位置変更 left/right # 顔グラ位置変更を変更
 *
 * Java ScriptよりもRubyを使いたい！ by 貪藻矢射妥←
 * 
 * @url https://diamond.iza-yoi.net/
 * 
 * @command FaceAlign
 * @text 顔グラ位置変更
 * @desc 顔グラフィックの表示位置を変更します
 * 
 * @arg arg1
 * @text 第一引数
 * @default left
 * @type select
 * @option left
 * @option right
 * @desc 顔グラフィックの表示位置を選んでください。
 */

var OuterFlg = OuterFlg || {};

(() => {

'use strict';

OuterFlg.imported = OuterFlg.imported || {};
OuterFlg.imported['Face_Right'] = true;

//var pluginParams = PluginManager.parameters('Change_Face_Right_MZ');
//var hogehoge     = pluginParams['hogehoge'] || '';

//var ParamsEx          = PluginManagerEx.createParameter(document.currentScript);
//var ParamsEx_hogehoge = ParamsEx['hogehogeStruct'];


//-----------------------------------------------------------------------------
// Game_System

const _Change_Face_Right_System_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function() {
    // 元の処理を呼び戻す
    _Change_Face_Right_System_initialize.call(this, arguments);
    
    // 追加
    this._face_align = "left";
};


//-----------------------------------------------------------------------------
// Plugin commands

PluginManager.registerCommand('Change_Face_Right_MZ', 'FaceAlign', function (args) {
    $gameSystem._face_align = args.arg1;
});


//-----------------------------------------------------------------------------
// Window_Message

Window_Message.prototype.drawMessageFace = function() {
    const faceName  = $gameMessage.faceName();
    const faceIndex = $gameMessage.faceIndex();
    const width     = ImageManager.faceWidth;
    const height    = this.innerHeight;
    var   x         = 4;
    if ( $gameMessage.isRTL() || $gameSystem._face_align === "right") {
        x = this.innerWidth - width - 4
    }
    this.drawFace(faceName, faceIndex, x, 0, width, height);
};

Window_Message.prototype.newLineX = function(textState) {
    const faceExists = $gameMessage.faceName() !== "";
    const faceWidth  = ImageManager.faceWidth;
    const spacing    = 20;
    var   margin     = 4;
    if ( faceExists && $gameSystem._face_align === "left" ) {
        margin = faceWidth + spacing
    }
    return textState.rtl ? this.innerWidth - margin : margin;
};


//-----------------------------------------------------------------------------
// Window_NameBox

Window_NameBox.prototype.updatePlacement = function() {
    this.width  = this.windowWidth();
    this.height = this.windowHeight();
    const messageWindow = this._messageWindow;
    if ( $gameMessage.isRTL() || $gameSystem._face_align === "right" ) {
        this.x = messageWindow.x + messageWindow.width - this.width;
    } else {
        this.x = messageWindow.x;
    }
    if (messageWindow.y > 0) {
        this.y = messageWindow.y - this.height;
    } else {
        this.y = messageWindow.y + messageWindow.height;
    }
};


})();
