﻿/*:
 * @plugindesc Change face graphic size on start or in game.
 * @author faida
 *
 * @help
 *
 * Plugin Command:
 *   FaceSize changeWidth 144  # Change face graphic width to 144.
 *   FaceSize ChangeHeight 144 # Change face graphic height to 144.
 * 
 * @param intFaceWidth
 * @desc faceWidth on start.
 * @default 144
 *
 * @param intFaceHeight
 * @desc faceHeight on start.
 * @default 144
 *
 */

/*:ja
 * @plugindesc 顔グラのサイズを変えることができます。
 * @author faida
 *
 * @help
 *
 * プラグインコマンド:
 *   FaceSize changeWidth 144  # 顔グラ幅を144にする
 *   FaceSize changeHeight 144 # 顔グラ高さを144にする
 *
 * @param intFaceWidth
 * @desc 顔グラの幅の初期値
 * @default 144
 *
 * @param intFaceHeight
 * @desc 顔グラの高さの初期値
 * @default 144
 *
 */

(function() {
  var Game_Interpreter_fai_faceWidthHeight_pluginCommand = Game_Interpreter.prototype.pluginCommand
  Game_Interpreter.prototype.pluginCommand = function(command, args) {
    Game_Interpreter_fai_faceWidthHeight_pluginCommand.call(this, command, args)
    if (command === 'FaceSize') {
      switch (args[0]) {
      case 'changeWidth':
        $gameSystem.changeFaceWidth(Number(args[1]))
        break
      case 'changeHeight':
        $gameSystem.changeFaceHeight(Number(args[1]))
        break
      }
    }
  };

  var Game_System_fai_faceWidthHeight_initialize = Game_System.prototype.initialize
  Game_System.prototype.initialize = function() {
    Game_System_fai_faceWidthHeight_initialize.call(this)
    parameters = PluginManager.parameters('FaceWidthHeight')
    this._faceWidth = Number(parameters['intFaceWidth'])
    this._faceHeight = Number(parameters['intFaceHeight'])
  };

  Game_System.prototype.changeFaceWidth = function(value) {
    this._faceWidth = value
    Window_Base._faceWidth = this._faceWidth
  }

  Game_System.prototype.changeFaceHeight = function(value) {
    this._faceHeight = value
    Window_Base._faceHeight = this._faceHeight
  }

  var Game_System_fai_faceWidthHeight_onAfterLoad = Game_System.prototype.onAfterLoad
  Game_System.prototype.onAfterLoad = function() {
    Game_System_fai_faceWidthHeight_onAfterLoad.call(this)
    Window_Base._faceWidth = this._faceWidth
    Window_Base._faceHeight = this._faceHeight
  };

  parameters = PluginManager.parameters('FaceWidthHeight')
  Window_Base._faceWidth = Number(parameters['intFaceWidth'])
  Window_Base._faceHeight = Number(parameters['intFaceHeight'])

})();