/*:
 * @target MZ
 * @plugindesc [v1.1.0] 選択肢で左右キー1回だけキャンセル + 発動時に指定のコモンイベントを実行
 * @author ChatGPT
 *
 * @param DefaultCommonEventId
 * @text 既定コモンイベント
 * @type common_event
 * @desc 左右キャンセルが発動したときに実行するコモンイベント（未指定=0で無効）
 * @default 0
 *
 * @command EnableOneTimeCancelByLR
 * @text 左右キャンセル1回有効
 * @desc 次に表示される選択肢でのみ、左右キーによるキャンセルを許可します。
 *
 * @command SetCancelCommonEvent
 * @text 次回キャンセル用コモン設定
 * @desc 次に発動する左右キャンセルに限り、実行するコモンイベントを一時的に上書きします（1回きり）。
 * @arg commonEventId
 * @text コモンイベント
 * @type common_event
 * @default 0
 */

(() => {
  const pluginName = "LRChoiceEscape";
  const params = PluginManager.parameters(pluginName);
  const DEFAULT_CE_ID = Number(params.DefaultCommonEventId || 0) || 0;

  let _enableLeftRightCancelOnce = false;  // 次の選択肢でのみLRキャンセル有効
  let _appliedToCurrentChoice = false;     // 既に次の選択肢へ適用したか
  let _nextCommonEventId = 0;              // 「次の一回だけ」上書きするCE

  // 既存：次に出る選択肢1回だけLRキャンセル有効化
  PluginManager.registerCommand(pluginName, "EnableOneTimeCancelByLR", () => {
    _enableLeftRightCancelOnce = true;
    _appliedToCurrentChoice = false;
  });

  // 追加：次回の左右キャンセルで実行するコモンイベントを1回だけ上書き
  PluginManager.registerCommand(pluginName, "SetCancelCommonEvent", args => {
    _nextCommonEventId = Number(args.commonEventId || 0) || 0;
  });

  // ChoiceList開始時に「今回だけLRキャンセル可」を付与
  const _Window_ChoiceList_start = Window_ChoiceList.prototype.start;
  Window_ChoiceList.prototype.start = function() {
    this._enableLROnce = _enableLeftRightCancelOnce && !_appliedToCurrentChoice;
    if (this._enableLROnce) {
      _enableLeftRightCancelOnce = false;
      _appliedToCurrentChoice = true;
    }
    _Window_ChoiceList_start.call(this);
  };

  // updateで左右入力をフック：発動時にキャンセル + コモンイベント予約
  const _Window_ChoiceList_update = Window_ChoiceList.prototype.update;
  Window_ChoiceList.prototype.update = function() {
    _Window_ChoiceList_update.call(this);

    if (this._enableLROnce &&
        (Input.isTriggered("left") || Input.isTriggered("right")) &&
        this.isCancelEnabled() && this.active) {
      SoundManager.playCancel();
      this.updateInputData();
      this.callCancelHandler();
      this._enableLROnce = false;

      // コモンイベント実行ロジック
      const eventId = _nextCommonEventId || DEFAULT_CE_ID;
      if (eventId > 0) {
        // 予約しておけば、マップシーンでは即時/次フレームに実行されます
        $gameTemp.reserveCommonEvent(eventId);
      }
      // 一回きり上書きは消費
      _nextCommonEventId = 0;
    }
  };
})();
