/*:
 * @target MZ
 * @plugindesc Live2Dモデルにモザイクフィルタを適用する簡易テスト
 * @command ApplyMosaic
 * @text モザイクを適用
 * @desc 指定したLive2Dモデルにモザイクをかける
 *
 * @arg model
 * @text モデル名
 * @desc モザイクをかけるLive2Dモデルの名前（例：chisa_01）
 * @type string
 *
 * @arg size
 * @text モザイクの粗さ
 * @desc モザイクのピクセルサイズ（大きいほど荒い）
 * @default 10
 * @type number
 *
 * @command ClearMosaic
 * @text モザイクを解除
 * @desc モザイクを解除する
 *
 * @arg model
 * @text モデル名
 * @desc モザイクを解除するLive2Dモデルの名前
 * @type string
 */

(() => {
    PluginManager.registerCommand("Live2DMosaicTest", "ApplyMosaic", args => {
        const modelName = args.model;
        const size = Number(args.size || 10);

        const model = $gameLive2d?.getModel?.(modelName);
        if (model) {
            const mosaic = new PIXI.filters.PixelateFilter();
            mosaic.size = [size, size];
            model.filters = [mosaic];
            console.log(`[Mosaic] モデル ${modelName} にモザイクを適用`);
        } else {
            console.warn(`[Mosaic] モデル "${modelName}" が見つかりませんでした`);
        }
    });

    PluginManager.registerCommand("Live2DMosaicTest", "ClearMosaic", args => {
        const modelName = args.model;
        const model = $gameLive2d?.getModel?.(modelName);
        if (model) {
            model.filters = null;
            console.log(`[Mosaic] モデル ${modelName} のモザイクを解除`);
        } else {
            console.warn(`[Mosaic] モデル "${modelName}" が見つかりませんでした`);
        }
    });
})();
