/*:
 * @target MZ
 * @plugindesc PictureLive2D用 白マスク可視化ツール（MaskPlugin.js対応）200x200画像指定＋ピクチャマスク対応
 * @author ChatGPT
 *
 * @command testWhiteMask
 * @text 白マスクテスト
 * @desc 指定画像をピクチャにマスクして表示。位置・回転・拡大調整可能。
 *
 * @arg targetPictureId
 * @text 対象ピクチャID
 * @type number
 * @default 10
 * @desc マスクを適用するピクチャID
 *
 * @arg filename
 * @text マスク画像ファイル名
 * @desc img/pictures フォルダにある白画像ファイル名（拡張子なし）
 * @type file
 * @dir img/pictures
 *
 * @arg x
 * @text 表示X座標
 * @type number
 * @default 300
 *
 * @arg y
 * @text 表示Y座標
 * @type number
 * @default 200
 *
 * @arg scaleX
 * @text 横拡大率
 * @type number
 * @default 1.0
 *
 * @arg scaleY
 * @text 縦拡大率
 * @type number
 * @default 1.0
 *
 * @arg rotation
 * @text 回転角（度）
 * @type number
 * @default 0
 */

(() => {
  const pluginName = "PictureLive2D_WhiteMaskTest";

  PluginManager.registerCommand(pluginName, "testWhiteMask", args => {
    const pictureId = Number(args.targetPictureId);
    const filename = args.filename || "WhiteMask";
    const x = Number(args.x || 0);
    const y = Number(args.y || 0);
    const scaleX = Number(args.scaleX || 1);
    const scaleY = Number(args.scaleY || 1);
    const rotation = Number(args.rotation || 0);

    const scene = SceneManager._scene;
    const container = scene._spriteset._pictureContainer;
    const targetSprite = container.children.find(s => s._picture && s._picture._pictureId === pictureId);

    if (!targetSprite) {
      console.warn("指定されたピクチャIDが見つかりません: " + pictureId);
      return;
    }

    const bitmap = ImageManager.loadPicture(filename);
    const maskSprite = new Sprite(bitmap);
    maskSprite.x = x;
    maskSprite.y = y;
    maskSprite.scale.x = scaleX;
    maskSprite.scale.y = scaleY;
    maskSprite.rotation = rotation * Math.PI / 180;

    if (window.MaskManager && typeof MaskManager.setMask === 'function') {
      MaskManager.setMask(targetSprite, maskSprite);
      container.addChild(maskSprite);
    } else {
      console.warn("MaskPlugin.js が読み込まれていないか、MaskManager.setMask が存在しません");
    }
  });
})();
