/*:
 * @target MZ
 * @plugindesc メッセージウィンドウのX/Y座標と名前ウィンドウの位置を変更可能にするプラグイン（プラグインコマンド対応）@ChatGPT
 *
 * @param MessageOffsetX
 * @text メッセージX座標オフセット
 * @type number
 * @desc メッセージウィンドウのX位置をこの値分ずらします（正で右、負で左）
 * @default 0
 *
 * @param MessageOffsetY
 * @text メッセージY座標オフセット
 * @type number
 * @desc メッセージウィンドウのY位置をこの値分ずらします（正で下、負で上）
 * @default 0
 *
 * @param NameBoxOffsetX
 * @text 名前ウィンドウX座標オフセット
 * @type number
 * @desc 名前ウィンドウのX位置をこの値分ずらします
 * @default 0
 *
 * @param NameBoxOffsetY
 * @text 名前ウィンドウY座標オフセット
 * @type number
 * @desc 名前ウィンドウのY位置をこの値分ずらします
 * @default 0
 *
 * @command SetOffsets
 * @text オフセット変更
 * @desc メッセージ/名前ウィンドウのオフセットを変更します。
 *
 * @arg messageX
 * @type number
 * @default 0
 * @desc メッセージウィンドウのXオフセット
 *
 * @arg messageY
 * @type number
 * @default 0
 * @desc メッセージウィンドウのYオフセット
 *
 * @arg nameX
 * @type number
 * @default 0
 * @desc 名前ウィンドウのXオフセット
 *
 * @arg nameY
 * @type number
 * @default 0
 * @desc 名前ウィンドウのYオフセット
 */

(() => {
    const pluginName = "MessageWindowOffset";
    let messageOffsetX = Number(PluginManager.parameters(pluginName)["MessageOffsetX"] || 0);
    let messageOffsetY = Number(PluginManager.parameters(pluginName)["MessageOffsetY"] || 0);
    let nameBoxOffsetX = Number(PluginManager.parameters(pluginName)["NameBoxOffsetX"] || 0);
    let nameBoxOffsetY = Number(PluginManager.parameters(pluginName)["NameBoxOffsetY"] || 0);

    PluginManager.registerCommand(pluginName, "SetOffsets", args => {
        messageOffsetX = Number(args.messageX || 0);
        messageOffsetY = Number(args.messageY || 0);
        nameBoxOffsetX = Number(args.nameX || 0);
        nameBoxOffsetY = Number(args.nameY || 0);
    });

    const _Window_Message_updatePlacement = Window_Message.prototype.updatePlacement;
    Window_Message.prototype.updatePlacement = function() {
        _Window_Message_updatePlacement.call(this);
        this.x = (Graphics.boxWidth - this.width) / 2 + messageOffsetX;
        this.y += messageOffsetY;
    };

    Window_NameBox.prototype.updatePlacement = function() {
        this.x = 0 + nameBoxOffsetX;
        this.y = 0 + nameBoxOffsetY;
    };

    Window_NameBox.prototype.refresh = function() {
        this.contents.clear();
        const text = this._name;

        if (!text) {
            this.visible = false;
            this.width = 0;
            return;
        }

        this.visible = true;

        const padding = $gameSystem.windowPadding();
        const extraMargin = 28; // ← さらに余白を拡大（20→28）
 // ← さらに余白を増やす（旧: 10）

        const tempBitmap = new Bitmap(Graphics.width, 48);
        const tempWindow = new Window_Base(new Rectangle(0, 0, Graphics.width, 48));
        tempWindow.contents = tempBitmap;
        const textWidth = tempWindow.drawTextEx(text, 0, 0);

        this.width = textWidth + padding * 2 + extraMargin * 2;
        this.height = this.fittingHeight(1);
        this.createContents();

        this.drawTextEx(text, padding + extraMargin, 0);
    };
})();
