/*:
 * @target MZ
 * @plugindesc PictureKeyMoveMZの setLocalMoveArea 実行中のみ固定アイコンを表示するプラグイン
 * @author むしずし
 *
 * @param targetPlugin
 * @text 監視対象プラグイン名
 * @type string
 * @default PictureKeyMoveMZ
 * @desc setLocalMoveArea を監視するプラグイン名（.jsを除く）
 *
 * @param pictureId
 * @text 表示ピクチャ番号
 * @type number
 * @default 50
 * @desc 表示に使用するピクチャ番号
 *
 * @param pictureName
 * @text 表示画像
 * @type file
 * @dir img/pictures/
 * @default move_area_icon
 * @desc 表示する画像ファイル
 *
 * @param followId
 * @text 監視ピクチャID
 * @type number
 * @default 1
 * @desc このピクチャが消えたときに自動でアイコンも消えます
 *
 * @param x
 * @text X座標
 * @type number
 * @default 1180
 *
 * @param y
 * @text Y座標
 * @type number
 * @default 40
 *
 * @param scaleX
 * @text 横倍率(%)
 * @type number
 * @default 100
 *
 * @param scaleY
 * @text 縦倍率(%)
 * @type number
 * @default 100
 *
 * @param opacity
 * @text 不透明度(0-255)
 * @type number
 * @default 255
 *
 * @param blendMode
 * @text 合成モード
 * @type select
 * @option 通常 @value 0
 * @option 加算 @value 1
 * @option 乗算 @value 2
 * @option スクリーン @value 3
 * @default 0
 *
 * @help
 * PictureKeyMoveMZ の setLocalMoveArea コマンド実行中のみ、
 * 指定画像を固定位置に自動表示します。
 *
 * 【特徴】
 * - プラグインコマンド setLocalMoveArea 実行時に自動表示
 * - 監視ピクチャ（followId）が消えると自動で非表示
 * - X/Y/拡大率/透明度/ブレンドモードも設定可能
 *
 * 【使い方】
 * 1. PictureKeyMoveMZ.js を導入済みにする
 * 2. このプラグインを有効化
 * 3. パラメータを設定（画像名、位置、倍率など）
 */

(() => {
  const PLUGIN_NAME = "PictureKeyMoveIndicatorEX";
  const p = PluginManager.parameters(PLUGIN_NAME);
  const targetPlugin = String(p.targetPlugin || "PictureKeyMoveMZ");
  const pictureId = Number(p.pictureId || 50);
  const followId = Number(p.followId || 1);
  const pictureName = String(p.pictureName || "move_area_icon");
  const posX = Number(p.x || 1180);
  const posY = Number(p.y || 40);
  const scaleX = Number(p.scaleX || 100);
  const scaleY = Number(p.scaleY || 100);
  const opacity = Number(p.opacity || 255);
  const blendMode = Number(p.blendMode || 0);

  let _active = false;

  // --- PictureKeyMoveMZ の setLocalMoveArea 実行を検知 ---
  const _PluginManager_callCommand = PluginManager.callCommand;
  PluginManager.callCommand = function(pluginName, command, args) {
    _PluginManager_callCommand.apply(this, arguments);
    if (pluginName === targetPlugin && command === "setLocalMoveArea") {
      _active = true;
      if (!$gameScreen.picture(pictureId)) {
        $gameScreen.showPicture(
          pictureId,
          pictureName,
          1, // 画面座標基準
          posX,
          posY,
          scaleX,
          scaleY,
          opacity,
          blendMode
        );
      }
    }
  };

  // --- 監視対象ピクチャが消えたら自動で消去 ---
  const _Game_Screen_erasePicture = Game_Screen.prototype.erasePicture;
  Game_Screen.prototype.erasePicture = function(id) {
    _Game_Screen_erasePicture.call(this, id);
    if (id === followId && $gameScreen.picture(pictureId)) {
      $gameScreen.erasePicture(pictureId);
      _active = false;
    }
  };

  // --- 毎フレーム監視（保険用） ---
  const _Game_Map_update = Game_Map.prototype.update;
  Game_Map.prototype.update = function(sceneActive) {
    _Game_Map_update.call(this, sceneActive);
    if (_active && !$gameScreen.picture(followId)) {
      $gameScreen.erasePicture(pictureId);
      _active = false;
    }
  };
})();
