/*:
 * @target MZ
 * @plugindesc 特定の変数が変化したときにコモンイベントを実行するプラグイン（スイッチ制御付き）
 * @author ChatGPT
 *
 * @param VariableCommonBindings
 * @text 変数とコモンイベントの紐付け
 * @type struct<VariableBinding>[]
 * @desc 監視する変数と対応するコモンイベントIDの組み合わせ
 *
 * @param EnableSwitchId
 * @text 実行を有効にするスイッチID
 * @type switch
 * @desc このスイッチがONのときだけ監視が有効になります
 *
 * @help
 * このプラグインは、指定された変数の値が変化したときに
 * 自動的にコモンイベントを実行する機能を提供します。
 *
 * ■ 使用方法
 * 1. プラグインパラメータで変数IDとコモンイベントIDの組を設定してください。
 * 2. さらに、監視を有効にするスイッチIDを設定します。
 * 3. マップ上でそのスイッチがONかつ、変数の値が変化した場合にコモンイベントが呼ばれます。
 *
 * ※ 注意：このプラグインはマップ上（Scene_Map）でのみ動作します。
 */

/*~struct~VariableBinding:
 * @param variableId
 * @text 変数ID
 * @type variable
 * @desc 監視対象の変数ID
 *
 * @param commonEventId
 * @text コモンイベントID
 * @type common_event
 * @desc 実行するコモンイベントのID
 */

(() => {
  const pluginName = "VariableWatcher";

  const parameters = PluginManager.parameters(pluginName);
  const variableBindingsRaw = JSON.parse(parameters["VariableCommonBindings"] || "[]");
  const enableSwitchId = Number(parameters["EnableSwitchId"] || 0);

  const variableBindings = variableBindingsRaw.map(binding => {
    const parsed = JSON.parse(binding);
    return {
      variableId: Number(parsed.variableId),
      commonEventId: Number(parsed.commonEventId),
      lastValue: null
    };
  });

  const _Scene_Map_start = Scene_Map.prototype.start;
  Scene_Map.prototype.start = function() {
    _Scene_Map_start.call(this);
    variableBindings.forEach(binding => {
      binding.lastValue = $gameVariables.value(binding.variableId);
    });
  };

  const _Scene_Map_update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function() {
    _Scene_Map_update.call(this);
    if (enableSwitchId > 0 && !$gameSwitches.value(enableSwitchId)) return;

    variableBindings.forEach(binding => {
      const current = $gameVariables.value(binding.variableId);
      if (binding.lastValue !== null && current !== binding.lastValue) {
        binding.lastValue = current;
        if (!$gameMap.isEventRunning()) {
          $gameTemp.reserveCommonEvent(binding.commonEventId);
        }
      }
    });
  };
})();
