/*:
 * @target MZ
 * @plugindesc ステータス画面を着せ替えUIにカスタマイズ＋右クリック確認 v1.1
 * @author あなたの名前
 *
 * @param ExitConfirmCommonEventId
 * @text 抜ける確認コモンイベントID
 * @type common_event
 * @default 1
 * @desc 右クリック時に実行される「抜けてよいか確認」コモンイベント
 *
 * @help
 * このプラグインは、Scene_Status（ステータス画面）を
 * 着せ替えUI用のキャンバスに変えます。
 *
 * - 通常のステータスウィンドウは非表示
 * - 背景やアイコンなどを自作UIで表示可能
 * - 右クリックで戻らず、指定したコモンイベントを実行（確認表示用）
 *
 * 【使い方】
 * 1. このプラグインをONにする
 * 2. Scene_Statusをスクリプトで開く（SceneManager.push(Scene_Status);）
 * 3. パラメータで指定したコモンイベントに「抜けますか？」を記述
 *     → 「はい：SceneManager.goto(Scene_Map);」
 *     → 「いいえ：何もしない」
 */

(() => {
    const pluginName = "CustomKisekaeStatus";
    const parameters = PluginManager.parameters(pluginName);
    const ExitCommonEventId = Number(parameters["ExitConfirmCommonEventId"] || 1);
  
    Scene_Status.prototype.create = function() {
      Scene_MenuBase.prototype.create.call(this);
      this.createMyUI(); // 着せ替えUIピクチャなどここに追加
    };
  
    Scene_Status.prototype.start = function() {
      Scene_MenuBase.prototype.start.call(this);
    };
  
    Scene_Status.prototype.update = function() {
      Scene_MenuBase.prototype.update.call(this);
      if (TouchInput.isCancelled() && !this._exitConfirmReserved) {
        if (!$gameTemp.isCommonEventReserved()) {
          $gameTemp.reserveCommonEvent(ExitCommonEventId);
          this._exitConfirmReserved = true; // 多重起動防止
        }
      }
    };
  
    Scene_Status.prototype.createMyUI = function() {
      const bg = new Sprite(ImageManager.loadPicture("kisekae_bg"));
      this.addChild(bg);
      // 他にもピクチャなどをここで追加可能
    };
  })();
  