/*:
 * @target MZ
 * @plugindesc HR_PictureMask のマスクが画像変更・再表示で外れるのを自動再付与で防止する互換パッチ。
 * @author you
 *
 * @help
 * 概要:
 *  - 画像の差し替え(同一IDでの再表示)やスプライト再生成のタイミングで、
 *    マスク参照(texSprite.mask)が外れてしまう状況を自動で再付与して防ぎます。
 *  - HR_PictureMask.js の setMask/clearMask API を利用します。
 *  - Live2D ではなく通常のピクチャに対する補強です。
 *
 * 使い方:
 *  - HR_PictureMask.js より後ろ(下)に配置してください。
 *  - プロジェクトに入れるだけで動作します(プラグインコマンド不要)。
 */
(function(){
  'use strict';

  // 安全取得ユーティリティ
  function pictureSprites(){
    const scene = SceneManager._scene;
    return scene && scene._spriteset && scene._spriteset._pictureContainer
      ? scene._spriteset._pictureContainer.children
      : null;
  }

  // 1) Sprite_Picture の毎フレーム更新で、必要に応じて mask を再付与
  const _Sprite_Picture_update = Sprite_Picture.prototype.update;
  Sprite_Picture.prototype.update = function(){
    _Sprite_Picture_update.call(this);
    const id = this._pictureId;
    if(!id) return;
    const gamePic = $gameScreen.picture(id);
    if(!gamePic || !gamePic._maskId) return;

    const sprites = pictureSprites();
    if(!sprites) return;
    const texSprite = sprites[id - 1];
    const maskSprite = sprites[Number(gamePic._maskId) - 1];
    if(texSprite && maskSprite && texSprite.mask !== maskSprite){
      texSprite.mask = maskSprite; // 再付与
    }
  };

  // 2) Game_Screen.showPicture で再表示された際にも mask を復元
  const _Game_Screen_showPicture = Game_Screen.prototype.showPicture;
  Game_Screen.prototype.showPicture = function(pictureId, name, origin, x, y, scaleX, scaleY, opacity, blendMode){
    _Game_Screen_showPicture.apply(this, arguments);
    const gamePic = this.picture(pictureId);
    if(gamePic && gamePic._maskId && typeof this.setMask === 'function'){
      this.setMask(pictureId, gamePic._maskId);
    }
  };

  // 3) 画面復帰時(タイトル遷移など)は HR_PictureMask 側の復元に任せる
  //    本パッチは『外れていたら再付与』の保険的挙動のみ行う。
})();
