var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command kekkon
 * @text 結婚した後に呼ばれる処理
 * @arg actorId
 * @type number
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Actor';
    PluginManager.registerCommand(pluginName, 'kekkon', function (args) {
        var actorId = parseInt(args.actorId);
        $gameActors.actor(actorId).kekkon();
    });
})(Nore || (Nore = {}));
var NAKADASHI_RAKUGAKI_MAX = 20;
var SATSUKI_CRIT_ANIME_ID = 122;
var ACTOR1_MEDAL_NAME_VAR = 111;
var ACTOR2_MEDAL_NAME_VAR = 112;
var ACTOR3_MEDAL_NAME_VAR = 113;
var ACTOR4_MEDAL_NAME_VAR = 114;
var ACTOR5_MEDAL_NAME_VAR = 115;
var SkillMeta;
(function (SkillMeta) {
    SkillMeta["wrath"] = "wrath";
    SkillMeta["wrath2"] = "wrath2";
    SkillMeta["wrath3"] = "wrath3";
    SkillMeta["syukuchi"] = "syukuchi";
    SkillMeta["breakUp"] = "breakUp";
})(SkillMeta || (SkillMeta = {}));
var EquipMeta;
(function (EquipMeta) {
    EquipMeta["syukuchi"] = "syukuchi";
    EquipMeta["ninshin100"] = "ninshin100";
})(EquipMeta || (EquipMeta = {}));
var CostumeSlot;
(function (CostumeSlot) {
    CostumeSlot[CostumeSlot["normal"] = 1] = "normal";
    CostumeSlot[CostumeSlot["baisyun"] = 2] = "baisyun";
    CostumeSlot[CostumeSlot["baisyunBattle"] = 3] = "baisyunBattle";
    CostumeSlot[CostumeSlot["dousei"] = 4] = "dousei";
})(CostumeSlot || (CostumeSlot = {}));
Game_Actors.prototype.mainActor = function () {
    if ($gameVariables.value(5) > 1) {
        return this.actor($gameVariables.value(5));
    }
    return this.actor(1);
};
Game_Actors.prototype.actor = function (actorId) {
    if ($dataActors[actorId]) {
        if (!this._data[actorId]) {
            this._data[actorId] = new Game_Actor2(actorId);
        }
        return this._data[actorId];
    }
    return null;
};
var BodyChangeLv = /** @class */ (function () {
    function BodyChangeLv(level, equipAcce) {
        this.level = level;
        this.equipAcce = equipAcce;
    }
    return BodyChangeLv;
}());
var Game_Actor2 = /** @class */ (function (_super) {
    __extends(Game_Actor2, _super);
    function Game_Actor2() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._lastCostumeList = [];
        _this._abilityMap = {};
        _this._syusanCount = 0;
        _this._ninshinDamage = 0;
        _this._mankoKuroValue = 0;
        _this._mankoHenkeiValue = 0;
        _this._chikubiKuroValue = 0;
        _this._mankoFaceId = 0;
        _this._mankoHoppeId = 0;
        _this._mankoNamidaId = 0;
        _this._sikyu = new Sikyu();
        _this._tiredness = 0;
        return _this;
    }
    Game_Actor2.prototype.setup = function (actorId2) {
        var actorId = parseInt(actorId2);
        _super.prototype.setup.call(this, actorId);
        this._baisyun = new Baisyun(actorId);
        this._baisyunHistory = new BaisyunHistory(actorId);
        this._eroStatus = new EroStatus(actorId);
        this._babyHistory = new BabyHistory(actorId);
        this._friendship = new FriendshipActor(actorId);
        this._baisyunPlayer = new BaisyunPlayer(this.actorId());
        this.setupEroParams();
        this.initEquips();
    };
    Game_Actor2.prototype.isNinshin100 = function () {
        var slot = this._actorEquip.slotAt(NINSHIN_SLOT_ID - SLOT_START_ID);
        return slot.itemId() == 201;
    };
    Game_Actor2.prototype.isNinshin0 = function () {
        var slot = this._actorEquip.slotAt(NINSHIN_SLOT_ID - SLOT_START_ID);
        return slot.itemId() == 202;
    };
    Game_Actor2.prototype.friendshipLevel = function (manId) {
        return this.friendshipActor().friendshipLevel(manId);
    };
    Game_Actor2.prototype.friendshipActor = function () {
        return this._friendship;
    };
    Game_Actor2.prototype.isNonokaDousei = function (makeAv) {
        if (makeAv) {
            return false;
        }
        if ($gameSwitches.value(252)) {
            return false;
        }
        if (this.actorId() != 9) {
            return false;
        }
        if (this.dousei().manId() != 19) {
            return false;
        }
        return true;
    };
    Game_Actor2.prototype.canDousei = function (manId) {
        if ($gameSwitches.value(263)) {
            switch (this._actorId) {
                case 4:
                case 9:
                case 13:
                case 17:
                    return true;
            }
        }
        return false;
    };
    Game_Actor2.prototype.setBote = function (boteId) {
        if (this._boteId == boteId) {
            return;
        }
        this._boteId = boteId;
        this.setCacheChanged();
    };
    Game_Actor2.prototype.setupEroParams = function () {
        this._paramMap = {};
    };
    Game_Actor2.prototype.name = function () {
        if (this.actorId() == 77) {
            // 同棲相手
            var realActorId = $gameVariables.value(55);
            if (realActorId >= 1 && realActorId != 77 && $gameActors.actor(realActorId)) {
                return $gameActors.actor(realActorId).name();
            }
        }
        if (this.actorId() == 78) {
            // AV男優
            var realActorId = $gameVariables.value(55);
            if (realActorId >= 1 && realActorId != 78 && $gameActors.actor(realActorId)) {
                return $gameActors.actor(realActorId).name();
            }
        }
        switch (ConfigManager.language) {
            case 'en':
                if (this.actor().meta['nameEn']) {
                    return this.actor().meta['nameEn'];
                }
                break;
            case 'ch':
            case 'jp':
                break;
        }
        return this.actor().name;
    };
    Game_Actor2.prototype.posByActor = function () {
        switch (this.actorId()) {
            case 1: return 0;
            case 3: return 0;
            case 4: return 0;
            case 8: return -10;
            case 9: return -20;
            case 10: return -40;
            case 11: return -20;
            case 13: return -16;
            case 17: return -16;
        }
        return 0;
    };
    Game_Actor2.prototype.actorId = function () {
        return Math.trunc(_super.prototype.actorId.call(this));
    };
    Game_Actor2.prototype.saveCostume = function (slot, includeFace) {
        if (includeFace === void 0) { includeFace = false; }
        var faceId = 0;
        if (includeFace) {
            faceId = this.getDefaultFaceId();
        }
        this._lastCostumeList[slot] = new CostumeSaver(this.actorId(), faceId);
    };
    Game_Actor2.prototype.restoreCostume = function (slot, includeAcce) {
        if (!this._lastCostumeList[slot]) {
            console.error('costume not found:' + slot);
            return false;
        }
        this._lastCostumeList[slot].restoreCostume(null, includeAcce);
        return true;
    };
    Game_Actor2.prototype.costume = function (slot) {
        return this._lastCostumeList[slot];
    };
    Game_Actor2.prototype.setCostume = function (slot, cos) {
        this._lastCostumeList[slot] = cos;
    };
    Game_Actor2.prototype.power = function () {
        var n = 0;
        n += this.mhp;
        n += this.atk * 10;
        return n;
    };
    Game_Actor2.prototype.param = function (n) {
        if (n == 2) {
            return this.atk2();
        }
        if (n == 10) {
            return this.initialShield();
        }
        return _super.prototype.param.call(this, n);
    };
    Game_Actor2.prototype.initialShield = function () {
        var n = this.paramPlus(2);
        var equip = this.actorEquip();
        for (var _i = 0, _a = equip.allSlots(); _i < _a.length; _i++) {
            var e = _a[_i];
            n += e.initialShield();
        }
        return n;
    };
    Game_Actor2.prototype.atk2 = function () {
        var rate = this.attackBaseRate();
        var plus = this.stateAtkPlus();
        //p('plus:' + plus)
        var equip = this.actorEquip();
        return Math.round((_super.prototype.param.call(this, 2) + equip.atk() + plus) * rate);
        /*const action: Game_EquipAction = this._lastAction;
        const e = action.equipSlot();
        const damage = e.damage();
        return Math.floor(damage * rate)*/
    };
    Game_Actor2.prototype.attackBaseRate = function () {
        if (this._actorId == 2) {
            // サツキはダメージ1.5倍
            return 1.5;
        }
        return 1;
    };
    Game_Actor2.prototype.skillInvokeRatePlus = function (index) {
        if (this._actorId == 1) {
            // ロザリーは確率アップ
            return 10;
        }
        if (this._actorId == 3) {
            if ($gameParty.inBattle()) {
                if ($gameTroop.turnCount() == 1) {
                    if (index % 5 === 0) {
                        return 100;
                    }
                }
            }
        }
        return 0;
    };
    Game_Actor2.prototype.stateAtkPlus = function () {
        var result = 0;
        for (var _i = 0, _a = this.states(); _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.meta['atkPlus']) {
                var n = parseInt(s.meta['atkPlus']);
                n *= this.getStateTurn(s.id);
                result += n;
            }
        }
        return result;
    };
    Game_Actor2.prototype.attackRate = function (skill) {
        if (skill.hitType == 0) {
            return 1;
        }
        if (skill.hitType == 1) {
            return this.atk / 100;
        }
        else {
            return this.mat / 100;
        }
    };
    Game_Actor2.prototype.attackAnimationId1 = function () {
        switch (this._actorId) {
            case 1: return 1;
            case 2: return 6;
            case 3: return 6;
        }
        return _super.prototype.attackAnimationId1.call(this);
    };
    Game_Actor2.prototype.def2 = function () {
        return this.def;
    };
    Game_Actor2.prototype.lastEquipAction = function () {
        return this._lastAction;
    };
    Game_Actor2.prototype.isOverallCash = function () {
        // 全体キャッシュが必要なアクセ
        /*const cashAcce = [1060, 1061, 1062, 1063, 1064, 1065, 1065]
        for (const id of cashAcce) {
            if (this.acceMap[id]) {
                return true;
            }
        }*/
        return this.isClone();
    };
    Game_Actor2.prototype.dousei = function () {
        this._dousei = this._dousei || new Dousei(this.actorId());
        return this._dousei;
    };
    Game_Actor2.prototype.isBote = function () {
        return this.boteId > 0;
    };
    Game_Actor2.prototype.iconIndex = function () {
        if (this._actorId >= MAN_ID_ACTOR_OFFSET) {
            return 1360 + this._actorId - MAN_ID_ACTOR_OFFSET - 1;
        }
        switch (this._actorId) {
            case 1: return 532;
            case 2: return 530;
            case 3: return 531;
            case 5: return 535;
            case 6: return 536;
            case 17: return 1376;
            case 32: return 533;
        }
        return -1;
    };
    Game_Actor2.prototype.mankoHenkeiValue = function () {
        var mankoEro = this.eroParam(AvRequired.manko);
        var syusanPoint = this.countSyusan() * 17;
        return mankoEro + syusanPoint;
    };
    Game_Actor2.prototype.mankoHenkei100Value = function () {
        var mankoEro = this.mankoHenkeiValue();
        var max = MANKO_ID_LIST[5] * 100 / 90;
        return Math.min(Math.ceil(mankoEro / max * 100), 100);
    };
    Game_Actor2.prototype.mankoHenkeiLv = function () {
        var acceMap = {
            1: 1122,
            2: 1123,
            3: 1124,
            4: 1125,
            5: 1126,
            6: 1127,
            7: 1128,
        };
        var acceBodyChange = this.calcAcceEquipLv(acceMap);
        if (acceBodyChange) {
            return acceBodyChange;
        }
        return this.realMankoHenkeiLv();
    };
    Game_Actor2.prototype.realMankoHenkeiLv = function () {
        var mankoEro = this.mankoHenkeiValue();
        return new BodyChangeLv(this.calcValueLv(MANKO_ID_LIST, mankoEro), false);
    };
    Game_Actor2.prototype.sikyu = function () {
        return this._sikyu;
    };
    Game_Actor2.prototype.equipSlots = function () {
        var slots = [1, 2, 3];
        /*for (let i = 1; i < $dataSystem.equipTypes.length; i++) {
            slots.push(i);
        }
        slots.push(4);
        slots.push(4);
        slots.push(4);*/
        return slots;
    };
    Game_Actor2.prototype.hasSkillMeta = function (meta) {
        for (var _i = 0, _a = this.skills(); _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.meta[meta]) {
                return true;
            }
        }
        return false;
    };
    Game_Actor2.prototype.hasEquipMeta = function (meta) {
        return this.countEquipMeta(meta) > 0;
    };
    Game_Actor2.prototype.countEquipMeta = function (meta) {
        var n = 0;
        for (var _i = 0, _a = this.actorEquip().allSlots(); _i < _a.length; _i++) {
            var s = _a[_i];
            if (!s) {
                continue;
            }
            var e = s.item();
            if (!e) {
                continue;
            }
            if (e.meta[meta]) {
                n++;
            }
        }
        return n;
    };
    Game_Actor2.prototype.setDirty = function () {
        this._dirty = true;
    };
    Game_Actor2.prototype.clearForecast = function () {
        this._forecastDamage = 0;
        this._forecastHpDamage = 0;
    };
    Game_Actor2.prototype.countSkill = function (meta) {
        var n = 0;
        for (var _i = 0, _a = this.skills(); _i < _a.length; _i++) {
            var skill = _a[_i];
            if (skill.meta[meta]) {
                n += Math.trunc(skill.meta[meta]);
            }
        }
        return n;
    };
    Game_Actor2.prototype.lowerLimit = function () {
        return this.countSkill(SkillMeta.lowerLimit);
    };
    Game_Actor2.prototype.criRate = function () {
        var rate = this.xparam(2);
        rate += this.countSkill(SkillMeta.critUp) / 100;
        return rate;
    };
    Game_Actor2.prototype.baisyunPlayer = function () {
        return this._baisyunPlayer;
    };
    Game_Actor2.prototype.tiredness = function () {
        return this._tiredness;
    };
    Game_Actor2.prototype.addTiredness = function (n) {
        this._tiredness += n;
    };
    Game_Actor2.prototype.baisyun = function () {
        return this._baisyun;
    };
    Game_Actor2.prototype.baisyunHistory = function () {
        return this._baisyunHistory;
    };
    Game_Actor2.prototype.baisyunLevel = function () {
        return this._baisyunPlayer.baisyunLevel();
    };
    Game_Actor2.prototype.addStun = function (n) {
        return false;
    };
    Game_Actor2.prototype.paySkillCost = function (skill) {
        this._mp -= this.skillMpCost(skill);
        this._tp -= this.skillTpCost(skill);
    };
    Game_Actor2.prototype.onActionStart = function () {
    };
    Game_Actor2.prototype.processShield = function (damage) {
        if (damage <= 0) {
            return damage;
        }
        var lastShield = this.totalShield();
        if (this.totalShield() > 0) {
            if (this.totalShield() < damage) {
                damage -= this.totalShield();
                this._result.addShieldDamage(this.totalShield());
                this._shield = 0;
                this._tempShield = 0;
            }
            else {
                this._result.addShieldDamage(damage);
                this.minusShield(damage);
                damage -= lastShield;
            }
        }
        return damage;
    };
    Game_Actor2.prototype.totalShield = function () {
        return this._shield + this._tempShield;
    };
    Game_Actor2.prototype.minusShield = function (d) {
        if (this._tempShield > 0) {
            if (this._tempShield >= d) {
                this._tempShield -= d;
                return;
            }
            else {
                d -= this._tempShield;
                this._tempShield = 0;
            }
        }
        if (this._shield > 0) {
            if (this._shield >= d) {
                this._shield -= d;
            }
            else {
                this._shield = 0;
            }
        }
    };
    Game_Actor2.prototype.gainHp = function (n, penetrate) {
        if (penetrate === void 0) { penetrate = false; }
        if (n > 0) {
            _super.prototype.gainHp.call(this, n);
            return;
        }
        var damage = -n;
        if (!penetrate) {
            damage = this.processShield(damage);
        }
        //damage = this.processArmor(damage);
        if (damage <= 0) {
            return;
        }
        $gameTemp.onDamage();
        if (damage > 0) {
            this.playDamageVoice();
        }
        _super.prototype.gainHp.call(this, -damage);
        return damage;
    };
    Game_Actor2.prototype.shield = function () {
        return this._shield;
    };
    Game_Actor2.prototype.tempShield = function () {
        return this._tempShield;
    };
    Game_Actor2.prototype.maxShield = function () {
        /*let n = this.luk;
        if (this._battleInfo) {
            n += this._battleInfo.countParam(3);
        }
        const base = n; //Math.trunc(n * (100 + (this._level - 1) * 10) / 100);
        const difficultyBonus = this.shieldDifficultyBonus();
        return base + this.skillShieldPlus() + difficultyBonus;*/
        return 99;
    };
    Game_Actor2.prototype.shieldDifficultyBonus = function () {
        switch ($gameSystem.difficulty()) {
            case Difficulty.DUNGEON_SKIP: return 20;
            case Difficulty.VERY_EASY: return 20;
            case Difficulty.EASY: return 10;
        }
        return 0;
    };
    Game_Actor2.prototype.gainTempShield = function (n) {
        this._tempShield += n;
    };
    Game_Actor2.prototype.gainShield = function (n) {
        this._shield += n;
        this._shield = Math.min(this._shield, this.maxShield());
    };
    Game_Actor2.prototype.onBattleStart = function (advantageous) {
        this._shield = 0;
        this._tempShield = 0;
        if (!$gameParty.inBaisyun()) {
            this._battleInfo = new Game_ActorBattleInfo(this._actorId);
            this._actorEquip.onBattleStart(this);
        }
        _super.prototype.onBattleStart.call(this, advantageous);
        this._equipActions = [];
        this._battleStartHp = this.hp;
    };
    Game_Actor2.prototype.onBattleEnd = function () {
        _super.prototype.onBattleEnd.call(this);
        this._battleInfo = null;
        this._equipActions = [];
        this._battleStartHp = this.hp;
    };
    Game_Actor2.prototype.skillShieldPlus = function () {
        return 0;
    };
    Game_Actor2.prototype.onTurnStart = function () {
        //this.removeState(StateId.afterStun);
        this._result.clear();
        var canMove = this.canMove();
        this.updateStateTurns();
        //this.removeState(StateId.afterStun);
        this.removeStatesAuto(2);
        this._dirty = true;
        /*if (! canMove && this.canMove()) {
            this.addState(StateId.afterStun, 1);
        }*/
    };
    Game_Actor2.prototype.countSkillMeta = function (meta) {
        var n = 0;
        for (var _i = 0, _a = this.skills(); _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.meta[meta]) {
                var value = parseInt(s.meta[meta]);
                if (!isNaN(value)) {
                    n += value;
                }
                else {
                    n += 1;
                }
            }
        }
        return n;
    };
    Game_Actor2.prototype.updateStateTurnsActor = function (timing) {
        for (var _i = 0, _a = this._states; _i < _a.length; _i++) {
            var stateId = _a[_i];
            if (this._stateTurns[stateId] > 0) {
                var state = $dataStates[stateId];
                if (state.autoRemovalTiming == timing) {
                    this._stateTurns[stateId]--;
                }
            }
        }
    };
    Game_Actor2.prototype.onTurnEnd = function () {
        this._tempShield = 0;
        _super.prototype.onTurnEnd.call(this);
        this.removeAllBuffs();
        this.regenerateHp();
        this.updateStateTurnsActor(2);
        this.updateStateTurns();
        this.removeStatesAuto(1);
        this.removeStatesAuto(2);
        this.deactivateEquips();
        if (!$gameParty.inBaisyun()) {
            this._actorEquip.onTurnEnd(this);
        }
    };
    Game_Actor2.prototype.deactivateEquips = function () {
        if (this._battleInfo) {
            this._battleInfo.deactivateAll();
        }
    };
    Game_Actor2.prototype.removeShield = function () {
        //this._shield = 0;
        this._tempShield = 0;
    };
    Game_Actor2.prototype.canUse = function (item) {
        if (!item) {
            return false;
        }
        else if (DataManager.isSkill(item)) {
            return this.meetsSkillConditions(item);
        }
        else if (DataManager.isItem(item)) {
            return this.meetsItemConditions(item);
        }
        else {
            return false;
        }
    };
    /*canPaySkillCost(skill): boolean {
        const unit = BattleManager.battleOrder().findWaitUnit(this);
        if (! unit) {
            return super.canPaySkillCost(skill);
        }
        return true;
    }*/
    Game_Actor2.prototype.calcExpRate = function (gainExp) {
        var value1 = this.currentExp();
        if (this._level > 1) {
            value1 -= this.expForLevel(this._level);
        }
        var value2 = this.nextLevelExp() - this.currentLevelExp();
        return (value1 + gainExp) / value2;
    };
    Game_Actor2.prototype.calcRealExp = function (rate) {
        var value1 = this.currentExp();
        if (this._level > 1) {
            value1 -= this.expForLevel(this._level);
        }
        var value2 = this.nextLevelExp() - this.currentLevelExp();
        return (value2 * rate) - value1;
    };
    Game_Actor2.prototype.playDamageVoice = function () {
        if (this._clone) {
            return;
        }
        var actorId = this.actorId();
        var randomId = Math.randomInt(4) + 1;
        var fileId = 'damebo_%1_%2'.format(actorId.padZero(2), randomId.padZero(2));
        AudioManager.playVoice({ name: fileId, volume: 100, pitch: 100, pan: 0 });
    };
    Game_Actor2.prototype.shouldDisplayLevelUp = function () {
        return false;
    };
    Game_Actor2.prototype.battleInfo = function () {
        return this._battleInfo;
    };
    Game_Actor2.prototype.updateTpbChargeTime = function (preBattle) {
        this._battleInfo.update(preBattle);
        if (this._battleInfo.isCharged()) {
            this.makeEquipActions();
            this._tpbState = "ready";
        }
    };
    Game_Actor2.prototype.makeEquipActions = function () {
        this._battleInfo.deactivateAll();
        _super.prototype.makeActions.call(this);
        if (this.numActions() > 0) {
            this.setActionState("undecided");
        }
        else {
            this.setActionState("waiting");
        }
        if (this.inputtingAction()) {
            this._actions = this._battleInfo.makeEquipActions();
            //this.inputtingAction().setSkill(skillId);
        }
    };
    Game_Actor2.prototype.performDamage = function () {
        Game_Battler.prototype.performDamage.call(this);
        if (this.isSpriteVisible()) {
            this.requestMotion("damage");
        }
        else {
            $gameScreen.startShake(5, 5, 10);
        }
        if (this._result.isNoDamage()) {
            AudioManager.playSe({ name: 'Evasion1', volume: 80, pitch: 100, pan: 0 });
        }
        else if (this._result.isShieldOnlyDamage()) {
            AudioManager.playSe({ name: 'Hammer', volume: 80, pitch: 100, pan: 0 });
        }
        else {
            SoundManager.playActorDamage();
        }
        this.clearResult();
    };
    Game_Actor2.prototype.performVictory = function () {
        _super.prototype.performVictory.call(this);
        this._battleInfo = null;
    };
    Game_Actor2.prototype.actorEquip = function () {
        return this._actorEquip;
    };
    Game_Actor2.prototype.initEquips = function () {
        this._actorEquip = new ActorEquip(this._actorId);
    };
    Game_Actor2.prototype.isSpriteVisible = function () {
        return true;
    };
    Game_Actor2.prototype.shouldPopupDamage = function () {
        var result = this._result;
        return (result.missed ||
            result.evaded ||
            result.hpAffected ||
            result.shieldDamage() > 0 ||
            result.mpDamage !== 0);
    };
    Game_Actor2.prototype.battleStartHp = function () {
        return this._battleStartHp;
    };
    Game_Actor2.prototype.makeSpeed = function () {
        this._speed = 1000 + this._actorId * 100;
    };
    Game_Actor2.prototype.sparam = function (paramId) {
        var n = _super.prototype.sparam.call(this, paramId);
        if (paramId == 0) {
            // 狙われ率
            if (this.hpRate() < 0.3) {
                n *= 0.7;
            }
            else if (this.hpRate() < 0.5) {
                n *= 0.9;
            }
        }
        return n;
    };
    Game_Actor2.prototype.ninshinDamage = function () {
        return this._ninshinDamage;
    };
    Game_Actor2.prototype.upNinshinDamage = function (n, manId, commonId, isTest) {
        if (this.isNinshin()) {
            return new RanshiResult(100, 100);
        }
        if (this._ninshinDamage >= this.maxNinshinDamage()) {
            var baby = this.babyHistory().lastBaby();
            if (!baby || baby.isSyusan()) {
                console.error('妊娠中のはずですが子供が存在しません');
            }
            return new RanshiResult(this._ninshinDamage, this._ninshinDamage);
        }
        if (this.isNinshin100()) {
            //n = 100;
        }
        else if (this.isNinshin0()) {
            return new RanshiResult(this._ninshinDamage, this._ninshinDamage);
        }
        var before = this._ninshinDamage;
        this._ninshinDamage += n;
        if (this._ninshinDamage >= this.maxNinshinDamage()) {
            this._ninshinDamage = this.maxNinshinDamage();
            if (!isTest) {
                this.babyHistory().ninshin(manId, commonId);
            }
        }
        return new RanshiResult(before, this._ninshinDamage);
    };
    Game_Actor2.prototype.maxNinshinDamage = function () {
        return 100;
    };
    Game_Actor2.prototype.syusan = function () {
        this._ninshinDamage = 0;
        this.babyHistory().lastBaby().syusan();
        this.setBote(0);
        $gameMedals.onSyusan(this.actorId(), this.babyHistory().countSyusan());
    };
    Game_Actor2.prototype.kekkon = function () {
        $gameMedals.onKekkon(this.actorId(), this.kekkonCount());
    };
    Game_Actor2.prototype.kekkonCount = function () {
        switch (this.actorId()) {
            case 1: return this.kekkonCount1();
            case 2: return this.kekkonCount2();
        }
        return 0;
    };
    Game_Actor2.prototype.kekkonCount1 = function () {
        var n = 0;
        if ($gameSwitches.value(1423)) {
            n++; // ゼノ
        }
        return n;
    };
    Game_Actor2.prototype.kekkonCount2 = function () {
        var n = 0;
        if ($gameSwitches.value(1137)) {
            n++; // ゼノ
        }
        if ($gameSwitches.value(1138)) {
            n++; // パティ
        }
        if ($gameSwitches.value(1139)) {
            n++; // レックス
        }
        return n;
    };
    Game_Actor2.prototype.babyHistory = function () {
        if (!this._babyHistory) {
            this._babyHistory = new BabyHistory(this._actorId);
        }
        return this._babyHistory;
    };
    Game_Actor2.prototype.isNinshin = function () {
        return this.babyHistory().isNinshin();
    };
    Game_Actor2.prototype.setClone = function (b) {
        this._clone = b;
    };
    Game_Actor2.prototype.isClone = function () {
        return this._clone;
    };
    Game_Actor2.prototype.cloneActorOffset = function () {
        // 立ち絵の描画をオリジナルと区別するため
        return 50;
    };
    Game_Actor2.prototype.countSpecial = function (s) {
        var n = 0;
        for (var _i = 0, _a = this.actorEquip().allSlots(); _i < _a.length; _i++) {
            var slot = _a[_i];
            var e = slot;
            var special = e.special();
            if (special == s) {
                n += e.specialValue(s);
            }
        }
        return n;
    };
    Game_Actor2.prototype.addState = function (stateId, turnCount) {
        if (this.isStateAddable(stateId)) {
            if ($stateManager.isBadState(stateId)) {
                var success = this.executeBadStateBlock();
                if (success) {
                    return;
                }
            }
            if (this.hasState(StateId.prevention)) {
                if (this.isBadState(stateId)) {
                    this.reduceStateTuens(StateId.prevention);
                    p('ステートを予防');
                    return;
                }
            }
        }
        _super.prototype.addState.call(this, stateId, turnCount);
    };
    Game_Actor2.prototype.executeBadStateBlock = function () {
        if (!this.hasStateMeta(StateMeta.prevention)) {
            return false;
        }
        this.removeState(StateId.prevention);
        return true;
    };
    Game_Actor2.prototype.isStateAddable = function (stateId) {
        var state = $dataStates[stateId];
        if (state.meta['shieldBlock']) {
            if (this.result().hpDamage == 0) {
                // シールドブロック
                return false;
            }
        }
        return _super.prototype.isStateAddable.call(this, stateId);
    };
    Game_Actor2.prototype.isBadState = function (stateId) {
        var state = $dataStates[stateId];
        if (state.restriction > 0) {
            return true;
        }
        return state.meta['badState'] != null;
    };
    Game_Actor2.prototype.reduceStateTuens = function (stateId) {
        if (this._stateTurns[stateId]) {
            this._stateTurns[stateId]--;
            if (this._stateTurns[stateId] == 0) {
                this.removeState(stateId);
            }
        }
    };
    Game_Actor2.prototype.eroStatus = function () {
        return this._eroStatus;
    };
    Game_Actor2.prototype.currentMedalId = function () {
        return this._currentMedalId;
    };
    Game_Actor2.prototype.setCurrentMedalId = function (n) {
        this._currentMedalId = n;
        if (this._actorId <= 5) {
            $gameVariables.setValue(this.medalNameVar(), this.makeMedalName());
        }
    };
    Game_Actor2.prototype.makeMedalName = function () {
        var param = $medalParamManager.getParam(this._currentMedalId);
        return param.nickname();
    };
    Game_Actor2.prototype.nickname = function () {
        var param = $medalParamManager.getParam(this._currentMedalId);
        if (param.isVisible()) {
            return param.name();
        }
        else {
            return '';
        }
    };
    Game_Actor2.prototype.medalNameVar = function () {
        switch (this._actorId) {
            case 1: return ACTOR1_MEDAL_NAME_VAR;
            case 2: return ACTOR2_MEDAL_NAME_VAR;
            case 3: return ACTOR3_MEDAL_NAME_VAR;
            case 4: return ACTOR4_MEDAL_NAME_VAR;
            case 5: return ACTOR5_MEDAL_NAME_VAR;
        }
        console.error('不正な actorId です' + this._actorId);
        return -1;
    };
    Game_Actor2.prototype.medalDesctipion = function () {
        var param = $medalParamManager.getParam(this._currentMedalId);
        var desc = param.description();
        if (desc && desc[0] == '「') {
            return desc;
        }
        else {
            return '　' + desc;
        }
    };
    Game_Actor2.prototype.profileText = function () {
        var param = $medalParamManager.getParam(this.actorId());
        return param.description();
    };
    Game_Actor2.prototype.initSetMedal = function () {
        switch (this._actorId) {
            case 1:
                this.setCurrentMedalId(600);
                break;
            case 2:
                this.setCurrentMedalId(500);
                break;
            case 3:
                this.setCurrentMedalId(550);
                break;
            case 5:
                this.setCurrentMedalId(701);
                break;
        }
    };
    Game_Actor2.prototype.syusanCount = function () {
        return this._syusanCount || 0;
    };
    Game_Actor2.prototype.setSyusanCount = function (n) {
        this._syusanCount = n;
    };
    Game_Actor2.prototype.douseiCount = function (manId) {
        var list = $gameParty.dayResultHistory().makeHistory(this._actorId);
        var n = 0;
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var s = list_1[_i];
            if (!s.isDousei()) {
                continue;
            }
            if (s.actorId() == manId || s.manId() == manId) {
                n++;
            }
        }
        return n;
    };
    Game_Actor2.prototype.isBattleMember = function () {
        if ($gameSwitches.value(ERIS_BATTLER_SW) && this.actorId() == 5) {
            return true;
        }
        return _super.prototype.isBattleMember.call(this);
    };
    Game_Actor2.prototype.countSyusan = function () {
        return this.babyHistory().countSyusan();
    };
    return Game_Actor2;
}(Game_CostumeActor));
Sprite_Actor.prototype.updateBitmap = function () {
    Sprite_Battler.prototype.updateBitmap.call(this);
    var name = this._actor.battlerName();
    if (this._battlerName !== name) {
        this._battlerName = name;
    }
};
Sprite_Actor.prototype.createShadowSprite = function () {
    this._shadowSprite = new Sprite();
    this.addChild(this._shadowSprite);
};
Sprite_Actor.prototype.stepForward = function () {
};
Sprite_Actor.prototype.stepBack = function () {
};
AudioManager.playVoice = function (se) {
    if (se.name) {
        // [Note] Do not play the same sound in the same frame.
        var latestBuffers = this._seBuffers.filter(function (buffer) { return buffer.frameCount === Graphics.frameCount; });
        if (latestBuffers.find(function (buffer) { return buffer.name === se.name; })) {
            return;
        }
        var buffer = this.createBuffer("se/", se.name);
        this.updateVoiceParameters(buffer, se);
        buffer.play(false);
        this._seBuffers.push(buffer);
        this.cleanupSe();
    }
};
AudioManager.updateVoiceParameters = function (buffer, se) {
    this.updateBufferParameters(buffer, this._voiceVolume, se);
};
