/*:ja
 * @target MZ
 * @author ル
 *
 * @command learnRecipe
 * @text レシピを習得
 * @arg id
 * @type number
 * @arg skipNewRecipe
 * @type boolean
 *
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Alchemy';
    PluginManager.registerCommand(pluginName, 'learnRecipe', function (args) {
        var id = parseInt(args.id);
        var skip = args.skipNewRecipe == 'true';
        var success = $gameParty.learnRecipe(id, skip);
        if (success) {
            p($recipeManager.findRecipeParam(id).destItem().name + 'のレシピ習得');
        }
        else {
            p($recipeManager.findRecipeParam(id).destItem().name + 'はすでに習得済みです');
        }
    });
})(Nore || (Nore = {}));
var MAX_RECIPE_GOLD = 9999999999;
var MaterialType;
(function (MaterialType) {
    MaterialType[MaterialType["item"] = 0] = "item";
    MaterialType[MaterialType["weapon"] = 1] = "weapon";
    MaterialType[MaterialType["armor"] = 2] = "armor";
})(MaterialType || (MaterialType = {}));
var Material = /** @class */ (function () {
    function Material(item, requiredNum) {
        this._num = 1;
        this._itemId = item.id;
        this._requiredNum = requiredNum;
        if (DataManager.isWeapon(item)) {
            this._type = MaterialType.weapon;
        }
        else if (DataManager.isArmor(item)) {
            this._type = MaterialType.armor;
        }
        else {
            this._type = MaterialType.item;
        }
    }
    Material.prototype.item = function () {
        switch (this._type) {
            case MaterialType.item:
                return $dataItems[this._itemId];
            case MaterialType.weapon:
                return $dataWeapons[this._itemId];
            case MaterialType.armor:
                return $dataArmors[this._itemId];
        }
    };
    Material.prototype.requiredNum = function () {
        return this._requiredNum * this._num;
    };
    Material.prototype.name = function () {
        return getItemName(this.item());
    };
    Material.prototype.nameJp = function () {
        return this.item().name;
    };
    Material.prototype.iconIndex = function () {
        return this.item().iconIndex;
    };
    Material.prototype.setNum = function (n) {
        this._num = n;
    };
    Material.prototype.posessionNum = function () {
        return $gameParty.numItems(this.item());
    };
    Material.prototype.rank = function () {
        var dungeonItem = getDungeonItem(this._itemId);
        if (dungeonItem) {
            return dungeonItem.rank();
        }
        return DungeonItemRank.A;
    };
    Material.prototype.isMaterialItem = function () {
        switch (this.rank()) {
            case DungeonItemRank.A: return true;
            case DungeonItemRank.shop: return true;
            case DungeonItemRank.alchemy: return true;
            case DungeonItemRank.event: return true;
        }
        return false;
    };
    return Material;
}());
var Category;
(function (Category) {
    Category[Category["all"] = 0] = "all";
    Category[Category["item"] = 2] = "item";
    Category[Category["weapon"] = 3] = "weapon";
    Category[Category["event"] = 5] = "event";
    Category[Category["bodyArmor"] = 6] = "bodyArmor";
    Category[Category["shield"] = 7] = "shield";
    Category[Category["card"] = 8] = "card";
    Category[Category["skill"] = 9] = "skill";
})(Category || (Category = {}));
var FilterType;
(function (FilterType) {
    FilterType[FilterType["all"] = 0] = "all";
    FilterType[FilterType["notAlchemy"] = 1] = "notAlchemy";
})(FilterType || (FilterType = {}));
var AlchemyCategory = /** @class */ (function () {
    function AlchemyCategory(_category) {
        this._category = _category;
    }
    AlchemyCategory.prototype.iconIndex = function () {
        switch (this._category) {
            case Category.all: return 12;
            case Category.weapon: return 65;
            case Category.item: return 208;
            case Category.event: return 968;
            case Category.bodyArmor: return 128;
            case Category.shield: return 115;
            case Category.card: return 543;
            case Category.skill: return 981;
        }
    };
    AlchemyCategory.prototype.category = function () {
        return this._category;
    };
    return AlchemyCategory;
}());
var AlchemyFilter = /** @class */ (function () {
    function AlchemyFilter(_filter) {
        this._filter = _filter;
    }
    AlchemyFilter.prototype.text = function () {
        switch (this._filter) {
            case FilterType.all: return TextManager.alchemyAll;
            case FilterType.notAlchemy: return TextManager.notAlchemy;
        }
    };
    AlchemyFilter.prototype.filter = function () {
        return this._filter;
    };
    return AlchemyFilter;
}());
var Alchemy = /** @class */ (function () {
    function Alchemy(_recipe) {
        this._recipe = _recipe;
        this._materialItems = [];
        this._materialPowers = [];
        this._num = 1;
        this.initMaterialPower();
        this.refresh();
    }
    Alchemy.prototype.initMaterialPower = function () {
        var list = this._recipe.materialList();
        for (var i = 0; i < list.length; i++) {
            this.addMaterialPower(i, list[i]);
        }
    };
    Alchemy.prototype.recipe = function () {
        return this._recipe;
    };
    Alchemy.prototype.addMaterialPower = function (index, n) {
        this._materialPowers[index] = n;
    };
    Alchemy.prototype.plusNum = function (wrap) {
        this._num++;
        if (this._num > this.maxNum()) {
            if (wrap) {
                this._num = 1;
            }
            else {
                this._num = this.maxNum();
            }
        }
    };
    Alchemy.prototype.minusNum = function (wrap) {
        this._num--;
        if (this._num < 1) {
            if (wrap) {
                this._num = this.maxNum();
            }
            else {
                this._num = 1;
            }
        }
    };
    Alchemy.prototype.num = function () {
        return this._num;
    };
    Alchemy.prototype.maxNum = function () {
        return this._maxNum;
    };
    Alchemy.prototype.canAlchemy = function () {
        if (!this.isRankAItemOk()) {
            return false;
        }
        if (!this._recipe.isConditionOk()) {
            return false;
        }
        for (var i = 0; i < this._materialPowers.length; i++) {
            var n = this._materialPowers[i];
            var current = $gameParty.materialList()[i];
            if (n > current) {
                return false;
            }
        }
        return true;
    };
    Alchemy.prototype.materialRate = function () {
        return $gameParty.alchemyManager().levelMaterialPer($gameParty.alchemyLevel()) / 100;
    };
    Alchemy.prototype.canAlchemyWithSeieki = function () {
        if (!this.isRankAItemOk()) {
            return false;
        }
        if (!this._recipe.isConditionOk()) {
            return false;
        }
        return this.isEnoughMaterialPowerWithSeieki();
    };
    Alchemy.prototype.isEnoughMaterialPowerWithSeieki = function () {
        var minus = this.needSeieki();
        var useSeieki = this._materialPowers[4];
        return minus + useSeieki <= $gameParty.materialList()[MaterialType.seieki];
    };
    Alchemy.prototype.isRankAItemOk = function () {
        for (var _i = 0, _a = this._materialItems; _i < _a.length; _i++) {
            var m = _a[_i];
            if (m.rank() == DungeonItemRank.A) {
                var n = $gameParty.numItems(m.item());
                if (n < m.requiredNum()) {
                    return false;
                }
            }
        }
        return true;
    };
    Alchemy.prototype.shortRankAItemList = function () {
        var result = [];
        for (var _i = 0, _a = this._materialItems; _i < _a.length; _i++) {
            var m = _a[_i];
            if (m.isMaterialItem()) {
                var n = $gameParty.numItems(m.item());
                if (n < m.requiredNum()) {
                    var shortCount = m.requiredNum() - n;
                    var item = m.item();
                    for (var i = 0; i < shortCount; i++) {
                        result.push(item);
                    }
                }
            }
        }
        return result;
    };
    Alchemy.prototype.needSeieki = function () {
        var minus = 0;
        for (var i = 0; i < this._materialPowers.length; i++) {
            var n = this._materialPowers[i];
            var current = $gameParty.materialList()[i];
            if (n > current) {
                minus += n - current;
            }
        }
        return minus;
    };
    Alchemy.prototype.needGold = function () {
        var n = 0;
        var list = this.shortRankAItemList();
        var goodsList = $gameSystem.shopStock().makeGoods();
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var item = list_1[_i];
            n += this.itemPrice(goodsList, item);
        }
        return n;
    };
    Alchemy.prototype.itemPrice = function (goodsList, item) {
        for (var _i = 0, goodsList_1 = goodsList; _i < goodsList_1.length; _i++) {
            var g = goodsList_1[_i];
            if (g[1] == item.id) {
                return Nore.shopPrice(item.id);
            }
        }
        return MAX_RECIPE_GOLD;
    };
    Alchemy.prototype.execute = function () {
        var needGold = this.needGold();
        if (!this.canAlchemyWithSeieki()) {
            if ($gameParty.gold() < needGold) {
                console.error('錬金が実行できません');
                return;
            }
        }
        this.loseMaterials();
        this.loseMaterialPower();
        this.loseGold(needGold);
        this.gainRecipeItem();
        this.gainExp();
        this.registerHistory();
        this.checkMedal();
        this.addMaseki();
        this.switchOn(this._recipe.destItem());
    };
    Alchemy.prototype.loseGold = function (gold) {
        if (gold == 0) {
            return;
        }
        SoundManager.playShop();
        $gameParty.loseGold(gold);
    };
    Alchemy.prototype.gainRecipeItem = function () {
        var actor = $gameParty.alchemyActor();
        var isFirstItem = false;
        var history = $gameSystem.alchemyHistory();
        if (!history.isRecipeMade(this._recipe.id())) {
            isFirstItem = true;
        }
        $gameTemp.alchemyResult = new AlchemyResult(this._recipe.destItem(), this._num, this._recipe.id(), actor.currentExp(), isFirstItem);
        $gameParty.gainAlchemyItem(this._recipe.destItem(), this._num);
    };
    Alchemy.prototype.gainExp = function () {
        var exp = $gameTemp.alchemyResult.exp();
        var actor = $gameParty.alchemyActor();
        var lastLevel = actor.level;
        actor.gainExp(exp);
        if (actor.level > lastLevel) {
            $gameMedals.onAlchemyLevelChange(actor.level);
        }
    };
    Alchemy.prototype.checkMedal = function () {
        var pictralBook = new PictralBook();
        var rate = pictralBook.collectionRate();
        $gameMedals.onEncyclopedia(rate);
    };
    Alchemy.prototype.loseMaterials = function () {
        for (var _i = 0, _a = this._materialItems; _i < _a.length; _i++) {
            var m = _a[_i];
            var n = m.requiredNum() * this._num;
            $gameParty.loseItem(m.item(), n);
        }
    };
    Alchemy.prototype.addMaseki = function () {
        var item = this._recipe.destItem();
        if (!item.meta['maseki']) {
            return;
        }
        var itemId = item.id;
        $gameParty.masekiActorSet().addMaseki(itemId);
    };
    Alchemy.prototype.loseMaterialPower = function () {
        var useSeieki = 0;
        for (var i = 0; i < this._materialPowers.length; i++) {
            var n = this._materialPowers[i];
            var current = $gameParty.materialList()[i];
            if (n <= current) {
                $gameParty.loseMaterialPower(i, n);
            }
            else {
                useSeieki = n - current;
                $gameParty.loseMaterialPower(i, current);
            }
        }
        if (useSeieki > 0) {
            p('使った精液:' + useSeieki);
            $gameParty.loseMaterialPower(MaterialType.seieki, useSeieki);
        }
    };
    Alchemy.prototype.registerHistory = function () {
        var h = $gameSystem.alchemyHistory();
        var result = $gameTemp.alchemyResult;
        h.addHistory(result);
        this.reserveCommonEvent(result.item());
        if (result.isItem()) {
            this.statusUp(result.item());
            this.getCard(result.item());
        }
    };
    Alchemy.prototype.getCard = function (item) {
        if (!item.meta['card']) {
            return;
        }
        if (item.meta['maseki']) {
            return;
        }
        var cardId = parseInt(item.meta['card']);
        for (var _i = 0, _a = $gameParty.getActorIdList(); _i < _a.length; _i++) {
            var id = _a[_i];
            var a = $gameActors.actor(id);
            var storage = a.baisyunPlayer().storage();
            storage.addCard(cardId);
        }
    };
    Alchemy.prototype.statusUp = function (item) {
        if (!item.meta['statusUp']) {
            return;
        }
        if (item.meta['hpUp']) {
            var actorId = parseInt(item.meta['actor']);
            if (isNaN(actorId)) {
                console.error('不正なactorIdです:' + item.id);
                return;
            }
            var actor = $gameActors.actor(actorId);
            var n = parseInt(item.meta['hpUp']);
            actor.addParam(0, n);
        }
    };
    Alchemy.prototype.reserveCommonEvent = function (item) {
        if (item.meta['commonEventId']) {
            if (item.meta['commonEventSw']) {
                var sw = parseInt(item.meta['commonEventSw']);
                if ($gameSwitches.value(sw)) {
                    p('commonEvent は登録しませんでした');
                    return;
                }
            }
            var commonEventId = parseInt(item.meta['commonEventId']);
            $commonEvent.reserveCommonEvent(commonEventId, CommonIdType.normal);
        }
    };
    Alchemy.prototype.refresh = function () {
        this._materialItems = this._recipe.materialItems(this._num);
        this._maxNum = this.calcMaxNum();
    };
    Alchemy.prototype.calcMaxNum = function () {
        var max = 9999;
        if (this.isOnce()) {
            if (this.canAlchemy()) {
                return 1;
            }
            else {
                return 0;
            }
        }
        for (var _i = 0, _a = this._materialItems; _i < _a.length; _i++) {
            var m = _a[_i];
            var n = $gameParty.numItems(m.item());
            var num = Math.floor(n / m.requiredNum());
            if (max > num) {
                max = num;
            }
        }
        return max;
    };
    Alchemy.prototype.switchOn = function (item) {
        var sw = -1;
        if (DataManager.isItem(item)) {
            switch (item.id) {
                case 201: //ソーマ
                    sw = 213;
                    break;
            }
        }
        if (sw > 0) {
            $gameSwitches.setValue(sw, true);
        }
    };
    Alchemy.prototype.isOnce = function () {
        return this._recipe.isOnce();
    };
    return Alchemy;
}());
var AlchemyManager = /** @class */ (function () {
    function AlchemyManager() {
    }
    AlchemyManager.prototype.canAlchemy = function (recipe) {
        var alchemy = new Alchemy(recipe);
        return alchemy.canAlchemy() && alchemy.needGold() == 0;
    };
    AlchemyManager.prototype.canAlchemyWithSeieki = function (recipe) {
        if (!recipe.isConditionOk()) {
            return false;
        }
        var alchemy = new Alchemy(recipe);
        var g = $gameParty.gold();
        if (alchemy.needGold() > 0) {
            return false;
        }
        return alchemy.canAlchemyWithSeieki();
    };
    AlchemyManager.prototype.canAlchemyWithSeiekiAndAutoBuy = function (recipe) {
        if (!recipe.isConditionOk()) {
            return AutoBuy.disable;
        }
        var alchemy = new Alchemy(recipe);
        if (!alchemy.isEnoughMaterialPowerWithSeieki()) {
            return AutoBuy.disable;
        }
        var g = $gameParty.gold();
        if (g < alchemy.needGold()) {
            return AutoBuy.disable;
        }
        for (var _i = 0, _a = alchemy.shortRankAItemList(); _i < _a.length; _i++) {
            var item = _a[_i];
            if (!Nore.isShopOnlyItemId(item.id)) {
                return AutoBuy.autoBuyMaterial;
            }
        }
        if (alchemy.needSeieki()) {
            return AutoBuy.autoBuyShopItemAndSeieki;
        }
        return AutoBuy.autoBuyShopItem;
    };
    AlchemyManager.prototype.levelMaterialPer = function (level) {
        return 100 - ((level - 1) * 2);
    };
    return AlchemyManager;
}());
var AutoBuy;
(function (AutoBuy) {
    AutoBuy[AutoBuy["autoBuyMaterial"] = 1] = "autoBuyMaterial";
    AutoBuy[AutoBuy["autoBuyShopItem"] = 2] = "autoBuyShopItem";
    AutoBuy[AutoBuy["disable"] = 3] = "disable";
    AutoBuy[AutoBuy["autoBuyShopItemAndSeieki"] = 4] = "autoBuyShopItemAndSeieki";
})(AutoBuy || (AutoBuy = {}));
