var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Scene_AlchemyEffect = /** @class */ (function (_super) {
    __extends(Scene_AlchemyEffect, _super);
    function Scene_AlchemyEffect() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._successEffectList = [];
        return _this;
    }
    Scene_AlchemyEffect.prototype.create = function () {
        _super.prototype.create.call(this);
        this.createPictures();
        this.createSuccessEffectContainer();
        this.createPictures2();
        this.createAlchemyEffect();
        this.createJar();
        this.createRosalie();
        this.createBar();
        this.createResultWindow();
        this.createExpWindow();
        this.createAlchemyButtonSprite();
        this.createFlashSprite();
        this.showInitialPicture();
        Input.clear();
    };
    Scene_AlchemyEffect.prototype.terminate = function () {
        _super.prototype.terminate.call(this);
        $gameScreen.erasePicture(1);
        $gameScreen.erasePicture(2);
        $gameScreen.erasePicture(3);
        $gameScreen.erasePicture(4);
        $gameScreen.erasePicture(5);
    };
    Scene_AlchemyEffect.prototype.start = function () {
        _super.prototype.start.call(this);
        this._alchemyResult = $gameTemp.alchemyResult;
        this._buttonSprite.refresh();
    };
    Scene_AlchemyEffect.prototype.showInitialPicture = function () {
        $gameScreen.showPicture(1, 'alchemy_back', 0, 0, 0, 100, 100, 255, 0);
    };
    Scene_AlchemyEffect.prototype.createSuccessEffectContainer = function () {
        this._successContainer = new Sprite();
        this.addChild(this._successContainer);
    };
    Scene_AlchemyEffect.prototype.startPictureEffect = function () {
        $gameScreen.erasePicture(1);
        if (ConfigManager.alchemyEffect) {
            $gameScreen.showPicture(1, 'alchemy_back2', 0, 0, 0, 100, 100, 255, 0);
        }
        //$gameScreen.showPicture(3, 'Halo4', 1, 640, 398, 200, 200, 200, 1);
        //$gameScreen.picture(3).rotate(3);
        $gameScreen.showPicture(4, 'Halo4', 1, 640, 398, 280, 280, 200, 1);
        $gameScreen.picture(4).rotate(-2);
        $gameScreen.showPicture(5, 'alchemy_level_back', 1, 643, 675, 100, 100, 255, 0);
        for (var i = 0; i < 4; i++) {
            var s = new Sprite_SuccessEffect(i);
            this._successContainer.addChild(s);
        }
    };
    Scene_AlchemyEffect.prototype.createPictures = function () {
        var width = Graphics.width;
        var height = Graphics.height;
        var x = (Graphics.width - width) / 2;
        var y = (Graphics.height - height) / 2;
        this._pictureContainer = new Sprite();
        this._pictureContainer.setFrame(x, y, width, height);
        for (var i = 0; i <= 1; i++) {
            this._pictureContainer.addChild(new Sprite_Picture(i));
        }
        this.addChild(this._pictureContainer);
    };
    Scene_AlchemyEffect.prototype.createPictures2 = function () {
        var width = Graphics.width;
        var height = Graphics.height;
        var x = (Graphics.width - width) / 2;
        var y = (Graphics.height - height) / 2;
        this._pictureContainer2 = new Sprite();
        this._pictureContainer2.setFrame(x, y, width, height);
        for (var i = 2; i <= 5; i++) {
            this._pictureContainer2.addChild(new Sprite_Picture(i));
        }
        this.addChild(this._pictureContainer2);
    };
    Scene_AlchemyEffect.prototype.createAlchemyEffect = function () {
        this._alchemyEffect = new Game_AlchemyEffect();
    };
    Scene_AlchemyEffect.prototype.createAlchemyButtonSprite = function () {
        this._buttonSprite = new Sprite_AlchemyButton();
        this.addChild(this._buttonSprite);
    };
    Scene_AlchemyEffect.prototype.createRosalie = function () {
        var rosalie = new Game_Rosalie();
        var char = new Sprite_Character(rosalie);
        this._rosalie = rosalie;
        this._rosalieSprite = char;
        this.addChild(char);
    };
    Scene_AlchemyEffect.prototype.createJar = function () {
        var jar = new Game_Jar();
        var char = new Sprite_Character(jar);
        this._jar = jar;
        this._charSprite = char;
        this.addChild(char);
    };
    Scene_AlchemyEffect.prototype.createBar = function () {
        this._barSprite = new Sprite_AlchemyBar(this._alchemyEffect);
        this.addChild(this._barSprite);
    };
    Scene_AlchemyEffect.prototype.createFlashSprite = function () {
        this._flashSprite = new Sprite_AlchemyFlash();
        this.addChild(this._flashSprite);
        this._flashSprite.setResultHandler(this.onResult.bind(this));
    };
    Scene_AlchemyEffect.prototype.createExpWindow = function () {
        this._expSprite = new Sprite_AlchemyExp();
        this.addChild(this._expSprite);
    };
    Scene_AlchemyEffect.prototype.createResultWindow = function () {
        this._resultNameSprite = new Sprite_AlchemyResultName();
        this._resultNameSprite.visible = false;
        this.addChild(this._resultNameSprite);
        this._resultNameSprite.x = 415;
        this._resultNameSprite.y = 492;
        this._resultImageSprite = new Sprite_AlchemyResultImage();
        this.addChild(this._resultImageSprite);
    };
    Scene_AlchemyEffect.prototype.onResult = function () {
        this.playResultSe();
        this._barSprite.visible = false;
        this._buttonSprite.visible = false;
        this.removeChild(this._charSprite);
        this.removeChild(this._rosalieSprite);
        this._resultNameSprite.showResult(this._alchemyResult.item());
        this._resultImageSprite.showResult(this._alchemyResult.item(), this._alchemyResult.num());
        this._expSprite.showResult(this._alchemyResult);
        this.startPictureEffect();
    };
    Scene_AlchemyEffect.prototype.playResultSe = function () {
        AudioManager.playSe({ name: 'Flash2', volume: 90, pitch: 100, pan: 0 });
    };
    Scene_AlchemyEffect.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateJar();
        this.updateFinish();
        this.updateInput();
        $gameScreen.update();
    };
    Scene_AlchemyEffect.prototype.updateJar = function () {
        if (this._jar) {
            this._jar.update();
        }
        if (this._rosalie) {
            if (this._buttonSprite.isPressed()) {
                this._rosalie.setMoveSpeed(5);
            }
            else {
                this._rosalie.setMoveSpeed(2);
            }
            this._rosalie.update();
        }
    };
    Scene_AlchemyEffect.prototype.updateFinish = function () {
        if (!this._flashSprite) {
            return;
        }
        if (this._flashSprite.isFinished()) {
            if (Input.isTriggered('ok') || TouchInput.isClicked()) {
                SoundManager.playOk();
                this.popScene();
            }
        }
    };
    Scene_AlchemyEffect.prototype.updateInput = function () {
        if (!this._alchemyEffect) {
            return;
        }
        if (this._alchemyEffect.isMax()) {
            return;
        }
        if (Input.isPressed('ok') || Input.isPressed('cancel') || TouchInput.isPressed()) {
            this._alchemyEffect.upValue();
            this._buttonSprite.setPress(true);
            if (this._alchemyEffect.isMax()) {
                this._flashSprite.startEffect();
            }
        }
        else {
            this._buttonSprite.setPress(false);
        }
    };
    Scene_AlchemyEffect.prototype.popScene = function () {
        if ($commonEvent.isCommonEventReserved(CommonIdType.normal)) {
            SceneManager.popAllScene();
        }
        else {
            _super.prototype.popScene.call(this);
        }
    };
    return Scene_AlchemyEffect;
}(Scene_Base));
var AlchemyResult = /** @class */ (function () {
    function AlchemyResult(item, num, recipeId, lastExp, isFirstItem) {
        this._itemId = item.id;
        this._recipeId = recipeId;
        if (DataManager.isItem(item)) {
            this._isItem = true;
        }
        else if (DataManager.isArmor(item)) {
            this._isArmor = true;
        }
        else if (DataManager.isWeapon(item)) {
            this._isWeapon = true;
        }
        this._isFirstItem = isFirstItem;
        this._num = num;
        this._lastExp = lastExp;
        this.calcExp();
    }
    AlchemyResult.prototype.calcExp = function () {
        var exp = this.findRecipeParam().exp();
        if (!this._isFirstItem) {
            exp /= 4;
        }
        this._exp = Math.round(exp * this._num);
    };
    AlchemyResult.prototype.findRecipeParam = function () {
        return $recipeManager.findRecipeParam(this._recipeId);
    };
    AlchemyResult.prototype.exp = function () {
        return this._exp;
    };
    AlchemyResult.prototype.item = function () {
        if (this._isItem) {
            return $dataItems[this._itemId];
        }
        if (this._isWeapon) {
            return $dataWeapons[this._itemId];
        }
        if (this._isArmor) {
            return $dataArmors[this._itemId];
        }
        return null;
    };
    AlchemyResult.prototype.num = function () {
        return this._num;
    };
    AlchemyResult.prototype.isItem = function () {
        return this._isItem;
    };
    AlchemyResult.prototype.lastExp = function () {
        return this._lastExp;
    };
    AlchemyResult.prototype.isFirstItem = function () {
        return this._isFirstItem;
    };
    AlchemyResult.prototype.isArmor = function () {
        return this._isArmor;
    };
    AlchemyResult.prototype.isWeapon = function () {
        return this._isWeapon;
    };
    return AlchemyResult;
}());
var Game_AlchemyEffect = /** @class */ (function () {
    function Game_AlchemyEffect() {
        this._value = 0;
    }
    Game_AlchemyEffect.prototype.value = function () {
        return this._value;
    };
    Game_AlchemyEffect.prototype.upValue = function () {
        this._value++;
        if (this._value > this.maxValue()) {
            this._value = this.maxValue();
        }
    };
    Game_AlchemyEffect.prototype.maxValue = function () {
        return 75;
    };
    Game_AlchemyEffect.prototype.rate = function () {
        return this._value / this.maxValue();
    };
    Game_AlchemyEffect.prototype.isMax = function () {
        return this._value >= this.maxValue();
    };
    return Game_AlchemyEffect;
}());
var Sprite_AlchemyFlash = /** @class */ (function (_super) {
    __extends(Sprite_AlchemyFlash, _super);
    function Sprite_AlchemyFlash() {
        var _this = _super.call(this) || this;
        var g = new PIXI.Graphics();
        g.beginFill(0x999955, 1);
        g.drawRect(0, 0, Graphics.width, Graphics.height);
        g.endFill();
        _this.addChild(g);
        _this.alpha = 0;
        return _this;
    }
    Sprite_AlchemyFlash.prototype.startEffect = function () {
        this._fadeIn = true;
        AudioManager.playSe({ name: 'Flash3', volume: 90, pitch: 110, pan: 0 });
    };
    Sprite_AlchemyFlash.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._finished) {
            return;
        }
        if (this._fadeIn) {
            this.alpha += 0.015;
            if (this.alpha >= 1) {
                this._fadeIn = false;
                this._fadeOut = true;
                this._resultHandler.call(this);
            }
        }
        else if (this._fadeOut) {
            this.alpha -= 0.02;
            if (this.alpha <= 0) {
                this._finished = true;
            }
        }
    };
    Sprite_AlchemyFlash.prototype.setResultHandler = function (f) {
        this._resultHandler = f;
    };
    Sprite_AlchemyFlash.prototype.isFinished = function () {
        return this._finished;
    };
    return Sprite_AlchemyFlash;
}(Sprite));
var Sprite_AlchemyBar = /** @class */ (function (_super) {
    __extends(Sprite_AlchemyBar, _super);
    function Sprite_AlchemyBar(alchemyEffect) {
        var _this = _super.call(this) || this;
        _this.x = 420;
        _this.y = ALCHEMY_BAR_Y;
        _this._alchemyEffect = alchemyEffect;
        _this.bitmap = new Bitmap(450, 80);
        _this.refresh();
        return _this;
    }
    Sprite_AlchemyBar.prototype.refresh = function () {
        this._lastValue = this._alchemyEffect.value();
        this.bitmap.clear();
        this.drawBg(0, 0);
        this.drawBar(26, 13);
    };
    Sprite_AlchemyBar.prototype.drawBg = function (x, y) {
        var bitmap = ImageManager.loadSystem('alchemy_ui');
        this.bitmap.blt(bitmap, 0, 300, 450, 50, x, y);
    };
    Sprite_AlchemyBar.prototype.drawBar = function (x, y) {
        var bitmap = ImageManager.loadSystem('alchemy_ui');
        var w = 390;
        var ww = Math.round(w * this._alchemyEffect.rate());
        if (ww == 0) {
            return;
        }
        this.bitmap.blt(bitmap, 0, 350, ww, 18, x, y, ww);
    };
    Sprite_AlchemyBar.prototype.updateSe = function () {
        if (this._lastValue % 5 != 0) {
            return;
        }
        var index = Math.round(this._lastValue / 4);
        AudioManager.playSe({ name: 'FCPC1_SE03_Select03', volume: 90, pitch: 40 + index * 3, pan: 0 });
    };
    Sprite_AlchemyBar.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
            this.updateSe();
        }
    };
    Sprite_AlchemyBar.prototype.isChanged = function () {
        if (!this._alchemyEffect) {
            return false;
        }
        return this._lastValue != this._alchemyEffect.value();
    };
    return Sprite_AlchemyBar;
}(Sprite));
var ALCHEMY_EFFECT_CHAR_Y = 520;
var ALCHEMY_BAR_Y = 612;
var Game_Jar = /** @class */ (function (_super) {
    __extends(Game_Jar, _super);
    function Game_Jar() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Game_Jar.prototype.characterName = function () {
        return '!$athanor';
    };
    Game_Jar.prototype.characterIndex = function () {
        return 0;
    };
    Game_Jar.prototype.hasStepAnime = function () {
        return false;
    };
    Game_Jar.prototype.screenX = function () {
        return 630;
    };
    Game_Jar.prototype.screenY = function () {
        return ALCHEMY_EFFECT_CHAR_Y;
    };
    return Game_Jar;
}(Game_Character));
var Game_Rosalie = /** @class */ (function (_super) {
    __extends(Game_Rosalie, _super);
    function Game_Rosalie() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Game_Rosalie.prototype.characterName = function () {
        return '!$rosalie';
    };
    Game_Rosalie.prototype.characterIndex = function () {
        return 0;
    };
    Game_Rosalie.prototype.hasStepAnime = function () {
        return true;
    };
    Game_Rosalie.prototype.screenX = function () {
        return 630;
    };
    Game_Rosalie.prototype.screenY = function () {
        return ALCHEMY_EFFECT_CHAR_Y - 224;
    };
    Game_Rosalie.prototype.direction = function () {
        return 8;
    };
    return Game_Rosalie;
}(Game_Character));
var Sprite_AlchemyResultName = /** @class */ (function (_super) {
    __extends(Sprite_AlchemyResultName, _super);
    function Sprite_AlchemyResultName(hiddenBg) {
        if (hiddenBg === void 0) { hiddenBg = false; }
        var _this = _super.call(this) || this;
        _this._hiddenBg = hiddenBg;
        _this.bitmap = new Bitmap(450, 100);
        _this.bitmap.fontSize = 28;
        _this.bitmap.outlineWidth = 6;
        _this.bitmap.fontFace = $gameSystem.mainFontFace();
        return _this;
    }
    Sprite_AlchemyResultName.prototype.showResult = function (item) {
        this.bitmap.clear();
        this.drawBg();
        this.drawItemName(item, 43, 24, 390);
        this.visible = true;
    };
    Sprite_AlchemyResultName.prototype.drawBg = function () {
        var sy = this._hiddenBg ? 500 : 0;
        var bitmap = ImageManager.loadSystem('alchemy_ui');
        this.bitmap.blt(bitmap, 0, sy, 450, 100, 7, 0);
    };
    Sprite_AlchemyResultName.prototype.drawItemName = function (item, x, y, width) {
        if (item) {
            var iconY = y - 10;
            var textMargin = ImageManager.iconWidth + 4;
            this.drawIcon(item.iconIndex, x, iconY);
            var name_1 = getItemName(item);
            var dropShadow = 2;
            if (this.isShortName(name_1)) {
                this.shadowFontSetting();
                this.bitmap.drawText(name_1, x + 32 + 44 + dropShadow, y + dropShadow, 220, 40, 'center');
                this.mainFontSetting();
                this.bitmap.drawText(name_1, x + 32 + 44, y, 220, 40, 'center');
            }
            else {
                this.shadowFontSetting();
                this.bitmap.drawText(name_1, x + 32 + 34 + dropShadow, y + dropShadow, 290, 40, 'left');
                this.mainFontSetting();
                this.bitmap.drawText(name_1, x + 32 + 34, y, 290, 40, 'left');
            }
        }
    };
    Sprite_AlchemyResultName.prototype.isShortName = function (name) {
        if (ConfigManager.isJp()) {
            return name.length < 10;
        }
        else {
            return name.length < 18;
        }
    };
    Sprite_AlchemyResultName.prototype.mainFontSetting = function () {
        this.bitmap.textColor = '#FFFFFF';
        this.bitmap.outlineColor = '#361800';
    };
    Sprite_AlchemyResultName.prototype.shadowFontSetting = function () {
        this.bitmap.textColor = '#000000';
        this.bitmap.outlineColor = '#000000';
    };
    Sprite_AlchemyResultName.prototype.lineHeight = function () {
        return 32;
    };
    Sprite_AlchemyResultName.prototype.drawIcon = function (iconIndex, x, y) {
        var bitmap = ImageManager.loadSystem("IconSet");
        var pw = ImageManager.iconWidth;
        var ph = ImageManager.iconHeight;
        var sx = (iconIndex % 16) * pw;
        var sy = Math.floor(iconIndex / 16) * ph;
        this.drawScaleUpBitmap(bitmap, sx, sy, pw, ph, x, y);
        //this.bitmap.blt(bitmap, sx, sy, pw, ph, x, y, pw * 4, ph * 4);
    };
    Sprite_AlchemyResultName.prototype.drawScaleUpBitmap = function (bitmap, sx, sy, pw, ph, dx, dy) {
        var scale = 2;
        for (var xx = 0; xx < pw; xx++) {
            for (var yy = 0; yy < ph; yy++) {
                var x = xx + sx;
                var y = yy + sy;
                var pixel = bitmap.getPixel(x, y);
                if (pixel == '#000000') {
                    continue;
                }
                this.bitmap.fillRect(dx + xx * scale, dy + yy * scale, scale, scale, pixel);
            }
        }
    };
    return Sprite_AlchemyResultName;
}(Sprite));
var Sprite_AlchemyResultImage = /** @class */ (function (_super) {
    __extends(Sprite_AlchemyResultImage, _super);
    function Sprite_AlchemyResultImage() {
        var _this = _super.call(this) || this;
        _this.x = 578 - 16;
        _this.y = 330 - 16;
        _this.bitmap = new Bitmap(32 * 7, 32 * 5);
        return _this;
    }
    Sprite_AlchemyResultImage.prototype.showResult = function (item, num) {
        this.drawIcon(item.iconIndex, 0, 0);
        this.bitmap.fontSize = 30;
        //this.bitmap.drawText('×' + num, 150, 100, 100, 32);
        this.visible = true;
    };
    Sprite_AlchemyResultImage.prototype.drawIcon = function (iconIndex, x, y) {
        var bitmap = ImageManager.loadSystem("IconSet");
        var pw = ImageManager.iconWidth;
        var ph = ImageManager.iconHeight;
        var sx = (iconIndex % 16) * pw;
        var sy = Math.floor(iconIndex / 16) * ph;
        this.drawScaleUpBitmap(bitmap, sx, sy, pw, ph, x, y);
    };
    Sprite_AlchemyResultImage.prototype.drawScaleUpBitmap = function (bitmap, sx, sy, pw, ph, dx, dy) {
        var scale = 5;
        for (var xx = 0; xx < pw; xx++) {
            for (var yy = 0; yy < ph; yy++) {
                var x = xx + sx;
                var y = yy + sy;
                var pixel = bitmap.getPixel(x, y);
                if (pixel == '#000000') {
                    continue;
                }
                this.bitmap.fillRect(dx + xx * scale, dy + yy * scale, scale, scale, pixel);
            }
        }
    };
    return Sprite_AlchemyResultImage;
}(Sprite));
SceneManager.popAllScene = function () {
    if (this._stack.length > 0) {
        var num = this._stack.length;
        for (var i = 0; i < num; i++) {
            this.goto(this._stack.pop());
        }
    }
    else {
        this.exit();
    }
};
var Sprite_AlchemyExp = /** @class */ (function (_super) {
    __extends(Sprite_AlchemyExp, _super);
    function Sprite_AlchemyExp() {
        var _this = this;
        var r = new Rectangle(450, 640, 390, 110);
        _this = _super.call(this) || this;
        _this.bitmap = new Bitmap(390, 150);
        _this.x = 450;
        _this.y = 610;
        _this.visible = false;
        return _this;
    }
    Sprite_AlchemyExp.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._finished) {
            return;
        }
        if (this._started) {
            this._per++;
            if (this._per >= 100) {
                this._per = 0;
                AudioManager.playSe({ name: 'LNSM_SE04_Sense4', volume: 90, pitch: 100, pan: 0 });
                this._level++;
            }
            this.refresh();
            if (this.checkFinished()) {
                this._finished = true;
            }
        }
    };
    Sprite_AlchemyExp.prototype.checkFinished = function () {
        if (this._level < this._afterLevel) {
            return false;
        }
        if (this._level > this._afterLevel) {
            return true;
        }
        if (this._per >= this._afterPer) {
            return true;
        }
        return false;
    };
    Sprite_AlchemyExp.prototype.showResult = function (result) {
        this.visible = true;
        var actor = $gameParty.alchemyActor();
        this._afterLevel = actor.level;
        var expActor = $gameActors.actor(99);
        this._beforeExp = result.lastExp();
        this._afterExp = actor.currentExp();
        this._gainExp = this._afterExp - this._beforeExp;
        this._afterLevel = actor.level;
        this._afterPer = Math.floor(actor.calcExpRate(0) * 100);
        expActor.changeExp(this._beforeExp, false);
        this._beforeLevel = expActor.level;
        this._level = this._beforeLevel;
        this._beforePer = Math.floor(expActor.calcExpRate(0) * 100);
        this._per = this._beforePer;
        if (expActor.isMaxLevel()) {
            this._per = 0;
            this._afterPer = 0;
        }
        this._firstItem = result.isFirstItem();
        this._started = true;
        this.refresh();
    };
    Sprite_AlchemyExp.prototype.refresh = function () {
        this.bitmap.clear();
        this.removeChildren();
        this.refreshExp();
        this.refreshLevel(35, -2);
        this.refreshGauge();
    };
    Sprite_AlchemyExp.prototype.refreshExp = function () {
        this.refreshExpLabel(235, 62);
        this.drawNumber(this._gainExp, 300, 61, 100, 'left', 7);
        if (this._firstItem) {
            this.refreshFirstBonus(70, 62);
        }
    };
    Sprite_AlchemyExp.prototype.refreshExpLabel = function (x, y) {
        var bitmap = ImageManager.loadSystem('alchemy_ui');
        this.bitmap.blt(bitmap, 0, 200, 450, 50, x, y);
    };
    Sprite_AlchemyExp.prototype.refreshLevel = function (x, y) {
        var bitmap = ImageManager.loadSystem('alchemy_ui');
        var sx = ConfigManager.isJp() ? 0 : 200;
        this.bitmap.blt(bitmap, sx, 100, 200, 50, x, y);
        if ($gameActors.actor(99).maxLevel() == this._level) {
            this.bitmap.blt(bitmap, 200, 200, 200, 50, 146, y);
        }
        else {
            this.drawNumber(this._level, 146, 0, 100, 'left', 16);
        }
    };
    Sprite_AlchemyExp.prototype.refreshFirstBonus = function (x, y) {
        var bitmap = ImageManager.loadSystem('alchemy_ui');
        var sx = ConfigManager.isJp() ? 0 : 200;
        this.bitmap.blt(bitmap, sx, 150, 200, 50, x, y);
    };
    Sprite_AlchemyExp.prototype.refreshGauge = function () {
        var xx = 49;
        var yy = 63;
        var w = 282;
        var hh = 12;
        //this.contents.fillRect(xx, yy, ww, hh, '#000000');
        var rate = this._per / 100;
        var bitmap = ImageManager.loadSystem('alchemy_ui');
        var ww = Math.floor(w * rate);
        this.bitmap.blt(bitmap, 0, 250, ww, 20, xx, yy, ww);
        //this.bitmap.fillRect(xx, yy, Math.floor(ww * rate), hh, '#FFFF00');
    };
    return Sprite_AlchemyExp;
}(Sprite));
var Sprite_AlchemyButton = /** @class */ (function (_super) {
    __extends(Sprite_AlchemyButton, _super);
    function Sprite_AlchemyButton() {
        var _this = _super.call(this) || this;
        _this._pressed = false;
        _this._index = 0;
        _this._waitFrame = 0;
        _this._arrowSprite = new Sprite_AlchemyArrow();
        _this._arrowSprite.x = 81;
        _this.addChild(_this._arrowSprite);
        _this.updateArrowVisible();
        ImageManager.loadCharacter('!Switch1');
        _this.bitmap = new Bitmap(200, 140);
        _this.x = 290;
        _this.y = ALCHEMY_BAR_Y - 79;
        return _this;
    }
    Sprite_AlchemyButton.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._pressed && this._index < 3) {
            this.updatePress();
        }
        else if (!this._pressed && this._index > 0) {
            this.updateUnpress();
        }
    };
    Sprite_AlchemyButton.prototype.updatePress = function () {
        this._waitFrame--;
        if (this._waitFrame <= 0) {
            this._waitFrame = this.maxWaitFrame();
            this._index++;
            this.refreshImage();
        }
    };
    Sprite_AlchemyButton.prototype.updateUnpress = function () {
        this._waitFrame--;
        if (this._waitFrame <= 0) {
            this._waitFrame = this.maxWaitFrame();
            this._index--;
            this.refreshImage();
        }
    };
    Sprite_AlchemyButton.prototype.maxWaitFrame = function () {
        return 3;
    };
    Sprite_AlchemyButton.prototype.refresh = function () {
        this._arrowSprite.refresh();
        this._switchBitmap = ImageManager.loadCharacter('!Switch1');
        this.refreshImage();
    };
    Sprite_AlchemyButton.prototype.refreshImage = function () {
        this.bitmap.clear();
        var b = this._switchBitmap;
        var size = 48;
        if (!this._pressed && this.isTurorial()) {
            this.bitmap.drawText(TextManager.alchemyButton, 0, 12, 200, 32, 'center');
        }
        this.bitmap.blt(b, 0, size * 4 + this._index * size, size, size, 70, 70);
    };
    Sprite_AlchemyButton.prototype.isTurorial = function () {
        return $gameSystem.alchemyHistory().alchemyCount() <= 1;
    };
    Sprite_AlchemyButton.prototype.isPressed = function () {
        return this._pressed;
    };
    Sprite_AlchemyButton.prototype.setPress = function (b) {
        if (this._pressed == b) {
            return;
        }
        this._pressed = b;
        if (this._pressed) {
            this._arrowSprite.visible = false;
            this._index = 0;
            this._waitFrame = 1;
        }
        else {
            this.updateArrowVisible();
            this._index = 3;
            this._waitFrame = 1;
        }
    };
    Sprite_AlchemyButton.prototype.updateArrowVisible = function () {
        this._arrowSprite.visible = this.isArrowVisible();
    };
    Sprite_AlchemyButton.prototype.isArrowVisible = function () {
        if (this._pressed) {
            return false;
        }
        if (!this.isTurorial()) {
            return false;
        }
        return true;
    };
    return Sprite_AlchemyButton;
}(Sprite));
var Sprite_AlchemyArrow = /** @class */ (function (_super) {
    __extends(Sprite_AlchemyArrow, _super);
    function Sprite_AlchemyArrow() {
        var _this = _super.call(this) || this;
        _this._index = 0;
        _this.bitmap = ImageManager.loadSystem('alchemy_arrow');
        return _this;
    }
    Sprite_AlchemyArrow.prototype.refresh = function () {
        this.bitmap = ImageManager.loadSystem('alchemy_arrow');
    };
    Sprite_AlchemyArrow.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._reverse) {
            this._index--;
            if (this._index <= 0) {
                this._reverse = false;
            }
        }
        else {
            this._index++;
            if (this._index >= 16) {
                this._reverse = true;
            }
        }
        this.y = this.baseY() + this._index / 2;
    };
    Sprite_AlchemyArrow.prototype.baseY = function () {
        return 43;
    };
    return Sprite_AlchemyArrow;
}(Sprite));
var Sprite_SuccessEffect = /** @class */ (function (_super) {
    __extends(Sprite_SuccessEffect, _super);
    function Sprite_SuccessEffect(index) {
        var _this = _super.call(this) || this;
        _this._reverse = false;
        _this._index = index;
        _this.bitmap = ImageManager.loadPicture('success' + (index + 1));
        var ww = Math.floor(_this.bitmap.width / 4);
        _this.x = _this.calcX(index) + 180;
        _this.y = 55 + Math.floor((257 - _this.imageHeight()) / 2);
        _this._easingExponent = 2;
        _this._wait = index * 6;
        _this.moveTo(_this.x, _this.y - _this.distance(), 60);
        return _this;
    }
    Sprite_SuccessEffect.prototype.imageHeight = function () {
        switch (this._index) {
            case 0: return 246;
            case 1: return 257;
            case 2: return 244;
            case 3: return 250;
        }
    };
    Sprite_SuccessEffect.prototype.calcX = function (index) {
        switch (index) {
            case 0: return 0;
            case 1: return 229;
            case 2: return 459;
            case 3: return 459 + 229;
        }
    };
    Sprite_SuccessEffect.prototype.moveTo = function (x, y, duration) {
        this._targetX = x;
        this._targetY = y;
        this._duration = duration;
        this._wholeDuration = duration;
        this._easingExponent = 2;
    };
    Sprite_SuccessEffect.prototype.easeInOut = function (t, exponent) {
        if (t < 0.5) {
            return this.easeIn(t * 2, exponent) / 2;
        }
        else {
            return this.easeOut(t * 2 - 1, exponent) / 2 + 0.5;
        }
    };
    Sprite_SuccessEffect.prototype.easeIn = function (t, exponent) {
        return Math.pow(t, exponent);
    };
    Sprite_SuccessEffect.prototype.easeOut = function (t, exponent) {
        return 1 - Math.pow(1 - t, exponent);
    };
    Sprite_SuccessEffect.prototype.applyEasing = function (current, target) {
        var d = this._duration;
        var wd = this._wholeDuration;
        var lt = this.calcEasing((wd - d) / wd);
        var t = this.calcEasing((wd - d + 1) / wd);
        var start = (current - target * lt) / (1 - lt);
        return start + (target - start) * t;
    };
    Sprite_SuccessEffect.prototype.calcEasing = function (t) {
        var exponent = this._easingExponent;
        return this.easeInOut(t, exponent);
    };
    Sprite_SuccessEffect.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateMove();
    };
    Sprite_SuccessEffect.prototype.updateMove = function () {
        if (this._wait > 0) {
            this._wait--;
            return;
        }
        if (this._duration > 0) {
            this.x = this.applyEasing(this.x, this._targetX);
            this.y = this.applyEasing(this.y, this._targetY);
            this._duration--;
        }
        else {
            if (this._reverse) {
                this._reverse = false;
                this.moveTo(this.x, this.y - this.distance(), 60);
            }
            else {
                this._reverse = true;
                this.moveTo(this.x, this.y + this.distance(), 60);
            }
        }
    };
    Sprite_SuccessEffect.prototype.distance = function () {
        return 30;
    };
    return Sprite_SuccessEffect;
}(Sprite));
