var AlchemyHistory = /** @class */ (function () {
    function AlchemyHistory() {
        this._resultList = [];
    }
    AlchemyHistory.prototype.alchemyCount = function () {
        return this._resultList.length;
    };
    AlchemyHistory.prototype.addHistory = function (h) {
        this._resultList.push(h);
    };
    AlchemyHistory.prototype.isItemMade = function (item) {
        for (var _i = 0, _a = this._resultList; _i < _a.length; _i++) {
            var r = _a[_i];
            if (DataManager.isItem(item)) {
                if (r.isItem() && r.item().id == item.id) {
                    return true;
                }
            }
            else if (DataManager.isArmor(item)) {
                if (r.isArmor() && r.item().id == item.id) {
                    return true;
                }
            }
            else if (DataManager.isWeapon(item)) {
                if (r.isWeapon() && r.item().id == item.id) {
                    return true;
                }
            }
        }
        return false;
    };
    AlchemyHistory.prototype.isRecipeMade = function (recipeId) {
        if (!$recipeManager.findRecipeParam(recipeId).isVisible()) {
            return true;
        }
        for (var _i = 0, _a = this._resultList; _i < _a.length; _i++) {
            var r = _a[_i];
            if (r._recipeId == recipeId) {
                return true;
            }
        }
        return false;
    };
    return AlchemyHistory;
}());
