/*:ja
 * @target MZ
 * @author ル
 *
 * @command checkNewRecipe
 * @text 新レシピチェック
 * @des 新レシピチェック
 *
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_AlchemyRecipe';
    PluginManager.registerCommand(pluginName, 'checkNewRecipe', function (args) {
        var newRecipeId = $gameParty.nextNewRecipe();
        if (newRecipeId > 0) {
            $gameSwitches.setValue(32, true);
            var param = $recipeManager.findRecipeParam(newRecipeId);
            var name_1 = getItemName(param.destItem());
            $gameVariables.setValue(15, name_1);
        }
        else {
            $gameSwitches.setValue(32, false);
        }
    });
})(Nore || (Nore = {}));
var Recipe = /** @class */ (function () {
    function Recipe(recipeParam) {
        this._materialItems = [];
        this._materialPowers = [];
        this._recipeParam = recipeParam;
        this.makeMaterialItems();
    }
    Recipe.prototype.makeMaterialItems = function () {
        for (var i = 1; i <= 4; i++) {
            var item = this._recipeParam.sourceItem(i);
            if (item) {
                var m1 = new Material(item, this._recipeParam.sourceValue(i));
                this._materialItems.push(m1);
            }
        }
    };
    Recipe.prototype.addMaterial = function (m) {
        this._materialItems.push(m);
    };
    Recipe.prototype.name = function () {
        return getItemName(this.destItem());
    };
    Recipe.prototype.destItem = function () {
        return this._recipeParam.destItem();
    };
    Recipe.prototype.iconIndex = function () {
        return this.destItem().iconIndex;
    };
    Recipe.prototype.materialItems = function (num) {
        if (num === void 0) { num = 1; }
        var result = this._materialItems.concat();
        for (var _i = 0, result_1 = result; _i < result_1.length; _i++) {
            var m = result_1[_i];
            m.setNum(num);
        }
        return result;
    };
    Recipe.prototype.materialItemsForAlchemy = function (num) {
        if (num === void 0) { num = 1; }
        var result = [];
        for (var _i = 0, _a = this._materialItems; _i < _a.length; _i++) {
            var m = _a[_i];
            if (!m.isMaterialItem()) {
                continue;
            }
            if (m.requiredNum() > 0) {
                result.push(m);
                m.setNum(num);
            }
        }
        return result;
    };
    Recipe.prototype.isOnce = function () {
        return this.destItem().meta['once'];
    };
    Recipe.prototype.posessionNum = function () {
        return $gameParty.numItems(this.destItem());
    };
    Recipe.prototype.level = function () {
        return this._recipeParam.level();
    };
    Recipe.prototype.stage = function () {
        var source = this._recipeParam.sourceItem1();
        if (source) {
            if (source.meta['dungeon']) {
                return parseInt(source.meta['dungeon']);
            }
        }
        console.error('レシピに stage が設定されていません');
        console.error(this._recipeParam);
        return 0;
    };
    Recipe.prototype.id = function () {
        return this._recipeParam.id();
    };
    Recipe.prototype.materialList = function () {
        var mRate = this.materialRate();
        return [
            Math.floor(this._recipeParam.flame() * mRate),
            Math.floor(this._recipeParam.water() * mRate),
            Math.floor(this._recipeParam.wood() * mRate),
            Math.floor(this._recipeParam.metal() * mRate),
            Math.floor(this._recipeParam.seieki() * mRate),
        ];
    };
    Recipe.prototype.materialRate = function () {
        return $gameParty.alchemyManager().levelMaterialPer($gameParty.alchemyLevel()) / 100;
    };
    Recipe.prototype.sortValue = function () {
        var categoryValue = this.sortCategoryValue() * 100000;
        var plusValue = 0;
        if (this.isClearItem()) {
            plusValue = -10000;
        }
        if (this.isStatusUp()) {
            plusValue += 10000;
        }
        var lvValue = this.level() * 1000;
        return categoryValue + plusValue + lvValue + this.id();
    };
    Recipe.prototype.sortCategoryValue = function () {
        var item = this.destItem();
        if (this.isEvent()) {
            return 1;
        }
        if (this.isCard()) {
            return 2;
        }
        if (this.isRelic()) {
            return 3;
        }
        if (this.isMaseki()) {
            return 4;
        }
        if (this.isSkill()) {
            return 5;
        }
        if (this.isWeapon()) {
            return 6;
        }
        if (this.isBodyArmor()) {
            return 7;
        }
        if (this.isShield()) {
            return 8;
        }
        return 9;
    };
    Recipe.prototype.isEvent = function () {
        if (this.isCard()) {
            return false;
        }
        if (DataManager.isItem(this.destItem())) {
            return this.destItem().meta['event'] || this.destItem().meta['statusUp'];
        }
        return false;
    };
    Recipe.prototype.isClearItem = function () {
        if (DataManager.isItem(this.destItem())) {
            return this.destItem().meta['clearItem'];
        }
        return false;
    };
    Recipe.prototype.isStatusUp = function () {
        return this.destItem().meta['statusUp'];
    };
    Recipe.prototype.isWeapon = function () {
        return DataManager.isWeapon(this.destItem());
    };
    Recipe.prototype.isArmor = function () {
        return DataManager.isArmor(this.destItem());
    };
    Recipe.prototype.isEquipItem = function () {
        if (!this.isArmor()) {
            return false;
        }
        var armor = this.destItem();
        return armor.etypeId == 3;
    };
    Recipe.prototype.isShield = function () {
        if (!this.isArmor()) {
            return false;
        }
        var armor = this.destItem();
        return armor.etypeId == 6;
    };
    Recipe.prototype.isBodyArmor = function () {
        if (!this.isArmor()) {
            return false;
        }
        var armor = this.destItem();
        return armor.etypeId == 2;
    };
    Recipe.prototype.isSkill = function () {
        if (!this.isArmor()) {
            return false;
        }
        var armor = this.destItem();
        return armor.etypeId == 7;
    };
    Recipe.prototype.isCard = function () {
        return this.destItem().meta['card'] != null;
    };
    Recipe.prototype.isRelic = function () {
        return this.destItem().meta['relic'] != null;
    };
    Recipe.prototype.isMaseki = function () {
        return this.destItem().meta['maseki'] != null;
    };
    Recipe.prototype.isConditionOk = function () {
        return this._recipeParam.isCondiionOk();
    };
    Recipe.prototype.isCollection = function () {
        var item = this.destItem();
        if (item.meta['notCollection'] != null) {
            return false;
        }
        return true;
    };
    return Recipe;
}());
var RecipeManager = /** @class */ (function () {
    function RecipeManager() {
        this.parse();
    }
    RecipeManager.prototype.parse = function () {
        this._map = {};
        for (var key in RECIPE_MAP) {
            var array = RECIPE_MAP[key];
            this._map[key] = new RecipeParam(array, parseInt(key));
        }
    };
    RecipeManager.prototype.findRecipeParam = function (recipeId) {
        var param = this._map[recipeId];
        if (!param) {
            console.error(recipeId + 'のレシピが見つかりません');
        }
        return param;
    };
    RecipeManager.prototype.makeRecipeList = function () {
        var result = [];
        for (var key in this._map) {
            var param = this._map[key];
            if (!param.isLearn()) {
                continue;
            }
            if (!param.isVisible()) {
                continue;
            }
            result.push(new Recipe(param));
        }
        return result;
    };
    RecipeManager.prototype.hasRecipe = function (recipeId) {
        var param = this._map[recipeId];
        if (!param.isLearn()) {
            return false;
        }
        if (!param.isVisible()) {
            return false;
        }
        var item = param.destItem();
        if ($gameSystem.alchemyHistory().isItemMade(item)) {
            return false;
        }
        return true;
    };
    RecipeManager.prototype.makeRecipeListForPictralBook = function () {
        var result = [];
        for (var key in this._map) {
            var param = this._map[key];
            if (param.isCard()) {
                continue;
            }
            if (param.isOmamori()) {
                continue;
            }
            result.push(new Recipe(param));
        }
        return result;
    };
    RecipeManager.prototype.makeRecipeOne = function (recipeId) {
        for (var key in this._map) {
            var param = this._map[key];
            if (param.id() == recipeId) {
                return new Recipe(param);
            }
        }
        return null;
    };
    RecipeManager.prototype.findDestItem = function (item) {
        for (var key in this._map) {
            var param = this._map[key];
            if (param.destItem() == item) {
                return param;
            }
        }
        return null;
    };
    return RecipeManager;
}());
