var RECIPE_MAP = {
    1: [3, 0, 15, , , 201, 214, 2, 0, 0, 0, 0, 0, 0, 10],
    2: [0, 0, 0, , , 2001, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    3: [0, 0, 0, , , 2011, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    4: [0, 0, 0, , , 1020, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    5: [0, 0, 0, , , 1030, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    6: [0, 0, 0, , , 1041, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    7: [1, 0, 0, , , 2148, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    8: [1, 0, 0, , , 2149, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    9: [1, 0, 0, , , 2150, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    10: [7, 0, 0, , , 2201, , 0, 0, 0, 0, 0, 0, 0, 0],
    11: [1, 0, 0, , , 2202, , 0, 0, 0, 0, 0, 0, 0, 0],
    12: [5, 383, -1, , , 200, 155, 1, 133, 1, 20, 60, 15, 0, 10],
    13: [4, 395, -1, , , 198, 126, 1, 129, 1, 23, 20, 0, 15, 0],
    111: [2, -1, -1, , , 1021, 114, 2, 0, 0, 10, 10, 15, 30, 0],
    121: [1, -1, -1, , , 1031, 106, 2, 0, 0, 0, 30, 15, 0, 0],
    131: [2, -1, -1, , , 1011, 109, 2, 0, 0, 20, 0, 25, 10, 0],
    141: [1, -1, -1, , , 1042, 107, 0, 0, 0, 55, 0, 0, 0, 0],
    151: [2, -1, -1, , , 2002, 115, 2, 0, 0, 10, 0, 20, 10, 0],
    152: [2, -1, -1, , , 2012, 103, 2, 0, 0, 10, 0, 0, 30, 0],
    153: [2, -1, -1, , , 2022, 109, 1, 0, 0, 20, 0, 20, 0, 0],
    161: [2, -1, -1, , , 2041, 112, 2, 114, 2, 0, 25, 0, 25, 0],
    171: [2, -1, -1, , , 2071, 113, 2, 0, 0, 2, 0, 35, 0, 0],
    172: [2, -1, -1, , , 2072, 109, 1, 0, 0, 30, 0, 0, 0, 0],
    173: [2, -1, -1, , , 2075, 106, 1, 0, 0, 0, 60, 0, 0, 0],
    174: [2, -1, -1, , , 2076, 103, 2, 0, 0, 25, 0, 40, 0, 0],
    175: [2, -1, -1, , , 2077, 0, 0, 0, 0, 20, 10, 0, 15, 0],
    191: [5, -1, 50, , , 207, 216, 1, 0, 0, 10, 10, 0, 0, 100],
    211: [3, -1, -1, , , 1022, 133, 2, 0, 0, 30, 43, 0, 0, 0],
    212: [4, -1, -1, , , 1023, 132, 5, 134, 1, 50, 0, 25, 35, 0],
    221: [3, -1, -1, , , 1032, 126, 2, 114, 2, 0, 10, 0, 50, 0],
    222: [4, -1, -1, , , 1033, 126, 5, 0, 0, 0, 50, 30, 40, 0],
    231: [3, -1, -1, , , 1012, 134, 2, 0, 0, 0, 20, 0, 40, 0],
    232: [4, -1, -1, , , 1013, 134, 5, 0, 0, 30, 50, 29, 10, 0],
    241: [3, -1, -1, , , 1043, 129, 2, 0, 0, 50, 0, 20, 20, 0],
    251: [4, -1, -1, , , 2003, 135, 2, 0, 0, 0, 35, 50, 35, 0],
    252: [4, -1, -1, , , 2013, 134, 2, 0, 0, 0, 100, 0, 20, 0],
    254: [4, -1, -1, , , 2023, 135, 2, 0, 0, 20, 50, 30, 15, 0],
    256: [4, -1, -1, , , 2042, 129, 3, 0, 0, 25, 45, 16, 30, 0],
    261: [4, -1, -1, , , 2101, 134, 3, 112, 0, 15, 25, 10, 45, 36],
    262: [4, -1, -1, , , 2102, 132, 3, 109, 0, 15, 40, 10, 20, 45],
    263: [4, -1, -1, , , 2103, 126, 3, 106, 0, 35, 25, 20, 0, 20],
    271: [4, -1, -1, , , 2073, 129, 1, 0, 0, 40, 20, 20, 40, 10],
    272: [4, -1, -1, , , 2074, 123, 1, 0, 0, 20, 20, 0, 40, 10],
    273: [5, -1, -1, , , 2079, 126, 1, 0, 0, 25, 0, 20, 40, 10],
    274: [5, -1, -1, , , 2080, 128, 0, 0, 0, 25, 40, 20, 0, 10],
    275: [4, -1, -1, , , 2078, 123, 0, 0, 0, 40, 10, 25, 10, 0],
    281: [3, -1, -1, , , 224, 213, 1, 0, 0, 10, 10, 20, 30, 25],
    282: [5, 237, -1, , , 225, 123, 2, 133, 2, 10, 30, 10, 10, 0],
    283: [5, 237, -1, , , 226, 126, 2, 134, 2, 30, 10, 10, 10, 0],
    284: [5, 237, -1, , , 227, 129, 2, 135, 2, 10, 10, 10, 30, 0],
    291: [6, -1, -1, , , 202, 217, 1, 207, 1, 40, 100, 20, 20, 100],
    292: [4, -1, -1, , , 222, 221, 1, 0, 0, 25, 25, 25, 25, 70],
    293: [6, -1, -1, , , 236, 209, 1, 0, 0, 15, 15, 15, 15, 80],
    294: [4, 412, -1, 2, 0, 256, 103, 5, 133, 1, 30, 40, 0, 0, 0],
    295: [4, 414, -1, 2, 0, 258, 126, 3, 113, 1, 30, 40, 0, 0, 45],
    296: [4, 416, -1, 1, 0, 260, 129, 3, 123, 1, 30, 40, 0, 0, 50],
    297: [4, 445, -1, 4, 0, 268, 123, 3, 132, 1, 0, 0, 30, 40, 60],
    298: [4, 420, -1, 1, 1, 261, 129, 3, 123, 1, 30, 40, 0, 0, 45],
    311: [5, -1, -1, , , 1024, 146, 2, 0, 0, 45, 50, 15, 15, 0],
    312: [6, -1, -1, , , 1025, 146, 4, 153, 2, 100, 25, 25, 40, 0],
    322: [6, -1, -1, , , 1035, 149, 5, 155, 2, 0, 50, 60, 70, 0],
    331: [5, -1, -1, , , 1014, 143, 2, 0, 0, 25, 50, 35, 0, 0],
    332: [6, -1, -1, , , 1015, 143, 3, 154, 2, 0, 100, 45, 25, 0],
    341: [5, -1, -1, , , 1044, 152, 2, 132, 2, 30, 40, 40, 25, 0],
    351: [5, -1, -1, , , 2004, 153, 2, 123, 3, 42, 21, 50, 30, 0],
    352: [5, -1, -1, , , 2014, 146, 2, 114, 3, 25, 35, 10, 60, 0],
    353: [5, -1, -1, , , 2024, 142, 2, 135, 2, 25, 26, 60, 28, 0],
    356: [5, -1, -1, , , 2043, 152, 3, 146, 2, 30, 45, 45, 45, 0],
    371: [6, -1, -1, , , 2083, 149, 3, 0, 0, 0, 40, 40, 40, 10],
    372: [5, -1, -1, , , 2086, 155, 1, 0, 0, 50, 30, 30, 30, 0],
    373: [5, -1, -1, , , 2088, 153, 1, 0, 0, 10, 50, 50, 0, 0],
    390: [6, 448, -1, 4, 1, 269, 149, 5, 143, 2, 33, 50, 30, 0, 25],
    391: [7, -1, -1, , , 211, 218, 1, 202, 1, 90, 0, 40, 30, 125],
    392: [7, -1, -1, , , 212, 208, 1, 0, 0, 49, 40, 42, 40, 30],
    394: [8, -1, -1, , , 251, 210, 1, 0, 0, 10, 10, 10, 10, 0],
    395: [6, 391, -1, , , 199, 152, 1, 153, 2, 40, 40, 50, 0, 15],
    396: [6, 413, -1, 2, 1, 257, 143, 3, 155, 1, 10, 50, 50, 0, 0],
    397: [6, 415, -1, 2, 1, 259, 146, 3, 155, 1, 10, 50, 50, 0, 0],
    398: [6, 417, -1, 1, 0, 262, 143, 5, 153, 1, 65, 65, 0, 0, 0],
    399: [6, 441, -1, 4, 1, 266, 149, 5, 152, 1, 26, 57, 68, 0, 0],
    411: [7, -1, -1, , , 1026, 169, 2, 0, 0, 45, 25, 25, 45, 0],
    412: [8, -1, -1, , , 1027, 169, 5, 173, 0, 100, 40, 35, 75, 0],
    421: [7, -1, -1, , , 1036, 172, 2, 0, 0, 0, 90, 30, 20, 0],
    431: [7, -1, -1, , , 1016, 163, 2, 0, 0, 10, 100, 10, 20, 0],
    441: [7, -1, -1, , , 1045, 166, 2, 0, 0, 30, 60, 80, 30, 0],
    451: [7, -1, -1, , , 2005, 175, 2, 0, 0, 25, 96, 15, 20, 0],
    452: [7, -1, -1, , , 2015, 173, 2, 0, 0, 65, 20, 43, 20, 0],
    453: [7, -1, -1, , , 2025, 166, 2, 0, 0, 60, 60, 60, 0, 0],
    461: [8, -1, -1, , , 2044, 174, 3, 0, 0, 50, 50, 40, 80, 0],
    462: [6, -1, -1, , , 2104, 174, 3, 0, 0, 30, 60, 45, 70, 0],
    463: [6, -1, -1, , , 2105, 173, 3, 0, 0, 45, 80, 30, 45, 0],
    464: [6, -1, -1, , , 2106, 175, 3, 0, 0, 70, 60, 45, 30, 0],
    471: [7, -1, -1, , , 2082, 168, 2, 0, 0, 50, 20, 40, 30, 0],
    472: [8, -1, -1, , , 2081, 166, 3, 0, 0, 50, 20, 40, 50, 0],
    473: [7, -1, -1, , , 2084, 163, 2, 0, 0, 30, 20, 40, 50, 0],
    474: [7, -1, -1, , , 2085, 173, 2, 0, 0, 50, 20, 40, 20, 0],
    491: [10, -1, -1, , , 204, 219, 1, 211, 1, 70, 70, 50, 80, 125],
    492: [8, 418, -1, 1, 1, 263, 163, 4, 173, 2, 0, 100, 80, 0, 0],
    493: [8, 419, -1, 0, 0, 2089, 172, 5, 146, 5, 0, 100, 80, 200, 50],
    494: [8, 451, -1, 4, 0, 270, 163, 3, 143, 2, 0, 0, 40, 0, 25],
    495: [8, 452, -1, 4, 0, 267, 163, 3, 143, 2, 0, 0, 40, 0, 25],
    497: [8, 606, -1, 4, 0, 271, 173, 5, 143, 2, 0, 60, 40, 0, 25],
    511: [9, -1, -1, , , 1028, 265, 1, 183, 1, 100, 50, 50, 10, 0],
    512: [10, -1, -1, , , 1029, 203, 1, 206, 1, 100, 50, 50, 15, 400],
    521: [9, -1, -1, , , 1038, 186, 2, 195, 1, 0, 45, 100, 45, 0],
    522: [10, -1, -1, , , 1039, 194, 2, 186, 5, 0, 80, 100, 150, 0],
    532: [10, -1, -1, , , 1019, 189, 5, 193, 2, 0, 200, 50, 50, 0],
    551: [9, -1, -1, , , 2006, 193, 3, 0, 0, 0, 120, 120, 20, 0],
    552: [9, -1, -1, , , 2016, 195, 3, 0, 0, 100, 0, 0, 150, 0],
    553: [9, -1, -1, , , 2026, 193, 3, 0, 0, 0, 0, 120, 150, 0],
    561: [10, -1, -1, , , 2045, 192, 3, 195, 2, 200, 50, 50, 50, 0],
    593: [10, 456, -1, , , 205, 197, 1, 169, 5, 100, 100, 100, 100, 25],
    594: [10, 457, -1, , , 196, 205, 1, 186, 8, 150, 150, 150, 150, 30],
    1001: [4, -1, -1, , , 240, 220, 1, 0, 0, 0, 0, 0, 0, 5],
    1002: [4, 376, -1, , , 241, 220, 1, 0, 0, 0, 0, 0, 0, 5],
    1003: [4, 376, -1, , , 242, 220, 1, 0, 0, 0, 0, 0, 0, 5],
    1011: [2, -1, -1, , , 234, 113, 1, 0, 0, 0, 0, 0, 0, 13],
    1012: [4, 378, -1, , , 235, 133, 1, 0, 0, 0, 0, 0, 0, 25],
    1013: [5, 378, -1, , , 237, 153, 1, 0, 0, 0, 0, 0, 0, 35],
    1014: [9, 349, -1, , , 2108, 71, 1, 72, 1, 0, 125, 0, 0, 120],
};
var RecipeParam = /** @class */ (function () {
    function RecipeParam(array, recipeId) {
        this._recipeId = recipeId;
        this.parseLevel(array[0]);
        this.parseSw(array[1]);
        this.parseExp(array[2]);
        this.parseCondition(array[3], array[4]);
        this.parseDestItem(array[5]);
        var itemIndex = 6;
        this.parseSourceItem(1, array[itemIndex], array[itemIndex + 1]);
        this.parseSourceItem(2, array[itemIndex + 2], array[itemIndex + 3]);
        this._flame = array[itemIndex + 4];
        this._water = array[itemIndex + 5];
        this._wood = array[itemIndex + 6];
        this._metal = array[itemIndex + 7];
        this._seieki = array[itemIndex + 8];
    }
    RecipeParam.prototype.parseLevel = function (lv) {
        this._level = lv;
    };
    RecipeParam.prototype.parseSw = function (sw) {
        this._sw = sw;
    };
    RecipeParam.prototype.parseExp = function (exp) {
        this._exp = exp;
    };
    RecipeParam.prototype.parseCondition = function (actorId, condition) {
        this._conditionActorId = actorId;
        if (isNaN(this._conditionActorId)) {
            this._conditionActorId = 0;
        }
        this._condition = condition;
        if (isNaN(this._condition)) {
            this._condition = 0;
        }
    };
    RecipeParam.prototype.parseDestItem = function (itemId) {
        this._destItem = this.parseItem(itemId);
    };
    RecipeParam.prototype.parseItem = function (itemId) {
        if (itemId > 2000) {
            return $dataArmors[itemId - 2000];
        }
        else if (itemId > 1000) {
            return $dataWeapons[itemId - 1000];
        }
        else {
            return $dataItems[itemId];
        }
    };
    RecipeParam.prototype.isDestItemWeapon = function () {
        return DataManager.isWeapon(this._destItem);
    };
    RecipeParam.prototype.parseSourceItem = function (index, itemId, value) {
        this['_sourceItem' + index] = this.parseItem(itemId);
        this['_sourceValue' + index] = value;
    };
    RecipeParam.prototype.destItem = function () {
        return this._destItem;
    };
    RecipeParam.prototype.sourceItem = function (index) {
        return this['_sourceItem' + index];
    };
    RecipeParam.prototype.sourceItem1 = function () {
        return this._sourceItem1;
    };
    RecipeParam.prototype.sourceItem2 = function () {
        return this._sourceItem2;
    };
    RecipeParam.prototype.sourceValue1 = function () {
        return this._sourceValue1;
    };
    RecipeParam.prototype.sourceValue = function (index) {
        return this['_sourceValue' + index];
    };
    RecipeParam.prototype.sourceValue2 = function () {
        return this._sourceValue2;
    };
    RecipeParam.prototype.learnSwitch = function () {
        return this._sw;
    };
    RecipeParam.prototype.isVisible = function () {
        return this._exp != 0;
    };
    RecipeParam.prototype.isLearn = function () {
        if (this.learnSwitch() == 0) {
            return true;
        }
        if (this.learnSwitch() == -2) {
            return false;
        }
        if (this.learnSwitch() > 0) {
            if (!$gameSwitches.value(this.learnSwitch())) {
                return false;
            }
        }
        if (!$gameParty.isLearnRecipe(this.id())) {
            return false;
        }
        if ($gameParty.isNewRecipe(this.id())) {
            return false;
        }
        return true;
    };
    RecipeParam.prototype.level = function () {
        return this._level;
    };
    RecipeParam.prototype.exp = function () {
        var base = this.baseExp();
        var total = this.materialTotal();
        return Math.round(base + total);
    };
    RecipeParam.prototype.materialTotal = function () {
        return this._flame + this._water + this._wood + this._metal + this._seieki * 2;
    };
    RecipeParam.prototype.baseExp = function () {
        if (this._exp == 0) {
            return 0;
        }
        if (this._exp > 0) {
            return this._exp;
        }
        switch (this._level) {
            case 1: return 6;
            case 2: return 12;
            case 3: return 30;
            case 4: return 50;
            case 5: return 100;
            case 6: return 150;
            case 7: return 250;
            case 8: return 500;
            case 9: return 700;
            case 10: return 1200;
        }
        return this._level * 12;
    };
    RecipeParam.prototype.id = function () {
        return this._recipeId;
    };
    RecipeParam.prototype.flame = function () {
        return this._flame * this.powerRate();
    };
    RecipeParam.prototype.water = function () {
        return this._water * this.powerRate();
    };
    RecipeParam.prototype.wood = function () {
        return this._wood * this.powerRate();
    };
    RecipeParam.prototype.metal = function () {
        return this._metal * this.powerRate();
    };
    RecipeParam.prototype.seieki = function () {
        return this._seieki;
    };
    RecipeParam.prototype.powerRate = function () {
        switch (this._level) {
            case 1: return 1.3;
            case 2: return 1.3;
            case 3: return 1.3;
            case 4: return 1.4;
            case 5: return 1.5;
            case 6: return 1.5;
            case 7: return 1.6;
            case 8: return 1.6;
            case 9: return 1.7;
            case 10: return 1.8;
        }
        return 1;
    };
    RecipeParam.prototype.isCard = function () {
        return this.destItem().meta['card'] != null;
    };
    RecipeParam.prototype.isOmamori = function () {
        return this.destItem().meta['omamori'] != null;
    };
    RecipeParam.prototype.isCondiionOk = function () {
        if (this._conditionActorId == 0) {
            return true;
        }
        if (!$gameSystem.isNight()) {
            return false;
        }
        switch (this._conditionActorId) {
            case 1:
                if ($gameSwitches.value(245)) {
                    // ロザリーのHイベント実行済み
                    return false;
                }
                break;
            case 2:
                if ($gameSwitches.value(246)) {
                    // サツキのHイベント実行済み
                    return false;
                }
                break;
            case 4: return true;
        }
        var actor = $gameActors.actor(this._conditionActorId);
        if (this._condition == 0) {
            if (actor.isBote()) {
                return false;
            }
        }
        else {
            if (!actor.isBote()) {
                return false;
            }
        }
        return true;
    };
    RecipeParam.prototype.conditionText = function () {
        if (this._conditionActorId == 0) {
            return '';
        }
        if (this._conditionActorId >= 4) {
            return '';
        }
        var actor = $gameActors.actor(this._conditionActorId);
        if (this._condition == 0) {
            return '%1が妊娠状態でない時のみ調合可能'.format(actor.name());
        }
        else {
            return '%1が妊娠状態の時のみ調合可能'.format(actor.name());
        }
    };
    RecipeParam.prototype.conditionText2 = function () {
        if (this._conditionActorId == 0) {
            return '';
        }
        return '夜パートのみ調合可能';
    };
    return RecipeParam;
}());
var $recipeManager = null;
var Nore;
(function (Nore) {
    var _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _DataManager_createGameObjects.call(this);
        $recipeManager = new RecipeManager();
    };
})(Nore || (Nore = {}));
