/*:ja
 * @target MZ
 * @author ル
 *
 * @command showRecipe
 * @text レシピ表示
 * @des レシピ表示
 * @arg recipeId
 * @type number
 * @text recipeId
 * @desc recipeId
 *
 * @command hideRecipe
 * @text レシピ非表示
 * @des レシピ非表示
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Nore;
(function (Nore) {
    var pluginName = 'Nore_AlchemyRecipeUi';
    PluginManager.registerCommand(pluginName, 'showRecipe', function (args) {
        var recipeId = parseInt(args.recipeId);
        var param = $recipeManager.findRecipeParam(recipeId);
        if (SceneManager._scene instanceof Scene_Map2) {
            var scene = SceneManager._scene;
            scene._spriteset.createRecipeWindow();
        }
        $gameTemp.recipeParam = param;
    });
    PluginManager.registerCommand(pluginName, 'hideRecipe', function (args) {
        $gameTemp.recipeParam = null;
    });
})(Nore || (Nore = {}));
var Window_Recipe = /** @class */ (function (_super) {
    __extends(Window_Recipe, _super);
    function Window_Recipe() {
        var _this = this;
        var r = new Rectangle(10, 100, 390, 500);
        _this = _super.call(this, r) || this;
        _this.visible = false;
        return _this;
    }
    Window_Recipe.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateVisible();
    };
    Window_Recipe.prototype.updateVisible = function () {
        if ($gameTemp.recipeParam) {
            if (!this.visible) {
                this.refresh($gameTemp.recipeParam);
            }
            this.visible = true;
        }
        else {
            this.visible = false;
        }
    };
    Window_Recipe.prototype.refresh = function (param) {
        this._param = param;
        this.contents.clear();
        this.drawDestItem();
    };
    Window_Recipe.prototype.drawDestItem = function () {
        this.contents.fontSize = 26;
        var destItem = this._param.destItem();
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(TextManager.alchemyResultItem, 10, 12, 200);
        this.drawItem(destItem, 10, 50);
        var yy = 150;
        var interval = 36;
        var item1 = this._param.sourceItem1();
        if (item1) {
            this.changeTextColor(ColorManager.systemColor());
            this.drawText(TextManager.alchemyMaterialItem, 10, yy - 32, 200);
            this.drawSourceItem(item1, this._param.sourceValue1(), 10, yy);
        }
        var item2 = this._param.sourceItem2();
        if (item2) {
            this.drawSourceItem(item2, this._param.sourceValue2(), 10, yy + interval);
        }
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(TextManager.alchemyResultMetarial, 10, 230, 300);
        this.drawPartyMaterial(260);
    };
    Window_Recipe.prototype.drawItem = function (item, x, y) {
        //this.drawIcon(item.iconIndex, x, y);
        this.changeTextColor(ColorManager.normalColor());
        this.drawItemName(item, x, y, 290);
    };
    Window_Recipe.prototype.drawSourceItem = function (item, value, x, y) {
        //this.drawIcon(item.iconIndex, x, y);
        this.drawItemName(item, x, y, 290);
        this.drawText('x' + value, x + 310, y, 200, 'left');
    };
    Window_Recipe.prototype.drawPartyMaterial = function (yy) {
        this.contents.fontSize = 22;
        var list = this.materialList();
        var xx = 40;
        for (var i = 0; i < list.length; i++) {
            var icon = $gameParty.materialIcon(i);
            this.drawIcon(icon, xx, yy);
            this.drawMaterialName(i, xx + 60, yy);
            this.changeTextColor(ColorManager.normalColor());
            this.drawText(list[i], xx, yy - 1, 300, 'right');
            yy += 35;
        }
    };
    Window_Recipe.prototype.materialList = function () {
        return [
            this._param.flame(),
            this._param.water(),
            this._param.wood(),
            this._param.metal(),
            this._param.seieki(),
        ];
    };
    Window_Recipe.prototype.drawMaterialName = function (index, x, y) {
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(this.materialName(index), x, y, 150);
    };
    Window_Recipe.prototype.materialName = function (index) {
        switch (index) {
            case 0: return TextManager.materialFlame;
            case 1: return TextManager.materialWater;
            case 2: return TextManager.materialWood;
            case 3: return TextManager.materialMetal;
            case 4: return TextManager.materialSemen;
        }
    };
    return Window_Recipe;
}(Window_Base));
