var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 *
 *
 * @command go
 * @text 錬金シーンへ
 * @des 錬金シーンへ
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_AlchemyUi';
    PluginManager.registerCommand(pluginName, 'go', function (args) {
        SceneManager.push(Scene_Alchemy);
    });
})(Nore || (Nore = {}));
var ALCHEMY_MARK_MANY_TIMES = '　';
var Scene_Alchemy = /** @class */ (function (_super) {
    __extends(Scene_Alchemy, _super);
    function Scene_Alchemy() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_Alchemy.prototype.create = function () {
        _super.prototype.create.call(this);
        this.createBg();
        this.createLabelWindow();
        this.createCommandWindow();
        this.createMaterialWindow();
        this.createAlchemyWindow();
        this.createConfirmWindow();
        this.createAlchemyLevelWindow();
        this.createAlchemyLabelSprite();
        this.createGoldSprite();
    };
    Scene_Alchemy.prototype.createGoldSprite = function () {
        this._goldSprite = new Sprite_Gold();
        this.addChild(this._goldSprite);
    };
    Scene_Alchemy.prototype.createBg = function () {
        this._bgSprite = new Sprite();
        this.addChild(this._bgSprite);
        this.updateBg();
    };
    Scene_Alchemy.prototype.updateBg = function () {
        var file = ConfigManager.isJp() ? 'alchemy_jp' : 'alchemy_en';
        this._bgSprite.bitmap = ImageManager.loadSystem(file);
    };
    Scene_Alchemy.prototype.start = function () {
        _super.prototype.start.call(this);
        this._commandWindow.activate();
        this.onCategoryChange();
        this._commandWindow.selectFirstItem();
        $gameSystem.offEventSwitch();
        this.updateBg();
    };
    Scene_Alchemy.prototype.createConfirmWindow = function () {
        this._confirmWindow = new Nore.Window_Confirm(700);
        this._confirmWindow.setTexts(['', '']);
        this._confirmWindow.setHandler('ok', this.onConfirmOk.bind(this));
        this._confirmWindow.setHandler('cancel', this.onConfirmCancel.bind(this));
        this._confirmWindow.deactivate();
        this.addChild(this._confirmWindow);
        this._confirmWindow.hide();
    };
    Scene_Alchemy.prototype.onConfirmOk = function () {
        this._materialWindow.hide();
        this._commandWindow.hide();
        this._alchemyCategoryWindow.hide();
        this._alchemy.execute();
        $gameTemp.alchemyLastIndex = this._commandWindow.index();
        SceneManager.push(Scene_AlchemyEffect);
    };
    Scene_Alchemy.prototype.onConfirmCancel = function () {
        this._confirmWindow.hide();
        this._confirmWindow.deactivate();
        this._commandWindow.activate();
        this._alchemyCategoryWindow.activate();
    };
    Scene_Alchemy.prototype.createLabelWindow = function () {
        var text = this.makeTutorialText();
        if (text) {
            this._nextGoalWindow = new Window_Label(TextManager.nextTarget + text, 240, 4, 600);
            //this.addChild(this._nextGoalWindow);
        }
    };
    Scene_Alchemy.prototype.makeTutorialText = function () {
        var tu = $gameTutorial;
        return tu.nextTarget();
    };
    Scene_Alchemy.prototype.createCommandWindow = function () {
        this._commandWindow = new Window_AlchemyCommand();
        this.addChild(this._commandWindow);
        this._commandWindow.setHandler('ok', this.onCommandOk.bind(this));
        this._commandWindow.setHandler('cancel', this.onCommandCancel.bind(this));
        this._commandWindow.setHandler('change', this.onCommandChange.bind(this));
        this._commandWindow.setHandler('pageup', this.onCommandPageup.bind(this));
        this._commandWindow.setHandler('pagedown', this.onCommandPagedown.bind(this));
    };
    Scene_Alchemy.prototype.createAlchemyLevelWindow = function () {
        this._alchemyLevelSprite = new Sprite_AlchemyLevel();
        this.addChild(this._alchemyLevelSprite);
    };
    Scene_Alchemy.prototype.createMaterialWindow = function () {
        this._materialWindow = new Window_AlchemyMaterial();
        this.addChild(this._materialWindow);
        this._alchemyPartyMaterialWindow = new Window_AlchemyPartyMaterial();
        this.addChild(this._alchemyPartyMaterialWindow);
    };
    Scene_Alchemy.prototype.createAlchemyLabelSprite = function () {
    };
    Scene_Alchemy.prototype.onCommandPageup = function () {
        SoundManager.playCursor();
        this._commandWindow.activate();
        this._alchemyFilterWindow.change();
    };
    Scene_Alchemy.prototype.onFilterChange = function () {
        var filter = this._alchemyFilterWindow.filter();
        this._commandWindow.setFilter(filter);
        $gameTemp.alchemyFilter = this._alchemyFilterWindow.index();
    };
    Scene_Alchemy.prototype.onCommandPagedown = function () {
        this.onCommandPageup();
    };
    Scene_Alchemy.prototype.onCommandCancel = function () {
        $gameTemp.alchemyLastIndex = -1;
        this.popScene();
    };
    Scene_Alchemy.prototype.onCommandOk = function () {
        var recipe = this._commandWindow.selectedRecipe();
        if (!recipe) {
            this._commandWindow.activate();
            return;
        }
        var alchemy = new Alchemy(recipe);
        this._alchemy = alchemy;
        this.showConfirmWindow(alchemy);
        this._alchemyCategoryWindow.deactivate();
    };
    Scene_Alchemy.prototype.showConfirmWindow = function (alchemy) {
        var texts = this.makeConfirmTexts(alchemy);
        this._confirmWindow.show();
        this._confirmWindow.select(0);
        this._confirmWindow.activate();
        this._confirmWindow.setTexts([texts[0], texts[1]]);
    };
    Scene_Alchemy.prototype.makeConfirmTexts = function (alchemy) {
        var needGold = alchemy.needGold();
        var itemName = getItemName(alchemy.recipe().destItem());
        if (alchemy.canAlchemy() && needGold == 0) {
            var text1_1 = TextManager.alchemyConfirm2.format(itemName);
            var text2_1 = TextManager.alchemyConfirm3;
            return [text1_1, text2_1];
        }
        if (alchemy.canAlchemyWithSeieki()) {
            return this.makeAclenyWithSeiekiTexts(alchemy);
        }
        var text1 = TextManager.alchemyShormMaterial.format(needGold);
        var needSeieki = alchemy.needSeieki();
        var text2 = TextManager.alchemyConfirm.format(itemName);
        if (needSeieki > 0) {
            text2 = TextManager.alchemyShormElement.format(needSeieki);
        }
        return [text1, text2];
    };
    Scene_Alchemy.prototype.makeAclenyWithSeiekiTexts = function (alchemy) {
        var results = [];
        var needSeieki = alchemy.needSeieki();
        if (needSeieki > 0) {
            var text1 = TextManager.alchemyShormElement.format(needSeieki);
            results.push(text1);
        }
        var needGold = alchemy.needGold();
        if (needGold > 0) {
            var text4 = TextManager.alchemyShormMaterial.format(needGold);
            results.push(text4);
        }
        var itemName = getItemName(alchemy.recipe().destItem());
        var text2 = TextManager.alchemyConfirm.format(itemName);
        results.push(text2);
        return results;
    };
    Scene_Alchemy.prototype.onCommandChange = function () {
        var recipe = this._commandWindow.selectedRecipe();
        this._materialWindow.setRecipe(recipe);
    };
    Scene_Alchemy.prototype.createAlchemyWindow = function () {
        this._alchemyWindow = new Window_Alchemy();
        this.addChild(this._alchemyWindow);
        this._alchemyWindow.hide();
        this._alchemyForecastWindow = new Window_AlchemyForecast();
        this.addChild(this._alchemyForecastWindow);
        this._alchemyForecastWindow.hide();
        this._alchemyCategoryWindow = new Window_AlchemyCategory();
        this.addChild(this._alchemyCategoryWindow);
        if ($gameTemp.alchemyCategory >= 0) {
            this._alchemyCategoryWindow.select($gameTemp.alchemyCategory);
        }
        this._alchemyCategoryWindow.setHandler('change', this.onCategoryChange.bind(this));
        this._alchemyFilterWindow = new Window_AlchemyFilter();
        this._alchemyFilterWindow.setHandler('change', this.onFilterChange.bind(this));
        this.addChild(this._alchemyFilterWindow);
        if ($gameTemp.alchemyFilter >= 0) {
            this._alchemyFilterWindow.select($gameTemp.alchemyFilter);
        }
        var filter = this._alchemyFilterWindow.filter();
        this._commandWindow.setFilter(filter);
    };
    Scene_Alchemy.prototype.onCategoryChange = function () {
        $gameTemp.alchemyCategory = this._alchemyCategoryWindow.index();
        var category = this._alchemyCategoryWindow.category();
        this._commandWindow.setCategory(category);
    };
    return Scene_Alchemy;
}(Scene_Base));
var Window_Label = /** @class */ (function (_super) {
    __extends(Window_Label, _super);
    function Window_Label(text, x, y, width, fontSize) {
        if (width === void 0) { width = 300; }
        if (fontSize === void 0) { fontSize = 18; }
        var _this = _super.call(this, new Rectangle(x, y, width, 60)) || this;
        _this._fontSize = fontSize;
        _this.drawTextEx(text, 0, 0, width);
        _this.backOpacity = 0;
        return _this;
    }
    Window_Label.prototype._createFrameSprite = function () {
        this._frameSprite = new Sprite();
    };
    Window_Label.prototype.resetFontSettings = function () {
        this.contents.fontSize = this._fontSize;
    };
    Window_Label.prototype._refreshFrame = function () {
    };
    return Window_Label;
}(Window_Base));
var Window_AlchemyCategory = /** @class */ (function (_super) {
    __extends(Window_AlchemyCategory, _super);
    function Window_AlchemyCategory() {
        var _this = this;
        var r = new Rectangle(22, 107, 390, 70);
        _this = _super.call(this, r) || this;
        _this.frameVisible = false;
        _this.backOpacity = 0;
        _this.makeData();
        _this.refresh();
        _this.select(0);
        _this.activate();
        return _this;
    }
    Window_AlchemyCategory.prototype.makeData = function () {
        this._categoryList = [];
        this._categoryList.push(new AlchemyCategory(Category.all));
        this._categoryList.push(new AlchemyCategory(Category.event));
        this._categoryList.push(new AlchemyCategory(Category.card));
        this._categoryList.push(new AlchemyCategory(Category.skill));
        this._categoryList.push(new AlchemyCategory(Category.weapon));
        this._categoryList.push(new AlchemyCategory(Category.bodyArmor));
        this._categoryList.push(new AlchemyCategory(Category.shield));
        this._categoryList.push(new AlchemyCategory(Category.item));
    };
    Window_AlchemyCategory.prototype.maxItems = function () {
        if (!this._categoryList) {
            return 0;
        }
        return this._categoryList.length;
    };
    Window_AlchemyCategory.prototype.maxCols = function () {
        return 8;
    };
    Window_AlchemyCategory.prototype.drawItem = function (index) {
        var c = this._categoryList[index];
        var rect = this.itemRect(index);
        this.drawIcon(c.iconIndex(), rect.x + 3, rect.y + 4);
    };
    Window_AlchemyCategory.prototype.category = function () {
        if (!this._categoryList) {
            return null;
        }
        return this._categoryList[this.index()];
    };
    return Window_AlchemyCategory;
}(Window_Selectable));
var Window_AlchemyFilter = /** @class */ (function (_super) {
    __extends(Window_AlchemyFilter, _super);
    function Window_AlchemyFilter() {
        var _this = this;
        var r = new Rectangle(447, 109, 240, 70);
        _this = _super.call(this, r) || this;
        _this.makeData();
        _this.refresh();
        _this.select(0);
        _this.deactivate();
        _this.frameVisible = false;
        _this.backOpacity = 0;
        return _this;
    }
    Window_AlchemyFilter.prototype.makeData = function () {
        this._filterList = [];
        this._filterList.push(new AlchemyFilter(FilterType.all));
        this._filterList.push(new AlchemyFilter(FilterType.notAlchemy));
    };
    Window_AlchemyFilter.prototype.maxItems = function () {
        if (!this._filterList) {
            return 0;
        }
        return this._filterList.length;
    };
    Window_AlchemyFilter.prototype.maxCols = function () {
        return 2;
    };
    Window_AlchemyFilter.prototype.drawItem = function (index) {
        this.contents.fontSize = 18;
        var c = this._filterList[index];
        var rect = this.itemRect(index);
        var image = ImageManager.loadSystem('alchemy_ui');
        var xx = 0;
        if (this.index() == index) {
            xx = 100;
        }
        if (ConfigManager.isEn()) {
            xx += 200;
        }
        this.contents.blt(image, xx, 400 + index * 50, 100, 50, rect.x, rect.y);
        //this.drawText(c.text(), rect.x, rect.y, rect.width, 'center');
    };
    Window_AlchemyFilter.prototype.filter = function () {
        if (!this._filterList) {
            return null;
        }
        return this._filterList[this.index()];
    };
    Window_AlchemyFilter.prototype.change = function () {
        if (this.index() == 0) {
            this.select(1);
        }
        else {
            this.select(0);
        }
        this.refresh();
    };
    Window_AlchemyFilter.prototype.select = function (index) {
        if (this.index() == index) {
            return;
        }
        _super.prototype.select.call(this, index);
        this.refresh();
    };
    Window_AlchemyFilter.prototype.setCursorRect = function () {
        // do nothing   
    };
    Window_AlchemyFilter.prototype.drawItemBackground = function (index) {
        // do nothing   
    };
    return Window_AlchemyFilter;
}(Window_ClickableSelector));
var Window_AlchemyCommand = /** @class */ (function (_super) {
    __extends(Window_AlchemyCommand, _super);
    function Window_AlchemyCommand() {
        var _this = this;
        var r = new Rectangle(20, 186, 666, 604);
        _this = _super.call(this, r) || this;
        _this.makeData();
        _this.refresh();
        _this.frameVisible = false;
        _this.backOpacity = 0;
        return _this;
    }
    Window_AlchemyCommand.prototype.selectFirstItem = function () {
        if ($gameTemp.alchemyLastIndex >= 0) {
            this.select($gameTemp.alchemyLastIndex);
            this.setTopRow($gameTemp.alchemyLastIndex - 2);
        }
        else {
            this.select(0);
        }
    };
    Window_AlchemyCommand.prototype.makeData = function () {
        var list = $recipeManager.makeRecipeList();
        this._recipeList = [];
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var r = list_1[_i];
            if (this.isInclude(r)) {
                this._recipeList.push(r);
            }
        }
        this._recipeList = this._recipeList.sort(function (a, b) {
            return a.sortValue() - b.sortValue();
        });
    };
    Window_AlchemyCommand.prototype.addRecipe = function (r) {
        if (this.isInclude(r)) {
            this._recipeList.push(r);
        }
    };
    Window_AlchemyCommand.prototype.isInclude = function (r) {
        if (!this.isCategoryMatch(r)) {
            return false;
        }
        if (!this.isFilterMatch(r)) {
            return false;
        }
        var item = r.destItem();
        if (item.meta['once']) {
            if ($gameSystem.alchemyHistory().isItemMade(item)) {
                return false;
            }
        }
        return true;
    };
    Window_AlchemyCommand.prototype.isFilterMatch = function (r) {
        if (this._filter == null) {
            return true;
        }
        if (this._filter.filter() == FilterType.all) {
            return true;
        }
        var history = $gameSystem.alchemyHistory();
        if (history.isRecipeMade(r.id())) {
            return false;
        }
        return true;
    };
    Window_AlchemyCommand.prototype.isCategoryMatch = function (r) {
        if (!this._category) {
            return true;
        }
        switch (this._category.category()) {
            case Category.weapon: return this.isCategoryWeaponMatch(r);
            case Category.bodyArmor: return this.isCategoryBodyArmorMatch(r);
            case Category.shield: return this.isCategoryShieldMatch(r);
            case Category.card: return this.isCategoryCardMatch(r);
            case Category.event: return this.isCategoryEventMatch(r);
            case Category.item: return this.isCategoryItemMatch(r);
            case Category.skill: return this.isCategorySkillMatch(r);
        }
        return true;
    };
    Window_AlchemyCommand.prototype.isCategoryWeaponMatch = function (r) {
        return r.isWeapon();
    };
    Window_AlchemyCommand.prototype.isCategoryBodyArmorMatch = function (r) {
        return r.isBodyArmor();
    };
    Window_AlchemyCommand.prototype.isCategoryShieldMatch = function (r) {
        return r.isShield();
    };
    Window_AlchemyCommand.prototype.isCategorySkillMatch = function (r) {
        return r.isSkill();
    };
    Window_AlchemyCommand.prototype.isCategoryCardMatch = function (r) {
        return r.isCard() || r.isRelic() || r.isMaseki();
    };
    Window_AlchemyCommand.prototype.isCategoryEventMatch = function (r) {
        return r.isEvent();
    };
    Window_AlchemyCommand.prototype.isCategoryItemMatch = function (r) {
        return r.isEquipItem();
    };
    Window_AlchemyCommand.prototype.maxItems = function () {
        if (!this._recipeList) {
            return 0;
        }
        return this._recipeList.length;
    };
    Window_AlchemyCommand.prototype.drawItem = function (index) {
        var recipe = this._recipeList[index];
        var rect = this.itemRect(index);
        this.fillRecipeBg(rect, recipe);
        this.drawCanAlchemy(rect, recipe);
        this.drawRecipeName(rect, recipe);
        this.drawNew(recipe, rect.y);
        this.drawRank(rect, recipe);
        //this.drawCount(rect, recipe); うるさいのでやめ
        this.drawActorIcon(recipe, rect.y);
        this.fillOverlayBlack(rect, index);
    };
    Window_AlchemyCommand.prototype.fillRecipeBg = function (rect, recipe) {
        var bgColor = ColorManager.recipeBgColor(recipe);
        this.contents.fillRect(rect.x, rect.y, rect.width, rect.height, bgColor);
    };
    /*drawItemBackground(index) {
        // do nothing
    }*/
    Window_AlchemyCommand.prototype.drawRecipeName = function (rect, recipe) {
        this.contents.fontSize = 24;
        this.changeTextColor(ColorManager.normalColor());
        this.drawIcon(recipe.iconIndex(), rect.x + 50, rect.y);
        this.drawText(recipe.name(), rect.x + 84, rect.y, 210, 'left');
    };
    Window_AlchemyCommand.prototype.drawRank = function (rect, recipe) {
        this.contents.fontSize = 18;
        var level = recipe.level();
        this.changeTextColor(ColorManager.rareColor(level));
        var yy = rect.y;
        for (var i = 0; i < 10; i++) {
            var enabled = level > i;
            this.drawRareOne(i, enabled, yy);
        }
    };
    Window_AlchemyCommand.prototype.drawRareOne = function (rare, enabled, yy) {
        var text = '★';
        if (enabled) {
            this.changeTextColor(ColorManager.rareColor(rare));
        }
        else {
            this.changeTextColor(ColorManager.disableRareColor());
        }
        this.drawText(text, rare * 18 + 444, yy, 32);
    };
    /*drawCount(rect: Rectangle, recipe: Recipe) {
        const item = recipe.destItem();

        const count = $gameParty.numItems(item, true);
        this.changeTextColor(ColorManager.normalColor());

        this.contents.fontSize = 22;

        this.drawText('×', rect.x, rect.y, 604, 'right');
        this.drawText(count, rect.x, rect.y, 620, 'right');
    }*/
    Window_AlchemyCommand.prototype.selectAlchemyMark = function (recipe) {
        var manager = $gameParty.alchemyManager();
        var canAlchemy = manager.canAlchemy(recipe);
        var history = $gameSystem.alchemyHistory();
        if (recipe.destItem().meta['manyTimes']) {
            if (history.isRecipeMade(recipe.id())) {
                // 複数回調合しても問題ないもの
                this.changePaintOpacity(true);
                return ALCHEMY_MARK_MANY_TIMES;
            }
        }
        if (canAlchemy) {
            this.changePaintOpacity(true);
            this.changeTextColor(ColorManager.textColor(2));
            if (history.isRecipeMade(recipe.id())) {
                return '△';
            }
            else {
                return '◎';
            }
        }
        var canAlchemyWithSeieki = manager.canAlchemyWithSeieki(recipe);
        if (canAlchemyWithSeieki) {
            if (history.isRecipeMade(recipe.id())) {
                return '△';
            }
            else {
                return '◯';
            }
        }
        var canAlchemyWithBuyItem = manager.canAlchemyWithSeiekiAndAutoBuy(recipe);
        if (canAlchemyWithBuyItem != AutoBuy.disable) {
            if (canAlchemyWithBuyItem == AutoBuy.autoBuyShopItem) {
                // ショップ限定アイテムの場合は買うしかないので◎表記
                var history_1 = $gameSystem.alchemyHistory();
                if (!history_1.isRecipeMade(recipe.id())) {
                    return '◎';
                }
            }
            if (history.isRecipeMade(recipe.id())) {
                return '△';
            }
            else {
                return '◯';
            }
        }
        return '';
    };
    Window_AlchemyCommand.prototype.drawCanAlchemy = function (rect, recipe) {
        this.changePaintOpacity(true);
        this.changeTextColor(ColorManager.textColor(2));
        this.contents.fontSize = 22;
        var mark = this.selectAlchemyMark(recipe);
        if (mark.length > 0) {
            this.drawText(mark, rect.x + 6, rect.y, 140, 'left');
        }
        else {
            this.changePaintOpacity(false);
            this.changeTextColor(ColorManager.textColor(8));
        }
    };
    Window_AlchemyCommand.prototype.isEnabled = function (index) {
        var recipe = this._recipeList[index];
        if (!recipe) {
            return false;
        }
        var manager = $gameParty.alchemyManager();
        var canAlchemy = manager.canAlchemy(recipe);
        if (canAlchemy) {
            return true;
        }
        var canAlchemyWithSeieki = manager.canAlchemyWithSeieki(recipe);
        if (canAlchemyWithSeieki) {
            return true;
        }
        var canAlchemyWithBuyItem = manager.canAlchemyWithSeiekiAndAutoBuy(recipe);
        if (canAlchemyWithBuyItem != AutoBuy.disable) {
            return true;
        }
        return false;
    };
    Window_AlchemyCommand.prototype.isCurrentItemEnabled = function () {
        return this.isEnabled(this.index());
    };
    Window_AlchemyCommand.prototype.fillOverlayBlack = function (rect, index) {
        if (!this.isEnabled(index)) {
            this.contents.fillRect(rect.x, rect.y, rect.width, rect.height, '#00000055');
        }
    };
    Window_AlchemyCommand.prototype.drawNew = function (recipe, y) {
        var history = $gameSystem.alchemyHistory();
        if (history.isRecipeMade(recipe.id())) {
            return;
        }
        this.changeTextColor(ColorManager.crisisColor());
        this.contents.fontSize = 12;
        this.drawText(TextManager.notAlchemy, 40, y + 14, 60, 'center');
        this.changeTextColor(ColorManager.normalColor());
    };
    Window_AlchemyCommand.prototype.drawActorIcon = function (recipe, y) {
        var item = recipe.destItem();
        var x = 314;
        this.contents.fontSize = 12;
        this.changeTextColor(ColorManager.crisisColor());
        if (DataManager.isArmor(item) || DataManager.isWeapon(item)) {
            var equip = item;
            var actors = [2, 3, 1];
            for (var i = 0; i < actors.length; i++) {
                var actor = $gameActors.actor(actors[i]);
                if (actor.canEquip(equip)) {
                    var isEquip = actor.actorEquip().isEquip(equip);
                    this.drawIcon(actor.iconIndex(), x, y);
                    if (isEquip) {
                        this.drawText('Equip', x, y + 14, 34, 'center');
                    }
                }
                x += 34;
            }
        }
        this.changePaintOpacity(true);
    };
    Window_AlchemyCommand.prototype.selectedRecipe = function () {
        var recipe = this._recipeList[this.index()];
        return recipe;
    };
    Window_AlchemyCommand.prototype.refresh = function () {
        _super.prototype.refresh.call(this);
        this.select(0);
        this.scrollTo(0, 0);
    };
    Window_AlchemyCommand.prototype.setCategory = function (c) {
        if (this._category == c) {
            return;
        }
        this._category = c;
        this.refreshAll();
    };
    Window_AlchemyCommand.prototype.setFilter = function (f) {
        if (this._filter == f) {
            return;
        }
        this._filter = f;
        this.refreshAll();
    };
    Window_AlchemyCommand.prototype.refreshAll = function () {
        this.makeData();
        this.refresh();
        this.callHandler('change');
    };
    return Window_AlchemyCommand;
}(Window_Selectable));
/**
 * 中央のメインウィンドウ
 */
var Window_AlchemyMaterial = /** @class */ (function (_super) {
    __extends(Window_AlchemyMaterial, _super);
    function Window_AlchemyMaterial() {
        var _this = this;
        var r = new Rectangle(690, 80, 560, 710);
        _this = _super.call(this, r) || this;
        _this._equipHelpSprite = new Sprite_EquipHelp();
        _this._equipHelpSprite.hideName();
        _this._equipHelpSprite.x = 110;
        _this._equipHelpSprite.y = 10 + 24;
        _this.addChild(_this._equipHelpSprite);
        _this._nameSprite = new Sprite_AlchemyResultName(true);
        _this.addChild(_this._nameSprite);
        _this._nameSprite.x = 65;
        _this._nameSprite.y = -3;
        _this.frameVisible = false;
        _this.backOpacity = 0;
        return _this;
    }
    Window_AlchemyMaterial.prototype.refresh = function () {
        this.changePaintOpacity(true);
        this._windowContentsSprite.removeChildren();
        _super.prototype.refresh.call(this);
        this.drawInfo();
        this.drawEquip();
        this.drawName();
        this.drawPartyMaterial();
        this.drawRecipeMaterial();
        this.drawNeedGold();
    };
    Window_AlchemyMaterial.prototype.drawName = function () {
        var item = this._recipe.destItem();
        this._nameSprite.showResult(item);
    };
    Window_AlchemyMaterial.prototype.drawEquip = function () {
        var item = this._recipe.destItem();
        var e = item;
        this._equipHelpSprite.setItem(e);
    };
    Window_AlchemyMaterial.prototype.maxItems = function () {
        if (!this._recipe) {
            return 0;
        }
        return this._recipe.materialItemsForAlchemy().length;
    };
    Window_AlchemyMaterial.prototype.drawItem = function (index) {
        var material = this._recipe.materialItemsForAlchemy()[index];
        var rect = this.itemRect(index);
        this.contents.fontSize = 20;
        if ($gameParty.numItems(material.item()) >= material.requiredNum()) {
            this.changeTextColor(ColorManager.normalColor());
        }
        else {
            this.changeTextColor(ColorManager.deathColor());
        }
        var yy = rect.y + 1;
        this.drawIcon(material.iconIndex(), rect.x + 72, rect.y + 3);
        this.drawText(material.name(), rect.x + 110, yy, 250, 'left');
        this.drawText('x' + material.requiredNum(), rect.x + 140, yy, 260, 'right');
        this.drawText('/', rect.x + 153, yy, 280, 'right');
        this.drawText(material.posessionNum(), rect.x + 186, yy, 280, 'right');
        this.drawShopOnlyText(material, rect);
    };
    Window_AlchemyMaterial.prototype.drawShopOnlyText = function (material, rect) {
        this.contents.fontSize = 14;
        var shopOnly = Nore.isShopOnly(material.nameJp());
        if (!shopOnly) {
            return;
        }
        this.changeTextColor(ColorManager.crisisColor());
        this.drawText('Shop only', rect.x + 1, rect.y + 1, 280, 'left');
    };
    Window_AlchemyMaterial.prototype.itemRect = function (index) {
        var r = _super.prototype.itemRect.call(this, index);
        r.x += 22;
        r.width -= 20;
        r.y += 393;
        return r;
    };
    Window_AlchemyMaterial.prototype.setRecipe = function (recipe) {
        if (!recipe) {
            return;
        }
        this._recipe = recipe;
        this.refresh();
    };
    Window_AlchemyMaterial.prototype.drawInfo = function () {
        this.changeTextColor(ColorManager.normalColor());
        this.contents.fontSize = 20;
    };
    Window_AlchemyMaterial.prototype.drawRecipeMaterial = function () {
        var list = this._recipe.materialList();
        var xx = 60;
        var yy = 516;
        for (var i = 0; i < list.length; i++) {
            var icon = $gameParty.materialIcon(i);
            this.changePaintOpacity(list[i] > 0);
            this.drawIcon(icon, xx, yy);
            //this.changeTextColor(this.materialColor(i, list[i]));
            var num = list[i];
            var numId = this.numberId(i, list[i]);
            this.drawNumber(num, xx, yy - 8, 110, 'right', numId);
            //this.drawText(list[i], xx, yy - 1, 80, 'right');
            yy += 32;
        }
    };
    Window_AlchemyMaterial.prototype.drawPartyMaterial = function () {
        var recipeList = this._recipe.materialList();
        var list = $gameParty.materialList();
        var xx = 240;
        var yy = 516;
        for (var i = 0; i < list.length; i++) {
            var icon = $gameParty.materialIcon(i);
            this.changePaintOpacity(recipeList[i] > 0);
            this.drawIcon(icon, xx, yy);
            //this.changeTextColor(this.materialColor(i, list[i]));
            //this.drawText(list[i], xx, yy - 1, 80, 'right');
            var num = list[i];
            var numId = this.numberId(i, list[i]);
            this.drawNumber(num, xx, yy - 8, 110, 'right', numId);
            yy += 32;
        }
    };
    Window_AlchemyMaterial.prototype.numberId = function (type, num) {
        if (num == 0) {
            return 7;
        }
        if ($gameParty.materialList()[type] >= num) {
            return 7;
        }
        else {
            return 17;
        }
    };
    Window_AlchemyMaterial.prototype.materialColor = function (type, num) {
        if (num == 0) {
            return ColorManager.normalColor();
        }
        if ($gameParty.materialList()[type] >= num) {
            return ColorManager.normalColor();
        }
        else {
            return ColorManager.deathColor();
        }
    };
    Window_AlchemyMaterial.prototype.drawNeedGold = function () {
        var alchemy = new Alchemy(this._recipe);
        var gold = alchemy.needGold();
        if (gold == 0) {
            return;
        }
        if (gold >= MAX_RECIPE_GOLD) {
            return;
        }
        this.changePaintOpacity(true);
        this.changeTextColor(ColorManager.systemColor());
        var xx = 400;
        var yy = 530;
        //this.drawText(TextManager.alchemyBuyItem, xx, yy, 180, 'left')
        this.changeTextColor(ColorManager.normalColor());
        if (gold > $gameParty.gold()) {
            this.changeTextColor(ColorManager.deathColor());
        }
        this.drawNumber(gold, xx, yy - 8, 134, 'right', 16);
        this.drawIcon2x(188, xx, yy - 4);
        this.drawIcon(254, xx + 110, yy);
        //this.drawText('%1Ｇ'.format(gold), xx, yy + 32, 80, 'right')
    };
    return Window_AlchemyMaterial;
}(Window_Selectable));
var Window_AlchemyForecast = /** @class */ (function (_super) {
    __extends(Window_AlchemyForecast, _super);
    function Window_AlchemyForecast() {
        var r = new Rectangle(150, 210, 250, 200);
        return _super.call(this, r) || this;
    }
    Window_AlchemyForecast.prototype.setAlchemy = function (alchemy) {
        this._alchemy = alchemy;
        this.refresh();
    };
    Window_AlchemyForecast.prototype.refresh = function () {
        this._lastNum = this._alchemy.num();
        this.contents.clear();
        var item = this._alchemy.recipe().destItem();
        this.drawIcon(item.iconIndex, 0, 20);
        this.drawText(item.name, 52, 20, 155, 'left');
        var yy = 105;
        this.drawText('作る個数', 60, 70, 140, 'left');
        if (this._alchemy.isOnce()) {
            this.drawText('限定１個', 60, yy, 140, 'left');
        }
        else {
            this.drawText('' + this._alchemy.num() + ' / ' + this._alchemy.maxNum(), 80, yy, 140, 'left');
            this.drawText('<', 40, yy, 140, 'left');
            this.drawText('>', 160, yy, 140, 'left');
        }
    };
    Window_AlchemyForecast.prototype.update = function () {
        _super.prototype.update.call(this);
        if (!this._alchemy) {
            return;
        }
        if (this._lastNum != this._alchemy.num()) {
            this.refresh();
        }
    };
    return Window_AlchemyForecast;
}(Window_Base));
var Window_Alchemy = /** @class */ (function (_super) {
    __extends(Window_Alchemy, _super);
    function Window_Alchemy() {
        var r = new Rectangle(650, 210, 600, 500);
        return _super.call(this, r) || this;
    }
    Window_Alchemy.prototype.maxItems = function () {
        if (!this._alchemy) {
            return 0;
        }
        return this._alchemy.recipe().materialItems().length;
    };
    Window_Alchemy.prototype.setAlchemy = function (alchemy) {
        this._alchemy = alchemy;
        this.refresh();
    };
    Window_Alchemy.prototype.maxCols = function () {
        return 1;
    };
    Window_Alchemy.prototype.refresh = function () {
        if (this._alchemy) {
            this._lastNum = this._alchemy.num();
        }
        _super.prototype.refresh.call(this);
        this.drawPartyMaterial();
    };
    Window_Alchemy.prototype.drawItem = function (index) {
        var material = this._alchemy.recipe().materialItems()[index];
        var count = $gameParty.numItems(material.item());
        var requiredNum = material.requiredNum() * this._alchemy.num();
        if (count >= requiredNum) {
            this.changePaintOpacity(true);
        }
        else {
            this.changePaintOpacity(false);
        }
        var rect = this.itemRect(index);
        this.drawIcon(material.iconIndex(), rect.x, rect.y + 0);
        this.drawText(material.name(), rect.x + 100, rect.y + 0, 240, 'left');
        this.drawText(requiredNum + '/' + count, rect.x + 400, rect.y, 140, 'left');
    };
    Window_Alchemy.prototype.itemHeight = function () {
        return 100;
    };
    Window_Alchemy.prototype.update = function () {
        _super.prototype.update.call(this);
        if (!this._alchemy) {
            return;
        }
        if (this._lastNum != this._alchemy.num()) {
            this.refresh();
        }
    };
    Window_Alchemy.prototype.drawPartyMaterial = function () {
        var list = this._alchemy.recipe().materialList();
        var xx = 20;
        var yy = 424;
        for (var i = 0; i < list.length; i++) {
            var icon = $gameParty.materialIcon(i);
            this.drawIcon(icon, xx, yy);
            this.drawText(list[i], xx, yy - 1, 80, 'right');
            xx += 105;
            if (i < 4) {
                this.contents.fillRect(xx - 4, yy + 3, 1, 28, '#999999');
            }
        }
    };
    return Window_Alchemy;
}(Window_Selectable));
var Sprite_AlchemyLevel = /** @class */ (function (_super) {
    __extends(Sprite_AlchemyLevel, _super);
    function Sprite_AlchemyLevel() {
        var _this = _super.call(this) || this;
        _this.x = 726;
        _this.y = 21;
        _this.refresh();
        return _this;
    }
    Sprite_AlchemyLevel.prototype.refresh = function () {
        var level = $gameParty.alchemyLevel();
        var offset = (level < 10) ? 10 : 0;
        if (level == $gameParty.alchemyActor().maxLevel()) {
            var bitmap = ImageManager.loadSystem('alchemy_ui');
            var s = new Sprite();
            s.bitmap = bitmap;
            s.setFrame(200, 200, 200, 50);
            s.x = 36;
            this.addChild(s);
        }
        else {
            this.drawNumber(level, 42 + offset, 0, 144, 'left', 16);
        }
        var per = $gameParty.alchemyManager().levelMaterialPer(level);
        this.drawNumber(per, 176, 0, 100, 'right', 16);
    };
    return Sprite_AlchemyLevel;
}(Sprite));
var Window_AlchemyPartyMaterial = /** @class */ (function (_super) {
    __extends(Window_AlchemyPartyMaterial, _super);
    function Window_AlchemyPartyMaterial() {
        var _this = this;
        var r = new Rectangle(680, -130, 550, 64);
        _this = _super.call(this, r) || this;
        _this.refresh();
        return _this;
    }
    Window_AlchemyPartyMaterial.prototype.refresh = function () {
        this.contents.clear();
        var list = $gameParty.materialList();
        var xx = 10;
        var yy = 4;
        for (var i = 0; i < list.length; i++) {
            var icon = $gameParty.materialIcon(i);
            this.drawIcon(icon, xx, yy);
            this.drawText(list[i], xx, yy - 1, 80, 'right');
            xx += 105;
            if (i < 4) {
                this.contents.fillRect(xx - 4, yy + 3, 1, 28, '#999999');
            }
        }
    };
    return Window_AlchemyPartyMaterial;
}(Window_Base));
var Sprite_Gold = /** @class */ (function (_super) {
    __extends(Sprite_Gold, _super);
    function Sprite_Gold() {
        var _this = _super.call(this) || this;
        _this.x = 1132;
        _this.y = 8;
        _this.refresh();
        return _this;
    }
    Sprite_Gold.prototype.refresh = function () {
        var gold = $gameParty.gold();
        this.drawNumber(gold, 0, 0, 100, 'right', 16);
    };
    return Sprite_Gold;
}(Sprite));
