var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Window_DayBase = /** @class */ (function (_super) {
    __extends(Window_DayBase, _super);
    function Window_DayBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_DayBase.prototype.isChanged = function () {
        if (this._time != $gameSystem.time()) {
            return true;
        }
        if (this._day != $gameSystem.day()) {
            return true;
        }
        if (this._floor != $gameSystem.floor()) {
            return true;
        }
        return false;
    };
    Window_DayBase.prototype.refresh = function () {
        this._windowContentsSprite.removeChildren();
        this.contents.clear();
        this.contents.fontSize = ConfigManager.isJp() ? 20 : 18;
        this.drawChapter(6);
        this.drawDay(ConfigManager.isJp() ? 40 : 60);
        this.drawTime(174);
        this.drawFloor(160);
    };
    Window_DayBase.prototype.textY = function () {
        return 3;
    };
    Window_DayBase.prototype.drawChapter = function (x) {
        var stage = $gameSystem.stage();
        if (stage == 0) {
            this.drawPrologue(x);
            return;
        }
        var text = TextManager.chapter.format('　');
        var offset1 = ConfigManager.isJp() ? 0 : -6;
        this.drawText(text, x + 2 + offset1, this.textY(), 100);
        var offset2 = ConfigManager.isJp() ? 0 : 71;
        this.drawNumber(stage, x + 9 + offset2, -5, 100, 'left', 7);
    };
    Window_DayBase.prototype.drawPrologue = function (x) {
        var text = TextManager.prologue;
        this.drawText(text, x, this.textY(), 80);
    };
    Window_DayBase.prototype.drawDay = function (x) {
        var day = $gameSystem.day();
        this._day = day;
        if (day == 0) {
            var offset = ConfigManager.isJp() ? 0 : 34;
            this.drawText(TextManager.anyDay.format(day), x + offset, this.textY(), 80, 'right');
        }
        else {
            var offset = ConfigManager.isJp() ? 0 : 50;
            this.drawNumber(day, x + 9 + offset, -5, 64, 'right', 7);
            this.drawText(TextManager.saveDay.format('　'), x, this.textY(), 100, 'right');
        }
    };
    Window_DayBase.prototype.drawTime = function (x) {
        if ($gameParty.inDungeon()) {
            return;
        }
        var time = $gameSystem.time();
        this._time = time;
        var image = this.timeImage(time);
        this.contents.blt(image, 0, 0, image.width, image.height, x, -3);
        //this.drawText(this.timeName(time), x, 0, 100);
    };
    Window_DayBase.prototype.timeImage = function (time) {
        switch (time) {
            case Time.morning: return ImageManager.loadSystem('weather01_03');
            case Time.afternoon: return ImageManager.loadSystem('weather01_03');
            case Time.night: return ImageManager.loadSystem('weather04_02');
        }
        return null;
    };
    Window_DayBase.prototype.timeName = function (time) {
        switch (time) {
            case Time.morning: return TextManager.morningPart;
            case Time.afternoon: return TextManager.morningPart;
            case Time.night: return TextManager.nightPart;
        }
        return 'error';
    };
    Window_DayBase.prototype.drawFloor = function (x) {
        var floor = $gameSystem.floor();
        this._floor = floor;
        if (!$gameParty.inDungeon()) {
            return;
        }
        var offset1 = ConfigManager.isJp() ? 0 : 14;
        this.drawNumber(floor, x - 14 + offset1, -5, 60, 'right', 7);
        this.drawText(TextManager.floor, x, this.textY(), 54, 'right');
    };
    Window_DayBase.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateVisible();
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Window_DayBase.prototype.updateVisible = function () {
        if ($gameSystem.isEroEvent()) {
            this.visible = false;
            return;
        }
        if ($gameSwitches.value(75)) {
            this.visible = false;
            return;
        }
        if ($gameSystem.isRecollection()) {
            this.visible = false;
            return;
        }
        if ($gameMap && $gameMap.mapId() == 1) {
            this.visible = false;
            return;
        }
        this.visible = true;
    };
    return Window_DayBase;
}(Window_Base));
var Window_Day = /** @class */ (function (_super) {
    __extends(Window_Day, _super);
    function Window_Day() {
        var _this = this;
        var r = new Rectangle(0, 0, 250, 66);
        _this = _super.call(this, r) || this;
        _this.refresh();
        return _this;
    }
    return Window_Day;
}(Window_DayBase));
var Window_DayAtelier = /** @class */ (function (_super) {
    __extends(Window_DayAtelier, _super);
    function Window_DayAtelier() {
        var _this = this;
        var r = new Rectangle(0, 0, 250, 66);
        _this = _super.call(this, r) || this;
        _this._margin = 0;
        _this.frameVisible = false;
        _this.backOpacity = 0;
        _this.refresh();
        return _this;
    }
    return Window_DayAtelier;
}(Window_DayBase));
var Sprite_DayAtelier = /** @class */ (function (_super) {
    __extends(Sprite_DayAtelier, _super);
    function Sprite_DayAtelier(w) {
        var _this = _super.call(this) || this;
        _this._dayWindow = w;
        _this.bitmap = ImageManager.loadSystem('menu_ui');
        _this.setFrame(350, 450, 300, 100);
        _this.createWarpButton();
        return _this;
    }
    Sprite_DayAtelier.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._dayWindow) {
            this.visible = this._dayWindow.visible;
        }
        if ($gameSystem.isRecollection()) {
            this.visible = false;
        }
        this.updateWarpVisible();
    };
    Sprite_DayAtelier.prototype.updateWarpVisible = function () {
        this._warpButton.visible = $gameSystem.isWarpOpen() && this.inAtelier();
        if (this._leftList) {
            if (this._leftList.visible || this.inBabyRoom()) {
                if (!this._warpButton.isEnabled()) {
                    this._warpButton.enable();
                }
            }
            else {
                if (this._warpButton.isEnabled()) {
                    this._warpButton.disable();
                }
            }
        }
        this._warpSprite.visible = this._warpButton.visible && !$gameSwitches.value(350) && this._warpButton.isEnabled();
    };
    Sprite_DayAtelier.prototype.createWarpButton = function () {
        this._warpButton = new Sprite_OverableButton("warp", true);
        this._warpButton.x = 235;
        this._warpButton.y = 9;
        this.addChild(this._warpButton);
        this._warpSprite = new Sprite();
        this._warpSprite.x = 277;
        this._warpSprite.y = -16;
        this._warpSprite.bitmap = ImageManager.loadSystem('menu_ui');
        this._warpSprite.setFrame(300, 250, 50, 50);
        this.addChild(this._warpSprite);
    };
    Sprite_DayAtelier.prototype.inAtelier = function () {
        switch ($gameMap.mapId()) {
            case 13: return true;
            case 75: return true;
            case 78: return true;
            case 86: return true;
            case 137: return true;
        }
        return false;
    };
    Sprite_DayAtelier.prototype.inBabyRoom = function () {
        switch ($gameMap.mapId()) {
            case 137: return true;
        }
        return false;
    };
    Sprite_DayAtelier.prototype.setLeftList = function (leftList) {
        this._leftList = leftList;
    };
    return Sprite_DayAtelier;
}(Sprite));
var Sprite_DayDungeon = /** @class */ (function (_super) {
    __extends(Sprite_DayDungeon, _super);
    function Sprite_DayDungeon(w) {
        var _this = _super.call(this) || this;
        _this._dayWindow = w;
        _this.bitmap = ImageManager.loadSystem('menu_ui');
        _this.setFrame(0, 250, 250, 100);
        return _this;
    }
    Sprite_DayDungeon.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._dayWindow) {
            this.visible = this._dayWindow.visible;
        }
        if ($gameSystem.isRecollection()) {
            this.visible = false;
        }
    };
    return Sprite_DayDungeon;
}(Sprite));
