/*:ja
 * @target MZ
 * @author ル
 *
 * @command updateVarForNinshinEvent
 * @text 妊娠用変数を設定
 * @des 妊娠用変数を設定
 * @arg actorId
 * @type number
 *
 * @command ninshin
 * @text 妊娠させる
 * @des 妊娠させる
 * @arg actorId
 * @type number
 * @arg manId
 * @type number
 *
 * @command ninshinVar
 * @text 妊娠させる(変数指定)
 * @des 妊娠させる(変数指定)
 * @arg actorId
 * @type number
 * @arg varId
 * @type number
 *
 * @command syusan
 * @text 出産させる
 * @arg actorId
 * @type number
 *
 * @command ninshinAndSyusan
 * @text 妊娠&出産させる(デバッグ用)
 * @arg actorId
 * @type number
 * @arg manId
 * @type number
 *
 * @command ninshinAndSyusanVar
 * @text 妊娠&出産させる(デバッグ用変数指定)
 * @arg actorId
 * @type number
 * @arg varId
 * @type number
 *
 * @command ninshinAndSyusanCommon
 * @text 妊娠&出産させる(コモンイベント指定)
 * @arg commonId
 * @type number
 *
 * @command saveNinshinCos
 * @arg actorId
 * @type number
 *
 * @command setFatherNameTo25
 * @text 変数２５に父親の名前を入れる
 * @arg actorId
 * @type number
 *
 * @command setFatherNameTo97
 * @text 変数97にパティ以外の父親の名前を入れる
 * @arg actorId
 * @type number
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Baby';
    var INOCHI_NO_MINAMOTO_ID = 220;
    PluginManager.registerCommand(pluginName, 'updateVarForNinshinEvent', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        try {
            actor.babyHistory().updateVarForNinshinEvent();
        }
        catch (e) {
            if ($gameSystem.isRecollection()) {
                return;
            }
            console.error(e);
        }
    });
    PluginManager.registerCommand(pluginName, 'ninshin', function (args) {
        var actorId = parseInt(args.actorId);
        var manId = parseInt(args.manId);
        var actor = $gameActors.actor(actorId);
        actor.upNinshinDamage(100, manId, -1, false);
    });
    PluginManager.registerCommand(pluginName, 'ninshinVar', function (args) {
        var actorId = parseInt(args.actorId);
        var varId = parseInt(args.varId);
        var actor = $gameActors.actor(actorId);
        var manId = $gameVariables.value(varId);
        actor.upNinshinDamage(100, manId, -1, false);
        var baby = actor.babyHistory().lastBaby();
        if (baby && baby.fatherId() == manId) {
            p(manId + 'の子を妊娠');
        }
        else {
            console.error(manId + 'の子を妊娠失敗');
        }
    });
    PluginManager.registerCommand(pluginName, 'syusan', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        actor.syusan();
        p(actorId + 'の出産');
    });
    PluginManager.registerCommand(pluginName, 'ninshinAndSyusan', function (args) {
        var actorId = parseInt(args.actorId);
        var manId = parseInt(args.manId);
        var actor = $gameActors.actor(actorId);
        actor.upNinshinDamage(100, manId, -1, false);
        actor.syusan();
    });
    PluginManager.registerCommand(pluginName, 'ninshinAndSyusanVar', function (args) {
        var actorId = parseInt(args.actorId);
        var varId = parseInt(args.varId);
        var manId = $gameVariables.value(varId);
        var actor = $gameActors.actor(actorId);
        actor.upNinshinDamage(100, manId, -1, false);
        actor.syusan();
    });
    PluginManager.registerCommand(pluginName, 'ninshinAndSyusanCommon', function (args) {
        var commonId = parseInt(args.commonId);
        var map = ERO_MAP[commonId];
        if (!map) {
            console.error("'".concat(commonId, "\u306ESEIEKI_MAP\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093"));
            return;
        }
        var param = new EroParam(map);
        var actor = $gameActors.actor(param.actorId());
        actor.upNinshinDamage(100, param.manId(), param.commonId(), false);
        actor.syusan();
    });
    PluginManager.registerCommand(pluginName, 'saveNinshinCos', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        actor.babyHistory().lastBaby().saveCos();
    });
    PluginManager.registerCommand(pluginName, 'setFatherNameTo25', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        var name = actor.babyHistory().lastBaby().fatherName();
        $gameVariables.setValue(FATHER_NAME_VAR, name);
    });
    PluginManager.registerCommand(pluginName, 'setFatherNameTo97', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        var list = actor.babyHistory().babyList();
        var candidates = [];
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var b = list_1[_i];
            if (b.fatherId() != 3) {
                candidates.push(b);
            }
        }
        if (candidates.length == 0) {
            console.error('パティ以外の父親がいません');
            return;
        }
        var dice = Math.randomInt(candidates.length);
        var baby = candidates[dice];
        $gameVariables.setValue(FATHER_NAME_NOT_PATTY_VAR, baby.fatherName());
    });
})(Nore || (Nore = {}));
var FATHER_NAME_VAR = 24;
var FATHER_ID_VAR = 25;
var NINSHIN_COUNT_VAR = 26;
var NINSHIN_COUNT_PER_FATHER_VAR = 27;
var NINSHIN_ACOTR_NAME_VAR = 28;
var LIKEABILITY_SW = 21;
var SEX_COUNT_VAR = 40;
var SANZOKU_ACTOR_ID = 61;
var FATHER_NAME_NOT_PATTY_VAR = 97;
var BabyProgress;
(function (BabyProgress) {
    BabyProgress["jusei"] = "jusei";
    BabyProgress["bote"] = "bote";
    BabyProgress["syusan"] = "syusan";
})(BabyProgress || (BabyProgress = {}));
var BabySkill;
(function (BabySkill) {
    BabySkill["idiot"] = "idiot";
})(BabySkill || (BabySkill = {}));
var BabySkillSet = /** @class */ (function () {
    function BabySkillSet(actorId, fatherId) {
        this._actorId = actorId;
        this._fatherId = fatherId;
        this._skills = [];
    }
    BabySkillSet.prototype.decideBabySkill = function () {
    };
    BabySkillSet.prototype.makeCandidates = function () {
        return [BabySkill.idiot];
    };
    return BabySkillSet;
}());
var Baby = /** @class */ (function () {
    function Baby(actorId, fatherId, commonId) {
        this._time = 0;
        this._type = 1;
        this._actorId = actorId;
        this._fatherId = fatherId;
        this._commonId = commonId;
        this._day = $gameSystem.day();
        this._progress = BabyProgress.jusei;
        this._male = Math.randomInt(2) == 0;
        this._type = Math.randomInt(2) + 1;
    }
    Baby.prototype.progress = function () {
        return this._progress;
    };
    Baby.prototype.actorId = function () {
        return this._actorId;
    };
    Baby.prototype.fatherId = function () {
        return this._fatherId;
    };
    Baby.prototype.commonId = function () {
        return this._commonId;
    };
    Baby.prototype.setBote = function () {
        this._progress = BabyProgress.bote;
    };
    Baby.prototype.syusan = function () {
        this._progress = BabyProgress.syusan;
        this._time = $gameSystem.playtime();
    };
    Baby.prototype.isSyusan = function () {
        return this._progress == BabyProgress.syusan;
    };
    Baby.prototype.isBote = function () {
        return this._progress == BabyProgress.bote;
    };
    Baby.prototype.isJusei = function () {
        return this._progress == BabyProgress.jusei;
    };
    Baby.prototype.isMale = function () {
        return this._male;
    };
    Baby.prototype.fatherName = function () {
        var taneoya = $gameActors.actor(this.fatherId());
        if (!taneoya) {
            console.error(this.fatherId() + ' の種親が見つかりません');
            return '';
        }
        if (taneoya.actorId() == 146) {
            return $gameActors.actor(SANZOKU_ACTOR_ID).name();
        }
        return taneoya.name();
    };
    Baby.prototype.eroImageId = function () {
        var result = this.findSeiekiResult();
        if (!result) {
            console.error('精液リザルトが見つかりません');
            return '';
        }
        return result.eroImageFile();
        /*
        const commonId = this._commonId;
        if (! commonId) {
            return '';
        }
          const map = ERO_MAP[commonId];
        if (! map) {
            console.error(`'${commonId}のSEIEKI_MAPが見つかりません`)
            return '';
        }
        const param = new EroParam(map);
        return param.eroImageId();*/
    };
    Baby.prototype.findSeiekiResult = function () {
        var list = $gameParty.dayResultHistory().makeHistory(this._actorId);
        for (var _i = 0, list_2 = list; _i < list_2.length; _i++) {
            var s = list_2[_i];
            if (s.day() != this._day) {
                continue;
            }
            if (s.isNinshin()) {
                return s;
            }
        }
        return null;
    };
    Baby.prototype.babyImageId = function () {
        var imageIndex = this.imageIndex();
        if (this.isGoblin()) {
            return '$baby_03_0' + imageIndex;
        }
        if (this.isBlack()) {
            return '$baby_02_0' + imageIndex;
        }
        if (this.isMale()) {
            return '$baby_01_ma_0' + imageIndex;
        }
        else {
            return '$baby_01_fe_0' + imageIndex;
        }
    };
    Baby.prototype.babyImageIndex = function () {
        return this.growth();
    };
    Baby.prototype.isBlack = function () {
        return $baisyunManParamManager.findManParamByManId(this._fatherId).isBlack();
    };
    Baby.prototype.imageIndex = function () {
        return this._type || 1;
    };
    Baby.prototype.growth = function () {
        if ($gameSystem.day() - this.day() >= 8) {
            return 2;
        }
        if ($gameSystem.day() - this.day() >= 4) {
            return 1;
        }
        return 0;
    };
    Baby.prototype.update = function () {
        if (this.isSyusan()) {
            this._time++;
        }
    };
    Baby.prototype.loadImage = function () {
        //p('loadImage:' + this.babyImageId())
        return ImageManager.loadCharacter(this.babyImageId());
    };
    Baby.prototype.isGoblin = function () {
        return $baisyunManParamManager.findManParamByManId(this._fatherId).isGoblin();
    };
    Baby.prototype.saveCos = function () {
        this._cos = new CostumeSaver(this._actorId);
    };
    Baby.prototype.cos = function () {
        return this._cos || new CostumeSaver(this._actorId);
    };
    Baby.prototype.day = function () {
        return this._day;
    };
    Baby.prototype.changeDay = function (offset) {
        this._day += offset;
    };
    return Baby;
}());
var BabyHistory = /** @class */ (function () {
    function BabyHistory(actorId) {
        this._actorId = actorId;
        this._babyList = [];
    }
    BabyHistory.prototype.clear = function () {
        this._babyList = [];
    };
    BabyHistory.prototype.actorId = function () {
        return this._actorId;
    };
    BabyHistory.prototype.ninshin = function (fatherId, commonId) {
        if (fatherId == 0) {
            console.error('種親が設定されていません');
            throw {};
        }
        if (this.lastBaby() && this.lastBaby().progress() != BabyProgress.syusan) {
            console.error('今は妊娠できません');
            p(this.lastBaby());
            return false;
        }
        var baby = new Baby(Math.trunc(this._actorId), fatherId, commonId);
        this._babyList.push(baby);
        var ninshinCommonId = this.ninsinCommonEventId(commonId);
        if (ninshinCommonId > 0) {
            p('妊娠判明 ninshinCommonId ' + ninshinCommonId);
            if (this.actor().isBote()) {
                p('すでにボテ腹だったの妊娠判明イベントを無視しました');
                return true;
            }
            $commonEvent.restoreCommonEvent(ninshinCommonId);
            $commonEvent.reserveCommonEvent(ninshinCommonId, CommonIdType.ninshin);
        }
        else {
            if (this._actorId <= 3) {
                if (this.isNotReserveNinshinCommonEvent(commonId)) {
                    p('妊娠判明イベントが発生しないイベントです');
                }
                else {
                    console.error(this._actorId + 'の妊娠判明 commonId が存在しません');
                }
            }
        }
        return true;
    };
    BabyHistory.prototype.lastBaby = function () {
        if (this._babyList.length == 0) {
            return null;
        }
        return this._babyList[this._babyList.length - 1];
    };
    BabyHistory.prototype.ninsinCommonEventId = function (commonId) {
        if (this.isNotReserveNinshinCommonEvent(commonId)) {
            return -1;
        }
        switch (this._actorId) {
            case 1: return 233;
            case 2: return 225;
        }
        return -1;
    };
    BabyHistory.prototype.isNotReserveNinshinCommonEvent = function (commonId) {
        switch (commonId) {
            case 1425: return true; // ロザリーでのゴブリン
        }
        return false;
    };
    BabyHistory.prototype.babyList = function () {
        return this._babyList;
    };
    BabyHistory.prototype.syusanBabyList = function () {
        var result = [];
        for (var _i = 0, _a = this.babyList(); _i < _a.length; _i++) {
            var baby = _a[_i];
            if (baby.isSyusan()) {
                result.push(baby);
            }
        }
        return result;
    };
    BabyHistory.prototype.syusanBabyListByMan = function (manId) {
        var result = [];
        for (var _i = 0, _a = this.babyList(); _i < _a.length; _i++) {
            var baby = _a[_i];
            if (baby.isSyusan() && baby.fatherId() == manId) {
                result.push(baby);
            }
        }
        return result;
    };
    BabyHistory.prototype.hasBaby = function (index) {
        return this.countSyusan() - 1 >= index;
    };
    BabyHistory.prototype.baby = function (index) {
        return this._babyList[index];
    };
    BabyHistory.prototype.countNinshin = function () {
        var result = 0;
        for (var _i = 0, _a = this.babyList(); _i < _a.length; _i++) {
            var baby = _a[_i];
            result++;
        }
        return result;
    };
    BabyHistory.prototype.countNinshinPerFather = function (fatherId) {
        var result = 0;
        for (var _i = 0, _a = this.babyList(); _i < _a.length; _i++) {
            var baby = _a[_i];
            if (baby.fatherId() == fatherId) {
                result++;
            }
        }
        return result;
    };
    BabyHistory.prototype.countSyusan = function () {
        return this.syusanBabyList().length;
    };
    BabyHistory.prototype.countSyusanDay = function (day) {
        var n = 0;
        for (var _i = 0, _a = this.babyList(); _i < _a.length; _i++) {
            var baby = _a[_i];
            if (baby.isSyusan() && baby.day() <= day) {
                n++;
            }
        }
        return n;
    };
    BabyHistory.prototype.countSyusanMan = function (fatherId) {
        var result = 0;
        for (var _i = 0, _a = this.babyList(); _i < _a.length; _i++) {
            var baby = _a[_i];
            if (baby.isSyusan() && baby.fatherId() == fatherId) {
                result++;
            }
        }
        return result;
    };
    BabyHistory.prototype.isNinshin = function () {
        var baby = this.lastBaby();
        if (!baby) {
            return false;
        }
        return !baby.isSyusan();
    };
    BabyHistory.prototype.updateVarForNinshinEvent = function () {
        this.updateFirstNinshinSw();
        this.updateNinshinCountSw();
        this.updateFatherVar();
        this.updateActorNameVar();
        this.updateLikeabilitySw();
    };
    BabyHistory.prototype.updateNinshinCountSw = function () {
        $gameVariables.setValue(NINSHIN_COUNT_VAR, this.countNinshin());
        var baby = this.lastBaby();
        var n = this.countNinshinPerFather(baby.fatherId());
        $gameVariables.setValue(NINSHIN_COUNT_PER_FATHER_VAR, n);
    };
    BabyHistory.prototype.updateFirstNinshinSw = function () {
        if (this.countNinshin() == 1) {
            $gameSwitches.setValue(20, true);
        }
        else {
            $gameSwitches.setValue(20, false);
        }
    };
    BabyHistory.prototype.updateActorNameVar = function () {
        var actorName = this.actor().name();
        $gameVariables.setValue(NINSHIN_ACOTR_NAME_VAR, actorName);
    };
    BabyHistory.prototype.updateFatherVar = function () {
        var baby = this.lastBaby();
        var fatherName = baby.fatherName();
        $gameVariables.setValue(FATHER_NAME_VAR, fatherName);
    };
    BabyHistory.prototype.updateLikeabilitySw = function () {
        var baby = this.lastBaby();
        $gameVariables.setValue(FATHER_ID_VAR, baby.fatherId());
        if (this.isHighLikeability(baby.fatherId())) {
            $gameSwitches.setValue(LIKEABILITY_SW, true);
        }
        else {
            $gameSwitches.setValue(LIKEABILITY_SW, false);
        }
    };
    BabyHistory.prototype.isHighLikeability = function (fatherId) {
        var level = this.actor().friendshipActor().friendshipLevel(fatherId);
        return level.rank() >= FriendshipLevelS.rank();
    };
    BabyHistory.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    BabyHistory.prototype.previousSyusanBaby = function (baby) {
        var previous = null;
        for (var _i = 0, _a = this.babyList(); _i < _a.length; _i++) {
            var b = _a[_i];
            if (!b.isSyusan()) {
                continue;
            }
            if (baby == b) {
                return previous;
            }
            previous = b;
        }
        console.error('赤ん坊が見つかりません');
        return null;
    };
    BabyHistory.prototype.nextSyusanBaby = function (baby) {
        var found = false;
        for (var _i = 0, _a = this.babyList(); _i < _a.length; _i++) {
            var b = _a[_i];
            if (!b.isSyusan()) {
                continue;
            }
            if (baby == b) {
                found = true;
                continue;
            }
            if (found) {
                return b;
            }
        }
        if (!found) {
            console.error('赤ん坊が見つかりません');
        }
        return null;
    };
    return BabyHistory;
}());
