var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 *
 * @command  setupSyusanVar
 * @text 出産回数変数設定
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_BabyEvent';
    PluginManager.registerCommand(pluginName, 'setupSyusanVar', function (args) {
        var actor1 = $gameActors.actor(1);
        $gameVariables.setValue(132, actor1.countSyusan());
        var actor2 = $gameActors.actor(2);
        $gameVariables.setValue(131, actor2.countSyusan());
    });
})(Nore || (Nore = {}));
var Sprite_BabyFather = /** @class */ (function (_super) {
    __extends(Sprite_BabyFather, _super);
    function Sprite_BabyFather(actorId) {
        var _this = _super.call(this) || this;
        _this.x = -25;
        _this.y = -75;
        _this._actorId = actorId;
        _this.drawFather();
        return _this;
    }
    Sprite_BabyFather.prototype.drawFather = function () {
        var actor = $gameActors.actor(this._actorId);
        if (!actor) {
            return;
        }
        this.bitmap = new Bitmap(100, 50);
        this.bitmap.outlineWidth = 5;
        this.bitmap.fontSize = 9;
        this.bitmap.drawText(actor.name(), 0, 10, 50, 32, 'center');
    };
    return Sprite_BabyFather;
}(Sprite));
var Sprite_BabyCharacter = /** @class */ (function (_super) {
    __extends(Sprite_BabyCharacter, _super);
    function Sprite_BabyCharacter(event, baby) {
        var _this = _super.call(this, event) || this;
        _this._baby = baby;
        if (!_this._baby) {
            console.error('赤ん坊が見つかりません');
            return _this;
        }
        _this.createFatherName();
        return _this;
    }
    Sprite_BabyCharacter.prototype.createFatherName = function () {
        this._fatherLayer = new Sprite_BabyFather(this._baby.fatherId());
        this.addChild(this._fatherLayer);
    };
    Sprite_BabyCharacter.prototype.updateBitmap = function () {
        if (this.isImageChanged()) {
            this._tilesetId = $gameMap.tilesetId();
            this._tileId = this._character.tileId();
            this._characterName = this.characterName();
            this._characterIndex = this.characterIndex();
            if (this._tileId > 0) {
                this.setTileBitmap();
            }
            else {
                this.setCharacterBitmap();
            }
        }
    };
    Sprite_BabyCharacter.prototype.characterName = function () {
        if (this._character.characterName().length == 0) {
            return '';
        }
        if (!this._baby) {
            return '';
        }
        return this._baby.babyImageId();
    };
    Sprite_BabyCharacter.prototype.isImageChanged = function () {
        return (this._characterName !== this.characterName() ||
            this._characterIndex !== this.characterIndex());
    };
    Sprite_BabyCharacter.prototype.characterIndex = function () {
        if (!this._baby) {
            return 0;
        }
        return this._baby.babyImageIndex();
    };
    Sprite_BabyCharacter.prototype.characterBlockX = function () {
        return 0;
    };
    Sprite_BabyCharacter.prototype.characterBlockY = function () {
        return this._characterIndex;
    };
    return Sprite_BabyCharacter;
}(Sprite_Character));
