var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command showBaby
 * @arg actorId
 * @type number
 * @arg index
 * @type number
 *
 * @command runScenario
 *
 */
var Nore;
(function (Nore) {
    var $selectedBaby = null;
    var pluginName = 'Nore_BabyScene';
    var babyScenario;
    PluginManager.registerCommand(pluginName, 'showBaby', function (args) {
        var actorId = parseInt(args.actorId);
        var index = parseInt(args.index);
        var actor = $gameActors.actor(actorId);
        var syusanBaby = actor.babyHistory().babyList()[index];
        p(actorId + ' ' + index);
        if (!syusanBaby) {
            $selectedBaby = null;
            return;
        }
        $selectedBaby = syusanBaby;
        p($selectedBaby);
        SceneManager.push(Scene_Baby);
    });
    PluginManager.registerCommand(pluginName, 'runScenario', function (args) {
        p('runScenario');
        var list = $dataScenario[babyScenario];
        if (!list) {
            throw new Error('id:' + babyScenario + ' のデータが見つかりません');
        }
        console.log("Scenario \u30B3\u30DE\u30F3\u30C9\u5B9F\u884C: ".concat(babyScenario));
        $gameTemp.clearDestination();
        this.setupChild(list, this._eventId);
    });
    var BabyScenarioType;
    (function (BabyScenarioType) {
        BabyScenarioType[BabyScenarioType["type1"] = 1] = "type1";
        BabyScenarioType[BabyScenarioType["type2"] = 2] = "type2";
        BabyScenarioType[BabyScenarioType["type3"] = 3] = "type3";
    })(BabyScenarioType || (BabyScenarioType = {}));
    var Scene_Baby = /** @class */ (function (_super) {
        __extends(Scene_Baby, _super);
        function Scene_Baby() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._wait = -1;
            return _this;
        }
        Scene_Baby.prototype.start = function () {
            _super.prototype.start.call(this);
            this._babyWindow.setup($selectedBaby);
            this._motherWindow.setup($selectedBaby);
        };
        Scene_Baby.prototype.create = function () {
            _super.prototype.create.call(this);
            this.createBg();
            this.createWindowLayer();
            this.createAllWindows();
            ImageManager.loadEro($selectedBaby.eroImageId());
            this.createMotherWindow();
            this.createBabyWindow();
            this.createLabels();
            this.createPageButtons();
            this.createChichiButton(800, 50);
        };
        Scene_Baby.prototype.createPageButtons = function () {
            this._pageupButton = new Sprite_Button("pageup");
            this._pageupButton.x = 84;
            this._pageupButton.y = this.buttonY();
            var pageupRight = this._pageupButton.x + this._pageupButton.width;
            this._pagedownButton = new Sprite_Button("pagedown");
            this._pagedownButton.x = pageupRight + 4;
            this._pagedownButton.y = this.buttonY();
            this.addChild(this._pageupButton);
            this.addChild(this._pagedownButton);
            this._pageupButton.setClickHandler(this.onPageUp.bind(this));
            this._pagedownButton.setClickHandler(this.onPageDown.bind(this));
            this.refreshButtons();
        };
        Scene_Baby.prototype.createChichiButton = function (x, y) {
            var button = new Sprite_ButtonFocusableBaby('av', true);
            var left = x;
            var yy = y;
            button.x = left;
            button.y = yy;
            button.enable();
            this.addChild(button);
            button.setClickHandler(this.onChichi.bind(this));
            this._chichiButton = button;
            if ($selectedBaby.actorId() == 4 || $selectedBaby.actorId() == 35) {
                this._label2.hide();
                this._chichiButton.hide();
            }
        };
        Scene_Baby.prototype.onChichi = function () {
            SoundManager.playOk();
            this.runScenario();
        };
        Scene_Baby.prototype.refreshButtons = function () {
            var previous = this.actor().babyHistory().previousSyusanBaby($selectedBaby);
            this._pageupButton.visible = previous != null;
            var next = this.actor().babyHistory().nextSyusanBaby($selectedBaby);
            this._pagedownButton.visible = next != null;
        };
        Scene_Baby.prototype.buttonY = function () {
            return 30;
        };
        Scene_Baby.prototype.createBg = function () {
            this.createPictures();
            $gameScreen.showPicture(1, 'baby_back', 0, 0, 0, 100, 100, 255, PIXI.BLEND_MODES.NORMAL, 0);
            /*const g = new PIXI.Graphics();
            g.beginFill(0x000, 0.5);
            g.drawRect(0, 0, Graphics.width, Graphics.height);
            g.endFill();
            this.addChild(g);*/
        };
        Scene_Baby.prototype.createLabels = function () {
            this._label2 = new Window_Label(TextManager.babyMilk, 860, 40, 550);
            this.addChild(this._label2);
            //this._label1 = new Window_Label3(TextManager.outerAlpha, 100, 20, 450);
            //this.addChild(this._label1);
            //this.updateLabel();
        };
        Scene_Baby.prototype.updateLabel = function () {
            /*let alpha = Math.round($gameSystem.outerAlpha() * 100);
            const text = TextManager.outerAlpha.format(alpha);
            this._label1.setText(text);*/
        };
        Scene_Baby.prototype.createBabyWindow = function () {
            this._babyWindow = new Window_Baby();
            this.addChild(this._babyWindow);
        };
        Scene_Baby.prototype.createMotherWindow = function () {
            this._motherWindow = new Window_Mother();
            this._motherWindow.x = 50;
            this.addChild(this._motherWindow);
        };
        Scene_Baby.prototype.popScene = function () {
            $gameSwitches.setValue(62, false);
            $gameScreen.erasePicture(1);
            _super.prototype.popScene.call(this);
        };
        Scene_Baby.prototype.update = function () {
            _super.prototype.update.call(this);
            this.updateTouchInput();
            this.updateKeyInput();
        };
        Scene_Baby.prototype.updateTouchInput = function () {
            if (TouchInput.isTriggered()) {
                if (TouchInput._y > 200) {
                    SoundManager.playCancel();
                    this.popScene();
                }
            }
            else if (TouchInput.rightButton) {
                SoundManager.playCancel();
                this.popScene();
            }
        };
        Scene_Baby.prototype.updateKeyInput = function () {
            if (Input.isTriggered('ok')) {
                this.runScenario();
            }
            else if (Input.isTriggered('cancel')) {
                SoundManager.playCancel();
                this.popScene();
            }
            //this.updateLeftRightKeyInput(); 取りやめ
            if (Input.isTriggered('pagedown')) {
                this.onPageDown();
            }
            if (Input.isTriggered('pageup')) {
                this.onPageUp();
            }
        };
        Scene_Baby.prototype.updateLeftRightKeyInput = function () {
            if (Input.isTriggered('right') || Input.isTriggered('left')) {
                this._wait = 0;
            }
            if (Input.isPressed('right')) {
                if (this._wait < 0) {
                    return;
                }
                if (this._wait > 0) {
                    this._wait--;
                    return;
                }
                this.onUp();
                this._wait = 1;
            }
            if (Input.isPressed('left')) {
                if (this._wait < 0) {
                    return;
                }
                if (this._wait > 0) {
                    this._wait--;
                    return;
                }
                this.onDown();
                this._wait = 1;
            }
        };
        Scene_Baby.prototype.onUp = function () {
            $gameSystem.upOuterAlpha();
            this.updateLabel();
            this._motherWindow.drawActorImage();
        };
        Scene_Baby.prototype.actor = function () {
            return $gameActors.actor($selectedBaby.actorId());
        };
        Scene_Baby.prototype.onDown = function () {
            $gameSystem.downOuterAlpha();
            this.updateLabel();
            this._motherWindow.drawActorImage();
        };
        Scene_Baby.prototype.onPageUp = function () {
            var previous = this.actor().babyHistory().previousSyusanBaby($selectedBaby);
            if (!previous) {
                return;
            }
            SoundManager.playCursor();
            $selectedBaby = previous;
            this._babyWindow.setup($selectedBaby);
            this._motherWindow.drawActorImage();
            this.refreshButtons();
        };
        Scene_Baby.prototype.onPageDown = function () {
            var next = this.actor().babyHistory().nextSyusanBaby($selectedBaby);
            if (!next) {
                return;
            }
            SoundManager.playCursor();
            $selectedBaby = next;
            this._babyWindow.setup($selectedBaby);
            this._motherWindow.drawActorImage();
            this.refreshButtons();
        };
        Scene_Baby.prototype.runScenario = function () {
            var s = this.selectScenario();
            if (!s) {
                return;
            }
            p('赤ん坊シナリオ:' + s);
            babyScenario = s;
            $commonEvent.restoreCommonEvent(184);
            $commonEvent.reserveCommonEvent(184, CommonIdType.normal);
            this.popScene();
            $gameSwitches.setValue(62, false);
        };
        Scene_Baby.prototype.selectScenario = function () {
            if ($selectedBaby.actorId() == 1) {
                return this.selectScenario1();
            }
            if ($selectedBaby.actorId() == 2) {
                return this.selectScenario2();
            }
            return null;
        };
        Scene_Baby.prototype.calcScenarioType = function () {
            var level = this.friendship();
            if (level.value() < 50) {
                return BabyScenarioType.type1;
            }
            if (level.isMax()) {
                return BabyScenarioType.type3;
            }
            return BabyScenarioType.type2;
        };
        Scene_Baby.prototype.friendship = function () {
            var actorId = $selectedBaby.actorId();
            var actor = $gameActors.actor(actorId);
            var fatherId = $selectedBaby.fatherId();
            return actor.friendshipActor().friendshipLevel(fatherId);
        };
        Scene_Baby.prototype.selectScenarioAuto = function (type, sw1, sw2, name) {
            var file = $selectedBaby.actorId() == 1 ? '赤ん坊画面_ロザリー_%1_0%2' : '赤ん坊画面_%1_0%2';
            if (!$gameSwitches.value(sw1)) {
                $gameSwitches.setValue(sw1, true);
                return file.format(name, 1);
            }
            if (type == BabyScenarioType.type3) {
                if (!$gameSwitches.value(sw2)) {
                    $gameSwitches.setValue(sw2, true);
                    return file.format(name, 2);
                }
            }
            return file.format(name, type);
        };
        Scene_Baby.prototype.selectScenario2 = function () {
            //p('男ID:' + $selectedBaby.fatherId());
            //$selectedBaby._fatherId = 104
            $gameVariables.setValue(NAME_MAN_VAR_ID, $selectedBaby.fatherId());
            $gameVariables.setValue(NAME_MAN_NAME_VAR_ID, $selectedBaby.fatherName());
            var type = this.calcScenarioType();
            switch ($selectedBaby.fatherId()) {
                case 3: return this.selectScenario2_3(type);
                case 17: return this.selectScenario2_17(type);
                case 32: return this.selectScenario2_32(type);
                case 101: return this.selectScenario2_101(type);
                case 104: return this.selectScenario2_104(type);
                case 105: return this.selectScenario2_105(type);
                case 107: return this.selectScenario2_107(type);
                case 109: return this.selectScenario2_109(type);
                case 110: return this.selectScenario2_110(type);
                case 134: return this.selectScenario2_134(type);
                case 143: return this.selectScenario2_143(type);
                case 144: return this.selectScenario2_144(type);
                default: return this.selectScenario2_baisyun(type);
            }
            return null;
        };
        Scene_Baby.prototype.selectScenario2_3 = function (type) {
            var sw1 = 521;
            var sw2 = 522;
            var name = 'パティ';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario2_101 = function (type) {
            var sw1 = 548;
            var sw2 = 549;
            var name = 'みすぼらしい男';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario2_104 = function (type) {
            var sw1 = 544;
            var sw2 = 545;
            var name = '浮浪者';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario2_105 = function (type) {
            var sw1 = 555;
            var sw2 = 556;
            var name = '臭い男';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario2_109 = function (type) {
            var sw1 = 553;
            var sw2 = 554;
            var name = 'ロアン';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario2_110 = function (type) {
            var sw1 = 526;
            var sw2 = 527;
            var name = 'ゼノ';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario2_17 = function (type) {
            var sw1 = 531;
            var sw2 = 532;
            var name = 'ズラタン';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario2_107 = function (type) {
            var sw1 = 536;
            var sw2 = 537;
            var name = 'レックス';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario2_32 = function (type) {
            var sw1 = 541;
            var sw2 = 542;
            var name = '神父';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario2_134 = function (type) {
            var sw1 = 557;
            var sw2 = 558;
            var name = '下級冒険者';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario2_143 = function (type) {
            var sw1 = 559;
            var sw2 = 560;
            var name = '失礼な青年';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario2_144 = function (type) {
            var sw1 = 546;
            var sw2 = 547;
            var name = 'ゴブリン';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario2_baisyun = function (type) {
            $gameVariables.setValue(NAME_MAN_VAR_ID, $selectedBaby.fatherId());
            $gameVariables.setValue(NAME_MAN_NAME_VAR_ID, $selectedBaby.fatherName());
            var sw1 = 551;
            var sw2 = 552;
            var name = '売春客';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario1 = function () {
            var type = this.calcScenarioType();
            //p('男ID:' + $selectedBaby.fatherId());
            //$selectedBaby._fatherId = 151
            $gameVariables.setValue(NAME_MAN_VAR_ID, $selectedBaby.fatherId());
            $gameVariables.setValue(NAME_MAN_NAME_VAR_ID, $selectedBaby.fatherName());
            switch ($selectedBaby.fatherId()) {
                case 32: return this.selectScenario1_32(type);
                case 38: return this.selectScenario1_38(type);
                case 113: return this.selectScenario1_113(type);
                case 117: return this.selectScenario1_117(type);
                case 131: return this.selectScenario1_131(type);
                case 132: return this.selectScenario1_132(type);
                case 145: return this.selectScenario1_145(type);
                case 147: return this.selectScenario1_147(type);
                case 150: return this.selectScenario1_150(type);
                case 151: return this.selectScenario1_151(type);
                default: return this.selectScenario1_baisyun(type);
            }
            return null;
        };
        Scene_Baby.prototype.selectScenario1_32 = function (type) {
            var sw1 = 566;
            var sw2 = 567;
            var name = '神父';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario1_38 = function (type) {
            var sw1 = 571;
            var sw2 = 572;
            var name = '山賊';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario1_113 = function (type) {
            var sw1 = 585;
            var sw2 = 586;
            var name = 'ロアン';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario1_117 = function (type) {
            var sw1 = 561;
            var sw2 = 562;
            var name = 'ズラタン';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario1_131 = function (type) {
            var sw1 = 578;
            var sw2 = 579;
            var name = '飲んだくれの男';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario1_132 = function (type) {
            var sw1 = 563;
            var sw2 = 564;
            var name = '酒臭い男';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario1_145 = function (type) {
            var sw1 = 568;
            var sw2 = 569;
            var name = 'ロリコンの男';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario1_147 = function (type) {
            var sw1 = 573;
            var sw2 = 574;
            var name = 'チャラい男';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario1_150 = function (type) {
            var sw1 = 576;
            var sw2 = 577;
            var name = 'ゴブリン';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario1_151 = function (type) {
            var sw1 = 583;
            var sw2 = 584;
            var name = '浮浪者';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        Scene_Baby.prototype.selectScenario1_baisyun = function (type) {
            $gameVariables.setValue(NAME_MAN_VAR_ID, $selectedBaby.fatherId());
            $gameVariables.setValue(NAME_MAN_NAME_VAR_ID, $selectedBaby.fatherName());
            var sw1 = 581;
            var sw2 = 582;
            var name = '売春客';
            return this.selectScenarioAuto(type, sw1, sw2, name);
        };
        return Scene_Baby;
    }(Nore.Scene_Talk));
    Nore.Scene_Baby = Scene_Baby;
    var WINDOW_W = 442;
    var Window_Mother = /** @class */ (function (_super) {
        __extends(Window_Mother, _super);
        function Window_Mother() {
            var _this = this;
            var r = new Rectangle(0, 0, 500, 800);
            _this = _super.call(this, r) || this;
            _this.backOpacity = 0;
            _this.frameVisible = false;
            return _this;
        }
        Window_Mother.prototype.setup = function (baby) {
            this._baby = baby;
            this.drawActorImage();
        };
        Window_Mother.prototype.drawActorImage = function () {
            if (!this._baby.cos()) {
                console.error('コスチュームが見つかりません');
                return;
            }
            var a = $gameActors.actor(this._baby.actorId());
            var actor = JsonEx.makeDeepCopy(a);
            var syusanCount = a.babyHistory().countSyusanDay(this._baby.day());
            actor.setSyusanCount(syusanCount);
            actor._cacheChanged = false;
            var cos = this._baby.cos();
            cos.restoreCostume(actor, true);
            actor._boteId = this._baby.cos().boteId();
            actor.setHoppeId(cos.hoppeId());
            actor.setDefaultHoppeId(cos.hoppeId());
            actor.setAcceHoppeId(cos.hoppeId());
            actor.setCacheChanged();
            this.drawTachieActor(actor, this, 0, 0, null, cos.faceId());
            actor.setCacheChanged();
        };
        return Window_Mother;
    }(Window_Base));
    var Window_Baby = /** @class */ (function (_super) {
        __extends(Window_Baby, _super);
        function Window_Baby() {
            var r = new Rectangle(700, 300, 400, 310);
            return _super.call(this, r) || this;
        }
        Window_Baby.prototype.update = function () {
            _super.prototype.update.call(this);
            if (this._loading) {
                if (ImageManager.isReady()) {
                    this.drawEroImage();
                }
            }
        };
        Window_Baby.prototype.setup = function (baby) {
            this._baby = baby;
            this.refresh();
        };
        Window_Baby.prototype.refresh = function () {
            this.contents.clear();
            this.drawEroImage();
        };
        Window_Baby.prototype.drawEroImage = function () {
            var bitmap = ImageManager.loadEro(this._baby.eroImageId());
            if (!ImageManager.isReady()) {
                this._loading = true;
            }
            else {
                this._loading = false;
            }
            var dx = 10;
            var dy = 10;
            this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, dx, dy, bitmap.width, bitmap.height);
            var name = this._baby.fatherName();
            this.drawText('%1とのエッチで妊娠'.format(name), 10, 240, 300);
        };
        return Window_Baby;
    }(Window_Base));
})(Nore || (Nore = {}));
var Sprite_ButtonFocusableBaby = /** @class */ (function (_super) {
    __extends(Sprite_ButtonFocusableBaby, _super);
    function Sprite_ButtonFocusableBaby() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Sprite_ButtonFocusableBaby.prototype.isActive = function () {
        if (this._disable) {
            return false;
        }
        if (!this._active) {
            return false;
        }
        return true;
    };
    return Sprite_ButtonFocusableBaby;
}(Sprite_ButtonFocusable));
