/*:ja
 * @target MZ
 * @author ル
 *
 * @command start
 * @text 売春のマップ開始
 * @arg actorId
 * @type number
 *
 *
 * @command end
 * @text 売春のマップ終了
 *
 * @command nextTurn
 * @text ターンを進める
 *
 * @command resetTurn
 * @text ターンを復活させる
 *
 *
 * @command minusHp
 * @text HPを減らす
 *
 * @command runScenario
 * @text シナリオを実行
 *
 * @command face
 * @text 売春の表情変更
 * @arg faceId
 * @type number
 * @arg hoppeId
 * @type number
 *
 *
 * @command setBaisyunH
 * @text 売春Hを決定
 *
 * @command gainBaisyunGold
 * @text 売春のお金を獲得
 * @arg gold
 * @type number
 *
 * @command recoverHp
 * @text HPを全回復する
 */
var MAN_ID_ENEMY_OFFSET = 1000;
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Baisyun';
    var NEW_CARD_NAME_VAR = 36;
    var NEW_CARD_NUM_VAR = 37;
    PluginManager.registerCommand(pluginName, 'start', function (args) {
        var actorId = parseInt(args.actorId);
        $gameSystem.onBaisyunStart(actorId);
    });
    PluginManager.registerCommand(pluginName, 'end', function (args) {
        $gameSystem.onBaisyunEnd();
    });
    PluginManager.registerCommand(pluginName, 'recoverHp', function (args) {
        $gameSystem.baisyun().recoverHp();
    });
    var NewCard = /** @class */ (function () {
        function NewCard(skillId, cardNum) {
            this.skillId = skillId;
            this.cardNum = cardNum;
        }
        return NewCard;
    }());
    function newCardIdByMedal(list, actor) {
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var armor = list_1[_i];
            if (armor.meta['rewardCard']) {
                var id = parseInt(armor.meta['rewardCard']);
                if (!actor.baisyunPlayer().storage().hasCard(id)) {
                    var num = parseInt(armor.meta['rewardCardNum']);
                    return new NewCard(id, num);
                }
            }
        }
        return null;
    }
    PluginManager.registerCommand(pluginName, 'nextTurn', function (args) {
        var baisyunResult = $gameVariables.value(BAISYUN_RESULT_VAR_ID);
        $gameSystem.baisyun().onBaisyun(baisyunResult);
    });
    PluginManager.registerCommand(pluginName, 'resetTurn', function (args) {
        $gameSystem.baisyun().setRemainTurn(2);
    });
    PluginManager.registerCommand(pluginName, 'minusHp', function (args) {
        var manId = $gameSystem.baisyun().manId();
        var enemy = $dataEnemies[MAN_ID_ENEMY_OFFSET + manId];
        var minusHp = enemy.params[7];
        $gameSystem.baisyun().minusHp(minusHp);
    });
    PluginManager.registerCommand(pluginName, 'runScenario', function (args) {
        var baisyunResult = $gameVariables.value(BAISYUN_RESULT_VAR_ID);
        var baisyun = $gameSystem.baisyun();
        var actorId = baisyun.actorId();
        var manId = $gameVariables.value(BAISYUN_MAN_ID);
        var id = $baisyunTesManager.scenario(baisyunResult, actorId, manId);
        var list = $dataScenario[id];
        if (!list) {
            throw new Error('id:' + id + ' のデータが見つかりません');
        }
        console.log("Scenario \u30B3\u30DE\u30F3\u30C9\u5B9F\u884C: ".concat(id));
        $gameTemp.clearDestination();
        this.setupChild(list, this._eventId);
    });
    PluginManager.registerCommand(pluginName, 'face', function (args) {
        var faceId = parseInt(args.faceId);
        var hoppeId = parseInt(args.hoppeId);
        var baisyun = $gameSystem.baisyun();
        baisyun.setFaceId(faceId);
        baisyun.setHoppeId(hoppeId);
    });
    var KIJOUI_SW = 901;
    PluginManager.registerCommand(pluginName, 'setBaisyunH', function (args) {
        $gameSwitches.setValue(KIJOUI_SW, false);
        var baisyun = $gameSystem.baisyun();
        if (baisyun.isLastUseCard(1005)) {
            $gameSwitches.setValue(KIJOUI_SW, true);
        }
    });
    PluginManager.registerCommand(pluginName, 'gainBaisyunGold', function (args) {
        var gold = parseInt(args.gold);
        $gameParty.addBaisyunGold(gold);
    });
})(Nore || (Nore = {}));
var BAISYUN_FIN_SW = 81;
var BAISYUN_ACTOR_ID_OFFSET = 100;
var BaisyunManager = /** @class */ (function () {
    function BaisyunManager() {
        this._currentActorId = 0;
    }
    BaisyunManager.prototype.onBaisyunStart = function (actorId) {
        this._currentActorId = actorId;
        var actor = $gameActors.actor(actorId);
        var baisyun = actor.baisyun();
        baisyun.setFaceId(4);
        baisyun.setHoppeId(1);
        this.initRemainTurn(baisyun);
        this.initHp(baisyun);
        actor.baisyunPlayer().onBaisyunStart();
    };
    BaisyunManager.prototype.initRemainTurn = function (baisyun) {
        baisyun.setRemainTurn(2);
    };
    BaisyunManager.prototype.currentBaisyun = function () {
        if (this._currentActorId <= 0) {
            return null;
        }
        return $gameActors.actor(this._currentActorId).baisyun();
    };
    BaisyunManager.prototype.initHp = function (baisyun) {
        this.initMaxHp(baisyun);
        baisyun.setHp(baisyun.maxHp());
    };
    BaisyunManager.prototype.initMaxHp = function (baisyun) {
        var actor = $gameActors.actor(this._currentActorId);
        baisyun.setMaxHp(actor.baisyunPlayer().maxBaisyunHp());
    };
    return BaisyunManager;
}());
/**
 * 売春のたびに初期化される一時データ
 */
var Baisyun = /** @class */ (function () {
    function Baisyun(actorId) {
        this._successMap = {};
        this._failureMap = {};
        this._faceId = 0;
        this._hoppeId = 0;
        this._manId = 0;
        this._lastUseCardList = [];
        this._actorId = actorId;
        this.setup();
    }
    Baisyun.prototype.setup = function () {
        this._bokki = false;
        this._syasei = false;
        this._afterSyasei = false;
    };
    Baisyun.prototype.onBaisyun = function (result) {
        var manId = this._manId;
        this._remainTurn--;
        if (result > 0) {
            this._successMap[manId] = result;
        }
        else {
            this._failureMap[manId]++;
        }
        if (this._remainTurn == 0) {
            $gameSwitches.setValue(BAISYUN_FIN_SW, true);
        }
    };
    Baisyun.prototype.setRemainTurn = function (n) {
        this._remainTurn = n;
    };
    Baisyun.prototype.remainTurn = function () {
        return Math.max(this._remainTurn, 0);
    };
    Baisyun.prototype.isSuccess = function (manId) {
        return this._successMap[manId] > 0;
    };
    Baisyun.prototype.isFailure = function (manId) {
        return this._failureMap[manId] > 0;
    };
    Baisyun.prototype.maxHp = function () {
        return this._maxHp;
    };
    Baisyun.prototype.hp = function () {
        return this._hp;
    };
    Baisyun.prototype.setHp = function (n) {
        this._hp = n;
    };
    Baisyun.prototype.setMaxHp = function (n) {
        this._maxHp = n;
    };
    Baisyun.prototype.recoverHp = function () {
        this._hp = this.maxHp();
    };
    Baisyun.prototype.minusHp = function (n) {
        this._hp -= n;
        if (this._hp < 0) {
            this._hp = 0;
        }
        if (this._hp <= 0) {
            $gameSwitches.setValue(BAISYUN_FIN_SW, true);
        }
    };
    Baisyun.prototype.actorId = function () {
        return this._actorId;
    };
    Baisyun.prototype.faceId = function () {
        if (this._faceId > 0) {
            return this._faceId;
        }
        var sikyu = this.actor().sikyu();
        var percent = sikyu.percent();
        if (percent == 0) {
            return 1;
        }
        return 10;
    };
    Baisyun.prototype.setFaceId = function (n) {
        this._faceId = n;
    };
    Baisyun.prototype.setHoppeId = function (n) {
        this._hoppeId = n;
    };
    Baisyun.prototype.hoppeId = function () {
        if (this._hoppeId > 0) {
            return this._hoppeId;
        }
        var sikyu = this.actor().sikyu();
        var percent = sikyu.percent();
        if (percent == 0) {
            return 0;
        }
        return 1;
    };
    Baisyun.prototype.actor = function () {
        return $gameActors.actor(this.actorId());
    };
    Baisyun.prototype.onBattleEnd = function (baisyunPlayer, baisyunBattle) {
        this._faceId = 0;
        this._hoppeId = 0;
        this._hp = baisyunPlayer.hp();
        this._lastUseCardList = baisyunBattle.useCardIdList();
    };
    Baisyun.prototype.setManId = function (n) {
        this._manId = n;
    };
    Baisyun.prototype.manId = function () {
        return this._manId;
    };
    Baisyun.prototype.troopId = function () {
        return this.manId() + MAN_ID_ENEMY_OFFSET;
    };
    Baisyun.prototype.isLastUseCard = function (id) {
        return this._lastUseCardList.contains(id);
    };
    Baisyun.prototype.setBokki = function (b) {
        if (this._bokki == b) {
            return;
        }
        this._bokki = b;
        this.setDirtyTachie();
    };
    Baisyun.prototype.isBokki = function () {
        return this._bokki;
    };
    Baisyun.prototype.isDirtyTachie = function () {
        return this._dirtyTachie;
    };
    Baisyun.prototype.clearDirtyTachie = function () {
        this._dirtyTachie = false;
    };
    Baisyun.prototype.setDirtyTachie = function () {
        this._dirtyTachie = true;
    };
    Baisyun.prototype.syasei = function () {
        if (this._syasei) {
            return;
        }
        this._syasei = true;
        this.setDirtyTachie();
        this._faceId = 13;
    };
    Baisyun.prototype.endSyasei = function () {
        if (this._syasei) {
            this._syasei = false;
            this._afterSyasei = true;
            this._faceId = 5;
            this.setDirtyTachie();
        }
    };
    Baisyun.prototype.isSyasei = function () {
        return this._syasei;
    };
    Baisyun.prototype.isAfterSyasei = function () {
        return this._afterSyasei;
    };
    Baisyun.prototype.hpRate = function () {
        return this._hp / this._maxHp;
    };
    Baisyun.prototype.isBoss = function () {
        return this.enemy().meta['boss'] != null;
    };
    Baisyun.prototype.enemy = function () {
        return $dataEnemies[this.manId() + MAN_ID_ENEMY_OFFSET];
    };
    return Baisyun;
}());
var VoltageResult;
(function (VoltageResult) {
    VoltageResult[VoltageResult["D"] = 0] = "D";
    VoltageResult[VoltageResult["C"] = 1] = "C";
    VoltageResult[VoltageResult["B"] = 2] = "B";
    VoltageResult[VoltageResult["A"] = 3] = "A";
})(VoltageResult || (VoltageResult = {}));
var BaisyunBattle = /** @class */ (function () {
    function BaisyunBattle(player, enemyId, onCardUse) {
        if (onCardUse === void 0) { onCardUse = null; }
        this._endBaisyun = false;
        this._cardCountInTurn = 0;
        this._baisyunEventList = new BaisyunEventList();
        this._cardQueue = [];
        this._useCardIdList = [];
        this._player = player;
        this._onCardUse = onCardUse;
        this._enemy = new BaisyunEnemy(enemyId);
        this._remainTime = this._enemy.patience();
        this._baisyun = $gameSystem.baisyun();
        this._trashCan = new BaisyunTrashCan();
        this._stock = new BaisyunStock(this.deck(), this._trashCan, this.initialHandNum());
        this._exiledArea = new BaisyunExiledArea();
        this._turnCount = 1;
        this._cardId = 0;
        this._nama = false;
        this._useFinishCard = false;
        this.onBaisyunStart();
    }
    BaisyunBattle.prototype.initialHandNum = function () {
        return 5 + this._player.handPlus(this._turnCount) + this._enemy.handPlus();
    };
    BaisyunBattle.prototype.onBaisyunStart = function () {
        var actorId = this._player.actorId();
        this._enemy.onBaisyunStart(actorId, this._player);
    };
    BaisyunBattle.prototype.inEndTurn = function () {
        return this._inTurnEnd;
    };
    BaisyunBattle.prototype.isWaitCard = function () {
        return this._cardQueue.length > 0 || this._baisyunEventList.inEvent();
    };
    BaisyunBattle.prototype.isRunning = function () {
        return this.isWaitCard() || this.inEndTurn() || this.isTurnEndReserved();
    };
    BaisyunBattle.prototype.update = function (scene) {
        if (!this._baisyunEventList.inEvent()) {
            this.runNextEvent();
        }
        this._baisyunEventList.update(this, scene);
    };
    BaisyunBattle.prototype.isEventRunning = function () {
        if (this._baisyunEventList.inEvent()) {
            return true;
        }
        if (this._cardQueue.length > 0) {
            return true;
        }
        return false;
    };
    BaisyunBattle.prototype.runNextEvent = function () {
        if (this._cardQueue.length == 0) {
            $gameTemp.setBaisyunQueueCard(false);
            if (this.isTurnEndReserved()) {
                if (!this.inEndTurn()) {
                    this.endTurn();
                }
            }
            return;
        }
        var card = this._cardQueue.shift();
        if (card.canUse(this)) {
            this.useCard(card);
            if (this._onCardUse) {
                this._onCardUse.call(this);
            }
        }
    };
    BaisyunBattle.prototype.nextTurn = function () {
        if (this._player.isDead()) {
            this.endBaisyun();
            return;
        }
        this._enemy.onEnemyTurnEnd();
        this.onTurnStart();
    };
    BaisyunBattle.prototype.onTurnStart = function () {
        if (!this.isFinished() && !this.isTimeOver()) {
            this._inTurnEnd = false;
            this._lastTrashNum = this._trashCan.num();
            this._player.onTurnStart(this._turnCount, this._enemy);
            this._isShuffled = this._hand.fill(this._stock, this._player, this.initialHandNum(), this._turnCount);
            this.recoverMana();
            if (this._isShuffled) {
                this.startShuffle();
                this.gainShuffleMana();
            }
            this._hand.onTurnStart();
            this._enemy.onTurnStart();
            this.onTurnStartCostDown();
            this.addTurnStartCard();
        }
        this._cardCountInTurn = 0;
    };
    BaisyunBattle.prototype.addTurnStartCard = function () {
        var addCardId = this._player.stateAddCardId();
        if (addCardId == 0) {
            return true;
        }
        var addCardNum = 1;
        var hand = this.hand();
        for (var i = 0; i < addCardNum; i++) {
            hand.addCardId(this.actorId(), addCardId, this._player);
        }
    };
    BaisyunBattle.prototype.onTurnStartCostDown = function () {
        if (!this._player.hasState(BaisyunStateType.eroBook)) {
            return;
        }
        var list = this._hand.cardListCostOver0();
        if (list.length == 0) {
            return;
        }
        var dice = Math.randomInt(list.length);
        var card = list[dice];
        card.plusCostDown(1);
    };
    BaisyunBattle.prototype.startShuffle = function () {
        this._hand.startCardAnime();
    };
    BaisyunBattle.prototype.gainShuffleMana = function () {
        var manaPlus = this._player.shuffleMana();
        if (manaPlus > 0) {
            this.gainMana(manaPlus);
        }
    };
    BaisyunBattle.prototype.isShuffled = function () {
        return this._isShuffled;
    };
    BaisyunBattle.prototype.endShuffle = function () {
        this._isShuffled = false;
    };
    BaisyunBattle.prototype.recoverMana = function () {
        this._mana = this.maxMana();
    };
    BaisyunBattle.prototype.hand = function () {
        return this._hand;
    };
    BaisyunBattle.prototype.onGameStart = function () {
        this._hand = new BaisyunHand();
        this.deck().onGameStart(this);
        this._stock.shuffle(this.deck(), true);
        this._gameStart = true;
        this._anyWindowVisible = false;
    };
    BaisyunBattle.prototype.nextCardId = function () {
        this._cardId++;
        return this._cardId;
    };
    BaisyunBattle.prototype.setAnyWindowVisible = function (b) {
        this._anyWindowVisible = b;
    };
    BaisyunBattle.prototype.deck = function () {
        return this._player.deck();
    };
    BaisyunBattle.prototype.enemy = function () {
        return this._enemy;
    };
    BaisyunBattle.prototype.addUseCardQueue = function (card) {
        /*if (this._cardQueue.length > 3) {
            return false;
        }*/
        if (this._cardQueue.contains(card)) {
            return false;
        }
        if (this._baisyunEventList.inEvent()) {
            $gameTemp.setBaisyunQueueCard(true);
        }
        this._cardQueue.push(card);
        return true;
    };
    BaisyunBattle.prototype.useCard = function (card) {
        $gameTemp.setBaisyunFastCard(card.isFastCard());
        this._hand.removeCard(card);
        this._baisyunEventList.useCard(card);
    };
    BaisyunBattle.prototype.executeCard = function (card, doubleAttack) {
        this._useCardIdList.push(card.skillId());
        this.executeAttack(card);
        this.executeExcitement(card, doubleAttack);
        this.executeFinish(card);
        this.executeLoseHp(card);
        this.executeSelfDamage(card);
        this.executeDrawCard(card);
        this.executeDrawSyaseiCard(card);
        this.executeDrawFinishCard(card);
        this.executeGainMana(card);
        this.executeSyaseiOrBokki(card);
        this.executeGainShield(card);
        this.executeAddStateList(card);
        this.executeAddCard(card);
        this.executeDiscard(card, doubleAttack);
        this.executeIncrementCardCountInTurn(card, doubleAttack);
    };
    BaisyunBattle.prototype.executeAddCard = function (card) {
        var addCardId = card.addCardId();
        if (addCardId == 0) {
            return true;
        }
        var addCardNum = card.addCardNum();
        var hand = this.hand();
        for (var i = 0; i < addCardNum; i++) {
            hand.addCardId(this.actorId(), addCardId, this._player);
        }
    };
    BaisyunBattle.prototype.executeIncrementCardCountInTurn = function (card, doubleAttack) {
        if (doubleAttack) {
            return;
        }
        this._cardCountInTurn++;
    };
    BaisyunBattle.prototype.executeAttack = function (card) {
        if (!card.isAttack()) {
            return;
        }
        var damage = this.calcDamage(card);
        this.enemy().plusVoltage(damage);
    };
    BaisyunBattle.prototype.executeFinish = function (card) {
        if (!card.isFinish()) {
            return;
        }
        if (!this.canFinish()) {
            if (!this.player().hasState(BaisyunStateType.notFinish)) {
                this._enemy.minusState(BaisyunStateType.nenchakushitsu, 1);
            }
            return;
        }
        this._useFinishCard = true;
        this.endBaisyun();
    };
    BaisyunBattle.prototype.canFinish = function () {
        if (this._player.hasState(BaisyunStateType.notFinish)) {
            return false;
        }
        if (this._enemy.isBlockFinish()) {
            return false;
        }
        return true;
    };
    BaisyunBattle.prototype.executeLoseHp = function (card) {
        if (card.loseHp() > 0) {
            this._player.loseHp(card.loseHp());
            if (this._player.isDead()) {
                this.endBaisyun();
            }
        }
    };
    BaisyunBattle.prototype.executeSelfDamage = function (card) {
        if (card.selfDamage() > 0) {
            this._player.selfDamage(card.selfDamage());
            if (this._player.isDead()) {
                this.endBaisyun();
            }
        }
    };
    BaisyunBattle.prototype.executeDiscardAll = function (card) {
        if (card.discardAll() > 0) {
            this._hand.discardAll(this._trashCan, this._exiledArea);
            /*for (const c of this._hand.cardList()) {
                this.executeDiscard(c, false);
            }*/
        }
    };
    BaisyunBattle.prototype.executeDrawCard = function (card) {
        if (card.drawCardNum() > 0) {
            p(card.drawCardNum());
            this.drawCard(card.drawCardNum());
        }
    };
    BaisyunBattle.prototype.executeDrawFinishCard = function (card) {
        if (card.isDrawFinishCard() > 0) {
            this.drawFinishCard();
        }
    };
    BaisyunBattle.prototype.executeDrawSyaseiCard = function (card) {
        if (card.drawSyaseiCard() > 0) {
            this.drawSyaseiCard();
        }
    };
    BaisyunBattle.prototype.executeGainMana = function (card) {
        if (card.gainMana() > 0) {
            this.gainMana(card.gainMana());
        }
    };
    BaisyunBattle.prototype.executeSyaseiOrBokki = function (card) {
        if (card.isSyasei() && this._player.canSyasei()) {
            this._player.syasei();
            this._baisyun.setBokki(false);
            if (this._player.hasState(BaisyunStateType.postNutClarity)) {
                var n = this._player.stateValue(BaisyunStateType.postNutClarity);
                this._player.gainShield(n);
            }
        }
        else if (card.isBokki()) {
            if (card.heiseiBokki() > 0 && this._player.isHeisei()) {
                this._player.addBokki(card.heiseiBokki());
            }
            this._player.addBokki(card.bokki());
            if (this._player.canSyasei()) {
                this._baisyun.setBokki(true);
            }
        }
    };
    BaisyunBattle.prototype.executeGainShield = function (card) {
        var info = this.calcShieldInfo(card);
        if (info.shield() > 0) {
            this._player.gainShield(info.shield());
        }
        if (this._player.hasState(BaisyunStateType.calm)) {
            var n = this._player.stateValue(BaisyunStateType.calm);
            this._player.gainShield(n);
        }
    };
    BaisyunBattle.prototype.calcShieldInfo = function (card) {
        var value = card.shield();
        var result = new ShieldInfo(value);
        if (!$gameParty.inBattle()) {
            return result;
        }
        var player = this._player;
        result.setHalfDef(player.isHalfDef());
        var plus = 0;
        if (card.isHeisei() && player.bokki() == 0) {
            plus += card.heiseiShield();
        }
        if (card.defPlusByAttackCard() > 0) {
            var count = this.hand().countCard(CardType.attack);
            plus += count * card.defPlusByAttackCard();
        }
        if (card.trashShieldPlus() > 0) {
            plus += this.trashCan().num() * card.trashShieldPlus();
        }
        plus += card.masekiShield();
        value += plus;
        if (result.halfDef()) {
            // 脆弱は３３％ダウンにした
            value = Math.floor((value + plus) * 0.67);
        }
        result.setPlus(plus);
        result.setShield(value);
        return result;
    };
    BaisyunBattle.prototype.executeDiscard = function (card, doubleAttack) {
        if (doubleAttack) {
            return;
        }
        if (card.isExhaust()) {
            this._exiledArea.addCard(card);
        }
        else if (card.isTemporary()) {
        }
        else {
            this._trashCan.addCard(card);
        }
    };
    BaisyunBattle.prototype.executeExcitement = function (card, doubleAttack) {
        if (doubleAttack) {
            return;
        }
        if (this._player.hasState(BaisyunStateType.excitement)) {
            var damage = this._player.stateValue(BaisyunStateType.excitement);
            this.enemy().plusVoltage(damage);
        }
    };
    BaisyunBattle.prototype.executeDiscardEffect = function (card) {
        if (card.discardEffectCardId() == 0) {
            return;
        }
        var effectCard = new BaisyunCard(this.actorId(), card.discardEffectCardId());
        this.executeCard(effectCard, false);
    };
    BaisyunBattle.prototype.executeDisturbanceDamage = function () {
        var actionList = this.disturbanceActions();
        for (var _i = 0, actionList_1 = actionList; _i < actionList_1.length; _i++) {
            var action = actionList_1[_i];
            this.executeAction(action);
        }
    };
    BaisyunBattle.prototype.disturbanceActions = function () {
        var actionList = [];
        var enemy = this.enemy().gameEnemy();
        for (var _i = 0, _a = this._hand.cardList(); _i < _a.length; _i++) {
            var c = _a[_i];
            if (c.cardType() == CardType.disturbance) {
                if (c.damageSkillId() > 0) {
                    var action = new Game_Action2(enemy);
                    action.setSkill(c.damageSkillId());
                    actionList.push(action);
                }
            }
        }
        return actionList;
    };
    BaisyunBattle.prototype.cardCountInTurn = function () {
        return this._cardCountInTurn;
    };
    BaisyunBattle.prototype.calcDamage = function (card) {
        var d = card.damageValue();
        if (card.isFixDamage()) {
            return d;
        }
        var damage = d + this.calcDamagePlus(card, d);
        return damage;
    };
    BaisyunBattle.prototype.calcDamagePlus = function (card, value) {
        var plus = card.masekiVoltage();
        if (card.nudeAtkUp() > 0) {
            plus = this._player.takeOffCount() * card.nudeAtkUp();
        }
        if (this.isOpenerEffective()) {
            plus += card.openerDamage();
        }
        if (card.isSyasei() && this._player.canSyasei()) {
            plus += card.syaseiVoltage();
        }
        if (this._enemy.hasState(BaisyunStateType.ganko)) {
            plus -= this._enemy.stateValue(BaisyunStateType.ganko);
        }
        if (card.useCardAtkUp() > 0) {
            plus += card.useCardAtkUp() * this._cardCountInTurn;
        }
        if (card.isShowCrotch()) {
            plus += this._player.stateValue(BaisyunStateType.miwaku);
        }
        plus += this._player.atkPlus();
        plus += this._player.bokki() * 2;
        if (card.cardNumVoltage() > 0) {
            plus += this.cardCountWithoutCard(card) * card.cardNumVoltage();
        }
        if (this._player.hasState(BaisyunStateType.atkDownPlayer)) {
            plus -= this._player.stateValue(BaisyunStateType.atkDownPlayer);
        }
        /*if (this._player.hasState(BaisyunStateType.kaikyaku)) {
            plus += KAIKYAKU_VOLTAGE_PLUS;
        }*/
        if (this._enemy.hasState(BaisyunStateType.defDownEnemy)) {
            plus += this._enemy.stateValue(BaisyunStateType.defDownEnemy);
        }
        // 弱体、誘惑は最後に乗算
        if (this._player.hasState(BaisyunStateType.weakness)) {
            if (!this._enemy.hasState(BaisyunStateType.yuuwaku)) {
                plus -= Math.floor((value + plus) * 0.25);
            }
        }
        else if (this._enemy.hasState(BaisyunStateType.yuuwaku)) {
            plus += Math.floor((value + plus) * 0.25);
        }
        return plus;
    };
    BaisyunBattle.prototype.cardCountWithoutCard = function (card) {
        var n = 0;
        for (var _i = 0, _a = this.hand().cardList(); _i < _a.length; _i++) {
            var c = _a[_i];
            if (c == card) {
                continue;
            }
            n++;
        }
        return n;
    };
    BaisyunBattle.prototype.isOpenerEffective = function () {
        return this.cardCountInTurn() == 0;
    };
    BaisyunBattle.prototype.executeCardBeforeCostume = function (card) {
        var success = false;
        success || (success = this.executeCardBeforeCostumeOuterTop(card));
        success || (success = this.executeCardBeforeCostumeInnerTop(card));
        success || (success = this.executeCardBeforeCostumeOuterBottom(card));
        success || (success = this.executeCardBeforeCostumeInnerBottom(card));
        return success;
    };
    BaisyunBattle.prototype.executeCardBeforeCostumeOuterTop = function (card) {
        if (card.isTakeOffTop()) {
            if (this._player.isTakeOffTop()) {
                this._player.actor().clearTakeOffTop();
                return true;
            }
        }
        return false;
    };
    BaisyunBattle.prototype.executeCardBeforeCostumeInnerTop = function (card) {
        if (card.isTakeOffInnerTop()) {
            if (this._player.isTakeOffInnerTop()) {
                this._player.actor().clearTakeOffInnerTop();
                return true;
            }
        }
        return false;
    };
    BaisyunBattle.prototype.executeCardBeforeCostumeOuterBottom = function (card) {
        if (card.isTakeOffBottom()) {
            if (this._player.isTakeOffBottom()) {
                this._player.actor().clearTakeOffBottom();
                return true;
            }
        }
        return false;
    };
    BaisyunBattle.prototype.executeCardBeforeCostumeInnerBottom = function (card) {
        if (card.isTakeOffInnerBottom()) {
            if (this._player.isTakeOffInnerBottom()) {
                this._player.actor().clearTakeOffInnerBottom();
                return true;
            }
        }
        return false;
    };
    BaisyunBattle.prototype.executeCardCostume = function (card) {
        var changed = false;
        if (this.executeCardCostumeOuterTop(card)) {
            changed = true;
        }
        if (this.executeCardCostumeOuterBottom(card)) {
            changed = true;
        }
        if (this.executeCardCostumeInnerTop(card)) {
            changed = true;
        }
        if (this.executeCardCostumeInnerBottom(card)) {
            changed = true;
        }
        if (card.poseId() > 0) {
            this._player.setPoseId(card.poseId());
        }
        return changed;
    };
    BaisyunBattle.prototype.executeCardCostumeOuterTop = function (card) {
        if (!card.isTakeOffTop()) {
            return false;
        }
        this._player.actor().takeOffTop();
        this.playTakeOffSe();
        return true;
    };
    BaisyunBattle.prototype.executeCardCostumeOuterBottom = function (card) {
        if (!card.isTakeOffBottom()) {
            return false;
        }
        this._player.actor().takeOffBottom();
        this.playTakeOffSe();
        return true;
    };
    BaisyunBattle.prototype.executeCardCostumeInnerTop = function (card) {
        if (!card.isTakeOffInnerTop()) {
            return false;
        }
        this._player.actor().takeOffInnerTop();
        this.playTakeOffSe();
        return true;
    };
    BaisyunBattle.prototype.executeCardCostumeInnerBottom = function (card) {
        if (!card.isTakeOffInnerBottom()) {
            return false;
        }
        this._player.actor().takeOffInnerBottom();
        this.playTakeOffSe();
        return true;
    };
    BaisyunBattle.prototype.executeCardCostumeState = function (card) {
        if (card.isTakeOffTop()) {
            this._player.takeOffTop(card.takeOffTopCount());
        }
        if (card.isTakeOffBottom()) {
            this._player.takeOffBottom(card.takeOffBottomCount());
        }
        if (card.isTakeOffInnerTop()) {
            this._player.takeOffInnerTop(card.takeOffInnerTopCount());
        }
        if (card.isTakeOffInnerBottom()) {
            this._player.takeOffInnerBottom(card.takeOffInnerBottomCount());
        }
    };
    BaisyunBattle.prototype.playTakeOffSe = function () {
        AudioManager.playSe({ name: 'Equip2', volume: 90, pitch: 100, pan: 0 });
    };
    BaisyunBattle.prototype.executeAddStateList = function (card) {
        var selfStateList = card.selfStateList();
        this._player.addStateList(selfStateList);
        var enemyStateList = card.enemyStateList();
        this._enemy.addStateList(enemyStateList);
    };
    BaisyunBattle.prototype.remainTime = function () {
        return this._remainTime;
    };
    BaisyunBattle.prototype.consumeCost = function (card) {
        this.consumeTime(card);
        this.consumeMana(card);
    };
    BaisyunBattle.prototype.consumeTime = function (card) {
        this._remainTime -= card.timeCost();
    };
    BaisyunBattle.prototype.consumeMana = function (card) {
        this._mana -= card.manaCost(this);
    };
    BaisyunBattle.prototype.gainMana = function (n) {
        this._mana += n;
    };
    BaisyunBattle.prototype.drawCard = function (num) {
        this._hand.drawCard(num, this._stock, this._player);
    };
    BaisyunBattle.prototype.drawSyaseiCard = function () {
        this._hand.drawSyaseiCard(1, this._stock);
    };
    BaisyunBattle.prototype.drawFinishCard = function () {
        this._hand.drawCardType(1, this._stock, CardType.finish);
    };
    BaisyunBattle.prototype.isFinished = function () {
        if (this.isTimeOver()) {
            if (!this._baisyunEventList.isActive()) {
                return true;
            }
        }
        if (this._endBaisyun) {
            return true;
        }
        if (this._enemy.isMaxRank(this._player)) {
            return true;
        }
        return false;
    };
    BaisyunBattle.prototype.isTimeOver = function () {
        return this._remainTime <= 0;
    };
    BaisyunBattle.prototype.endBaisyun = function () {
        this._endBaisyun = true;
    };
    BaisyunBattle.prototype.isPlayerTurn = function () {
        return !this._inTurnEnd && this._gameStart;
    };
    BaisyunBattle.prototype.isButtonActive = function () {
        return !this._inTurnEnd && this._gameStart && !this._anyWindowVisible;
    };
    BaisyunBattle.prototype.onFirstScenarioFinish = function () {
        this._gameStart = true;
    };
    BaisyunBattle.prototype.onFirstScenarioStarted = function () {
        this._gameStart = false;
    };
    BaisyunBattle.prototype.endTurn = function () {
        $gameTemp.setBaisyunFastCard(false);
        if (this.isFinished()) {
            return;
        }
        this._reserveTurnEnd = false;
        this._inTurnEnd = true;
        this._remainTime--;
        this._turnCount++;
        this._baisyunEventList.enemyAction(this);
        this._hand.onTurnEnd(this._trashCan);
        this._player.onTurnEnd();
        this._enemy.onPlayerTurnEnd();
    };
    BaisyunBattle.prototype.executeForecast = function (card) {
        if (card) {
            this.executeCard(card, false);
        }
        var enemy = this.enemy();
        var action = enemy.action();
        this.executeAction(action);
    };
    BaisyunBattle.prototype.turnCount = function () {
        return this._turnCount;
    };
    BaisyunBattle.prototype.baisyunEventList = function () {
        return this._baisyunEventList;
    };
    BaisyunBattle.prototype.voltageResult = function () {
        if (this._player.isDead()) {
            return VoltageResult.D;
        }
        if (this._enemy.isNamaOnlyFail(this._player)) {
            return VoltageResult.D;
        }
        if (this._enemy.isBoss()) {
            switch (this._enemy.voltageRank()) {
                case VoltageRank.D: return VoltageResult.D;
                case VoltageRank.C:
                case VoltageRank.B:
                case VoltageRank.A:
                    // ボスは大成功
                    return VoltageResult.A;
                default:
                    console.error('不正な voltageResult です');
                    return VoltageResult.D;
            }
        }
        switch (this._enemy.voltageRank()) {
            case VoltageRank.D: return VoltageResult.D;
            case VoltageRank.C: return VoltageResult.C;
            case VoltageRank.B: return VoltageResult.B;
            case VoltageRank.A: return VoltageResult.A;
            default:
                console.error('不正な voltageResult です');
                return VoltageResult.D;
        }
    };
    BaisyunBattle.prototype.voltageDamageRate = function (rank) {
        return this._enemy.voltageDamageRate(rank);
    };
    BaisyunBattle.prototype.actorId = function () {
        return this._player.actorId();
    };
    BaisyunBattle.prototype.actor = function () {
        return this._player.actor();
    };
    BaisyunBattle.prototype.setBaisyunTalk = function (talk) {
        this._talk = talk;
    };
    BaisyunBattle.prototype.baisyunTalk = function () {
        return this._talk;
    };
    BaisyunBattle.prototype.setBaisyunManTalk = function (talk) {
        this._manTalk = talk;
    };
    BaisyunBattle.prototype.baisyunManTalk = function () {
        return this._manTalk;
    };
    BaisyunBattle.prototype.startAnime = function (animeId, toEnemy) {
        if (toEnemy) {
            $gameTemp.requestAnimation([this._enemy.gameEnemy()], animeId, false);
        }
        else {
            $gameTemp.requestAnimation([this._player], animeId, false);
        }
    };
    BaisyunBattle.prototype.player = function () {
        return this._player;
    };
    BaisyunBattle.prototype.executeAction = function (action) {
        var damage = this.forecastEnemyDamage(action);
        if (damage > 0) {
            this._player.damage(damage, this._enemy);
        }
        this.addStates(action);
        if (this._player.hp() <= 0) {
            if (!this._player.isClone()) {
                this._player.actor().playDamageVoice();
                this.baisyun().setFaceId(13);
            }
        }
    };
    BaisyunBattle.prototype.forecastEnemyDamage = function (action) {
        var damage = this.makeEnemyDamage(action);
        if (damage <= 0) {
            return 0;
        }
        if (action.item().meta['fixDamage']) {
            return damage;
        }
        var bokkiDamage = this._player.bokki() * 2;
        var atkDown = this._enemy.atkDown();
        var weakness = this._enemy.isWeakness();
        var reduceDamage = this._player.reduceDamage();
        var rate = weakness ? 0.75 : 1;
        var stateDamage = this._player.stateDamage();
        var finalDamage = Math.floor(Math.max(damage + bokkiDamage - atkDown - reduceDamage, 0) * rate) + stateDamage;
        return finalDamage;
    };
    BaisyunBattle.prototype.makeEnemyDamage = function (action) {
        if (!action.isDamage()) {
            return 0;
        }
        return action.makeDamageValue(this._player.actor(), false);
    };
    BaisyunBattle.prototype.addStates = function (action) {
        var effects = action.item().effects;
        for (var _i = 0, effects_1 = effects; _i < effects_1.length; _i++) {
            var e = effects_1[_i];
            switch (e.code) {
                case 21:
                    this.addState(e.dataId, (e.value1 * 100) - 100, action.isForUser());
                    break;
            }
        }
    };
    BaisyunBattle.prototype.addState = function (stateId, value, forEnemy) {
        var s = new BaisyunState(stateId, value);
        if (forEnemy) {
            this._enemy.addStateList([s]);
        }
        else {
            this._player.addStateList([s]);
        }
    };
    BaisyunBattle.prototype.baisyun = function () {
        return this._baisyun;
    };
    BaisyunBattle.prototype.stock = function () {
        return this._stock;
    };
    BaisyunBattle.prototype.trashCan = function () {
        return this._trashCan;
    };
    BaisyunBattle.prototype.maxMana = function () {
        return 3 + this._player.maxManaPlus(this._turnCount) + this._enemy.maxManaPlus();
    };
    BaisyunBattle.prototype.mana = function () {
        return this._mana;
    };
    BaisyunBattle.prototype.showInfo = function () {
        this._showInfo = true;
    };
    BaisyunBattle.prototype.hideInfo = function () {
        this._showInfo = false;
    };
    BaisyunBattle.prototype.isShowInfo = function () {
        return this._showInfo;
    };
    BaisyunBattle.prototype.useCardIdList = function () {
        return this._useCardIdList;
    };
    BaisyunBattle.prototype.drawSelectedCard = function (card) {
        this._hand.drawSelectedCard(card, this._stock);
    };
    BaisyunBattle.prototype.setNama = function () {
        this._nama = true;
    };
    BaisyunBattle.prototype.isNama = function () {
        return this._nama;
    };
    BaisyunBattle.prototype.isUseFinishCard = function () {
        return this._useFinishCard;
    };
    BaisyunBattle.prototype.lastTrashNum = function () {
        return this._lastTrashNum;
    };
    BaisyunBattle.prototype.reserveTurnEnd = function () {
        this._reserveTurnEnd = true;
    };
    BaisyunBattle.prototype.isTurnEndReserved = function () {
        return this._reserveTurnEnd;
    };
    BaisyunBattle.prototype.setDiscardSelect = function (b) {
        this._inDiscardSelect = b;
        if (b) {
            this._cardQueue = [];
        }
    };
    BaisyunBattle.prototype.inDiscardSelect = function () {
        return this._inDiscardSelect;
    };
    BaisyunBattle.prototype.rewardUp = function () {
        return this._player.stateValue(BaisyunStateType.rewardup);
    };
    return BaisyunBattle;
}());
var VoltageRank;
(function (VoltageRank) {
    VoltageRank["D"] = "D";
    VoltageRank["C"] = "C";
    VoltageRank["B"] = "B";
    VoltageRank["A"] = "A";
    VoltageRank["S"] = "S";
})(VoltageRank || (VoltageRank = {}));
var BaisyunStock = /** @class */ (function () {
    function BaisyunStock(deck, trashCan, maxHand) {
        this._cardList = [];
        this._deck = deck;
        this._trashCan = trashCan;
        this._maxHand = maxHand;
    }
    BaisyunStock.prototype.addDisturbanceCardList = function (cardList) {
        for (var _i = 0, cardList_1 = cardList; _i < cardList_1.length; _i++) {
            var card = cardList_1[_i];
            var dice = Math.randomInt(this._cardList.length);
            this._cardList.splice(dice, 0, card);
        }
    };
    BaisyunStock.prototype.shuffle = function (deck, isFirstTurn) {
        this._cardList = deck.cardList().concat();
        this._cardList = Nore.shuffle(this._cardList);
        if (isFirstTurn) {
            this.setupFirstTurn();
        }
    };
    BaisyunStock.prototype.setupFirstTurn = function () {
        this.setupTenpu();
        this.setupChien();
    };
    BaisyunStock.prototype.setupTenpu = function () {
        var tenpuList = [];
        for (var _i = 0, _a = this._cardList; _i < _a.length; _i++) {
            var c = _a[_i];
            if (c.isTenpu()) {
                tenpuList.push(c);
            }
        }
        for (var _b = 0, tenpuList_1 = tenpuList; _b < tenpuList_1.length; _b++) {
            var c = tenpuList_1[_b];
            this._cardList.remove(c);
        }
        for (var _c = 0, tenpuList_2 = tenpuList; _c < tenpuList_2.length; _c++) {
            var c = tenpuList_2[_c];
            this._cardList.unshift(c);
        }
    };
    BaisyunStock.prototype.setupChien = function () {
        var chienList = [];
        for (var _i = 0, _a = this._cardList; _i < _a.length; _i++) {
            var c = _a[_i];
            if (c.isChien()) {
                chienList.push(c);
            }
        }
        for (var _b = 0, chienList_1 = chienList; _b < chienList_1.length; _b++) {
            var c = chienList_1[_b];
            this._cardList.remove(c);
            var newIndex = Math.randomInt(MAX_DECK_NUM - 1 - this._maxHand) + this._maxHand;
            this._cardList.splice(newIndex, 0, c);
        }
    };
    BaisyunStock.prototype.next = function () {
        if (this.isEmpty()) {
            console.error('カードが存在しません');
            return;
        }
        return this._cardList.shift();
    };
    BaisyunStock.prototype.nextCardType = function (type) {
        var card = this.findCardType(type);
        if (!card) {
            return null;
        }
        this._cardList.remove(card);
        return card;
    };
    BaisyunStock.prototype.nextSyaseiCard = function () {
        var card = this.findSyaseiCard();
        if (!card) {
            return null;
        }
        this._cardList.remove(card);
        return card;
    };
    BaisyunStock.prototype.findSyaseiCard = function () {
        for (var _i = 0, _a = this._cardList; _i < _a.length; _i++) {
            var card = _a[_i];
            // フィニッシュカード以外を優先
            if (card.isSyasei() && !card.isFinish()) {
                return card;
            }
        }
        for (var _b = 0, _c = this._cardList; _b < _c.length; _b++) {
            var card = _c[_b];
            if (card.isSyasei()) {
                return card;
            }
        }
        return null;
    };
    BaisyunStock.prototype.findCardType = function (type) {
        for (var _i = 0, _a = this._cardList; _i < _a.length; _i++) {
            var card = _a[_i];
            if (card.cardType() == type) {
                return card;
            }
        }
        return null;
    };
    BaisyunStock.prototype.isEmpty = function () {
        return this._cardList.length == 0;
    };
    BaisyunStock.prototype.fill = function () {
        var trashList = this._trashCan.cardList();
        var addList = Nore.shuffle(trashList);
        for (var _i = 0, addList_1 = addList; _i < addList_1.length; _i++) {
            var card = addList_1[_i];
            this._cardList.push(card);
        }
        this._trashCan.clear();
    };
    BaisyunStock.prototype.remain = function () {
        return this._cardList.length;
    };
    BaisyunStock.prototype.cardList = function () {
        return this._cardList.concat();
    };
    BaisyunStock.prototype.reduceCard = function (card) {
        var index = -1;
        for (var i = 0; i < this._cardList.length; i++) {
            var c = this._cardList[i];
            if (c.skillId() == card.skillId()) {
                index = i;
                break;
            }
        }
        if (index < 0) {
            console.error('カードが山札に存在しません:' + card.skillId());
        }
        this._cardList.splice(index, 1);
    };
    BaisyunStock.prototype.randomCardList = function (num) {
        var result = [];
        var list = Nore.shuffle(this._cardList);
        for (var i = 0; i < num; i++) {
            if (list.length == 0) {
                console.error('山札が０になりました');
                break;
            }
            result.push(list.shift());
        }
        return result;
    };
    return BaisyunStock;
}());
var BaisyunHand = /** @class */ (function () {
    function BaisyunHand() {
        this._cardList = [];
        this._newCardId = 1000;
    }
    BaisyunHand.prototype.clear = function () {
        this._cardList = [];
        this._dirty = true;
        this._refreshAll = true;
    };
    BaisyunHand.prototype.fill = function (stock, player, initialHandNum, turnCount) {
        var isShuffled = false;
        for (var i = 0; i < initialHandNum; i++) {
            if (stock.isEmpty()) {
                stock.fill();
                isShuffled = true;
            }
            this.addCard(stock.next(), player);
        }
        this.insertRecilCard(player, turnCount);
        if (!isShuffled) {
            this._dirty = true;
        }
        return isShuffled;
    };
    BaisyunHand.prototype.insertRecilCard = function (player, turnCount) {
        if (turnCount != 1) {
            return;
        }
        var list = player.initialCardList();
        for (var _i = 0, list_2 = list; _i < list_2.length; _i++) {
            var card = list_2[_i];
            this._cardList.unshift(card);
        }
    };
    BaisyunHand.prototype.cardList = function () {
        return this._cardList.concat();
    };
    BaisyunHand.prototype.onTurnStart = function () {
        this._inTurnEnd = false;
        this._refreshAll = true;
    };
    BaisyunHand.prototype.onTurnEnd = function (trashCan) {
        this.addToTrashCan(trashCan);
        this.clearWithoutRetainCard();
        this._inTurnEnd = true;
    };
    BaisyunHand.prototype.discardAll = function (trashCan, exiledArea) {
        for (var _i = 0, _a = this.cardList(); _i < _a.length; _i++) {
            var c = _a[_i];
            if (c.isTemporary()) {
                exiledArea.addCard(c);
                continue;
            }
            if (c.isExhaust()) {
                continue;
            }
            trashCan.addCard(c);
        }
        this.clear();
    };
    BaisyunHand.prototype.inTurnEnd = function () {
        return this._inTurnEnd;
    };
    BaisyunHand.prototype.isRefreshAll = function () {
        return this._refreshAll;
    };
    BaisyunHand.prototype.gameEnd = function () {
        this._inGameEnd = true;
    };
    BaisyunHand.prototype.inGameEnd = function () {
        return this._inGameEnd;
    };
    BaisyunHand.prototype.refreshAll = function () {
        this._dirty = true;
        this._refreshAll = true;
    };
    BaisyunHand.prototype.isOtherButtonSelected = function () {
        return this._otherButtonSelected;
    };
    BaisyunHand.prototype.setOtherButtonSelected = function (b) {
        this._otherButtonSelected = b;
    };
    BaisyunHand.prototype.addToTrashCan = function (trashCan) {
        for (var _i = 0, _a = this.cardList(); _i < _a.length; _i++) {
            var c = _a[_i];
            if (c.isTemporary()) {
                continue;
            }
            if (c.isRetain()) {
                continue;
            }
            trashCan.addCard(c);
        }
    };
    BaisyunHand.prototype.clearWithoutRetainCard = function () {
        var retainList = [];
        for (var _i = 0, _a = this.cardList(); _i < _a.length; _i++) {
            var c = _a[_i];
            if (c.isRetain()) {
                retainList.push(c);
                c.onRetain();
            }
        }
        this.clear();
        this._cardList = retainList;
    };
    BaisyunHand.prototype.removeCard = function (card) {
        var index = -1;
        for (var i = 0; i < this._cardList.length; i++) {
            var c = this._cardList[i];
            if (c.id() == card.id()) {
                index = i;
                break;
            }
        }
        if (index >= 0) {
            this._cardList.splice(index, 1);
            this._dirty = true;
            return true;
        }
        console.error('カードを削除できませんでした');
        console.error(card);
        return false;
    };
    BaisyunHand.prototype.isDirty = function () {
        return this._dirty;
    };
    BaisyunHand.prototype.setDirty = function () {
        this._dirty = true;
    };
    BaisyunHand.prototype.clearDirty = function () {
        this._dirty = false;
        this._refreshAll = false;
    };
    BaisyunHand.prototype.onUseCard = function (card) {
        this._usedCard = card;
    };
    BaisyunHand.prototype.isCardUsed = function () {
        return this._usedCard != null;
    };
    BaisyunHand.prototype.usedCard = function () {
        return this._usedCard;
    };
    BaisyunHand.prototype.clearCardUsed = function () {
        this._usedCard = null;
    };
    BaisyunHand.prototype.startCardAnime = function () {
        this._inCardAnime = true;
    };
    BaisyunHand.prototype.endCardAnime = function () {
        this._inCardAnime = false;
    };
    BaisyunHand.prototype.isCardAnime = function () {
        return this._inCardAnime;
    };
    BaisyunHand.prototype.contains = function (card) {
        for (var _i = 0, _a = this._cardList; _i < _a.length; _i++) {
            var c = _a[_i];
            if (c.id() == card.id()) {
                return true;
            }
        }
        return false;
    };
    BaisyunHand.prototype.drawCard = function (num, stock, player) {
        for (var i = 0; i < num; i++) {
            if (stock.isEmpty()) {
                stock.fill();
            }
            var card = stock.next();
            card.setDrawn();
            this.addCard(card, player);
        }
        this._dirty = true;
    };
    BaisyunHand.prototype.drawSelectedCard = function (card, stock) {
        stock.reduceCard(card);
        card.setDrawn();
        this._cardList.push(card);
    };
    BaisyunHand.prototype.addCardId = function (actorId, skillId, player) {
        if (this.isFullHand()) {
            return;
        }
        var card = new BaisyunCard(actorId, skillId);
        card.setId(this._newCardId++);
        this.addCard(card, player);
    };
    BaisyunHand.prototype.addCard = function (card, player) {
        player.onDrawCard(card);
        this._cardList.push(card);
        this._dirty = true;
    };
    BaisyunHand.prototype.drawCardType = function (num, stock, type) {
        this._dirty = true;
        for (var i = 0; i < num; i++) {
            if (stock.isEmpty()) {
                return;
            }
            var card = stock.nextCardType(type);
            if (!card) {
                return;
            }
            this._cardList.push(card);
        }
    };
    BaisyunHand.prototype.drawSyaseiCard = function (num, stock) {
        this._dirty = true;
        for (var i = 0; i < num; i++) {
            if (stock.isEmpty()) {
                return;
            }
            var card = stock.nextSyaseiCard();
            if (!card) {
                return;
            }
            this._cardList.push(card);
        }
    };
    BaisyunHand.prototype.isFullHand = function () {
        if (this._cardList.length >= this.maxNum()) {
            return true;
        }
        return false;
    };
    BaisyunHand.prototype.maxNum = function () {
        return 10;
    };
    BaisyunHand.prototype.isEmpty = function () {
        return this._cardList.length == 0;
    };
    BaisyunHand.prototype.countCard = function (type, ignoreCard) {
        if (ignoreCard === void 0) { ignoreCard = null; }
        var n = 0;
        for (var _i = 0, _a = this._cardList; _i < _a.length; _i++) {
            var c = _a[_i];
            if (c.cardType() === type) {
                if (ignoreCard && ignoreCard == c) {
                    continue;
                }
                n++;
            }
        }
        return n;
    };
    BaisyunHand.prototype.cardListCostOver0 = function () {
        var result = [];
        for (var _i = 0, _a = this._cardList; _i < _a.length; _i++) {
            var c = _a[_i];
            if (c.manaCost() > 0) {
                result.push(c);
            }
        }
        return result;
    };
    return BaisyunHand;
}());
var BaisyunPlayer = /** @class */ (function () {
    function BaisyunPlayer(actorId) {
        this._stateMap = {};
        this._relicList = [];
        this._shield = 0;
        this._clone = false;
        this._actorId = actorId;
        this._baisyunLevel = new BaisyunLevel(actorId);
        this.resetDeckAndStorage();
    }
    BaisyunPlayer.prototype.setClone = function (b) {
        this._clone = true;
    };
    BaisyunPlayer.prototype.isClone = function () {
        return this._clone;
    };
    BaisyunPlayer.prototype.stateAddCardId = function () {
        if (this.hasState(BaisyunStateType.eroIntelligence)) {
            var state = $dataStates[BaisyunStateType.eroIntelligence];
            return parseInt(state.meta['addCardId']);
        }
        return 0;
    };
    BaisyunPlayer.prototype.resetDeckAndStorage = function () {
        var actorId = this._actorId;
        this._storage = new BaisyunCardStorage(actorId);
        $baisyunDeckManager.initStorage(this._storage);
        this._deck = new BaisyunDeck(actorId);
        this._storage.initDeck(this._deck);
    };
    BaisyunPlayer.prototype.setDeck = function (deck) {
        this._deck = deck;
    };
    BaisyunPlayer.prototype.initRelic = function () {
        var level = this._baisyunLevel.level();
        this._relicList = $relicManager.relicList(level);
    };
    BaisyunPlayer.prototype.onDrawCard = function (card) {
        for (var _i = 0, _a = this._relicList; _i < _a.length; _i++) {
            var relic = _a[_i];
            relic.onDrawCard(this, card);
        }
    };
    BaisyunPlayer.prototype.hasShieldCarryOverRelic = function () {
        for (var _i = 0, _a = this._relicList; _i < _a.length; _i++) {
            var relic = _a[_i];
            if (relic.shieldCarryOver()) {
                return true;
            }
        }
        return false;
    };
    BaisyunPlayer.prototype.shuffleMana = function () {
        for (var _i = 0, _a = this._relicList; _i < _a.length; _i++) {
            var relic = _a[_i];
            if (relic.shuffleMana() > 0) {
                return relic.shuffleMana();
            }
        }
        return 0;
    };
    BaisyunPlayer.prototype.onTurnStart = function (turnCount, enemy) {
        this.updateStatesTurnStart(turnCount, enemy);
        this.onTurnStartRelic(turnCount);
        this._dirty = true;
        this.addStateTurnStart();
    };
    BaisyunPlayer.prototype.onTurnStartRelic = function (turnCount) {
        for (var _i = 0, _a = this._relicList; _i < _a.length; _i++) {
            var relic = _a[_i];
            relic.onTurnStart(this, turnCount);
        }
    };
    BaisyunPlayer.prototype.addStateTurnStart = function () {
    };
    BaisyunPlayer.prototype.updateStatesTurnStart = function (turnCount, enemy) {
        this.clearShield(turnCount);
        this.clearState(BaisyunStateType.shield);
        this.clearState(BaisyunStateType.atkDown);
        this.clearState(BaisyunStateType.kaikyaku);
        this.clearState(BaisyunStateType.notFinish);
        this.clearState(BaisyunStateType.excitement);
        this.clearState(BaisyunStateType.calm);
        this.clearState(BaisyunStateType.shieldBreak);
        this.addZeijakuState(enemy);
        this.addShieldBreakState(enemy);
        this.minusCostumeCount();
        this.decrementState(BaisyunStateType.weakness, false);
        this.decrementState(BaisyunStateType.draw1Card, false);
        this.decrementState(BaisyunStateType.atkDownPlayer, false);
        this.gainShield(this.turnStartShield());
    };
    BaisyunPlayer.prototype.addShieldBreakState = function (enemy) {
        var gehin = enemy.stateValue(BaisyunStateType.gehin);
        if (gehin == 0) {
            return;
        }
        this.addState(new BaisyunState(BaisyunStateType.shieldBreak, gehin));
        this.updateShieldBreak();
    };
    BaisyunPlayer.prototype.addZeijakuState = function (enemy) {
        if (enemy.hasState(BaisyunStateType.sado)) {
            this.addState(new BaisyunState(StateId.weakness, 1));
        }
    };
    BaisyunPlayer.prototype.updateShieldBreak = function () {
        if (this._shield == 0) {
            return;
        }
        var shieldBreak = this.stateValue(BaisyunStateType.shieldBreak);
        if (shieldBreak > this._shield) {
            this.minusState(BaisyunStateType.shieldBreak, this._shield);
            this._shield = 0;
        }
        else {
            this._shield -= shieldBreak;
            this.clearState(BaisyunStateType.shieldBreak);
        }
    };
    BaisyunPlayer.prototype.turnStartShield = function () {
        return this.stateValue(BaisyunStateType.tactics);
    };
    BaisyunPlayer.prototype.minusCostumeCount = function () {
        var list = [BaisyunStateType.takeOffBottom, BaisyunStateType.takeOffTop, BaisyunStateType.takeOffInnerBottom, BaisyunStateType.takeOffInnerTop];
        if (this._actorId == 1) {
            // ロザリーは脱ぎ状態を維持しない
            for (var _i = 0, list_3 = list; _i < list_3.length; _i++) {
                var c = list_3[_i];
                this.clearState(c, true);
            }
        }
        else {
            for (var _a = 0, list_4 = list; _a < list_4.length; _a++) {
                var c = list_4[_a];
                if (this.isEternal(c)) {
                    continue;
                }
                this.decrementState(c, true);
            }
        }
    };
    BaisyunPlayer.prototype.isEternal = function (c) {
        if (!this.hasState(BaisyunStateType.eternalTopNude)) {
            return false;
        }
        if (c == BaisyunStateType.takeOffTop || c == BaisyunStateType.takeOffInnerTop) {
            return true;
        }
        return false;
    };
    BaisyunPlayer.prototype.clearShield = function (turnCount) {
        if (this.hasShieldCarryOverRelic()) {
            this._shield = Math.floor(this._shield / 2);
        }
        else {
            this._shield = 0;
        }
        if (turnCount == 1) {
            this.battleStartRelic();
        }
    };
    BaisyunPlayer.prototype.decrementState = function (stateType, takeOff) {
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.type() != stateType) {
                continue;
            }
            if (state.value() > 0) {
                state.decrement();
                if (state.value() === 0 && takeOff) {
                    this.clearTakeOff(stateType);
                }
            }
        }
    };
    BaisyunPlayer.prototype.clearTakeOff = function (stateType) {
        switch (stateType) {
            case BaisyunStateType.takeOffBottom:
                this.actor().clearTakeOffBottom();
                break;
            case BaisyunStateType.takeOffTop:
                this.actor().clearTakeOffTop();
                break;
            case BaisyunStateType.takeOffInnerBottom:
                this.actor().clearTakeOffInnerBottom();
                break;
            case BaisyunStateType.takeOffInnerTop:
                this.actor().clearTakeOffInnerTop();
                break;
            default:
                console.error('不正なBaisyunStateTypeです:' + stateType);
        }
    };
    BaisyunPlayer.prototype.onTurnEnd = function () {
        this.updateStatesTurnEnd();
        this._dirty = true;
    };
    BaisyunPlayer.prototype.updateStatesTurnEnd = function () {
        this.clearState(BaisyunStateType.defDown);
    };
    BaisyunPlayer.prototype.clearState = function (stateType, takeOff) {
        if (takeOff === void 0) { takeOff = false; }
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.type() == stateType) {
                state.clear();
                if (takeOff) {
                    this.clearTakeOff(stateType);
                }
                return;
            }
        }
    };
    BaisyunPlayer.prototype.minusState = function (stateType, num) {
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.type() == stateType) {
                state.minusValue(num);
                return;
            }
        }
    };
    BaisyunPlayer.prototype.isHalfDef = function () {
        return this.hasState(BaisyunStateType.defDown);
    };
    BaisyunPlayer.prototype.hasState = function (stateType) {
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.type() == stateType) {
                return state.value() > 0;
            }
        }
        return false;
    };
    BaisyunPlayer.prototype.stateValue = function (stateType) {
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.type() == stateType) {
                return state.value();
            }
        }
        return 0;
    };
    BaisyunPlayer.prototype.resetDeck = function () {
        this._deck = $baisyunDeckManager.makeDeck(this._actorId);
    };
    BaisyunPlayer.prototype.deck = function () {
        return this._deck;
    };
    BaisyunPlayer.prototype.storage = function () {
        return this._storage;
    };
    BaisyunPlayer.prototype.hp = function () {
        return this._hp;
    };
    BaisyunPlayer.prototype.maxHp = function () {
        return this._maxHp;
    };
    BaisyunPlayer.prototype.actorId = function () {
        return this._actorId;
    };
    BaisyunPlayer.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    BaisyunPlayer.prototype.shield = function () {
        return this._shield;
    };
    BaisyunPlayer.prototype.gainShield = function (n) {
        if (n == 0) {
            return;
        }
        if (n < 0) {
            console.error('獲得シールドがマイナスです:' + n);
        }
        //('gainShield:' + this._shield + ' ' + n)
        this._shield += n;
        this.updateShieldBreak();
    };
    BaisyunPlayer.prototype.loseShield = function (n) {
        if (n == 0) {
            return;
        }
        this._shield -= n;
        //p('loseShield:' + this._shield + ' ' + n)
        if (this._shield < 0) {
            this._shield = 0;
        }
    };
    BaisyunPlayer.prototype.damage = function (n, enemy) {
        this._dirty = true;
        var damage = this.damageToShield(n, enemy);
        if (damage == 0) {
            return;
        }
        this._hp -= this.updateDamage(damage);
        if (!this._clone) {
            this._hp = Math.max(this._hp, 0);
        }
    };
    BaisyunPlayer.prototype.loseHp = function (n) {
        this._dirty = true;
        /*const damage = this.damageToShieldFixed(n);
        if (damage == 0) {
            return;
        }*/
        this._hp -= n;
        if (!this._clone) {
            this._hp = Math.max(this._hp, 0);
        }
    };
    BaisyunPlayer.prototype.selfDamage = function (n) {
        this._dirty = true;
        n -= this.reduceDamage();
        if (n <= 0) {
            return;
        }
        var damage = this.damageToShieldFixed(n);
        if (damage == 0) {
            return;
        }
        this._hp -= this.updateDamage(n);
        if (!this._clone) {
            this._hp = Math.max(this._hp, 0);
        }
    };
    BaisyunPlayer.prototype.damageToShieldFixed = function (n) {
        var shield = this.shield();
        if (shield == 0) {
            return n;
        }
        var shieldDamage = Math.min(n, shield);
        if (shield > shieldDamage) {
            this.loseShield(shieldDamage);
            return 0;
        }
        n -= shieldDamage;
        this.loseShield(shield);
        return n;
    };
    BaisyunPlayer.prototype.damageToShield = function (n, enemy) {
        var shield = this.shield();
        if (shield == 0) {
            return n;
        }
        var shieldDamage = Math.min(n, shield);
        if (shield > shieldDamage) {
            this.loseShield(shieldDamage);
            return 0;
        }
        n -= shieldDamage;
        this.loseShield(shield);
        return n;
    };
    BaisyunPlayer.prototype.updateDamage = function (n) {
        if (this.hasState(BaisyunStateType.defDownPlayer)) {
            n += this.stateValue(BaisyunStateType.defDownPlayer);
        }
        if (this.hasState(BaisyunStateType.defDownPlayerEternal)) {
            n += this.stateValue(BaisyunStateType.defDownPlayerEternal);
        }
        return n;
    };
    BaisyunPlayer.prototype.isDead = function () {
        return this._hp <= 0;
    };
    BaisyunPlayer.prototype.onBaisyunStart = function () {
        this.onBattleStart();
    };
    BaisyunPlayer.prototype.onBattleStart = function () {
        this._deck.onBattleStart();
        var baisyun = this.actor().baisyun();
        this._hp = baisyun.hp();
        this._maxHp = baisyun.maxHp();
        this._stateMap = {};
        this._shield = 0;
        this._bokki = 0;
        this.initRelic();
    };
    BaisyunPlayer.prototype.battleStartRelic = function () {
        for (var _i = 0, _a = this._relicList; _i < _a.length; _i++) {
            var r = _a[_i];
            r.onBattleStart(this);
        }
    };
    BaisyunPlayer.prototype.initialCardList = function () {
        var result = [];
        for (var _i = 0, _a = this._relicList; _i < _a.length; _i++) {
            var r = _a[_i];
            var cardId = r.initialCard();
            if (cardId > 0) {
                for (var _b = 0, _c = this._relicList; _b < _c.length; _b++) {
                    var r2 = _c[_b];
                    cardId = r2.changeInitialCard(cardId);
                }
                result.push(new BaisyunCard(this._actorId, cardId));
            }
        }
        return result;
    };
    BaisyunPlayer.prototype.stateList = function () {
        var result = [];
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.value() > 0) {
                result.push(state);
            }
        }
        if (this._bokki > 0) {
            result.push(new BaisyunState(108, this._bokki));
        }
        if (this._actorId == 1) {
            result.push(this.actor1State());
        }
        result = result.sort(function (a, b) {
            return b.orderId() - a.orderId();
        });
        return result;
    };
    BaisyunPlayer.prototype.actor1State = function () {
        return new BaisyunState(110, -1);
    };
    BaisyunPlayer.prototype.isDirty = function () {
        return this._dirty;
    };
    BaisyunPlayer.prototype.clearDirty = function () {
        this._dirty = false;
    };
    BaisyunPlayer.prototype.addStateList = function (list) {
        for (var _i = 0, list_5 = list; _i < list_5.length; _i++) {
            var s = list_5[_i];
            this.addState(s);
        }
        this._dirty = true;
    };
    BaisyunPlayer.prototype.addState = function (s) {
        if (s.selectType() == BaisyunStateType.shield) {
            return;
        }
        if (s.selectType() == BaisyunStateType.shield && this.isHalfDef()) {
            s.half();
        }
        if (this._stateMap[s.stateId()]) {
            this._stateMap[s.stateId()].addValue(s.value());
        }
        else {
            this._stateMap[s.stateId()] = s;
        }
        this._dirty = true;
    };
    BaisyunPlayer.prototype.isTakeOffTop = function () {
        return this.hasState(BaisyunStateType.takeOffTop);
    };
    BaisyunPlayer.prototype.takeOffTop = function (turns) {
        if (this._stateMap[StateId.takeOffTop]) {
            this._stateMap[StateId.takeOffTop].addValue(turns);
        }
        else {
            var state = new BaisyunState(StateId.takeOffTop, turns);
            this.addState(state);
        }
        this.actor().takeOffTop();
        this._dirty = true;
    };
    BaisyunPlayer.prototype.isTakeOffBottom = function () {
        return this.hasState(BaisyunStateType.takeOffBottom);
    };
    BaisyunPlayer.prototype.takeOffInnerTop = function (turns) {
        if (this._stateMap[StateId.takeOffInnerTop]) {
            this._stateMap[StateId.takeOffInnerTop].addValue(turns);
        }
        else {
            var state = new BaisyunState(StateId.takeOffInnerTop, turns);
            this.addState(state);
        }
        this.actor().takeOffInnerTop();
        this._dirty = true;
    };
    BaisyunPlayer.prototype.isTakeOffInnerBottom = function () {
        return this.hasState(BaisyunStateType.takeOffInnerBottom);
    };
    BaisyunPlayer.prototype.isTakeOffInnerTop = function () {
        return this.hasState(BaisyunStateType.takeOffInnerTop);
    };
    BaisyunPlayer.prototype.takeOffBottom = function (turns) {
        if (this._stateMap[StateId.takeOffBottom]) {
            this._stateMap[StateId.takeOffBottom].addValue(turns);
        }
        else {
            var state = new BaisyunState(StateId.takeOffBottom, turns);
            this.addState(state);
        }
        this.actor().takeOffBottom();
        this._dirty = true;
    };
    BaisyunPlayer.prototype.takeOffInnerBottom = function (turns) {
        if (this._stateMap[StateId.takeOffInnerBottom]) {
            this._stateMap[StateId.takeOffInnerBottom].addValue(turns);
        }
        else {
            var state = new BaisyunState(StateId.takeOffInnerBottom, turns);
            this.addState(state);
        }
        this.actor().takeOffInnerBottom();
        this._dirty = true;
    };
    BaisyunPlayer.prototype.viewRelicList = function () {
        var list = this.relicList();
        return $relicManager.viewRelicList(list);
    };
    BaisyunPlayer.prototype.relicList = function () {
        return this._relicList;
    };
    BaisyunPlayer.prototype.handPlus = function (turnCount) {
        var n = 0;
        for (var _i = 0, _a = this.relicList(); _i < _a.length; _i++) {
            var r = _a[_i];
            n += r.handPlus(turnCount);
        }
        if (this.stateValue(BaisyunStateType.brainStorm) > 0) {
            n += this.stateValue(BaisyunStateType.brainStorm);
        }
        if (this.stateValue(BaisyunStateType.draw1Card) > 0) {
            n += 1;
        }
        return n;
    };
    BaisyunPlayer.prototype.maxManaPlus = function (turnCount) {
        var n = 0;
        for (var _i = 0, _a = this.relicList(); _i < _a.length; _i++) {
            var r = _a[_i];
            n += r.maxManaPlus(turnCount);
        }
        return n;
    };
    BaisyunPlayer.prototype.maxBaisyunHp = function () {
        var n = 10;
        for (var i = 2; i <= this._baisyunLevel.level(); i++) {
            n += this.maxBaisyunHpUpByLevel(i);
        }
        return n + this.maxHpPlus();
    };
    BaisyunPlayer.prototype.maxBaisyunHpUpByLevel = function (level) {
        if (level < 6) {
            return 2;
        }
        return 1;
    };
    BaisyunPlayer.prototype.maxHpPlus = function () {
        var n = 0;
        for (var _i = 0, _a = this.relicList(); _i < _a.length; _i++) {
            var r = _a[_i];
            n += r.maxHpPlus();
        }
        return n;
    };
    BaisyunPlayer.prototype.setPoseId = function (poseId) {
        this.actor().setPoseId(poseId);
    };
    BaisyunPlayer.prototype.takeOffCount = function () {
        var n = 0;
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.value() <= 0) {
                continue;
            }
            if (state.isTakeOffState()) {
                n++;
            }
        }
        return n;
    };
    BaisyunPlayer.prototype.atkPlus = function () {
        var n = 0;
        n += this.atkNudePlus();
        n += this.atkStatePlus();
        return n;
    };
    BaisyunPlayer.prototype.atkStatePlus = function () {
        return this.stateValue(BaisyunStateType.atkUpPlayer);
    };
    BaisyunPlayer.prototype.atkNudePlus = function () {
        return this.takeOffCount() * 2;
    };
    BaisyunPlayer.prototype.addBokki = function (n) {
        this._bokki += n;
        if (this._bokki >= this.maxBokki()) {
            this._bokki = this.maxBokki();
            this.actor().removeAcce(1011);
            this.actor().addAcce(1012);
        }
        else {
            this.actor().addAcce(1011);
            this.actor().removeAcce(1012);
        }
    };
    BaisyunPlayer.prototype.maxBokki = function () {
        return 10;
    };
    BaisyunPlayer.prototype.syaseiBokki = function () {
        return 2;
    };
    BaisyunPlayer.prototype.canSyasei = function () {
        return this._bokki >= this.syaseiBokki();
    };
    BaisyunPlayer.prototype.syasei = function () {
        if (this.hasState(BaisyunStateType.fullBokki)) {
            this.decrementState(BaisyunStateType.fullBokki, false);
            this._bokki--;
        }
        else {
            this._bokki = 0;
        }
    };
    BaisyunPlayer.prototype.bokki = function () {
        return this._bokki;
    };
    BaisyunPlayer.prototype.isHeisei = function () {
        return this.bokki() == 0;
    };
    BaisyunPlayer.prototype.baisyunLevel = function () {
        return this._baisyunLevel;
    };
    BaisyunPlayer.prototype.hasEroEventState = function () {
        for (var _i = 0, _a = this.stateList(); _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.isEroEventState()) {
                return true;
            }
        }
        return false;
    };
    BaisyunPlayer.prototype.stayEroScenario = function () {
        if (this.hasState(BaisyunStateType.kaikyaku)) {
            return 'ero_01_12_開脚';
        }
        return null;
    };
    BaisyunPlayer.prototype.reduceDamage = function () {
        if (this.hasState(BaisyunStateType.kaikyaku)) {
            return this.stateValue(BaisyunStateType.kaikyaku);
        }
        return 0;
    };
    BaisyunPlayer.prototype.isEroBook = function () {
        return this.hasState(BaisyunStateType.eroBook);
    };
    BaisyunPlayer.prototype.stateDamage = function () {
        return this.stateValue(BaisyunStateType.smell);
    };
    return BaisyunPlayer;
}());
var BaisyunTrashCan = /** @class */ (function () {
    function BaisyunTrashCan() {
        this._cardList = [];
    }
    BaisyunTrashCan.prototype.addDisturbanceCardList = function (cardList) {
        for (var _i = 0, cardList_2 = cardList; _i < cardList_2.length; _i++) {
            var card = cardList_2[_i];
            this._cardList.push(card);
        }
    };
    BaisyunTrashCan.prototype.addCard = function (card) {
        card.onTrash();
        this._cardList.push(card);
    };
    BaisyunTrashCan.prototype.cardList = function () {
        return this._cardList;
    };
    BaisyunTrashCan.prototype.clear = function () {
        this._cardList = [];
    };
    BaisyunTrashCan.prototype.num = function () {
        return this._cardList.length;
    };
    return BaisyunTrashCan;
}());
var BaisyunExiledArea = /** @class */ (function () {
    function BaisyunExiledArea() {
        this._cardList = [];
    }
    BaisyunExiledArea.prototype.addCard = function (card) {
        this._cardList.push(card);
    };
    BaisyunExiledArea.prototype.cardList = function () {
        return this._cardList;
    };
    BaisyunExiledArea.prototype.clear = function () {
        this._cardList = [];
    };
    BaisyunExiledArea.prototype.num = function () {
        return this._cardList.length;
    };
    return BaisyunExiledArea;
}());
