var ACTOR_TALK_LIST = [
    [2, 'attack', '私を買ってくれませんか？'],
    [2, 'attack', 'エッチしませんか？'],
    [2, 'attack', 'こういうのはいかが？'],
    [2, 'attack', 'あなた、すごく素敵だわ'],
    [2, 'guard', '何を言われても耐えなくては'],
    [2, 'guard', 'ここが耐えどころね'],
    [2, 'guard', '相手にしゃべらせましょう'],
    [2, 'skill', 'どう動いていこうかしら'],
    [2, 'skill', '考えどころね'],
    [2, 'skill', 'さて、次が肝心ね'],
    [2, 'skill', '準備はできたわ'],
    [2, 'recover', '力を抜いて交渉しましょう'],
    [2, 'recover', '一旦立て直しよ'],
    [2, 'finish', 'さあ、こちらに来てください'],
    [2, 'finish', 'これで交渉は終わりです'],
    [2, 'finish', '決めてください'],
    [2, 'disturbance', 'こんなことをしている場合では……'],
    [1, 'attack', 'あの……どうでしょう？'],
    [1, 'attack', 'エッチ、したくないですか？'],
    [1, 'attack', '私としませんか？'],
    [1, 'attack', 'こんなことしちゃいます'],
    [1, 'guard', '耐えましょう'],
    [1, 'guard', '聞き流さなくては'],
    [1, 'guard', 'ここは相手の出方をみましょう'],
    [1, 'skill', '考えどころです'],
    [1, 'skill', 'うーむ、どうすればいいのでしょう'],
    [1, 'skill', '師匠ならどうするでしょうか'],
    [1, 'skill', '作戦を練りましょう'],
    [1, 'finish', 'これでダメなら仕方ありません'],
    [1, 'finish', '部屋に行きましょう'],
    [1, 'finish', 'これ以上は待てません！'],
    [1, 'recover', '心を落ち着かせて……'],
    [1, 'recover', '深呼吸です'],
    [1, 'recover', 'スーハースーハー'],
    [1, 'disturbance', '頭が回りませんね'],
    [3, 'attack', 'オレとしないか……？'],
    [3, 'attack', '買ってほしいぜ'],
    [3, 'attack', '気持ちよくしてやれるぜ'],
    [3, 'attack', '気持ちいい部分がわかるぜ'],
    [3, 'guard', 'くそっ、耐えないと'],
    [3, 'guard', '頑張らねぇと……'],
    [3, 'guard', '相手はどうくるんだ？'],
    [3, 'skill', 'さて、どうすっかな'],
    [3, 'skill', 'うまく交渉しねぇとな'],
    [3, 'skill', '何をしたら効果的なんだ？'],
    [3, 'skill', 'ここで立ち止まってられねぇんだ'],
    [3, 'recover', 'これで回復だ！'],
    [3, 'recover', '一度立て直しだ'],
    [3, 'finish', 'もうこれで決めてくれっ'],
    [3, 'finish', 'これでどうだっ！'],
    [3, 'finish', 'さあ、買ってくれ！'],
    [3, 'disturbance', '足止めを食らっちまったな'],
];
var ActorTalk = /** @class */ (function () {
    function ActorTalk(actorId) {
        this._actorId = actorId;
        this._attackMessageList = [];
        this._guardMessageList = [];
        this._skillMessageList = [];
        this._finishMessageList = [];
        this._recoverMessageList = [];
        this._disturbanceMessageList = [];
        this.parseList();
    }
    ActorTalk.prototype.parseList = function () {
        for (var _i = 0, ACTOR_TALK_LIST_1 = ACTOR_TALK_LIST; _i < ACTOR_TALK_LIST_1.length; _i++) {
            var item = ACTOR_TALK_LIST_1[_i];
            if (item[0] == this._actorId) {
                var list = this.selectList(item[1]);
                if (list) {
                    list.push(item[2] + '');
                }
            }
        }
    };
    ActorTalk.prototype.selectList = function (type) {
        switch (type) {
            case 'attack': return this._attackMessageList;
            case 'skill': return this._skillMessageList;
            case 'power': return this._skillMessageList;
            case 'guard': return this._guardMessageList;
            case 'finish': return this._finishMessageList;
            case 'recover': return this._recoverMessageList;
            case 'disturbance': return this._disturbanceMessageList;
        }
        console.error('不正なtypeです:' + type);
        return null;
    };
    ActorTalk.prototype.attackMessage = function () {
        var dice = Math.randomInt(this._attackMessageList.length);
        return this._attackMessageList[dice];
    };
    ActorTalk.prototype.recoverMessage = function () {
        var dice = Math.randomInt(this._recoverMessageList.length);
        return this._recoverMessageList[dice];
    };
    ActorTalk.prototype.skillMessage = function () {
        var dice = Math.randomInt(this._skillMessageList.length);
        return this._skillMessageList[dice];
    };
    ActorTalk.prototype.guardMessage = function () {
        var dice = Math.randomInt(this._guardMessageList.length);
        return this._guardMessageList[dice];
    };
    ActorTalk.prototype.finishMessage = function () {
        var dice = Math.randomInt(this._finishMessageList.length);
        return this._finishMessageList[dice];
    };
    ActorTalk.prototype.disturbanceMessage = function () {
        var dice = Math.randomInt(this._disturbanceMessageList.length);
        return this._disturbanceMessageList[dice];
    };
    return ActorTalk;
}());
var ActorTalkParams = /** @class */ (function () {
    function ActorTalkParams() {
        this._map = {};
        this._map[1] = new ActorTalk(1);
        this._map[2] = new ActorTalk(2);
        this._map[3] = new ActorTalk(3);
    }
    ActorTalkParams.prototype.attackMessage = function (actorId) {
        return this._map[actorId].attackMessage();
    };
    ActorTalkParams.prototype.skillMessage = function (actorId) {
        return this._map[actorId].skillMessage();
    };
    ActorTalkParams.prototype.recoverMessage = function (actorId) {
        return this._map[actorId].recoverMessage();
    };
    ActorTalkParams.prototype.guardMessage = function (actorId) {
        return this._map[actorId].guardMessage();
    };
    ActorTalkParams.prototype.finishMessage = function (actorId) {
        return this._map[actorId].finishMessage();
    };
    ActorTalkParams.prototype.disturbanceMessage = function (actorId) {
        return this._map[actorId].disturbanceMessage();
    };
    return ActorTalkParams;
}());
var $actorTalkParams = new ActorTalkParams();
var ActorTalkManager = /** @class */ (function () {
    function ActorTalkManager() {
    }
    ActorTalkManager.actorTalk = function (card, actorId) {
        if (card.isRecoverType()) {
            return $actorTalkParams.recoverMessage(card.actorId());
        }
        switch (card.cardType()) {
            case CardType.attack:
                return $actorTalkParams.attackMessage(card.actorId());
            case CardType.skill:
                return $actorTalkParams.skillMessage(card.actorId());
            case CardType.guard:
                return $actorTalkParams.guardMessage(card.actorId());
            case CardType.finish:
                return $actorTalkParams.finishMessage(card.actorId());
            case CardType.disturbance:
                return $actorTalkParams.disturbanceMessage(actorId);
            case CardType.power:
                return $actorTalkParams.skillMessage(card.actorId());
            default:
                console.error('不正なカードタイプです:' + card.cardType());
        }
    };
    return ActorTalkManager;
}());
