var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var BaisyunState = /** @class */ (function () {
    function BaisyunState(stateId, value) {
        this._stateId = stateId;
        this._type = this.selectType();
        this._value = value;
    }
    BaisyunState.prototype.selectType = function () {
        for (var key in BaisyunStateType) {
            if (parseInt(key) == this._stateId) {
                return parseInt(key);
            }
        }
        console.error('不正なstateIDです:' + this._stateId);
    };
    BaisyunState.prototype.isTakeOffState = function () {
        switch (this.selectType()) {
            case BaisyunStateType.takeOffTop:
            case BaisyunStateType.takeOffBottom:
            case BaisyunStateType.takeOffInnerTop:
            case BaisyunStateType.takeOffInnerBottom:
                return true;
        }
        return false;
    };
    BaisyunState.prototype.name = function () {
        return getItemName($dataStates[this._stateId]);
    };
    BaisyunState.prototype.half = function () {
        this._value = Math.floor(this._value / 2);
    };
    BaisyunState.prototype.description = function () {
        var value = hankaku2ZenkakuUnder10(this._value);
        switch (this.selectType()) {
            case BaisyunStateType.shield:
                return [TextManager.baisyunState_shield];
            case BaisyunStateType.defDown:
                return [TextManager.baisyunState_defDown];
            case BaisyunStateType.nude:
                return [TextManager.baisyunState_nude];
            case BaisyunStateType.weakness:
                return [$dataSkills[983].description];
            case BaisyunStateType.kaikyaku:
                return this.formatText([TextManager.baisyunState_kaikyaku], value);
            case BaisyunStateType.bokki:
                return TextManager.baisyunState_bokki;
            case BaisyunStateType.hajirai:
                return [TextManager.baisyunState_passive, 'ターン開始時に服を着る'];
            case BaisyunStateType.takeOffBottom:
            case BaisyunStateType.takeOffInnerBottom:
            case BaisyunStateType.takeOffTop:
            case BaisyunStateType.takeOffInnerTop:
                return [TextManager.baisyunState_atk2];
            case BaisyunStateType.atkUp:
            case BaisyunStateType.atkUpPlayer:
                return [TextManager.baisyunState_atkUp];
            case BaisyunStateType.gainVoltage:
                return TextManager.baisyunState_gainVoltage;
            case BaisyunStateType.gehin:
                return this.formatText(TextManager.baisyunState_gehin, value);
            case BaisyunStateType.ganko:
                return [TextManager.baisyunState_ganko];
            case BaisyunStateType.tsundere:
                return this.formatText(TextManager.baisyunState_tsundere, value);
            case BaisyunStateType.impulsive:
                return this.formatText(TextManager.baisyunState_impulsive, value);
            case BaisyunStateType.defDownEnemy:
                return [TextManager.baisyunState_defDownEnemy];
            case BaisyunStateType.fool:
                return TextManager.baisyunState_fool;
            case BaisyunStateType.yuuwaku:
                return [TextManager.baisyunState_yuuwaku];
            case BaisyunStateType.atkDownPlayer:
                return [TextManager.baisyunState_atkDownPlayer];
            case BaisyunStateType.defDownPlayer:
            case BaisyunStateType.defDownPlayerEternal:
                return [TextManager.baisyunState_defDownPlayer];
            case BaisyunStateType.nenchakushitsu:
                return TextManager.baisyunState_nenchakushitsu;
            case BaisyunStateType.shihaiyoku:
                return this.formatText([TextManager.baisyunState_shihaiyoku], value);
            case BaisyunStateType.sado:
                return [TextManager.baisyunState_sado];
            case BaisyunStateType.douseiai:
                return TextManager.baisyunState_douseiai;
            case BaisyunStateType.nama:
                return [TextManager.baisyunState_nama];
            case BaisyunStateType.namaOnly:
                return [TextManager.baisyunState_namaOnly];
            case BaisyunStateType.smell:
                return this.formatText([TextManager.baisyunState_damage], value);
            case BaisyunStateType.sobou:
                return this.formatText(TextManager.baisyunState_sobou, value);
            case BaisyunStateType.kikijouzu:
                return [TextManager.baisyunState_kikijouzu];
            case BaisyunStateType.notFinish:
                return TextManager.baisyunState_notFinish;
            case BaisyunStateType.inki:
                return this.formatText(TextManager.baisyunState_inki, value);
            case BaisyunStateType.sekkachi:
                return TextManager.baisyunState_sekkachi;
            case BaisyunStateType.brainStorm:
                return [TextManager.baisyunState_brainStorm];
            case BaisyunStateType.strong:
                return [TextManager.baisyunState_strong];
            case BaisyunStateType.excitement:
                return this.formatText(TextManager.baisyunState_excitement, value);
            case BaisyunStateType.postNutClarity:
                return this.formatText([TextManager.baisyunState_postNut], value);
            case BaisyunStateType.MILFLover:
            case BaisyunStateType.lolicon:
            case BaisyunStateType.otokonokoLover:
                return [TextManager.baisyunState_MILFLover];
            case BaisyunStateType.eroBook:
                return [TextManager.cardCostCut1 + TextManager.cardCostCut2, TextManager.cardCostCut3];
            case BaisyunStateType.eternalTopNude:
                return [TextManager.cardEternalTopNude1, TextManager.cardEternalTopNude2];
            case BaisyunStateType.tactics:
                return this.formatText([TextManager.cardTactics1, TextManager.cardTactics2], value);
            case BaisyunStateType.rewardup:
                return this.formatText([TextManager.cardRewardup], value);
            case BaisyunStateType.draw1Card:
                return this.formatText(TextManager.baisyunState_draw1Card, value);
            case BaisyunStateType.shieldBreak:
                return this.formatText(TextManager.baisyunState_shieldBreak, value);
            case BaisyunStateType.fullBokki:
                return this.formatText(TextManager.baisyunState_fullBokki, value);
            case BaisyunStateType.eroIntelligence:
                return this.formatText(TextManager.baisyunState_eroIntelligence, value);
            case BaisyunStateType.calm:
                return this.formatText(TextManager.baisyunState_calm, value);
            case BaisyunStateType.miwaku:
                return this.formatText(TextManager.baisyunState_miwaku, value);
            case BaisyunStateType.poverty:
                return this.formatText(TextManager.baisyunState_poverty, value);
        }
        return [];
    };
    BaisyunState.prototype.formatText = function (texts, value) {
        var results = [];
        for (var _i = 0, texts_1 = texts; _i < texts_1.length; _i++) {
            var t = texts_1[_i];
            results.push(t.format(value));
        }
        return results;
    };
    BaisyunState.prototype.value = function () {
        return this._value;
    };
    BaisyunState.prototype.isTurnZero = function () {
        return this.state().meta['turnZero'] != null;
    };
    BaisyunState.prototype.iconIndex = function () {
        return this.state().iconIndex;
    };
    BaisyunState.prototype.state = function () {
        return $dataStates[this._stateId];
    };
    BaisyunState.prototype.stateId = function () {
        return this._stateId;
    };
    BaisyunState.prototype.addValue = function (n) {
        this._value += n;
    };
    BaisyunState.prototype.setValue = function (n) {
        this._value = n;
    };
    BaisyunState.prototype.orderId = function () {
        return this.state().priority * 100 + this._stateId;
    };
    BaisyunState.prototype.type = function () {
        return this._type;
    };
    BaisyunState.prototype.toSelf = function () {
        return this.state().meta['self'];
    };
    BaisyunState.prototype.toEnemy = function () {
        return this.state().meta['enemy'];
    };
    BaisyunState.prototype.clear = function () {
        this._value = 0;
    };
    BaisyunState.prototype.minusValue = function (n) {
        this._value = Math.max(this._value - n, 0);
    };
    BaisyunState.prototype.isEroEventState = function () {
        return this.state().meta['eroEventState'];
    };
    BaisyunState.prototype.decrement = function () {
        if (this._value > 0) {
            this._value--;
        }
    };
    BaisyunState.prototype.isPassive = function () {
        return this.state().meta['passive'] != null;
    };
    return BaisyunState;
}());
var Sprite_BaisyunActorStatus = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunActorStatus, _super);
    function Sprite_BaisyunActorStatus(player, baisyunForecast) {
        var _this = _super.call(this) || this;
        _this.x = 940;
        _this.y = 650;
        _this.bitmap = new Bitmap(400, 150);
        _this._player = player;
        _this._baisyunForecast = baisyunForecast;
        _this._lastForecastDamage = 0;
        _this.refresh();
        return _this;
    }
    Sprite_BaisyunActorStatus.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_BaisyunActorStatus.prototype.isChanged = function () {
        var damage = this._baisyunForecast.forecastDamage();
        if (this._lastForecastDamage != damage) {
            this._lastForecastDamage = damage;
            return true;
        }
        return this._player.isDirty();
    };
    Sprite_BaisyunActorStatus.prototype.refresh = function () {
        this.bitmap.fontSize = 22;
        this._player.clearDirty();
        this.bitmap.clear();
        this.removeChildren();
        this.drawBg();
        this.drawShield(14);
        this.drawHpGauge(26);
        this.drawHp(8);
        this.drawHpDamage();
        this.drawStates();
    };
    Sprite_BaisyunActorStatus.prototype.drawBg = function () {
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        this.bitmap.blt(bitmap, 0, 700, 350, 230, 0, 0);
    };
    Sprite_BaisyunActorStatus.prototype.drawStates = function () {
        this.bitmap.textColor = ColorManager.normalColor();
        var index = 0;
        var states = this._player.stateList();
        for (var _i = 0, states_1 = states; _i < states_1.length; _i++) {
            var s = states_1[_i];
            this.drawState(index, s);
            index++;
        }
        return index;
    };
    Sprite_BaisyunActorStatus.prototype.drawState = function (index, state) {
        var x = index * this.stateWidth() + 26;
        var y = 74;
        this.drawIcon(state.iconIndex(), x, y);
        if (state.isPassive()) {
            return;
        }
        var text = state.value() + '';
        if (this.isEternal(state)) {
            text = '∞';
            this.bitmap.drawText(text, x, y + 32, 32, 32, 'center');
        }
        else {
            this.drawNumber(state.value(), x + 7, y + 19, 60, 'left', 1);
        }
    };
    Sprite_BaisyunActorStatus.prototype.isEternal = function (state) {
        if (state.value() < 0) {
            return true;
        }
        if (this._player.isEternal(state.selectType())) {
            return true;
        }
        return false;
    };
    Sprite_BaisyunActorStatus.prototype.stateWidth = function () {
        return 40;
    };
    Sprite_BaisyunActorStatus.prototype.drawShield = function (y) {
        if (this._player.shield() == 0) {
            return;
        }
        this.drawShieldIcon();
        var s = this._player.shield();
        var offset = s < 10 ? 8 : 0;
        this.drawNumber(s, 13 + offset, -5, 60, 'left', 7);
    };
    Sprite_BaisyunActorStatus.prototype.drawShieldIcon = function () {
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        this.bitmap.blt(bitmap, 300, 0, 50, 50, 8, 8);
    };
    Sprite_BaisyunActorStatus.prototype.drawHp = function (y) {
        var x = 220;
        this.drawNumber(this._player.hp(), x, y, 60, 'right', 1);
        this.drawNumber(this._player.maxHp(), x + 32, y, 60, 'right', 1);
    };
    Sprite_BaisyunActorStatus.prototype.drawHpGauge = function (y) {
        this.bitmap.textColor = ColorManager.normalColor();
        var gaugeLeft = 96;
        var gaugeW = 150;
        this.drawGaugeRect(gaugeLeft, y, gaugeW, 14, this._lastForecastDamage);
    };
    Sprite_BaisyunActorStatus.prototype.drawHpDamage = function () {
        if (this._lastForecastDamage == 0) {
            return;
        }
        //this.bitmap.textColor = ColorManager.deathColor();
        //this.bitmap.drawText('-' + this._lastForecastDamage, 200, -2, 100, 32);
        this.drawNumber(-this._lastForecastDamage, 170, -22, 64, 'right', 3);
        if (this._lastForecastDamage >= this._player.hp()) {
            this.drawIcon(165, 162, -2);
        }
    };
    Sprite_BaisyunActorStatus.prototype.drawGaugeRect = function (x, y, width, height, damage) {
        var rate = this.gaugeRate();
        var fillW = Math.floor((width - 2) * rate);
        var fillH = height - 2;
        var color0 = this.gaugeBackColor();
        var color1 = ColorManager.hpGaugeColor1();
        var color2 = ColorManager.hpGaugeColor2();
        this.bitmap.fillRect(x, y, width, height, color0);
        this.bitmap.gradientFillRect(x + 1, y + 1, fillW, fillH, color1, color2);
        if (damage > 0) {
            var realDamage = Math.min(damage, this._player.hp());
            var damageRate = realDamage / this._player.maxHp();
            var damageW = Math.floor((width - 2) * damageRate);
            var bitmap = ImageManager.loadSystem('baisyun_ui');
            this.bitmap.blt(bitmap, 250, 100, 148, 20, x + 1 + fillW - damageW, y + 1, damageW, 20);
            this.bitmap.fillRect(x + 1 + fillW - damageW, y + 1, 1, fillH, '#9e1c0566');
            //this.bitmap.fillRect(x + 1 + fillW - damageW, y + 1, damageW, fillH, '#ce2c05');
        }
    };
    Sprite_BaisyunActorStatus.prototype.gaugeRate = function () {
        return this._player.hp() / this._player.maxHp();
    };
    Sprite_BaisyunActorStatus.prototype.gaugeBackColor = function () {
        return '#000000';
    };
    return Sprite_BaisyunActorStatus;
}(Sprite));
