var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Sprite_BaisyunBalloon = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunBalloon, _super);
    function Sprite_BaisyunBalloon(manId) {
        var _this = _super.call(this) || this;
        _this._manId = manId;
        _this.bitmap = new Bitmap(127, 67);
        return _this;
    }
    Sprite_BaisyunBalloon.prototype.setup = function (targetSprite, balloonId) {
        this._target = targetSprite;
        //this._balloonId = balloonId;
        //this._duration = 8 * this.speed() + this.waitTime();
        this.refresh();
        this.update();
    };
    Sprite_BaisyunBalloon.prototype.refresh = function () {
        this.bitmap.clear();
        this.bitmap.fontFace = $gameSystem.mainFontFace();
        var varId = $baisyunFlagManager.manVarId(this._manId);
        var flag = $gameVariables.value(varId);
        this.drawBg();
        this.drawAvailable(flag, -2);
        this.drawName(flag, -2);
        var actor = $gameSystem.baisyunActor();
        this.drawResult(actor, 22);
    };
    Sprite_BaisyunBalloon.prototype.drawBg = function () {
        //this.bitmap.fillRect(0, 0, this.bitmap.width, 64, '#333333');
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        this.bitmap.blt(bitmap, 200, 300, 127, 67, 0, 0);
    };
    Sprite_BaisyunBalloon.prototype.drawName = function (flag, y) {
        if (flag == ManFlag.failure) {
            return;
        }
        if (flag == ManFlag.success) {
            return;
        }
        var enemy = $gameActors.actor(this._manId);
        this.bitmap.fontSize = 13;
        this.bitmap.outlineWidth = 6;
        this.bitmap.textColor = ColorManager.normalColor();
        this.bitmap.drawText(enemy.name(), 0, y, this.bitmap.width, 32, 'center');
    };
    Sprite_BaisyunBalloon.prototype.drawAvailable = function (flag, y) {
        this.bitmap.fontSize = 13;
        this.bitmap.outlineWidth = 6;
        var text;
        if (flag == ManFlag.failure) {
            this.bitmap.textColor = ColorManager.disableColor();
            text = '交渉不可';
        }
        else if (flag == ManFlag.success) {
            this.bitmap.textColor = '#FF77BB';
            text = TextManager.baisyunAfterProstitution;
        }
        else {
            return;
        }
        this.bitmap.drawText(text, 0, y, this.bitmap.width - 5, 32, 'center');
    };
    Sprite_BaisyunBalloon.prototype.drawResult = function (actor, y) {
        this.bitmap.fontSize = 18;
        this.bitmap.outlineWidth = 4;
        var result = actor.baisyunHistory().lastResult(this._manId);
        var xx = 34;
        var yy = y;
        var interval = 20;
        var maxVoltage = this.maxVoltage();
        if (maxVoltage == 1) {
            xx += interval;
        }
        for (var i = 0; i < maxVoltage; i++) {
            if (result && i < result.rank()) {
                this.bitmap.textColor = '#FF66CC';
            }
            else {
                this.bitmap.textColor = '#BBBBBB';
            }
            this.bitmap.drawText('♥', xx, yy, 50, 32);
            xx += interval;
        }
    };
    Sprite_BaisyunBalloon.prototype.maxVoltage = function () {
        var enemy = $dataEnemies[this._manId + 1000];
        var hp1 = enemy.params[0];
        var hp2 = enemy.params[4];
        var hp3 = enemy.params[5];
        if (hp1 == hp2) {
            if (hp2 == hp3) {
                return 1;
            }
            else {
                return 2;
            }
        }
        return 3;
    };
    Sprite_BaisyunBalloon.prototype.update = function () {
        this.updatePosition();
        _super.prototype.update.call(this);
    };
    Sprite_BaisyunBalloon.prototype.updatePosition = function () {
        this.x = this._target.x - this.bitmap.width / 2;
        this.y = this._target.y - 120;
    };
    return Sprite_BaisyunBalloon;
}(Sprite));
