var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Window_BaisyunBattlerInfo = /** @class */ (function (_super) {
    __extends(Window_BaisyunBattlerInfo, _super);
    function Window_BaisyunBattlerInfo(r, battle) {
        var _this = _super.call(this, r) || this;
        _this.visible = false;
        _this._battle = battle;
        _this.frameVisible = false;
        _this.backOpacity = 0;
        return _this;
    }
    Window_BaisyunBattlerInfo.prototype.maxCols = function () {
        return 1;
    };
    Window_BaisyunBattlerInfo.prototype.itemHeight = function () {
        return 110;
    };
    Window_BaisyunBattlerInfo.prototype.maxItems = function () {
        if (!this._baisyunStateList) {
            return 0;
        }
        return this._baisyunStateList.length;
    };
    Window_BaisyunBattlerInfo.prototype.update = function () {
        _super.prototype.update.call(this);
        if (!this._battle) {
            return;
        }
        var lastVisible = this.visible;
        this.visible = this._battle.isShowInfo();
        if (this.visible && !lastVisible) {
            this.makeData();
            this.refresh();
        }
    };
    Window_BaisyunBattlerInfo.prototype.drawItem = function (index) {
        var r = this.itemRect(index);
        var s = this._baisyunStateList[index];
        this.drawIcon(s.iconIndex(), r.x + 6, r.y + 4);
        this.contents.fontSize = 22;
        if (s.value() > 0 && !s.isTurnZero()) {
            this.drawText(s.value(), r.x + 48, r.y + 2, 200);
        }
        this.drawText(s.name(), r.x + 74, r.y + 2, 200);
        var dList = s.description();
        var yy = r.y + 40;
        this.contents.fontSize = 18;
        for (var _i = 0, dList_1 = dList; _i < dList_1.length; _i++) {
            var d = dList_1[_i];
            this.drawText(d, r.x + 8, yy, 280);
            yy += 23;
        }
    };
    Window_BaisyunBattlerInfo.prototype.drawItemBackground = function (index) {
        var rect = this.itemRect(index);
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        this.contents.blt(bitmap, 0, 550, 300, 130, 0, rect.y);
    };
    return Window_BaisyunBattlerInfo;
}(Window_Selectable));
var Window_BaisyunActorInfo = /** @class */ (function (_super) {
    __extends(Window_BaisyunActorInfo, _super);
    function Window_BaisyunActorInfo(battle) {
        var r = new Rectangle(680, -5, 330, 700);
        return _super.call(this, r, battle) || this;
    }
    Window_BaisyunActorInfo.prototype.makeData = function () {
        this._baisyunStateList = this._battle.player().stateList().concat();
    };
    return Window_BaisyunActorInfo;
}(Window_BaisyunBattlerInfo));
var Window_BaisyunEnemyInfo = /** @class */ (function (_super) {
    __extends(Window_BaisyunEnemyInfo, _super);
    function Window_BaisyunEnemyInfo(battle) {
        var r = new Rectangle(-3, -5, 330, 700);
        return _super.call(this, r, battle) || this;
    }
    Window_BaisyunEnemyInfo.prototype.makeData = function () {
        this._baisyunStateList = this._battle.enemy().stateList().concat();
    };
    return Window_BaisyunEnemyInfo;
}(Window_BaisyunBattlerInfo));
