var CardType;
(function (CardType) {
    CardType["all"] = "all";
    CardType["attack"] = "attack";
    CardType["guard"] = "guard";
    CardType["skill"] = "skill";
    CardType["finish"] = "finish";
    CardType["disturbance"] = "disturbance";
    CardType["power"] = "power";
    CardType["none"] = "none";
})(CardType || (CardType = {}));
var CardRare;
(function (CardRare) {
    CardRare["N"] = "N";
    CardRare["R"] = "R";
    CardRare["SR"] = "SR";
})(CardRare || (CardRare = {}));
var BaisyunStateType;
(function (BaisyunStateType) {
    BaisyunStateType[BaisyunStateType["shield"] = 101] = "shield";
    BaisyunStateType[BaisyunStateType["yuuwaku"] = 102] = "yuuwaku";
    BaisyunStateType[BaisyunStateType["atkDown"] = 103] = "atkDown";
    BaisyunStateType[BaisyunStateType["weakness"] = 104] = "weakness";
    BaisyunStateType[BaisyunStateType["defDown"] = 106] = "defDown";
    BaisyunStateType[BaisyunStateType["bokki"] = 108] = "bokki";
    BaisyunStateType[BaisyunStateType["kaikyaku"] = 109] = "kaikyaku";
    BaisyunStateType[BaisyunStateType["hajirai"] = 110] = "hajirai";
    BaisyunStateType[BaisyunStateType["takeOffTop"] = 114] = "takeOffTop";
    BaisyunStateType[BaisyunStateType["takeOffBottom"] = 113] = "takeOffBottom";
    BaisyunStateType[BaisyunStateType["takeOffInnerTop"] = 112] = "takeOffInnerTop";
    BaisyunStateType[BaisyunStateType["takeOffInnerBottom"] = 111] = "takeOffInnerBottom";
    BaisyunStateType[BaisyunStateType["atkUp"] = 115] = "atkUp";
    BaisyunStateType[BaisyunStateType["gainVoltage"] = 116] = "gainVoltage";
    BaisyunStateType[BaisyunStateType["gehin"] = 117] = "gehin";
    BaisyunStateType[BaisyunStateType["ganko"] = 118] = "ganko";
    BaisyunStateType[BaisyunStateType["tsundere"] = 119] = "tsundere";
    BaisyunStateType[BaisyunStateType["impulsive"] = 120] = "impulsive";
    BaisyunStateType[BaisyunStateType["defDownEnemy"] = 121] = "defDownEnemy";
    BaisyunStateType[BaisyunStateType["fool"] = 122] = "fool";
    BaisyunStateType[BaisyunStateType["smell"] = 123] = "smell";
    BaisyunStateType[BaisyunStateType["defDownPlayer"] = 124] = "defDownPlayer";
    BaisyunStateType[BaisyunStateType["nenchakushitsu"] = 125] = "nenchakushitsu";
    BaisyunStateType[BaisyunStateType["shihaiyoku"] = 126] = "shihaiyoku";
    BaisyunStateType[BaisyunStateType["higtaku"] = 127] = "higtaku";
    BaisyunStateType[BaisyunStateType["douseiai"] = 128] = "douseiai";
    BaisyunStateType[BaisyunStateType["nama"] = 129] = "nama";
    BaisyunStateType[BaisyunStateType["namaOnly"] = 130] = "namaOnly";
    BaisyunStateType[BaisyunStateType["sobou"] = 131] = "sobou";
    BaisyunStateType[BaisyunStateType["kikijouzu"] = 132] = "kikijouzu";
    BaisyunStateType[BaisyunStateType["notFinish"] = 133] = "notFinish";
    BaisyunStateType[BaisyunStateType["inki"] = 134] = "inki";
    BaisyunStateType[BaisyunStateType["sekkachi"] = 135] = "sekkachi";
    BaisyunStateType[BaisyunStateType["brainStorm"] = 136] = "brainStorm";
    BaisyunStateType[BaisyunStateType["strong"] = 137] = "strong";
    BaisyunStateType[BaisyunStateType["MILFLover"] = 138] = "MILFLover";
    BaisyunStateType[BaisyunStateType["lolicon"] = 139] = "lolicon";
    BaisyunStateType[BaisyunStateType["otokonokoLover"] = 140] = "otokonokoLover";
    BaisyunStateType[BaisyunStateType["calm"] = 141] = "calm";
    BaisyunStateType[BaisyunStateType["postNutClarity"] = 142] = "postNutClarity";
    BaisyunStateType[BaisyunStateType["atkUpPlayer"] = 143] = "atkUpPlayer";
    BaisyunStateType[BaisyunStateType["eternalTopNude"] = 144] = "eternalTopNude";
    BaisyunStateType[BaisyunStateType["eroBook"] = 145] = "eroBook";
    BaisyunStateType[BaisyunStateType["defDownPlayerEternal"] = 146] = "defDownPlayerEternal";
    BaisyunStateType[BaisyunStateType["tactics"] = 148] = "tactics";
    BaisyunStateType[BaisyunStateType["rewardup"] = 149] = "rewardup";
    BaisyunStateType[BaisyunStateType["shieldBreak"] = 150] = "shieldBreak";
    BaisyunStateType[BaisyunStateType["draw1Card"] = 151] = "draw1Card";
    BaisyunStateType[BaisyunStateType["sado"] = 152] = "sado";
    BaisyunStateType[BaisyunStateType["atkDownPlayer"] = 153] = "atkDownPlayer";
    BaisyunStateType[BaisyunStateType["fullBokki"] = 154] = "fullBokki";
    BaisyunStateType[BaisyunStateType["eroIntelligence"] = 155] = "eroIntelligence";
    BaisyunStateType[BaisyunStateType["excitement"] = 156] = "excitement";
    BaisyunStateType[BaisyunStateType["miwaku"] = 157] = "miwaku";
    BaisyunStateType[BaisyunStateType["poverty"] = 158] = "poverty";
})(BaisyunStateType || (BaisyunStateType = {}));
var BaisyunEffect;
(function (BaisyunEffect) {
    BaisyunEffect[BaisyunEffect["calm"] = 971] = "calm";
    BaisyunEffect[BaisyunEffect["maintenance"] = 972] = "maintenance";
    BaisyunEffect[BaisyunEffect["fullBokki"] = 973] = "fullBokki";
    BaisyunEffect[BaisyunEffect["drawSyaseiCard"] = 974] = "drawSyaseiCard";
    BaisyunEffect[BaisyunEffect["gainVoltage"] = 975] = "gainVoltage";
    BaisyunEffect[BaisyunEffect["draw1Card"] = 976] = "draw1Card";
    BaisyunEffect[BaisyunEffect["kaikyaku"] = 977] = "kaikyaku";
    BaisyunEffect[BaisyunEffect["power"] = 978] = "power";
    BaisyunEffect[BaisyunEffect["excitement"] = 979] = "excitement";
    BaisyunEffect[BaisyunEffect["exhaust"] = 980] = "exhaust";
    BaisyunEffect[BaisyunEffect["opener"] = 981] = "opener";
    BaisyunEffect[BaisyunEffect["takeOffTop"] = 982] = "takeOffTop";
    BaisyunEffect[BaisyunEffect["weakness"] = 983] = "weakness";
    BaisyunEffect[BaisyunEffect["takeOffBottom"] = 984] = "takeOffBottom";
    BaisyunEffect[BaisyunEffect["takeOffInnerTop"] = 985] = "takeOffInnerTop";
    BaisyunEffect[BaisyunEffect["bokki"] = 986] = "bokki";
    BaisyunEffect[BaisyunEffect["syasei"] = 987] = "syasei";
    BaisyunEffect[BaisyunEffect["heisei"] = 988] = "heisei";
    BaisyunEffect[BaisyunEffect["tenpu"] = 989] = "tenpu";
    BaisyunEffect[BaisyunEffect["voltageUp"] = 990] = "voltageUp";
    BaisyunEffect[BaisyunEffect["retain"] = 991] = "retain";
    BaisyunEffect[BaisyunEffect["takeOffInnerBottom"] = 992] = "takeOffInnerBottom";
    BaisyunEffect[BaisyunEffect["defDownEnemy"] = 993] = "defDownEnemy";
    BaisyunEffect[BaisyunEffect["yuuwaku"] = 994] = "yuuwaku";
    BaisyunEffect[BaisyunEffect["finish"] = 995] = "finish";
    BaisyunEffect[BaisyunEffect["chien"] = 996] = "chien";
    BaisyunEffect[BaisyunEffect["notFinish"] = 997] = "notFinish";
    BaisyunEffect[BaisyunEffect["nudeAtkUp"] = 998] = "nudeAtkUp";
    BaisyunEffect[BaisyunEffect["temporary"] = 999] = "temporary";
})(BaisyunEffect || (BaisyunEffect = {}));
var BaisyunCardHelp = /** @class */ (function () {
    function BaisyunCardHelp(skillId) {
        this._skillId = skillId;
    }
    BaisyunCardHelp.prototype.name = function () {
        return getItemName($dataSkills[this._skillId]);
    };
    BaisyunCardHelp.prototype.descriptions = function () {
        var stateDesc = this.stateDescription();
        if (stateDesc) {
            return stateDesc;
        }
        var skill = $dataSkills[this._skillId];
        if (ConfigManager.language == 'jp') {
            return skill.description.split('\n');
        }
        var result = [];
        if (skill.meta['descEn1']) {
            result.push(skill.meta['descEn1']);
        }
        if (skill.meta['descEn2']) {
            result.push(skill.meta['descEn2']);
        }
        return result;
    };
    BaisyunCardHelp.prototype.stateDescription = function () {
        if (this._skillId == BaisyunEffect.defDownEnemy) {
            var splitter = new TextSplitter();
            return splitter.split([TextManager.baisyunState_defDownEnemy], 22, 230);
        }
        if (this._skillId == BaisyunEffect.yuuwaku) {
            return [TextManager.baisyunState_yuuwaku];
        }
        if (this._skillId == BaisyunEffect.notFinish) {
            var splitter = new TextSplitter();
            return splitter.split([TextManager.baisyunState_notFinish], 22, 230);
        }
        return null;
    };
    return BaisyunCardHelp;
}());
var CardDesc = /** @class */ (function () {
    function CardDesc(_text, _color) {
        if (_color === void 0) { _color = ColorManager.normalColor(); }
        this._text = _text;
        this._color = _color;
    }
    CardDesc.prototype.text = function () {
        return this._text;
    };
    CardDesc.prototype.color = function () {
        return this._color;
    };
    return CardDesc;
}());
var BaisyunCard = /** @class */ (function () {
    function BaisyunCard(actorId, skillId) {
        this._masekiId = 0;
        this._drawn = false;
        this._costDown = 0;
        this._maintemance = 0;
        this._actorId = actorId;
        this._skillId = skillId;
    }
    BaisyunCard.prototype.onBattleStart = function () {
        this._costDown = 0;
        this._maintemance = 0;
    };
    BaisyunCard.prototype.setMaseki = function (maseki) {
        if (maseki) {
            this._masekiId = maseki.itemId();
        }
        else {
            this._masekiId = 0;
        }
    };
    BaisyunCard.prototype.maseki = function () {
        if (this._masekiId > 0) {
            return new Maseki(this._actorId, this._masekiId);
        }
        return null;
    };
    BaisyunCard.prototype.skillId = function () {
        return this._skillId;
    };
    BaisyunCard.prototype.setId = function (n) {
        this._id = n;
    };
    BaisyunCard.prototype.id = function () {
        return this._id;
    };
    BaisyunCard.prototype.skill = function () {
        return $dataSkills[this._skillId];
    };
    BaisyunCard.prototype.name = function (outerId) {
        if (outerId === void 0) { outerId = null; }
        if (outerId == 'd') {
            if (this.isTakeOffBottomImageCard()) {
                return this.burumaName();
            }
        }
        return getItemName(this.skill());
    };
    BaisyunCard.prototype.burumaName = function () {
        return getItemName($dataSkills[1098]);
    };
    BaisyunCard.prototype.manaCost = function (battle) {
        if (battle === void 0) { battle = null; }
        if (this._drawn && this.drawCardCostMinus()) {
            return 0;
        }
        var cost = this.skill().mpCost;
        var costDown = this.manaCostDown(battle);
        return Math.max(cost - costDown, 0);
    };
    BaisyunCard.prototype.isFastCard = function () {
        switch (this._skillId) {
            case 1075:
            case 1076:
                // 股間見せ
                return true;
        }
        return false;
    };
    BaisyunCard.prototype.plusCostDown = function (n) {
        this._costDown += n;
    };
    BaisyunCard.prototype.manaCostDown = function (battle) {
        if (battle === void 0) { battle = null; }
        if (!battle) {
            return 0;
        }
        var minus = this.costDown();
        minus += this._maintemance;
        if (this.costCutDef1()) {
            if (battle.hand().countCard(CardType.attack, this) == 0) {
                minus += 1;
            }
        }
        var cost = this.skill().mpCost;
        return Math.min(cost, minus);
    };
    BaisyunCard.prototype.timeCost = function () {
        return this.skill().tpCost;
    };
    BaisyunCard.prototype.iconIndex = function (outerId) {
        if (outerId === void 0) { outerId = null; }
        if (outerId == 'd') {
            if (this.isTakeOffBottomImageCard()) {
                return this.burumaId();
            }
        }
        return this.skill().iconIndex;
    };
    BaisyunCard.prototype.burumaId = function () {
        var actorId = parseInt(this.skill().meta['actorId']);
        switch (actorId) {
            case 1: return 1177;
            case 2: return 1181;
            case 3: return 1179;
        }
        return 1177;
    };
    BaisyunCard.prototype.isTakeOffBottomImageCard = function () {
        switch (this.skill().id) {
            case 1014:
            case 1081:
            case 1082:
            case 1083:
            case 1104:
                return true;
        }
        return false;
    };
    BaisyunCard.prototype.itemBaseDescription = function () {
        if (ConfigManager.isEn()) {
            var list_1 = [];
            if (this.skill().meta['descEn1']) {
                list_1.push(new CardDesc(this.skill().meta['descEn1']));
            }
            if (this.skill().meta['descEn2']) {
                list_1.push(new CardDesc(this.skill().meta['descEn2']));
            }
            if (list_1.length > 0) {
                return list_1;
            }
        }
        var list = [];
        var decs = this.skill().description.split('\n');
        if (decs[0].length > 0) {
            for (var _i = 0, decs_1 = decs; _i < decs_1.length; _i++) {
                var d = decs_1[_i];
                list.push(new CardDesc(d));
            }
        }
        return list;
    };
    BaisyunCard.prototype.description = function () {
        var list = this.itemBaseDescription();
        this.addDescription(list, this.discardAll(), TextManager.cardDiscardAll);
        this.addDescription(list, this.drawCardNum(), TextManager.cardDraw);
        this.addDescription(list, this.drawSyaseiCard(), TextManager.cardDrawSyaseiCard);
        this.addDescription(list, this.atkDown(), TextManager.cardAtkDown);
        this.addDescription(list, this.yuuwaku(), TextManager.cardYuuwaku);
        this.addDescription(list, this.notFinish(), TextManager.cardContinue);
        this.addDescription(list, this.defDownEnemy(), TextManager.cardDefDown);
        this.addDescription(list, this.takeOffPlus(), TextManager.cardTakeOffPlus1, TextManager.cardTakeOffPlus2);
        this.addDescription(list, this.gainMana(), TextManager.cardPlusMana);
        this.addDescription(list, this.nudeAtkUp(), TextManager.cardStripEffect);
        this.addDescription(list, this.openerDamage(), TextManager.cardOpenerDamage);
        this.addDescription(list, this.isDrawFinishCard(), 'Finishカードを引く');
        this.addDescription(list, this.isBrainStorm(), TextManager.cardBrainStorm1, TextManager.cardBrainStorm2);
        this.addDescription(list, this.selectCard(), TextManager.selectCard1, TextManager.selectCard2);
        this.addDescription(list, this.turnDamage(), TextManager.cardTurnDamage1, TextManager.cardTurnDamage2, ColorManager.normalColor());
        this.addDescription(list, this.cardNumVoltage(), TextManager.cardNumVoltage1, TextManager.cardNumVoltage2);
        this.addDescription(list, this.discardNum(), TextManager.cardDiscard);
        this.addDescription(list, this.excitement(), TextManager.cardExcitement.format(this.excitement()));
        this.addDescription(list, this.calm(), TextManager.cardCalm);
        this.addDescription(list, this.loseHp(), TextManager.cardLoseHp);
        this.addDescription(list, this.isEternalTopNude(), TextManager.cardEternalTopNude1, TextManager.cardEternalTopNude2);
        this.addDescription(list, this.isCostCut(), TextManager.cardCostCut1, TextManager.cardCostCut2);
        this.addDescription(list, this.defDownEternal(), TextManager.cardDefDownEternal);
        this.addDescription(list, this.defPlusByAttackCard(), TextManager.cardDefPlusByAttackCard1, TextManager.cardDefPlusByAttackCard2);
        this.addDescription(list, this.postNut(), TextManager.cardPostNut1, TextManager.cardPostNut2);
        this.addDescription(list, this.costCutDef1(), TextManager.cardCostCutDef1, TextManager.cardCostCutDef2);
        this.addDescription(list, this.tactics(), TextManager.cardTactics1, TextManager.cardTactics2);
        this.addDescription(list, this.rewardup(), TextManager.cardRewardup);
        this.addDescription(list, this.draw1Card(), TextManager.cardDraw1Card);
        this.addDescription(list, this.gainVoltageUp(), TextManager.cardGainVoltageUp);
        this.addDescription(list, this.trashShieldPlus(), TextManager.cardTrashShieldPlus1, TextManager.cardTrashShieldPlus2);
        this.addDescription(list, this.fullBokki() > 0, TextManager.cardFullBokki);
        this.addDescription(list, this.useCardAtkUp(), TextManager.cardUseCardAtkUp1, TextManager.cardUseCardAtkUp2);
        this.addDescription(list, this.isMaintenance(), TextManager.cardMaintenance);
        this.addDescription(list, this.isEroIntelligence(), TextManager.baisyunState_eroIntelligence[0], TextManager.baisyunState_eroIntelligence[1]);
        this.addDescription(list, this.miwaku(), TextManager.baisyunState_miwaku[0], TextManager.baisyunState_miwaku[1]);
        this.addDescription(list, this.isEroBook(), TextManager.cardCostCut1, TextManager.cardCostCut2, ColorManager.normalColor(), TextManager.cardCostCut3);
        this.addDescription(list, this.drawCardCostMinus(), TextManager.cardDrawCardCostMinus1, TextManager.cardDrawCardCostMinus2, ColorManager.systemColor());
        if (this.attackCount() >= 2) {
            this.addDescription(list, this.attackCount(), TextManager.cardDoubleAttack);
        }
        return list;
    };
    BaisyunCard.prototype.addDescription = function (list, num, format1, format2, color, format3) {
        if (format2 === void 0) { format2 = null; }
        if (color === void 0) { color = ColorManager.normalColor(); }
        if (format3 === void 0) { format3 = null; }
        if (num == 0 || !num) {
            return;
        }
        var numStr = hankaku2ZenkakuUnder10(num);
        var text1 = format1.format(numStr);
        list.push(new CardDesc(text1, color));
        if (format2 == null) {
            return;
        }
        var text2 = format2.format(numStr);
        list.push(new CardDesc(text2, color));
        if (format3 == null) {
            return;
        }
        var text3 = format3.format(numStr);
        list.push(new CardDesc(text3, color));
    };
    BaisyunCard.prototype.alchemyDescription = function () {
        var desc = this.description();
        if (this.shield() > 0) {
            var text = TextManager.cardShield.format(hankaku2ZenkakuUnder10(this.shield()));
            desc.push(new CardDesc(text));
        }
        return desc;
    };
    BaisyunCard.prototype.costDown = function () {
        return this._costDown || 0;
    };
    BaisyunCard.prototype.attackCount = function () {
        return this.skill().repeats;
    };
    BaisyunCard.prototype.isFixDamage = function () {
        return this.skill().meta['fixDamage'];
    };
    BaisyunCard.prototype.turnDamage = function () {
        return this.parseValue('turnDamage');
    };
    BaisyunCard.prototype.isNeedNaked = function () {
        return this.skill().meta['needNaked'];
    };
    BaisyunCard.prototype.isNeedTakeOffBottom = function () {
        return this.skill().meta['needTakeOffBottom'];
    };
    BaisyunCard.prototype.isNeedTakeOffTop = function () {
        return this.skill().meta['needTakeOffTop'];
    };
    BaisyunCard.prototype.loseHp = function () {
        return this.parseValue('loseHp');
    };
    BaisyunCard.prototype.selectCard = function () {
        return this.parseValue('selectCard');
    };
    BaisyunCard.prototype.nudeAtkUp = function () {
        return this.parseValue('nudeAtkUp');
    };
    BaisyunCard.prototype.gainMana = function () {
        return this.parseValue('gainMana');
    };
    BaisyunCard.prototype.damageSkillId = function () {
        return this.parseValue('damageSkillId');
    };
    BaisyunCard.prototype.isDrawFinishCard = function () {
        return this.skill().meta['drawFinishCard'];
    };
    BaisyunCard.prototype.isBrainStorm = function () {
        return this.skill().meta['brainStorm'];
    };
    BaisyunCard.prototype.isEternalTopNude = function () {
        return this.skill().meta['eternalTopNude'];
    };
    BaisyunCard.prototype.isCostCut = function () {
        return this.skill().meta['costCut'];
    };
    BaisyunCard.prototype.defPlusByAttackCard = function () {
        return this.parseValue('defPlusByAttackCard');
    };
    BaisyunCard.prototype.openerDamage = function () {
        return this.parseValue('openerDamage');
    };
    BaisyunCard.prototype.parseValue = function (meta) {
        if (!this.skill().meta[meta]) {
            return 0;
        }
        return parseInt(this.skill().meta[meta]);
    };
    BaisyunCard.prototype.parseState = function (type, defaultValue) {
        if (defaultValue === void 0) { defaultValue = 0; }
        for (var _i = 0, _a = this.selfStateList(); _i < _a.length; _i++) {
            var s = _a[_i];
            if (s.type() == type) {
                return s.value();
            }
        }
        for (var _b = 0, _c = this.enemyStateList(); _b < _c.length; _b++) {
            var s = _c[_b];
            if (s.type() == type) {
                return s.value();
            }
        }
        return defaultValue;
    };
    BaisyunCard.prototype.defDownEternal = function () {
        return this.parseState(BaisyunStateType.defDownPlayerEternal);
    };
    BaisyunCard.prototype.notFinish = function () {
        return this.parseState(BaisyunStateType.notFinish);
    };
    BaisyunCard.prototype.draw1Card = function () {
        return this.parseState(BaisyunStateType.draw1Card);
    };
    BaisyunCard.prototype.gainVoltageUp = function () {
        return this.parseState(BaisyunStateType.gainVoltage);
    };
    BaisyunCard.prototype.shield = function () {
        return this.parseState(BaisyunStateType.shield, -1);
    };
    BaisyunCard.prototype.yuuwaku = function () {
        return this.parseState(BaisyunStateType.yuuwaku);
    };
    BaisyunCard.prototype.postNut = function () {
        return this.parseState(BaisyunStateType.postNutClarity);
    };
    BaisyunCard.prototype.costCutDef1 = function () {
        return this.skill().meta['costCutDef1'] != null;
    };
    BaisyunCard.prototype.excitement = function () {
        return this.parseState(BaisyunStateType.excitement);
    };
    BaisyunCard.prototype.calm = function () {
        return this.parseState(BaisyunStateType.calm);
    };
    BaisyunCard.prototype.miwaku = function () {
        return this.parseState(BaisyunStateType.miwaku);
    };
    BaisyunCard.prototype.isEroBook = function () {
        return this.parseState(BaisyunStateType.eroBook);
    };
    BaisyunCard.prototype.defDownEnemy = function () {
        return this.parseState(BaisyunStateType.defDownEnemy);
    };
    BaisyunCard.prototype.atkDown = function () {
        return this.parseState(BaisyunStateType.atkDown);
    };
    BaisyunCard.prototype.tactics = function () {
        return this.parseState(BaisyunStateType.tactics);
    };
    BaisyunCard.prototype.rewardup = function () {
        return this.parseState(BaisyunStateType.rewardup);
    };
    BaisyunCard.prototype.discardEffectCardId = function () {
        return this.parseValue('discardEffectCardId');
    };
    BaisyunCard.prototype.isFinish = function () {
        return this.skill().meta['finish'];
    };
    BaisyunCard.prototype.isTakeOffTop = function () {
        return this.takeOffTopCount() > 0;
    };
    BaisyunCard.prototype.takeOffTopCount = function () {
        return this.parseValue('takeOffTop');
    };
    BaisyunCard.prototype.weakness = function () {
        return this.parseState(BaisyunStateType.weakness);
    };
    BaisyunCard.prototype.isTakeOffBottom = function () {
        return this.takeOffBottomCount() > 0;
    };
    BaisyunCard.prototype.takeOffBottomCount = function () {
        return this.parseValue('takeOffBottom');
    };
    BaisyunCard.prototype.isTakeOffInnerTop = function () {
        return this.takeOffInnerTopCount() > 0;
    };
    BaisyunCard.prototype.takeOffInnerTopCount = function () {
        return this.parseValue('takeOffInnerTop');
    };
    BaisyunCard.prototype.isTakeOffInnerBottom = function () {
        return this.takeOffInnerBottomCount() > 0;
    };
    BaisyunCard.prototype.takeOffInnerBottomCount = function () {
        return this.parseValue('takeOffInnerBottom');
    };
    BaisyunCard.prototype.isNeedTakeOffInnerBottom = function () {
        return this.skill().meta['needTakeOffInnerBottom'];
    };
    BaisyunCard.prototype.isNeedTakeOffInnerTop = function () {
        return this.skill().meta['needTakeOffInnerTop'];
    };
    BaisyunCard.prototype.isNeedTop = function () {
        return this.skill().meta['needTop'];
    };
    BaisyunCard.prototype.isNeedBottom = function () {
        return this.skill().meta['needBottom'];
    };
    BaisyunCard.prototype.isExhaust = function () {
        return this.skill().meta['exhaust'];
    };
    BaisyunCard.prototype.isTemporary = function () {
        return this.skill().meta['temporary'];
    };
    BaisyunCard.prototype.isKaikyaku = function () {
        return this.hasSelfState(BaisyunStateType.kaikyaku);
    };
    BaisyunCard.prototype.isOnlyKaikyaku = function () {
        return this.skill().meta['onlyKaikyaku'];
    };
    BaisyunCard.prototype.addCardId = function () {
        return this.parseValue('addCardId');
    };
    BaisyunCard.prototype.addCardNum = function () {
        return this.parseValue('addCardNum');
    };
    BaisyunCard.prototype.takeOffPlus = function () {
        return this.parseValue('takeOffPlus');
    };
    BaisyunCard.prototype.poseId = function () {
        return this.parseValue('pose');
    };
    BaisyunCard.prototype.drawCardNum = function () {
        return this.parseValue('drawCard');
    };
    BaisyunCard.prototype.discardAll = function () {
        return this.parseValue('discardAll');
    };
    BaisyunCard.prototype.cardNumVoltage = function () {
        return this.parseValue('cardNumVoltage');
    };
    BaisyunCard.prototype.selfDamage = function () {
        return this.parseValue('selfDamage');
    };
    BaisyunCard.prototype.discardNum = function () {
        return this.parseValue('discardNum');
    };
    BaisyunCard.prototype.drawCardCostMinus = function () {
        return this.parseValue('drawCardCostMinus');
    };
    BaisyunCard.prototype.drawSyaseiCard = function () {
        return this.parseValue('drawSyaseiCard');
    };
    BaisyunCard.prototype.trashShieldPlus = function () {
        return this.parseValue('trashShieldPlus');
    };
    BaisyunCard.prototype.fullBokki = function () {
        return this.parseState(BaisyunStateType.fullBokki);
    };
    BaisyunCard.prototype.useCardAtkUp = function () {
        return this.parseValue('useCardAtkUp');
    };
    BaisyunCard.prototype.isMaintenance = function () {
        return this.parseValue('maintenance') > 0;
    };
    BaisyunCard.prototype.isEroIntelligence = function () {
        return this.parseValue('eroIntelligence') > 0;
    };
    BaisyunCard.prototype.evalDamageFormula = function () {
        try {
            var item = this.skill();
            var a = this.actor(); // eslint-disable-line no-unused-vars
            var value = Math.max(eval(item.damage.formula), 0);
            return isNaN(value) ? 0 : value;
        }
        catch (e) {
            return 0;
        }
    };
    BaisyunCard.prototype.actorId = function () {
        return this._actorId;
    };
    BaisyunCard.prototype.actor = function () {
        return $gameActors.actor(this._actorId);
    };
    BaisyunCard.prototype.isAttack = function () {
        var s = this.skill();
        return s.damage.type == 1;
    };
    BaisyunCard.prototype.damageValue = function () {
        return this.evalDamageFormula();
    };
    BaisyunCard.prototype.animationId = function () {
        return this.skill().animationId;
    };
    BaisyunCard.prototype.hoppeId = function () {
        var hoppeId = parseInt(this.skill().meta['hoppe']);
        if (hoppeId > 0) {
            return hoppeId;
        }
        return 0;
    };
    BaisyunCard.prototype.faceId = function () {
        var face = this.skill().meta['face'];
        if (!face) {
            return 1;
        }
        var faceId = parseInt(face);
        if (faceId > 0) {
            return faceId;
        }
        switch (face) {
            case '笑': return 2;
            case '明': return 3;
            case '困': return 4;
            case '呆': return 5;
            case '考': return 6;
            case '驚': return 7;
            case '怒': return 8;
            case '悲': return 9;
            case '恥': return 10;
            case '閉': return 12;
        }
        return 0;
    };
    BaisyunCard.prototype.message1 = function (actorId) {
        return ActorTalkManager.actorTalk(this, actorId);
    };
    BaisyunCard.prototype.message2 = function () {
        return this.skill().message2;
    };
    BaisyunCard.prototype.hasSelfState = function (type) {
        for (var _i = 0, _a = this.skill().effects; _i < _a.length; _i++) {
            var e = _a[_i];
            var s = this.makeState(e);
            if (s) {
                if (s.toSelf()) {
                    if (s.selectType() == type) {
                        return true;
                    }
                }
            }
        }
        return false;
    };
    BaisyunCard.prototype.selfStateList = function () {
        var result = [];
        for (var _i = 0, _a = this.skill().effects; _i < _a.length; _i++) {
            var e = _a[_i];
            var s = this.makeState(e);
            if (s) {
                if (s.toSelf()) {
                    result.push(s);
                }
            }
        }
        return result;
    };
    BaisyunCard.prototype.enemyStateList = function () {
        var result = [];
        for (var _i = 0, _a = this.skill().effects; _i < _a.length; _i++) {
            var e = _a[_i];
            var s = this.makeState(e);
            if (s) {
                if (s.toEnemy()) {
                    result.push(s);
                }
            }
        }
        return result;
    };
    BaisyunCard.prototype.makeState = function (effect) {
        switch (effect.code) {
            case Game_Action.EFFECT_ADD_STATE:
                var value = Math.round(effect.value1 * 100 - 100);
                var stateId = effect.dataId;
                return new BaisyunState(stateId, value);
            case Game_Action.EFFECT_REMOVE_STATE:
                //this.itemEffectRemoveState(target, effect);
                break;
        }
        return null;
    };
    BaisyunCard.prototype.canUse = function (battle) {
        if (!this.canPayCost(battle)) {
            return false;
        }
        if (!this.isCostumeOk(battle)) {
            return false;
        }
        if (!this.isTargetOk(battle)) {
            return false;
        }
        if (!this.isStateOk(battle)) {
            return false;
        }
        if (!this.isTakeOffOk(battle)) {
            return false;
        }
        if (this.cantFinish(battle)) {
            return false;
        }
        if (this.isHpZero(battle)) {
            return false;
        }
        return true;
    };
    BaisyunCard.prototype.cantFinish = function (battle) {
        if (!this.isFinish()) {
            return false;
        }
        if (battle.enemy().hasState(BaisyunStateType.nenchakushitsu)) {
            return false;
        }
        if (battle.player().hasState(BaisyunStateType.notFinish)) {
            return false;
        }
        var damage = battle.calcDamage(this);
        var e = battle.enemy();
        if (e.voltageRank() != VoltageRank.D) {
            return false;
        }
        var enemy = JsonEx.makeDeepCopy(e);
        enemy.plusVoltage(damage);
        return enemy.voltageRank() == VoltageRank.D;
    };
    BaisyunCard.prototype.isHpZero = function (battle) {
        if (!battle) {
            return false;
        }
        if (this.isLoseHpZero(battle)) {
            return true;
        }
        if (this.isSelfDamageZero(battle)) {
            return true;
        }
        return false;
    };
    BaisyunCard.prototype.isLoseHpZero = function (battle) {
        if (this.loseHp() == 0) {
            return false;
        }
        if (battle.player().hp() > this.loseHp()) {
            return false;
        }
        return true;
    };
    BaisyunCard.prototype.isSelfDamageZero = function (battle) {
        if (this.selfDamage() == 0) {
            return false;
        }
        var player = battle.player();
        var clone = JsonEx.makeDeepCopy(player);
        clone.setClone(true);
        clone.selfDamage(this.selfDamage());
        if (clone.hp() > 0) {
            return false;
        }
        return true;
    };
    BaisyunCard.prototype.isTakeOffOk = function (battle) {
        // 二重に服を脱ぐのはOKにしました。
        /*
        const player = battle.player();
        if (this.isTakeOffBottom() && player.isTakeOffBottom()) {
            return false;
        }
        if (this.isTakeOffTop() && player.isTakeOffTop()) {
            return false;
        }
        if (this.isTakeOffInnerBottom() && player.isTakeOffInnerBottom()) {
            return false;
        }
        if (this.isTakeOffInnerTop() && player.isTakeOffInnerTop()) {
            return false;
        }
        */
        return true;
    };
    BaisyunCard.prototype.canPayCost = function (battle) {
        if (this.manaCost(battle) > battle.mana()) {
            return false;
        }
        if (this.timeCost() > battle.remainTime()) {
            return false;
        }
        return true;
    };
    BaisyunCard.prototype.isCostumeOk = function (battle) {
        var player = battle.player();
        if (this.isNeedTop() && player.isTakeOffTop()) {
            return false;
        }
        if (this.isNeedTakeOffTop() && !player.isTakeOffTop()) {
            return false;
        }
        if (this.isNeedTakeOffBottom() && !player.isTakeOffBottom()) {
            return false;
        }
        if (this.isNeedTakeOffInnerBottom() && !player.isTakeOffInnerBottom()) {
            return false;
        }
        if (this.isNeedTakeOffInnerTop() && !player.isTakeOffInnerTop()) {
            return false;
        }
        return true;
    };
    BaisyunCard.prototype.isTargetOk = function (battle) {
        // 女相手にフェラとかするのはOKにしました
        /*if (this.isManOnly() && ! battle.enemy().isMan()) {
            return false;
        }*/
        return true;
    };
    BaisyunCard.prototype.isStateOk = function (battle) {
        var player = battle.player();
        if (this.isOnlyKaikyaku() && !player.hasState(BaisyunStateType.kaikyaku)) {
            return false;
        }
        return true;
    };
    BaisyunCard.prototype.isSpecialEffectAvailable = function (battle) {
        if (this.openerDamage() > 0) {
            if (battle.isOpenerEffective()) {
                return true;
            }
        }
        var player = battle.player();
        if (this.isOnlyKaikyaku() && player.hasState(BaisyunStateType.kaikyaku)) {
            return true;
        }
        if (this.isSyasei() && player.bokki() >= player.syaseiBokki()) {
            return true;
        }
        if (this.isHeisei() && player.isHeisei()) {
            return true;
        }
        if (this.costCutDef1()) {
            if (battle.hand().countCard(CardType.attack, this) == 0) {
                return true;
            }
        }
        if (this.isNeedTakeOffTop() && player.isTakeOffTop()) {
            return true;
        }
        return false;
    };
    BaisyunCard.prototype.cardType = function () {
        switch (this.skill().stypeId) {
            case 5: return CardType.attack;
            case 6: return CardType.guard;
            case 7: return CardType.skill;
            case 8: return CardType.finish;
            case 9: return CardType.disturbance;
            case 10: return CardType.power;
        }
        return CardType.none;
    };
    BaisyunCard.prototype.rare = function () {
        switch (this.skill().meta['rare']) {
            case CardRare.N: return CardRare.N;
            case CardRare.R: return CardRare.R;
            case CardRare.SR: return CardRare.SR;
            default:
                console.error('不正なレアです:' + this.skill().meta['rare']);
                p(this.skill().id);
        }
    };
    BaisyunCard.prototype.scenario = function (battle) {
        var ex = this.scenarioEx();
        if (ex) {
            var player = battle.player();
            if (player.bokki() >= player.syaseiBokki()) {
                return ex;
            }
        }
        return this.skill().meta['scenario'];
    };
    BaisyunCard.prototype.scenario2 = function (battle) {
        var ex = this.scenarioEx2();
        if (ex) {
            var player = battle.player();
            if (player.bokki() >= player.syaseiBokki()) {
                return ex;
            }
        }
        return this.skill().meta['scenario2'];
    };
    BaisyunCard.prototype.scenarioEx = function () {
        return this.skill().meta['scenarioEx'];
    };
    BaisyunCard.prototype.scenarioEx2 = function () {
        return this.skill().meta['scenarioEx2'];
    };
    BaisyunCard.prototype.sortValue = function () {
        return this._skillId + this.rareSortValue() + this.categorySortValue();
    };
    BaisyunCard.prototype.categorySortValue = function () {
        switch (this.cardType()) {
            case CardType.attack: return 500000;
            case CardType.guard: return 400000;
            case CardType.skill: return 300000;
            case CardType.finish: return 200000;
            case CardType.power: return 100000;
        }
        return 0;
    };
    BaisyunCard.prototype.rareSortValue = function () {
        switch (this.rare()) {
            case CardRare.N: return 0;
            case CardRare.R: return 1000;
            case CardRare.SR: return 10000;
        }
        return 0;
    };
    BaisyunCard.prototype.isFella = function () {
        return this.skill().meta['fella'] != null;
    };
    BaisyunCard.prototype.isBokki = function () {
        return this.skill().meta['bokki'];
    };
    BaisyunCard.prototype.bokki = function () {
        if (this.skill().meta['bokki']) {
            return parseInt(this.skill().meta['bokki']);
        }
        return 0;
    };
    BaisyunCard.prototype.isShowCrotch = function () {
        return this.skill().meta['showCrotch'];
    };
    BaisyunCard.prototype.isSyasei = function () {
        return this.skill().meta['syasei'];
    };
    BaisyunCard.prototype.isHeisei = function () {
        return this.skill().meta['heisei'];
    };
    BaisyunCard.prototype.effects = function () {
        var result = [];
        if (this.isRetain()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.retain));
        }
        if (this.openerDamage() > 0) {
            result.push(new BaisyunCardHelp(BaisyunEffect.opener));
        }
        if (this.isTakeOffTop()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.takeOffTop));
        }
        if (this.isTakeOffInnerTop()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.takeOffInnerTop));
        }
        if (this.isTakeOffBottom()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.takeOffBottom));
        }
        if (this.weakness() > 0) {
            result.push(new BaisyunCardHelp(BaisyunEffect.weakness));
        }
        if (this.isSyasei()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.syasei));
        }
        if (this.isHeisei()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.heisei));
        }
        if (this.isChien()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.chien));
        }
        if (this.defDownEnemy() > 0) {
            result.push(new BaisyunCardHelp(BaisyunEffect.defDownEnemy));
        }
        if (this.yuuwaku() > 0) {
            result.push(new BaisyunCardHelp(BaisyunEffect.yuuwaku));
        }
        if (this.notFinish() > 0) {
            result.push(new BaisyunCardHelp(BaisyunEffect.notFinish));
        }
        if (this.draw1Card() > 0) {
            result.push(new BaisyunCardHelp(BaisyunEffect.draw1Card));
        }
        if (this.nudeAtkUp() > 0) {
            result.push(new BaisyunCardHelp(BaisyunEffect.nudeAtkUp));
        }
        if (this.isFinish()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.finish));
        }
        if (this.isTemporary()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.temporary));
        }
        if (this.isExhaust()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.exhaust));
        }
        if (this.excitement() > 0) {
            result.push(new BaisyunCardHelp(BaisyunEffect.excitement));
        }
        if (this.calm() > 0) {
            result.push(new BaisyunCardHelp(BaisyunEffect.calm));
        }
        if (this.cardType() == CardType.power) {
            result.push(new BaisyunCardHelp(BaisyunEffect.power));
        }
        if (this.isKaikyaku()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.kaikyaku));
        }
        if (this.gainVoltageUp() > 0) {
            result.push(new BaisyunCardHelp(BaisyunEffect.gainVoltage));
        }
        if (this.drawSyaseiCard() > 0) {
            result.push(new BaisyunCardHelp(BaisyunEffect.drawSyaseiCard));
        }
        if (this.isBokki()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.bokki));
        }
        if (this.fullBokki() > 0) {
            result.push(new BaisyunCardHelp(BaisyunEffect.fullBokki));
        }
        /*
        // 数が増えたらキーワードにする
        if (this.isMaintenance()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.maintenance));
        }
        */
        if (this.isTenpu()) {
            result.push(new BaisyunCardHelp(BaisyunEffect.tenpu));
        }
        return result;
    };
    BaisyunCard.prototype.syaseiVoltage = function () {
        return this.parseValue('syaseiVoltage');
    };
    BaisyunCard.prototype.heiseiShield = function () {
        return this.parseValue('heiseiShield');
    };
    BaisyunCard.prototype.heiseiBokki = function () {
        return this.parseValue('heiseiBokki');
    };
    BaisyunCard.prototype.syaseiDesc = function () {
        return '+' + TextManager.cardAttack2.format(this.syaseiVoltage());
    };
    BaisyunCard.prototype.heiseiDesc = function () {
        if (this.heiseiShield() > 0) {
            return '+' + TextManager.cardShield2.format(this.heiseiShield());
        }
        if (this.heiseiBokki() > 0) {
            return '+' + TextManager.cardBokki2.format(this.heiseiBokki());
        }
        console.error('不正な平静カードです');
        console.error(this);
    };
    BaisyunCard.prototype.isTenpu = function () {
        if (this.skill().meta['tenpu']) {
            return true;
        }
        var maseki = this.maseki();
        if (maseki && maseki.isTenpu()) {
            return true;
        }
        return false;
    };
    BaisyunCard.prototype.isChien = function () {
        if (this.skill().meta['chien']) {
            return true;
        }
        var maseki = this.maseki();
        if (maseki && maseki.isChien()) {
            return true;
        }
        return false;
    };
    BaisyunCard.prototype.isRetain = function () {
        if (this.skill().meta['retain']) {
            return true;
        }
        var maseki = this.maseki();
        if (maseki && maseki.isRetain()) {
            return true;
        }
        return false;
    };
    BaisyunCard.prototype.onRetain = function () {
        if (!this.isMaintenance()) {
            return;
        }
        this._maintemance += 1;
    };
    BaisyunCard.prototype.masekiVoltage = function () {
        var maseki = this.maseki();
        if (maseki) {
            return maseki.voltageUp();
        }
        return 0;
    };
    BaisyunCard.prototype.masekiShield = function () {
        var maseki = this.maseki();
        if (maseki) {
            return maseki.shieldUp();
        }
        return 0;
    };
    BaisyunCard.prototype.isRecoverType = function () {
        if (this.gainMana() > 0) {
            return true;
        }
        return false;
    };
    BaisyunCard.prototype.isNama = function () {
        return this.skill().meta['nama'] != null;
    };
    BaisyunCard.prototype.isManOnly = function () {
        return this.skill().meta['manOnly'] != null;
    };
    BaisyunCard.prototype.setDrawn = function () {
        this._drawn = true;
    };
    BaisyunCard.prototype.onTrash = function () {
        this._drawn = false;
        this._costDown = 0;
        this._maintemance = 0;
    };
    return BaisyunCard;
}());
