var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Sprite_CardMove = /** @class */ (function (_super) {
    __extends(Sprite_CardMove, _super);
    function Sprite_CardMove() {
        var _this = _super.call(this) || this;
        _this.addSprite();
        _this.x = 750;
        _this.y = 100;
        _this._wait = 39;
        return _this;
    }
    Sprite_CardMove.prototype.addSprite = function () {
        this.bitmap = ImageManager.loadSystem('card_shuffle');
    };
    Sprite_CardMove.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._finished) {
            return;
        }
        this.updateMove();
        this.checkFinish();
    };
    Sprite_CardMove.prototype.updateMove = function () {
        this.x -= 20;
    };
    Sprite_CardMove.prototype.checkFinish = function () {
        if (this._wait > 0) {
            this._wait--;
            if (this._wait <= 0) {
                this._finished = true;
                this.visible = false;
            }
        }
    };
    Sprite_CardMove.prototype.isFinished = function () {
        return this._finished;
    };
    return Sprite_CardMove;
}(Sprite));
var Sprite_CardShuffle = /** @class */ (function (_super) {
    __extends(Sprite_CardShuffle, _super);
    function Sprite_CardShuffle(cardNum) {
        var _this = _super.call(this) || this;
        _this.bitmap = new Bitmap(800, 100);
        _this.refresh();
        _this._wait = 120;
        _this._cardNum = cardNum;
        _this._cardList = [];
        _this.x = 30;
        _this.y = 550;
        return _this;
    }
    Sprite_CardShuffle.prototype.refresh = function () {
        //this.bitmap.fillRect(0, 0, 700, 80, '#222222');
        //this.bitmap.drawText('カードが右から左に移動するシャッフル演出が入る', 0, 20, 700, 32, 'center');
    };
    Sprite_CardShuffle.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._empty) {
            this.checkFinish();
            return;
        }
        if (this._wait > 0) {
            if (this._wait % 20 == 9) {
            }
            if (this._wait % 4 == 0) {
                AudioManager.playSe({ name: 'card_DrawFantasyEastern', volume: 80, pitch: 150, pan: 0 });
                this.addCard();
            }
            this._wait--;
        }
    };
    Sprite_CardShuffle.prototype.checkFinish = function () {
        for (var _i = 0, _a = this._cardList; _i < _a.length; _i++) {
            var c = _a[_i];
            if (!c.isFinished()) {
                return;
            }
        }
        this._finished = true;
    };
    Sprite_CardShuffle.prototype.isFinished = function () {
        return this._finished;
    };
    Sprite_CardShuffle.prototype.addCard = function () {
        if (this._cardNum <= 0) {
            this._empty = true;
            return;
        }
        this._cardNum--;
        var c = new Sprite_CardMove();
        this.addChild(c);
        this._cardList.push(c);
    };
    return Sprite_CardShuffle;
}(Sprite));
