var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Window_BaisyunCardList = /** @class */ (function (_super) {
    __extends(Window_BaisyunCardList, _super);
    function Window_BaisyunCardList() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Window_BaisyunCardList.prototype.drawAllItems = function () {
        this._windowContentsSprite.removeChildren();
        _super.prototype.drawAllItems.call(this);
    };
    Window_BaisyunCardList.prototype.drawCardItem = function (rect, card) {
        var ui = new Sprite_Card();
        var ww = CARD_WIDTH;
        var hh = CARD_HEIGHT;
        ui.x = rect.x + CARD_WIDTH / 2 + 18;
        ui.y = rect.y + hh / 2 + 18;
        var innerRect = new Rectangle(0, 0, ww, hh);
        ui.drawCardItem(innerRect, card, CardScale.normal, null);
        this._windowContentsSprite.addChild(ui);
        return ui;
    };
    return Window_BaisyunCardList;
}(Window_Selectable));
var CardScale;
(function (CardScale) {
    CardScale[CardScale["normal"] = 1] = "normal";
    CardScale[CardScale["big"] = 2] = "big";
})(CardScale || (CardScale = {}));
var CARD_WIDTH = 200;
var CARD_HEIGHT = 300;
var Sprite_Drawable = /** @class */ (function (_super) {
    __extends(Sprite_Drawable, _super);
    function Sprite_Drawable() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Sprite_Drawable.prototype.changeTextColor = function (color) {
        this.bitmap.textColor = color;
    };
    Sprite_Drawable.prototype.drawText = function (text, x, y, maxWidth, align) {
        this.bitmap.drawText(text, x, y, maxWidth, this.lineHeight(), align);
    };
    Sprite_Drawable.prototype.lineHeight = function () {
        return 36;
    };
    return Sprite_Drawable;
}(Sprite));
var Sprite_CardCost = /** @class */ (function (_super) {
    __extends(Sprite_CardCost, _super);
    function Sprite_CardCost() {
        var _this = _super.call(this) || this;
        _this.createBitmap();
        _this.x = -99;
        _this.y = -149;
        return _this;
    }
    Sprite_CardCost.prototype.createBitmap = function () {
        this.bitmap = new Bitmap(70, 62);
        this.bitmap.fontSize = 24;
        this.bitmap.fontBold = true;
    };
    Sprite_CardCost.prototype.draw = function (card, canUse, battle) {
        this.bitmap.clear();
        this.drawTargetBitmap(card, canUse, this.bitmap, 0, 0, 1, battle);
    };
    Sprite_CardCost.prototype.drawTargetBitmap = function (card, canUse, bitmap, x, y, scale, battle) {
        if (scale === void 0) { scale = 1; }
        if (battle === void 0) { battle = null; }
        if (card.isFinish()) {
            this.drawFinish(card, canUse, bitmap, x, y, scale);
        }
        else {
            this.drawCost(card, canUse, bitmap, x, y, scale, battle);
        }
    };
    Sprite_CardCost.prototype.drawCost = function (card, canUse, bitmap, x, y, scale, battle) {
        this.drawCostBg(card, canUse, bitmap, x, y, scale);
        this.drawCostNum(card, canUse, bitmap, x, y, scale, battle);
    };
    Sprite_CardCost.prototype.drawCostBg = function (card, canUse, bitmap, x, y, scale) {
        var b;
        if (canUse) {
            b = ImageManager.loadSystem('card_cost');
        }
        else {
            b = ImageManager.loadSystem('card_cost2');
        }
        if (scale == 1) {
            bitmap.blt(b, 0, 0, b.width, b.height, x, y);
        }
        else {
            bitmap.blt(b, 0, 0, b.width, b.height, x, y, b.width * scale, b.height * scale);
        }
    };
    Sprite_CardCost.prototype.drawCostNum = function (card, canUse, bitmap, x, y, scale, battle) {
        var b = this.selectCostNumImage(card, canUse, battle);
        var cost = card.manaCost(battle);
        var w = 59;
        if (scale == 1) {
            bitmap.blt(b, w * cost, 0, w, b.height, x + 1, y + 2);
        }
        else {
            bitmap.blt(b, w * cost, 0, w, b.height, x + 1, y + 2, w * scale, b.height * scale);
        }
    };
    Sprite_CardCost.prototype.selectCostNumImage = function (card, canUse, battle) {
        if (canUse) {
            if (card.manaCostDown(battle) > 0) {
                return ImageManager.loadSystem('card_num3');
            }
            else {
                return ImageManager.loadSystem('card_num');
            }
        }
        else {
            return ImageManager.loadSystem('card_num2');
        }
    };
    Sprite_CardCost.prototype.drawFinish = function (card, canUse, bitmap, x, y, scale) {
        this.drawCostBg(card, canUse, bitmap, x, y, scale);
        var disable = canUse ? '' : '2';
        var post = card.actorId() == 3 ? '_man' : '';
        var b = ImageManager.loadSystem('card_finish' + post + disable);
        if (scale == 1) {
            bitmap.blt(b, 0, 0, b.width, b.height, x + 8, y + 2);
        }
        else {
            bitmap.blt(b, 0, 0, b.width, b.height, x + 8, y + 2, b.width * scale, b.height * scale);
        }
    };
    return Sprite_CardCost;
}(Sprite_Drawable));
var ShieldInfo = /** @class */ (function () {
    function ShieldInfo(shield) {
        this._halfDef = false;
        this._plus = 0;
        this._shield = shield;
    }
    ShieldInfo.prototype.halfDef = function () {
        return this._halfDef;
    };
    ShieldInfo.prototype.setHalfDef = function (b) {
        this._halfDef = b;
    };
    ShieldInfo.prototype.plus = function () {
        return this._plus;
    };
    ShieldInfo.prototype.setPlus = function (n) {
        this._plus = n;
    };
    ShieldInfo.prototype.setShield = function (n) {
        this._shield = n;
    };
    ShieldInfo.prototype.shield = function () {
        return this._shield;
    };
    return ShieldInfo;
}());
var Sprite_Card = /** @class */ (function (_super) {
    __extends(Sprite_Card, _super);
    function Sprite_Card() {
        var _this = _super.call(this) || this;
        _this.bitmap = new Bitmap(CARD_WIDTH, CARD_HEIGHT);
        _this.anchor.x = 0.5;
        _this.anchor.y = 0.5;
        _this._costSprite = new Sprite_CardCost();
        _this.addChild(_this._costSprite);
        return _this;
    }
    Sprite_Card.prototype.drawCardItem = function (rect, card, scale, battle) {
        var canUse = this.canUse(card);
        this.drawCardFrame(card, rect);
        this.drawCardRare(card, rect, scale);
        this.drawCostSprite(card, rect, canUse, battle);
        this.drawName(card, rect, canUse, scale);
        this.drawImage(card, rect);
        this.drawMaseki(card, rect);
        this.drawDescription(card, rect);
    };
    Sprite_Card.prototype.drawNewCard = function () {
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        this.bitmap.blt(bitmap, 550, 0, 100, 50, 15, 50);
    };
    Sprite_Card.prototype.drawCostSprite = function (card, rect, canUse, battle) {
        this._costSprite.draw(card, canUse, battle);
    };
    Sprite_Card.prototype.drawMaseki = function (card, rect) {
        var maseki = card.maseki();
        if (!maseki) {
            return;
        }
        this.drawIcon(maseki.iconIndex(), rect.x + 10, rect.y + 46);
    };
    Sprite_Card.prototype.canUse = function (card) {
        return true;
    };
    Sprite_Card.prototype.drawCardFrame = function (card, rect) {
        var frame = ImageManager.loadSystem(this.selectCardImage(card));
        this.bitmap.blt(frame, 14, 8, rect.width, rect.height, 0, 0);
    };
    Sprite_Card.prototype.selectCardImage = function (card) {
        switch (card.cardType()) {
            case CardType.attack: return 'card_frame';
            case CardType.guard: return 'card_frame2';
            case CardType.skill: return 'card_frame3';
            case CardType.finish: return 'card_frame6';
            case CardType.disturbance: return 'card_frame5';
            case CardType.power: return 'card_frame4';
        }
    };
    Sprite_Card.prototype.isSpecialEffectAvailable = function (card) {
        return false;
    };
    Sprite_Card.prototype.drawCardRare = function (card, rect, scale) {
        var b = ImageManager.loadSystem('card_rare');
        var h = 40;
        var index = 0;
        switch (card.rare()) {
            case CardRare.R:
                index = 1;
                break;
            case CardRare.SR:
                index = 2;
                break;
        }
        this.bitmap.blt(b, 0, h * index, b.width, h, 37, 9);
    };
    Sprite_Card.prototype.drawCost = function (card, rect, canUse) {
        this.bitmap.fontSize = 24;
        this.bitmap.fontBold = true;
        if (canUse) {
            this.changeTextColor(ColorManager.costColor());
        }
        else {
            this.changeTextColor(ColorManager.textColor(8));
        }
        this.drawText(card.manaCost(), rect.x + 4, rect.y, rect.width, 'left');
    };
    Sprite_Card.prototype.drawName = function (card, rect, canUse, scale) {
        this.bitmap.textColor = this.cardNameColor(canUse);
        this.bitmap.outlineColor = '#361800';
        this.bitmap.outlineWidth = 6;
        this.bitmap.fontBold = false;
        this.bitmap.fontSize = ConfigManager.isJp() ? 19 : 17;
        this.drawText(card.name(this.outerId()), rect.x + 61, rect.y + 10, rect.width - 78, 'center');
        this.bitmap.outlineColor = ColorManager.outlineColor();
    };
    Sprite_Card.prototype.cardNameColor = function (canUse) {
        if (canUse) {
            return '#FFFFFF';
        }
        else {
            return '#888888ff';
        }
    };
    Sprite_Card.prototype.drawImage = function (card, rect) {
        var iconIndex = card.iconIndex(this.outerId());
        if (this.is3xBigIcon(iconIndex)) {
            var odd = Math.floor(iconIndex / 16) % 2 == 1;
            this.drawIconBig3x(iconIndex - 64 * 16, rect.x + rect.width / 2 - 64, rect.y + 38, odd);
        }
        else {
            this.drawIcon(iconIndex, rect.x + rect.width / 2 - 16, rect.y + 76);
        }
    };
    Sprite_Card.prototype.outerId = function () {
        if (!$gameParty.inBaisyun()) {
            return null;
        }
        if (!$gameSystem.baisyunActor()) {
            return null;
        }
        return $gameSystem.baisyunActor().outerId;
    };
    Sprite_Card.prototype.drawIconBig3x = function (iconIndex, x, y, odd) {
        var bitmap = ImageManager.loadSystem("card_image");
        var pw = ImageManager.iconWidth * 6;
        var ph = ImageManager.iconHeight * 4;
        var sx;
        if (odd) {
            sx = ((iconIndex - 1) % 16) / 2 * pw;
        }
        else {
            sx = (iconIndex % 16) / 2 * pw;
        }
        var offsetX = 12;
        var offsetY = 8;
        var sy = Math.floor(iconIndex / 16) * ph + offsetY;
        sx += offsetX;
        var sw = pw - offsetX - 9;
        var sh = ph - offsetY - 10;
        this.bitmap.blt(bitmap, sx, sy, sw, sh, x - 32 + offsetX, y + offsetY);
    };
    Sprite_Card.prototype.is3xBigIcon = function (iconIndex) {
        var line = Math.floor(iconIndex / 16);
        switch (line) {
            case 64:
            case 65:
            case 66:
            case 67:
            case 68:
            case 69:
            case 70:
            case 71:
            case 72:
            case 73:
            case 74:
                return true;
        }
        return false;
    };
    Sprite_Card.prototype.drawDescription = function (card, rect) {
        this.bitmap.fontSize = 15;
        this.bitmap.fontBold = false;
        var index = this.drawDamage(card, rect, 0);
        index += this.drawShield(card, rect, index);
        index = this.drawExhaust(card, rect, index);
        index = this.drawRetain(card, rect, index);
        index = this.drawTemporary(card, rect, index);
        var descList = card.description();
        for (var i = 0; i < descList.length; i++) {
            var d = descList[i];
            this.changeTextColor(d.color());
            this.drawDescOne(d.text(), rect, index);
            index++;
        }
        index = this.drawAddStates(card, rect, index);
        index = this.drawCostumes(card, rect, index);
        index = this.drawBokki(card, rect, index);
        index = this.drawHeisei(card, rect, index);
        index = this.drawConditions(card, rect, index);
        index = this.drawKaikyaku(card, rect, index);
        index = this.drawSelectCard(card, rect, index);
        index = this.drawFinish(card, rect, index);
        index = this.drawNama(card, rect, index);
        index = this.drawSelfDamage(card, rect, index);
        index = this.drawHpZero(card, rect, index);
        index = this.drawDiscardEffect(card, rect, index);
        //index = this.drawDrawCardCostMinus(card, rect, index);
        index = this.drawMasekiEffect(card, rect, index);
    };
    Sprite_Card.prototype.drawDamage = function (card, rect, index, color) {
        if (color === void 0) { color = null; }
        var s = card.skill();
        if (s.damage.type != 1) {
            return 0;
        }
        var value = card.damageValue();
        var plus = 0;
        if ($gameParty.inBattle()) {
            var battle = this.baisyunBattle();
            if (battle) {
                plus = battle.calcDamagePlus(card, value);
            }
        }
        this.bitmap.textColor = ColorManager.cardDamageColor(plus);
        if (color) {
            this.bitmap.textColor = color;
        }
        var text = TextManager.cardAttack.format(hankaku2ZenkakuUnder10(value + plus));
        this.drawDescOne(text, rect, index);
        this.bitmap.textColor = ColorManager.normalColor();
        return 1;
    };
    Sprite_Card.prototype.calcDamagePlus = function (card, value) {
        if (!this.baisyunBattle()) {
            return 0;
        }
        return this.baisyunBattle().calcDamagePlus(card, value);
    };
    Sprite_Card.prototype.drawShield = function (card, rect, index, color) {
        if (color === void 0) { color = null; }
        var s = card.shield();
        if (s < 0) {
            return 0;
        }
        var shildInfo = this.calcShieldInfo(card);
        this.setShieldColor(shildInfo.halfDef(), shildInfo.plus(), color);
        var text = TextManager.cardShield.format(hankaku2ZenkakuUnder10(shildInfo.shield()));
        this.drawDescOne(text, rect, index);
        return 1;
    };
    Sprite_Card.prototype.calcShieldInfo = function (card) {
        var value = card.shield();
        var result = new ShieldInfo(value);
        if (!$gameParty.inBattle()) {
            return result;
        }
        var battle = this.baisyunBattle();
        if (!battle) {
            return result;
        }
        return battle.calcShieldInfo(card);
    };
    Sprite_Card.prototype.setShieldColor = function (halfDef, plus, color) {
        if (color) {
            this.bitmap.textColor = color;
        }
        else if (halfDef) {
            this.bitmap.textColor = ColorManager.disableColor();
        }
        else {
            if (plus > 0) {
                this.bitmap.textColor = ColorManager.crisisColor();
            }
            else {
                this.bitmap.textColor = ColorManager.cardTextColor();
            }
        }
    };
    Sprite_Card.prototype.baisyunEnemy = function () {
        var battle = this.baisyunBattle();
        if (!battle) {
            return null;
        }
        return battle.enemy();
    };
    Sprite_Card.prototype.baisyunBattle = function () {
        return null;
    };
    Sprite_Card.prototype.openerEffective = function () {
        if (!this.baisyunBattle()) {
            return false;
        }
        return this.baisyunBattle().isOpenerEffective();
    };
    Sprite_Card.prototype.drawTemporary = function (card, rect, index) {
        if (card.isTemporary()) {
            this.drawDescOne(TextManager.cardTemporary, rect, index);
            index++;
        }
        return index;
    };
    Sprite_Card.prototype.drawAddStates = function (card, rect, index) {
        if (card.weakness() > 0) {
            var value = hankaku2Zenkaku(card.weakness());
            this.drawDescOne(TextManager.cardWeakness.format(value), rect, index);
            index++;
        }
        return index;
    };
    Sprite_Card.prototype.drawBokki = function (card, rect, index, color) {
        if (color === void 0) { color = null; }
        if (color) {
            this.bitmap.textColor = color;
        }
        else {
            this.bitmap.textColor = ColorManager.cardTextColor();
        }
        if (card.isBokki()) {
            this.drawDescOne(TextManager.cardBokki.format(card.bokki()), rect, index);
            index++;
        }
        if (card.isSyasei()) {
            var syaseiDesc = card.syaseiDesc();
            this.drawDescOne(TextManager.cardSyasei.format(syaseiDesc), rect, index);
            index++;
        }
        return index;
    };
    Sprite_Card.prototype.drawHeisei = function (card, rect, index) {
        if (card.isHeisei()) {
            var inBattle = $gameParty.inBattle();
            var player = this.baisyunPlayer();
            if (inBattle && player.bokki() == 0) {
                this.changeTextColor(ColorManager.effectiveColor());
            }
            var heiseiDesc = card.heiseiDesc();
            this.drawDescOne(TextManager.cardHeisei.format(heiseiDesc), rect, index);
            index++;
        }
        return index;
    };
    Sprite_Card.prototype.drawCostumes = function (card, rect, index) {
        var player = this.baisyunPlayer();
        this.changeTextColor(ColorManager.costumeColor());
        if (card.isTakeOffTop()) {
            var n = card.takeOffTopCount();
            var turnText = TextManager.cardTurn.format(n);
            if (player.isEternal(BaisyunStateType.takeOffTop)) {
                turnText = TextManager.cardTurnEternal;
            }
            this.drawDescOne(TextManager.cardTopHalfNaked.format(turnText), rect, index);
            index++;
        }
        if (card.isTakeOffBottom()) {
            var n = card.takeOffBottomCount();
            var turnText = TextManager.cardTurn.format(n);
            if (player.isEternal(BaisyunStateType.takeOffBottom)) {
                turnText = TextManager.cardTurnEternal;
            }
            this.drawDescOne(TextManager.cardBottomHalfNaked.format(turnText), rect, index);
            index++;
        }
        if (card.isTakeOffInnerTop()) {
            var n = card.takeOffInnerTopCount();
            var turnText = TextManager.cardTurn.format(n);
            if (player.isEternal(BaisyunStateType.takeOffInnerTop)) {
                turnText = TextManager.cardTurnEternal;
            }
            this.drawDescOne(TextManager.cardInnerTopHalfNaked.format(turnText), rect, index);
            index++;
        }
        if (card.isTakeOffInnerBottom()) {
            var n = card.takeOffInnerBottomCount();
            var turnText = TextManager.cardTurn.format(n);
            if (player.isEternal(BaisyunStateType.takeOffInnerBottom)) {
                turnText = TextManager.cardTurnEternal;
            }
            this.drawDescOne(TextManager.cardInnerBottomHalfNaked.format(turnText), rect, index);
            index++;
        }
        return index;
    };
    Sprite_Card.prototype.drawConditions = function (card, rect, index) {
        var inBattle = $gameParty.inBattle();
        var player = this.baisyunPlayer();
        if (card.isNeedTakeOffBottom()) {
            if (inBattle && !player.isTakeOffBottom()) {
                this.changeTextColor(ColorManager.conditionErrorColor());
            }
            else {
                this.changeTextColor(ColorManager.conditionColor());
            }
            this.drawDescOne(TextManager.baisyunCondition_bottomNaked, rect, index);
            index++;
        }
        if (card.isNeedTakeOffTop()) {
            if (inBattle && !player.isTakeOffTop()) {
                this.changeTextColor(ColorManager.conditionErrorColor());
            }
            else {
                this.changeTextColor(ColorManager.conditionColor());
            }
            this.drawDescOne(TextManager.baisyunCondition_topNaked, rect, index);
            index++;
        }
        if (card.isNeedTakeOffInnerTop()) {
            if (inBattle && !player.isTakeOffInnerTop()) {
                this.changeTextColor(ColorManager.conditionErrorColor());
            }
            else {
                this.changeTextColor(ColorManager.conditionColor());
            }
            this.drawDescOne(TextManager.baisyunCondition_innerTopNaked, rect, index);
            index++;
        }
        if (card.isNeedTakeOffInnerBottom()) {
            if (inBattle && !player.isTakeOffInnerBottom()) {
                this.changeTextColor(ColorManager.conditionErrorColor());
            }
            else {
                this.changeTextColor(ColorManager.conditionColor());
            }
            this.drawDescOne(TextManager.baisyunCondition_innerBottomNaked, rect, index);
            index++;
        }
        return index;
    };
    Sprite_Card.prototype.drawKaikyaku = function (card, rect, index) {
        this.bitmap.textColor = ColorManager.cardTextColor();
        if (card.hasSelfState(BaisyunStateType.kaikyaku)) {
            this.drawDescOne(TextManager.cardKaikyaku, rect, index);
            index++;
        }
        if (card.addCardId()) {
            var skill = $dataSkills[card.addCardId()];
            var name_1 = getItemName(skill);
            var num = card.addCardNum();
            this.drawDescOne(TextManager.cardAddCard1.format(name_1, num), rect, index);
            index++;
            this.drawDescOne(TextManager.cardAddCard2.format(name_1, num), rect, index);
            index++;
        }
        if (card.isOnlyKaikyaku()) {
            var color = ColorManager.cardTextColor();
            if (this.baisyunBattle()) {
                if (this.isSpecialEffectAvailable(card)) {
                    color = ColorManager.effectiveColor();
                }
                else {
                    color = ColorManager.conditionErrorColor();
                }
            }
            this.bitmap.textColor = color;
            this.drawDescOne(TextManager.cardOnlykaikyaku, rect, index);
            index++;
        }
        return index;
    };
    Sprite_Card.prototype.drawSelectCard = function (card, rect, index) {
        this.bitmap.textColor = ColorManager.normalColor();
        return index;
    };
    Sprite_Card.prototype.drawFinish = function (card, rect, index) {
        if (!card.isFinish()) {
            return index;
        }
        this.bitmap.textColor = ColorManager.cardTextColor();
        if (this.isBlockFinish()) {
            this.drawDescOne('×' + TextManager.cardFinish, rect, index);
            return index + 1;
        }
        var inBattle = $gameParty.inBattle();
        this.drawDescOne(TextManager.cardFinish, rect, index);
        if (inBattle) {
            if (!this.canUse(card)) {
                this.bitmap.textColor = ColorManager.costErrorColor();
                this.drawDescOne(TextManager.cardCantFinish1, rect, index + 1);
                this.drawDescOne(TextManager.cardCantFinish2, rect, index + 2);
                return index + 3;
            }
        }
        return index + 1;
    };
    Sprite_Card.prototype.isBlockFinish = function () {
        var player = this.baisyunPlayer();
        if (player) {
            if (player.hasState(BaisyunStateType.notFinish)) {
                return true;
            }
        }
        if (this.baisyunEnemy()) {
            if (this.baisyunEnemy().isBlockFinish()) {
                return true;
            }
        }
        return false;
    };
    Sprite_Card.prototype.drawDrawCardCostMinus = function (card, rect, index) {
        if (card.drawCardCostMinus() == 0) {
            return index;
        }
        this.bitmap.textColor = ColorManager.crisisColor();
        this.drawDescOne(TextManager.cardDrawCardCostMinus, rect, index);
        return index + 1;
    };
    Sprite_Card.prototype.drawNama = function (card, rect, index) {
        if (!card.isNama()) {
            return index;
        }
        this.bitmap.textColor = ColorManager.namaColor();
        this.drawDescOne(TextManager.cardNama, rect, index);
        return index + 1;
    };
    Sprite_Card.prototype.drawSelfDamage = function (card, rect, index) {
        var damage = card.selfDamage();
        if (damage == 0) {
            return index;
        }
        if (this.baisyunPlayer()) {
            damage -= this.baisyunPlayer().reduceDamage();
        }
        if (damage == 0) {
            this.bitmap.textColor = ColorManager.crisisColor();
        }
        else {
            this.bitmap.textColor = ColorManager.deathColor();
        }
        this.drawDescOne(TextManager.cardSelfDamage.format(damage), rect, index);
        return index + 1;
    };
    Sprite_Card.prototype.drawHpZero = function (card, rect, index) {
        if (!card.isHpZero(this.baisyunBattle())) {
            return index;
        }
        this.bitmap.textColor = ColorManager.costErrorColor();
        this.drawDescOne(TextManager.cardCantFinish1, rect, index);
        this.drawDescOne(TextManager.cardCantFinish2, rect, index + 1);
        return index + 2;
    };
    Sprite_Card.prototype.drawDiscardEffect = function (card, rect, index) {
        var cardId = card.discardEffectCardId();
        if (cardId == 0) {
            return index;
        }
        this.changeTextColor(ColorManager.costumeColor());
        this.drawDescOne(TextManager.cardDiscardEffect, rect, index);
        var cardEffect = new BaisyunCard(0, cardId);
        var desc = cardEffect.description();
        index++;
        for (var _i = 0, desc_1 = desc; _i < desc_1.length; _i++) {
            var d = desc_1[_i];
            this.drawDescOne(d.text(), rect, index);
            index++;
        }
        if (cardEffect.isAttack()) {
            this.drawDamage(cardEffect, rect, index, ColorManager.costumeColor());
            index++;
        }
        if (cardEffect.shield() > 0) {
            this.drawShield(cardEffect, rect, index, ColorManager.costumeColor());
            index++;
        }
        if (cardEffect.isBokki()) {
            index = this.drawBokki(cardEffect, rect, index, ColorManager.costumeColor());
            index++;
        }
        if (cardEffect.addCardId()) {
            var skill = $dataSkills[cardEffect.addCardId()];
            var name_2 = getItemName(skill);
            var num = cardEffect.addCardNum();
            this.drawDescOne(TextManager.cardAddCard1.format(name_2, num), rect, index);
            index++;
            this.drawDescOne(TextManager.cardAddCard2.format(name_2, num), rect, index);
            index++;
        }
        return index;
    };
    Sprite_Card.prototype.drawExhaust = function (card, rect, index) {
        if (!card.isExhaust()) {
            return index;
        }
        this.changeTextColor(ColorManager.crisisColor());
        this.drawDescOne(TextManager.baisyunExhaust, rect, index);
        return index + 1;
    };
    Sprite_Card.prototype.drawRetain = function (card, rect, index) {
        if (!card.isRetain()) {
            return index;
        }
        this.changeTextColor(ColorManager.crisisColor());
        this.drawDescOne(TextManager.retain, rect, index);
        return index + 1;
    };
    Sprite_Card.prototype.drawMasekiEffect = function (card, rect, index) {
        var maseki = card.maseki();
        if (!maseki) {
            return index;
        }
        if (maseki.itemId() == 226) {
            // 保留は既存カードにもあり
            return index;
        }
        this.changeTextColor(ColorManager.crisisColor());
        var name = maseki.effectName();
        this.drawDescOne(name, rect, index);
        return index + 1;
    };
    Sprite_Card.prototype.baisyunPlayer = function () {
        return new BaisyunPlayer(1);
    };
    Sprite_Card.prototype.drawDescOne = function (text, rect, index) {
        var yy = rect.y + 160 + 19 * index;
        this.drawText(text, rect.x + 20, yy, rect.width - 40, 'center');
    };
    return Sprite_Card;
}(Sprite_Drawable));
var Sprite_BattleCard = /** @class */ (function (_super) {
    __extends(Sprite_BattleCard, _super);
    function Sprite_BattleCard(battle) {
        var _this = _super.call(this) || this;
        _this._battle = battle;
        return _this;
    }
    Sprite_BattleCard.prototype.canUse = function (card) {
        return card.canUse(this._battle);
    };
    Sprite_BattleCard.prototype.baisyunPlayer = function () {
        return this._battle.player();
    };
    Sprite_BattleCard.prototype.baisyunBattle = function () {
        return this._battle;
    };
    Sprite_BattleCard.prototype.isSpecialEffectAvailable = function (card) {
        return card.isSpecialEffectAvailable(this._battle);
    };
    return Sprite_BattleCard;
}(Sprite_Card));
