/*:ja
 * @target MZ
 * @author ル
 *
 *
 *
 * @command edit
 * @text デッキ編集
 * @des デッキ編集
 * @arg actorId
 * @type number
 *
 * @command debug
 * @text デバッグカード追加
 * @des デバッグカード追加
 * @arg actorId
 * @type number
 *
 * @command add
 * @text カード追加
 * @des カード追加
 * @arg actorId
 * @type number
 * @arg skillId
 * @type number
 * @arg num
 * @type number
 *
 * @command reset
 * @text リセット
 * @arg actorId
 * @type number
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_BaisyunDeck';
    PluginManager.registerCommand(pluginName, 'reset', function (args) {
        var actorId = parseInt(args.actorId);
        var actor = $gameActors.actor(actorId);
        actor.baisyunPlayer().resetDeckAndStorage();
    });
    PluginManager.registerCommand(pluginName, 'edit', function (args) {
        var actorId = parseInt(args.actorId);
        $gameParty.setMenuActorId(actorId);
        SceneManager.push(Scene_BaisyunDeck);
    });
    PluginManager.registerCommand(pluginName, 'add', function (args) {
        var actorId = parseInt(args.actorId);
        var skillId = parseInt(args.skillId);
        var num = parseInt(args.num) || 1;
        var storage = $gameActors.actor(actorId).baisyunPlayer().storage();
        for (var i = 0; i < num; i++) {
            storage.addCard(skillId);
        }
    });
    PluginManager.registerCommand(pluginName, 'debug', function (args) {
        var actorId = parseInt(args.actorId);
        var storage = $gameActors.actor(actorId).baisyunPlayer().storage();
        storage.addCard(1002);
        storage.addCard(1003);
        storage.addCard(1004);
        storage.addCard(1005);
        storage.addCard(1006);
        storage.addCard(1007);
        storage.addCard(1007);
        storage.addCard(1007);
        storage.addCard(1007);
        storage.addCard(1012);
        storage.addCard(1013);
        storage.addCard(1014);
        storage.addCard(1015);
        storage.addCard(1016);
        storage.addCard(1016);
        storage.addCard(1031);
        storage.addCard(1032);
        storage.addCard(1033);
        storage.addCard(1036);
        storage.addCard(1037);
        storage.addCard(1038);
        storage.addCard(1042);
        storage.addCard(1043);
        storage.addCard(1043);
        storage.addCard(1053);
        storage.addCard(1061);
        storage.addCard(1062);
    });
    var _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _DataManager_createGameObjects.call(this);
        $baisyunDeckManager = new BaisyunDeckManager();
    };
})(Nore || (Nore = {}));
var NEW_CARD_SW = 22;
var MAX_DECK_NUM = 20;
var BaisyunCardSet = /** @class */ (function () {
    function BaisyunCardSet(actorId, skillId, num) {
        if (num === void 0) { num = 0; }
        this._actorId = actorId;
        this._skillId = skillId;
        this._card = new BaisyunCard(actorId, skillId);
        this._num = num;
    }
    BaisyunCardSet.prototype.skillId = function () {
        return this._skillId;
    };
    BaisyunCardSet.prototype.setNum = function (num) {
        this._num = num;
    };
    BaisyunCardSet.prototype.num = function () {
        return this._num;
    };
    BaisyunCardSet.prototype.plusNum = function () {
        this._num++;
    };
    BaisyunCardSet.prototype.minusNum = function () {
        this._num--;
    };
    BaisyunCardSet.prototype.sortValue = function () {
        return this._card.sortValue();
    };
    BaisyunCardSet.prototype.name = function () {
        return getItemName(this.skill());
    };
    BaisyunCardSet.prototype.iconIndex = function () {
        return this.skill().iconIndex;
    };
    BaisyunCardSet.prototype.skill = function () {
        return $dataSkills[this._skillId];
    };
    BaisyunCardSet.prototype.card = function () {
        this._card.setMaseki(this.maseki());
        return this._card;
    };
    BaisyunCardSet.prototype.maseki = function () {
        var masekiSet = $gameParty.masekiActorSet().masekiSet(this._actorId);
        return masekiSet.findMaseki(this._skillId);
    };
    BaisyunCardSet.prototype.cardType = function () {
        return this._card.cardType();
    };
    BaisyunCardSet.prototype.rare = function () {
        return this._card.rare();
    };
    BaisyunCardSet.prototype.rareIcon = function () {
        switch (this.rare()) {
            case CardRare.N: return Icon.n;
            case CardRare.R: return Icon.r;
            case CardRare.SR: return Icon.sr;
        }
        return 0;
    };
    BaisyunCardSet.prototype.effects = function () {
        this._card.setMaseki(this.maseki());
        return this._card.effects();
    };
    BaisyunCardSet.prototype.manaCost = function () {
        return this._card.manaCost();
    };
    return BaisyunCardSet;
}());
var BaisyunDeckCustom = /** @class */ (function () {
    function BaisyunDeckCustom(actorId, deck, storage) {
        this._actorId = actorId;
        this._storage = storage;
        this._map = [];
        for (var _i = 0, _a = deck.cardList(); _i < _a.length; _i++) {
            var c = _a[_i];
            var set = this.findSet(c.skillId());
            set.plusNum();
        }
    }
    BaisyunDeckCustom.prototype.actorId = function () {
        return this._actorId;
    };
    BaisyunDeckCustom.prototype.findSet = function (skillId) {
        if (this._map[skillId]) {
            return this._map[skillId];
        }
        this._map[skillId] = new BaisyunCardSet(this._actorId, skillId);
        return this._map[skillId];
    };
    BaisyunDeckCustom.prototype.cardSetList = function () {
        var list = [];
        for (var key in this._map) {
            var set = this._map[key];
            if (set.num() > 0) {
                list.push(set);
            }
        }
        list = list.sort(function (a, b) {
            return b.sortValue() - a.sortValue();
        });
        p(list);
        return list;
    };
    BaisyunDeckCustom.prototype.totalNum = function () {
        var n = 0;
        for (var key in this._map) {
            var cardSet = this._map[key];
            if (cardSet.cardType() == CardType.power) {
                continue;
            }
            n += cardSet.num();
        }
        return n;
    };
    BaisyunDeckCustom.prototype.powerNum = function () {
        var n = 0;
        for (var key in this._map) {
            if (this._map[key].cardType() == CardType.power) {
                n += this._map[key].num();
            }
        }
        return n;
    };
    BaisyunDeckCustom.prototype.makeDeck = function () {
        var deck = new BaisyunDeck(this._actorId);
        for (var key in this._map) {
            var set = this._map[key];
            for (var i = 0; i < set.num(); i++) {
                deck.addCard(new BaisyunCard(this._actorId, set.skillId()));
            }
        }
        return deck;
    };
    BaisyunDeckCustom.prototype.maxNum = function (skillId) {
        return this._storage.num(skillId);
    };
    return BaisyunDeckCustom;
}());
var BaisyunCardStorage = /** @class */ (function () {
    function BaisyunCardStorage(actorId) {
        this._map = {};
        this._newCardMap = {};
        this._actorId = actorId;
    }
    BaisyunCardStorage.prototype.clear = function () {
        this._map = {};
    };
    BaisyunCardStorage.prototype.clearNewCard = function () {
        for (var key in this.newCardMap()) {
            this._newCardMap[key] = false;
        }
    };
    BaisyunCardStorage.prototype.isNewCard = function (skillId) {
        return this.newCardMap()[skillId] == true;
    };
    BaisyunCardStorage.prototype.newCardMap = function () {
        this._newCardMap = this._newCardMap || {};
        return this._newCardMap;
    };
    BaisyunCardStorage.prototype.actorId = function () {
        return this._actorId;
    };
    BaisyunCardStorage.prototype.addCard = function (skillId) {
        this.findSet(skillId).plusNum();
    };
    BaisyunCardStorage.prototype.findSet = function (skillId) {
        if (this._map[skillId]) {
            return this._map[skillId];
        }
        this._map[skillId] = new BaisyunCardSet(this._actorId, skillId);
        this.newCardMap()[skillId] = true;
        return this._map[skillId];
    };
    BaisyunCardStorage.prototype.cardSetList = function (deckCustom) {
        var list = [];
        for (var key in this._map) {
            var set = this._map[key];
            var num = set.num();
            if (deckCustom) {
                var deckSet = deckCustom.findSet(set.skillId());
                if (deckSet) {
                    num -= deckSet.num();
                }
            }
            var copy = new BaisyunCardSet(this._actorId, set.skillId(), num);
            list.push(copy);
        }
        list = list.sort(function (a, b) {
            return b.sortValue() - a.sortValue();
        });
        return list;
    };
    BaisyunCardStorage.prototype.initDeck = function (deck) {
        deck.clear();
        var total = 0;
        var limit = deck.maxNum();
        for (var _i = 0, _a = this.cardSetList(null); _i < _a.length; _i++) {
            var set = _a[_i];
            for (var i = 0; i < set.num(); i++) {
                deck.addCard(new BaisyunCard(this._actorId, set.skillId()));
                total++;
                if (limit <= total) {
                    return;
                }
            }
        }
    };
    BaisyunCardStorage.prototype.num = function (skillId) {
        return this.findSet(skillId).num();
    };
    BaisyunCardStorage.prototype.hasCard = function (skillId) {
        return this.num(skillId) > 0;
    };
    return BaisyunCardStorage;
}());
var BaisyunDeck = /** @class */ (function () {
    function BaisyunDeck(actorId) {
        this._cardList = [];
        this._actorId = actorId;
    }
    BaisyunDeck.prototype.onBattleStart = function () {
        for (var _i = 0, _a = this._cardList; _i < _a.length; _i++) {
            var c = _a[_i];
            c.onBattleStart();
        }
    };
    BaisyunDeck.prototype.addCard = function (card) {
        this._cardList.push(card);
    };
    BaisyunDeck.prototype.cardList = function () {
        return this._cardList;
    };
    BaisyunDeck.prototype.onGameStart = function (battle) {
        var masekiSet = $gameParty.masekiActorSet().masekiSet(this._actorId);
        var maseSetMap = {};
        for (var _i = 0, _a = this._cardList; _i < _a.length; _i++) {
            var c = _a[_i];
            var maseki = masekiSet.findMaseki(c.skillId());
            if (maseki && !maseSetMap[maseki.itemId()]) {
                maseSetMap[maseki.itemId()] = true;
                c.setMaseki(maseki);
            }
            else {
                c.setMaseki(null);
            }
            c.setId(battle.nextCardId());
        }
    };
    BaisyunDeck.prototype.clear = function () {
        this._cardList = [];
    };
    BaisyunDeck.prototype.findCardSet = function (skillId) {
        var set = new BaisyunCardSet(this._actorId, skillId);
        for (var _i = 0, _a = this._cardList; _i < _a.length; _i++) {
            var c = _a[_i];
            if (c.skillId() == skillId) {
                set.plusNum();
            }
        }
        return set;
    };
    BaisyunDeck.prototype.maxNum = function () {
        return MAX_DECK_NUM;
    };
    return BaisyunDeck;
}());
var BaisyunDeckManager = /** @class */ (function () {
    function BaisyunDeckManager() {
    }
    BaisyunDeckManager.prototype.makeDeck = function (actorId) {
        var deck = new BaisyunDeck(actorId);
        return deck;
    };
    BaisyunDeckManager.prototype.initStorage = function (storage) {
        storage.clear();
        var actorId = storage.actorId();
        switch (actorId) {
            case 1:
                this.initStorage1(storage);
                break;
            case 2:
                this.initStorage2(storage);
                break;
            case 3:
                this.initStorage3(storage);
                break;
            case 4:
                this.initStorage2(storage);
                break;
        }
    };
    /**
     * ロザリー
     */
    BaisyunDeckManager.prototype.initStorage1 = function (storage) {
        // くぱぁ準備
        storage.addCard(1070);
        storage.addCard(1070);
        //storage.addCard(1070);
        //storage.addCard(1070);
        // 服脱ぎ
        storage.addCard(1115);
        storage.addCard(1115);
        // 開脚
        storage.addCard(1001);
        storage.addCard(1001);
        storage.addCard(1076);
        storage.addCard(1076);
        //storage.addCard(1071);
        //storage.addCard(1071);
        //storage.addCard(1072);
        //storage.addCard(1072);
        // 交渉終了
        storage.addCard(1041);
        storage.addCard(1041);
        storage.addCard(1041);
        storage.addCard(1041);
        // 忍耐
        storage.addCard(1051);
        storage.addCard(1051);
        storage.addCard(1051);
        storage.addCard(1051);
        // 思案
        storage.addCard(1061);
        storage.addCard(1061);
        storage.addCard(1061);
        storage.addCard(1061);
        storage.clearNewCard();
    };
    /**
     * サツキ
     */
    BaisyunDeckManager.prototype.initStorage2 = function (storage) {
        storage.addCard(1001);
        storage.addCard(1001);
        storage.addCard(1001);
        storage.addCard(1001);
        storage.addCard(1011);
        storage.addCard(1011);
        storage.addCard(1011);
        storage.addCard(1011);
        storage.addCard(1041);
        storage.addCard(1041);
        storage.addCard(1041);
        storage.addCard(1041);
        storage.addCard(1051);
        storage.addCard(1051);
        storage.addCard(1051);
        storage.addCard(1051);
        storage.addCard(1061);
        storage.addCard(1061);
        storage.addCard(1061);
        storage.addCard(1061);
        storage.clearNewCard();
    };
    /**
     * パティ
     */
    BaisyunDeckManager.prototype.initStorage3 = function (storage) {
        storage.addCard(1001);
        storage.addCard(1001);
        storage.addCard(1001);
        storage.addCard(1001);
        storage.addCard(1041);
        storage.addCard(1041);
        storage.addCard(1041);
        storage.addCard(1041);
        storage.addCard(1101);
        storage.addCard(1101);
        storage.addCard(1101);
        storage.addCard(1101);
        storage.addCard(1111);
        storage.addCard(1111);
        storage.addCard(1111);
        storage.addCard(1111);
        storage.addCard(1112);
        storage.addCard(1112);
        storage.addCard(1112);
        storage.addCard(1112);
        storage.clearNewCard();
    };
    return BaisyunDeckManager;
}());
var $baisyunDeckManager;
