var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Scene_BaisyunDeck = /** @class */ (function (_super) {
    __extends(Scene_BaisyunDeck, _super);
    function Scene_BaisyunDeck() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_BaisyunDeck.prototype.create = function () {
        _super.prototype.create.call(this);
        this._backlogDisabled = true;
        this._actor = $gameParty.menuActor();
        this._baisyunPlayer = this._actor.baisyunPlayer();
        this._deck = this._baisyunPlayer.deck();
        this._storage = this._baisyunPlayer.storage();
        this._deckCustom = new BaisyunDeckCustom(this._actor.actorId(), this._deck, this._storage);
        this.createBackground();
        this.createWindowLayer();
        this.createAllWindows();
        this.createDeckCardListWindow();
        this.createAllCardListWindow();
        this.createCategoryWindow();
        this.createLabelWindow();
        this.createBlack();
        this.createPreviewWindow();
        this.createCardNumWindow();
        this.createConfirmWindow();
    };
    Scene_BaisyunDeck.prototype.createBlack = function () {
        var g = new PIXI.Graphics();
        g.beginFill(0x111111, 0.8);
        g.drawRect(0, 0, Graphics.width - 400, Graphics.height);
        g.endFill();
        this.addChild(g);
        this._black = g;
        this._black.visible = false;
    };
    Scene_BaisyunDeck.prototype.createBackground = function () {
        this._backgroundSprite = new Sprite();
        this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
        //this.addChild(this._backgroundSprite);
    };
    Scene_BaisyunDeck.prototype.createDeckCardListWindow = function () {
        this._deckCardWindow = new Window_DeckCardList();
        this._deckCardWindow.setHandler('shift', this.onDeckListShift.bind(this));
        this._deckCardWindow.setHandler('ok', this.onDeckListOk.bind(this));
        this._deckCardWindow.setHandler('cancel', this.onDeckListCancel.bind(this));
        this._deckCardWindow.setHandler('change', this.onDeckListChange.bind(this));
        this._deckCardWindow.setHandler('touchSelect', this.onDeckTouch.bind(this));
        this._deckCardWindow.setHandler('touchCancel', this.onDeckCardGain.bind(this));
        this._deckCardWindow.setHandler('touchOver', this.onDeckTouchOver.bind(this));
        this._deckCardWindow.setHandler('change', this.onDeckCardChange.bind(this));
        this._deckCardWindow.setHandler('gain', this.onDeckCardGain.bind(this));
        this._deckCardWindow.setup(this._deckCustom);
        this.addChild(this._deckCardWindow);
    };
    Scene_BaisyunDeck.prototype.createAllCardListWindow = function () {
        this._allCardWindow = new Window_AllCardList(this._storage, this._deckCustom);
        this._allCardWindow.setHandler('shift', this.onCardListShift.bind(this));
        this._allCardWindow.setHandler('ok', this.onCardListOk.bind(this));
        this._allCardWindow.setHandler('cancel', this.onCardListCancel.bind(this));
        this._allCardWindow.setHandler('pageup', this.onPageup.bind(this));
        this._allCardWindow.setHandler('pagedown', this.onPagedown.bind(this));
        this._allCardWindow.setHandler('change', this.onAllCardChange.bind(this));
        this._allCardWindow.setHandler('touchSelect', this.onCardListTouch.bind(this));
        this._allCardWindow.setHandler('touchOk', this.onCardListTouchOk.bind(this));
        this.addChild(this._allCardWindow);
        this._allCardWindow.select(0);
        this._allCardWindow.activate();
        this._allCardNumSprite = new Sprite_AllCardNum(this._storage);
        this.addChild(this._allCardNumSprite);
    };
    Scene_BaisyunDeck.prototype.createCardNumWindow = function () {
        this._cardNumWindow = new Window_CardNum();
        this._cardNumWindow.setHandler('ok', this.onNumOk.bind(this));
        this._cardNumWindow.setHandler('cancel', this.onNumCancel.bind(this));
        this.addChild(this._cardNumWindow);
        this._cardNumWindow.hide();
    };
    Scene_BaisyunDeck.prototype.createPreviewWindow = function () {
        var xx = 660;
        var interval = 125;
        var yy = 440;
        this._cardEffectSprite = new Sprite_CardEffectHelp(yy);
        this._cardEffectSprite.x = xx;
        this.addChild(this._cardEffectSprite);
        this._cardEffectSprite2 = new Sprite_CardEffectHelp(yy + interval);
        this._cardEffectSprite2.x = xx;
        this.addChild(this._cardEffectSprite2);
        this._cardEffectSprite3 = new Sprite_CardEffectHelp(yy + interval * 2);
        this._cardEffectSprite3.x = xx;
        this.addChild(this._cardEffectSprite3);
        this._cardEffectSprite4 = new Sprite_CardEffectHelp(yy + interval * 3);
        this._cardEffectSprite4.x = xx;
        this.addChild(this._cardEffectSprite4);
        this._previewWindow = new Window_DeckCardPreview(this._storage, this._cardEffectSprite, this._cardEffectSprite2, this._cardEffectSprite3, this._cardEffectSprite4);
        this.addChild(this._previewWindow);
        this._previewWindow.hide();
    };
    Scene_BaisyunDeck.prototype.createCategoryWindow = function () {
        this._categoryWindow = new Window_DeckCaterogy(this._storage);
        this._categoryWindow.setHandler('change', this.onCategoryChange.bind(this));
        this.addChild(this._categoryWindow);
    };
    Scene_BaisyunDeck.prototype.onDeckCardChange = function () {
        var set = this._deckCardWindow.selectedSet();
        if (!set) {
            this._previewWindow.hide();
            return;
        }
        if (!this._deckCardWindow.active) {
            this._previewWindow.hide();
            return;
        }
        this._previewWindow.setCardSet(set, true);
        this._previewWindow.show();
    };
    Scene_BaisyunDeck.prototype.createLabelWindow = function () {
        this._labelWindow1 = new Window_Label('左クリックで減少', 874, 0, 400);
        this.addChild(this._labelWindow1);
        this._labelWindow1.visible = false;
        this._labelWindow2 = new Window_Label('←キーで減少　→キーで増加', 874, 0, 400);
        this.addChild(this._labelWindow2);
        this._labelWindow2.visible = false;
        this._deckNumSprite = new Sprite_DeckNum(this._deckCustom, this._deck.maxNum());
        this.addChild(this._deckNumSprite);
    };
    Scene_BaisyunDeck.prototype.createConfirmWindow = function () {
        this._confirmWindow = new Nore.Window_Confirm();
        this._confirmWindow.setTexts([TextManager.deckCancelConfirm1, TextManager.deckCancelConfirm2]);
        this._confirmWindow.setHandler('ok', this.onConfirmOk.bind(this));
        this._confirmWindow.setHandler('cancel', this.onConfirmCancel.bind(this));
        this._confirmWindow.deactivate();
        this.addChild(this._confirmWindow);
        this._confirmWindow.hide();
    };
    Scene_BaisyunDeck.prototype.onNumOk = function () {
        this._black.visible = false;
        this._previewWindow.hide();
        var index = this._cardNumWindow.index();
        this._cardNumWindow.hide();
        this._allCardWindow.activate();
        if (index == 5) {
            return;
        }
        var set = this._cardNumWindow.set();
        set.setNum(index);
        this._deckCardWindow.makeData();
        this._deckCardWindow.refresh();
        this._allCardWindow.makeData();
        this._allCardWindow.refresh();
        this.onAllCardChange();
    };
    Scene_BaisyunDeck.prototype.onNumCancel = function () {
        this._cardNumWindow.hide();
        this._allCardWindow.activate();
        this._black.visible = false;
        this._previewWindow.hide();
    };
    Scene_BaisyunDeck.prototype.onConfirmOk = function () {
        this.popScene();
    };
    Scene_BaisyunDeck.prototype.onConfirmCancel = function () {
        this._confirmWindow.hide();
        this._confirmWindow.deactivate();
        this._allCardWindow.activate();
    };
    Scene_BaisyunDeck.prototype.onCardListShift = function () {
        Input.clear();
        SoundManager.playCursor();
        this.toDeckActivate();
    };
    Scene_BaisyunDeck.prototype.toDeckActivate = function () {
        this._allCardWindow.deactivate();
        this._deckCardWindow.activate();
        if (this._deckCardWindow.index() < 0) {
            this._deckCardWindow.select(0);
        }
        this._previewWindow.setPosition(550, 80, true);
        this._labelWindow2.visible = true;
        this._labelWindow1.visible = false;
        this._black.visible = true;
    };
    Scene_BaisyunDeck.prototype.onCardListTouch = function () {
        TouchInput.clear();
        if (this._allCardWindow.active) {
            return;
        }
        this.activateAllCard();
    };
    Scene_BaisyunDeck.prototype.onCardListTouchOk = function () {
        this._allCardWindow.activate();
        var set = this._allCardWindow.selectedSet();
        if (!set) {
            return;
        }
        var deckSet = this._deckCustom.findSet(set.skillId());
        var max = this._deckCustom.maxNum(set.skillId());
        if (deckSet.num() == max) {
            SoundManager.playBuzzer();
            return;
        }
        deckSet.plusNum();
        SoundManager.playOk();
        this._deckCardWindow.makeData();
        this._deckCardWindow.refresh();
        this._allCardWindow.makeData();
        this._allCardWindow.refresh();
        this.onAllCardChange();
    };
    Scene_BaisyunDeck.prototype.onDeckListShift = function () {
        SoundManager.playCursor();
        this.activateAllCard();
    };
    Scene_BaisyunDeck.prototype.activateAllCard = function () {
        Input.clear();
        this.onDeckListCancel();
    };
    Scene_BaisyunDeck.prototype.onDeckTouch = function () {
        TouchInput.clear();
        this.toDeckActivate();
    };
    Scene_BaisyunDeck.prototype.onDeckListOk = function () {
        TouchInput.clear();
        this._deckCardWindow.activate();
        var set = this._deckCardWindow.selectedSet();
        if (!set) {
            return;
        }
        if (set.num() == 0) {
            SoundManager.playBuzzer();
            return;
        }
        SoundManager.playOk();
        set.minusNum();
        this._deckCardWindow.makeData();
        this._deckCardWindow.refresh();
        this._allCardWindow.makeData();
        this._allCardWindow.refresh();
        this.onDeckListChange();
    };
    Scene_BaisyunDeck.prototype.onDeckCardGain = function () {
        TouchInput.clear();
        Input.clear();
        this._deckCardWindow.activate();
        var set = this._deckCardWindow.selectedSet();
        if (!set) {
            return;
        }
        var deckSet = this._deckCustom.findSet(set.skillId());
        var max = this._deckCustom.maxNum(set.skillId());
        if (deckSet.num() == max) {
            SoundManager.playBuzzer();
            return;
        }
        deckSet.plusNum();
        SoundManager.playOk();
        this._deckCardWindow.makeData();
        this._deckCardWindow.refresh();
        this._allCardWindow.makeData();
        this._allCardWindow.refresh();
    };
    /*onDeckTouchCancel() {
        TouchInput.clear();

        this._deckCardWindow.activate();
        const set = this._deckCardWindow.selectedSet();
        if (! set) {
            return;
        }
        if (set.num() == 0) {
            SoundManager.playBuzzer();
            return;
        }
        SoundManager.playOk();

        set.minusNum();
        this._deckCardWindow.makeData();
        this._deckCardWindow.refresh();
        this._allCardWindow.makeData();
        this._allCardWindow.refresh();
        this.onDeckListChange();
    }
        */
    Scene_BaisyunDeck.prototype.onDeckTouchOver = function () {
        TouchInput.clear();
        if (this._deckCardWindow.active) {
            return;
        }
        this.toDeckActivate();
        this._labelWindow1.visible = true;
        this._labelWindow2.visible = false;
        this._black.visible = true;
    };
    Scene_BaisyunDeck.prototype.onCardListOk = function () {
        var set = this._allCardWindow.selectedSet();
        if (!set) {
            this._allCardWindow.activate();
            return;
        }
        var index = this._allCardWindow.index();
        var r = this._allCardWindow.itemRect(index);
        var deckSet = this._deckCustom.findSet(set.skillId());
        var max = this._storage.num(set.skillId());
        this._cardNumWindow.setCardSet(deckSet, max);
        this._black.visible = true;
        //const xx = this._cardNumWindow.x + 80;
        //const yy = this._cardNumWindow.y - 380;
        var xx = 360;
        var yy = 80;
        this._previewWindow.setCardSet(set, false);
        this._previewWindow.setPosition(xx, yy, true);
        this._cardNumWindow.setPosition(xx - 80, yy + 380);
    };
    Scene_BaisyunDeck.prototype.onPageup = function () {
        this._categoryWindow.left();
    };
    Scene_BaisyunDeck.prototype.onPagedown = function () {
        this._categoryWindow.right();
    };
    Scene_BaisyunDeck.prototype.onCategoryChange = function () {
        SoundManager.playCursor();
        var symbol = this._categoryWindow.currentSymbol();
        this._allCardWindow.setCategory(symbol);
        this._allCardWindow.activate();
        this._deckCardWindow.deactivate();
    };
    Scene_BaisyunDeck.prototype.onDeckListCancel = function () {
        this._deckCardWindow.select(-1);
        this._deckCardWindow.deactivate();
        this._allCardWindow.activate();
        this._previewWindow.hide();
        this._labelWindow1.visible = false;
        this._labelWindow2.visible = false;
        this._black.visible = false;
    };
    Scene_BaisyunDeck.prototype.onCardListCancel = function () {
        this._allCardWindow.activate();
        this.decide();
    };
    Scene_BaisyunDeck.prototype.onAllCardChange = function () {
        if (!this._previewWindow) {
            return;
        }
        var set = this._allCardWindow.selectedSet();
        this._previewWindow.setCardSet(set, false);
        if (set) {
            this._deckCardWindow.selectCard(set.skillId());
        }
    };
    Scene_BaisyunDeck.prototype.onDeckListChange = function () {
        var set = this._deckCardWindow.selectedSet();
        this._previewWindow.setCardSet(set, true);
    };
    Scene_BaisyunDeck.prototype.decide = function () {
        if (this._deckCustom.totalNum() != this._deck.maxNum()) {
            Input.clear();
            TouchInput.clear();
            SoundManager.playBuzzer();
            this._allCardWindow.deactivate();
            this._deckCardWindow.deactivate();
            this._confirmWindow.show();
            this._confirmWindow.activate();
            return;
        }
        this._baisyunPlayer.setDeck(this._deckCustom.makeDeck());
        this.popScene();
    };
    Scene_BaisyunDeck.prototype.popScene = function () {
        this._storage.clearNewCard();
        _super.prototype.popScene.call(this);
    };
    return Scene_BaisyunDeck;
}(Nore.Scene_Talk));
var Window_DeckCardList = /** @class */ (function (_super) {
    __extends(Window_DeckCardList, _super);
    function Window_DeckCardList() {
        var _this = this;
        var r = new Rectangle(880, 74, 401, 728);
        _this = _super.call(this, r) || this;
        _this._enableType = CardType.all;
        _this._disableType = DisableType.none;
        _this.padding = 7;
        _this.createContents();
        _this._costSprite = new Sprite_CardCost();
        return _this;
    }
    Window_DeckCardList.prototype.rowSpacing = function () {
        return 1;
    };
    Window_DeckCardList.prototype.itemRect = function (index) {
        var r = _super.prototype.itemRect.call(this, index);
        r.y += 3;
        return r;
    };
    Window_DeckCardList.prototype.setup = function (deckCustom) {
        this._masekiSet = $gameParty.masekiActorSet().masekiSet(deckCustom.actorId());
        this._deckCustom = deckCustom;
        this.makeData();
        this.refresh();
    };
    Window_DeckCardList.prototype.setEnableType = function (cardType) {
        if (this._enableType == cardType) {
            return;
        }
        this._enableType = cardType;
        this.refresh();
    };
    Window_DeckCardList.prototype.setDisableType = function (disableType) {
        if (this._disableType == disableType) {
            return;
        }
        this._disableType = disableType;
        this.refresh();
    };
    Window_DeckCardList.prototype.maxCols = function () {
        return 1;
    };
    Window_DeckCardList.prototype.maxItems = function () {
        if (!this._list) {
            return 0;
        }
        if (this._list.length == 0) {
            return 1;
        }
        return this._list.length;
    };
    Window_DeckCardList.prototype.makeData = function () {
        this._list = this._deckCustom.cardSetList();
    };
    Window_DeckCardList.prototype.drawItem = function (index) {
        var item = this._list[index];
        var rect = this.itemRect(index);
        if (!item) {
            return;
        }
        this.changePaintOpacity(this.isEnabled(item));
        this.drawCardBg(rect, item);
        //this.drawCardRare(rect, item);
        var offset = 77;
        this.drawMaseki(item, rect);
        this.drawCost(item, rect);
        this.contents.fontBold = false;
        this.changeTextColor(ColorManager.normalColor());
        this.contents.fontSize = 20;
        this.drawCardIcon(item, rect.x + offset, rect.y + 4);
        this.drawCardName(item, rect, offset);
        //this.drawText('×' + item.num(), rect.x + offset, rect.y, 300, 'right');
    };
    Window_DeckCardList.prototype.drawCardName = function (item, rect, offset) {
        this.changeTextColor(this.cardColor(item));
        this.drawText(item.name(), rect.x + offset + 130, rect.y, 150);
    };
    Window_DeckCardList.prototype.cardColor = function (item) {
        return ColorManager.cardRareTextColor(item.rare());
    };
    Window_DeckCardList.prototype.drawCardIcon = function (set, x, y) {
        var xx = x;
        for (var i = 0; i < this._deckCustom.maxNum(set.skillId()); i++) {
            if (i < set.num()) {
                this.drawIcon(set.iconIndex(), xx, y);
            }
            else {
                this.drawBlackIcon(set.iconIndex(), xx, y, '#111111');
            }
            xx += 28;
        }
    };
    Window_DeckCardList.prototype.drawCost = function (set, rect) {
        this._costSprite.drawTargetBitmap(set.card(), true, this.contents, rect.x + 20, rect.y - 2, 0.8);
    };
    Window_DeckCardList.prototype.drawMaseki = function (item, rect) {
        var maseki = this._masekiSet.findMaseki(item.skillId());
        if (!maseki) {
            return;
        }
        this.drawIcon(maseki.iconIndex(), rect.x - 4, rect.y - 2);
    };
    Window_DeckCardList.prototype.drawCardBg = function (rect, cardSet) {
        var type = cardSet.card().cardType();
        var color = null;
        switch (type) {
            case CardType.attack:
                color = ColorManager.attackCardColor();
                break;
            case CardType.skill:
                color = ColorManager.skillCardColor();
                break;
            case CardType.guard:
                color = ColorManager.guardCardColor();
                break;
            case CardType.finish:
                color = ColorManager.finishCardColor();
                break;
            case CardType.power:
                color = ColorManager.powerCardColor();
                break;
        }
        if (!color) {
            return;
        }
        this.contents.fillRect(rect.x, rect.y, rect.width, rect.height, color);
    };
    Window_DeckCardList.prototype.drawCardRare = function (rect, cardSet) {
        if (cardSet.rare() == CardRare.N) {
            return;
        }
        var color = ColorManager.skillRareColor(cardSet.rare());
        this.contents.fillRect(rect.x + 84, rect.y + 0, 220, 34, color);
    };
    Window_DeckCardList.prototype.isEnabled = function (set) {
        if (!set) {
            return true;
        }
        if (this._enableType != CardType.all) {
            if (set.cardType() != this._enableType) {
                return false;
            }
        }
        if (this._disableType != DisableType.none) {
            if (this._disableType == DisableType.retain) {
                if (set.card().isRetain()) {
                    return false;
                }
            }
        }
        return set.num() > 0;
    };
    Window_DeckCardList.prototype.isCurrentItemEnabled = function () {
        var item = this._list[this.index()];
        return this.isEnabled(item);
    };
    Window_DeckCardList.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateInput();
        this.updateTouchSelect();
    };
    Window_DeckCardList.prototype.updateInput = function () {
        if (this.isOpen() && this.active) {
            if (Input.isTriggered("shift")) {
                Input.clear();
                this.callHandler('shift');
            }
        }
    };
    Window_DeckCardList.prototype.selectedSet = function () {
        return this._list[this.index()];
    };
    Window_DeckCardList.prototype.cursorLeft = function (wrap) {
        Input.clear();
        this.callHandler('ok');
    };
    Window_DeckCardList.prototype.cursorRight = function (wrap) {
        Input.clear();
        this.callHandler('gain');
    };
    Window_DeckCardList.prototype.updateTouchSelect = function () {
        if (!this.active && this.visible) {
            if ($gameTemp.confirmWindowActive) {
                return;
            }
            if (TouchInput.x != 0 || TouchInput.y != 0) {
                if (this.isTouchedInsideFrame()) {
                    this.callHandler('touchOver');
                }
            }
        }
        if (this.active && this.visible) {
            if (TouchInput.rightButton) {
                if (this.isTouchedInsideFrame()) {
                    this.callHandler('touchCancel');
                }
            }
        }
    };
    Window_DeckCardList.prototype.onTouchCancel = function () {
        this.callHandler('touchCancel');
        // do nothing
    };
    Window_DeckCardList.prototype.selectCard = function (skillId) {
        for (var i = 0; i < this._list.length; i++) {
            var set = this._list[i];
            if (set.skillId() == skillId) {
                this.select(i);
                return;
            }
        }
        this.select(-1);
    };
    return Window_DeckCardList;
}(Window_Selectable));
var Window_AllCardList = /** @class */ (function (_super) {
    __extends(Window_AllCardList, _super);
    function Window_AllCardList(storage, deckCustom) {
        var _this = this;
        var r = new Rectangle(-4, 70, 880, 732);
        _this = _super.call(this, r) || this;
        _this._category = CardType.all;
        _this._storage = storage;
        _this._deckCustom = deckCustom;
        _this.padding = 2;
        _this.frameVisible = false;
        _this.createContents();
        _this.makeData();
        _this.refresh();
        return _this;
    }
    Window_AllCardList.prototype.maxCols = function () {
        if (this._category == CardType.all) {
            return 5;
        }
        return 4;
    };
    Window_AllCardList.prototype.itemHeight = function () {
        var h = 348;
        if (this._category == CardType.all) {
            return Math.round(h * this.cardScale()) + 8;
        }
        return h;
    };
    Window_AllCardList.prototype.itemWidth = function () {
        var w = 217;
        if (this._category == CardType.all) {
            return 175;
        }
        return w;
    };
    Window_AllCardList.prototype.colSpacing = function () {
        return 3;
    };
    Window_AllCardList.prototype.maxItems = function () {
        if (!this._list) {
            return 0;
        }
        return this._list.length;
    };
    Window_AllCardList.prototype.cardScale = function () {
        if (this._category == CardType.all) {
            return 0.82;
        }
        return 1;
    };
    Window_AllCardList.prototype.makeData = function () {
        var list = this._storage.cardSetList(this._deckCustom);
        var result = [];
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var set = list_1[_i];
            if (this.isInclude(set)) {
                result.push(set);
            }
        }
        this._list = result;
    };
    Window_AllCardList.prototype.isInclude = function (set) {
        switch (this._category) {
            case CardType.all: return true;
            default: return set.cardType() == this._category;
        }
    };
    Window_AllCardList.prototype.drawItemBackground = function (index) {
        var rect = this.itemRect(index);
        this.drawBackgroundRect(rect);
    };
    Window_AllCardList.prototype.drawItem = function (index) {
        var rect = this.itemRect(index);
        var set = this._list[index];
        if (!set) {
            return;
        }
        this.changePaintOpacity(this.isEnabled(set));
        rect.height -= 30;
        var ui = this.drawCardItem(rect, set.card());
        if (this.cardScale() < 1) {
            ui.scale.x = ui.scale.y = this.cardScale();
            ui.x -= 20;
            ui.y -= 29;
        }
        if (this._storage.isNewCard(set.card().skillId())) {
            ui.drawNewCard();
        }
        this.drawCardNum(rect, set.num(), this._storage.num(set.skillId()));
    };
    Window_AllCardList.prototype.drawCardNum = function (rect, num, maxNum) {
        this.changeTextColor(ColorManager.normalColor());
        this.contents.fontSize = 22;
        var yy = rect.y + rect.height - 8;
        this.drawText(maxNum, rect.x, yy, rect.width - 60 * this.cardScale(), 'right');
        if (num == maxNum) {
            return;
        }
        this.changePaintOpacity(true);
        this.contents.fontSize = 25;
        var xx = rect.x + 60 * this.cardScale();
        var deckNum = maxNum - num;
        this.drawIcon(16, xx, yy + 2);
        this.drawText(deckNum, xx, yy, 32, 'center');
    };
    Window_AllCardList.prototype.isEnabled = function (set) {
        return true;
    };
    Window_AllCardList.prototype.isCurrentItemEnabled = function () {
        var item = this._list[this.index()];
        return this.isEnabled(item);
    };
    Window_AllCardList.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateInput();
        this.updateTouchSelect();
    };
    Window_AllCardList.prototype.updateInput = function () {
        if (this.isOpen() && this.active) {
            if (Input.isTriggered("shift")) {
                Input.clear();
                this.callHandler('shift');
            }
        }
    };
    Window_AllCardList.prototype.selectedSet = function () {
        return this._list[this.index()];
    };
    Window_AllCardList.prototype.setCategory = function (category) {
        this._category = category;
        this.makeData();
        this.refresh();
        this.scrollTo(0, 0);
        this.fixOverSelection();
    };
    Window_AllCardList.prototype.fixOverSelection = function () {
        if (this.index() >= this._list.length) {
            this.select(this._list.length - 1);
        }
    };
    Window_AllCardList.prototype.updateTouchSelect = function () {
        if (!this.active && this.visible) {
            if ($gameTemp.confirmWindowActive) {
                return;
            }
            if (this.isTouchedInsideFrame()) {
                this.callHandler('touchSelect');
            }
        }
    };
    Window_AllCardList.prototype.onTouchOk = function () {
        if (this.isTouchOkEnabled()) {
            var hitIndex = this.hitIndex();
            if (hitIndex >= 0) {
                this.callHandler('touchOk');
            }
        }
    };
    return Window_AllCardList;
}(Window_BaisyunCardList));
var Sprite_DeckNum = /** @class */ (function (_super) {
    __extends(Sprite_DeckNum, _super);
    function Sprite_DeckNum(deckCustom, maxNum) {
        var _this = _super.call(this) || this;
        _this.x = 886;
        _this.y = 42;
        _this._deckCustom = deckCustom;
        _this._maxNum = maxNum;
        _this.bitmap = new Bitmap(400, 60);
        _this.refresh();
        return _this;
    }
    Sprite_DeckNum.prototype.refresh = function () {
        this.bitmap.clear();
        this.drawDeckName(0);
        this.drawDeckNum(140);
        this.drawDeckPower(255);
    };
    Sprite_DeckNum.prototype.drawDeckName = function (x) {
        this.bitmap.fontSize = 22;
        this.bitmap.drawText(TextManager.myDeck, x, 0, 120, 32, 'left');
    };
    Sprite_DeckNum.prototype.drawDeckNum = function (x) {
        this.bitmap.fontSize = 27;
        this._lastNum = this._deckCustom.totalNum();
        if (this._lastNum != this._maxNum) {
            this.bitmap.textColor = ColorManager.deathColor();
        }
        this.bitmap.drawText('%1'.format(this._lastNum), x, 0, 120, 32, 'left');
        this.bitmap.textColor = ColorManager.normalColor();
        this.bitmap.drawText('/ 20'.format(this._lastNum), x + 38, 0, 120, 32, 'left');
    };
    Sprite_DeckNum.prototype.drawDeckPower = function (x) {
        this.bitmap.fontSize = 22;
        this._lastPower = this._deckCustom.powerNum();
        if (this._lastPower == 0) {
            return;
        }
        this.bitmap.drawText('+パワー ' + this._lastPower, x, 0, 120, 32, 'left');
    };
    Sprite_DeckNum.prototype.update = function () {
        _super.prototype.update.call(this);
        if (!this._deckCustom) {
            return;
        }
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_DeckNum.prototype.isChanged = function () {
        if (this._lastPower != this._deckCustom.powerNum()) {
            return true;
        }
        return this._lastNum != this._deckCustom.totalNum();
    };
    return Sprite_DeckNum;
}(Sprite));
var Sprite_AllCardNum = /** @class */ (function (_super) {
    __extends(Sprite_AllCardNum, _super);
    function Sprite_AllCardNum(storage) {
        var _this = _super.call(this) || this;
        _this.x = 8;
        _this.y = 42;
        _this._storage = storage;
        _this.bitmap = new Bitmap(300, 60);
        _this.refresh();
        return _this;
    }
    Sprite_AllCardNum.prototype.refresh = function () {
        this.bitmap.clear();
        this.bitmap.fontSize = 22;
        this.bitmap.drawText(TextManager.ownedCards, 0, 0, 130, 32, 'left');
    };
    return Sprite_AllCardNum;
}(Sprite));
var Window_DeckCaterogy = /** @class */ (function (_super) {
    __extends(Window_DeckCaterogy, _super);
    function Window_DeckCaterogy(storage) {
        var _this = this;
        var r = new Rectangle(193, 30, 680, 48);
        _this = _super.call(this, r) || this;
        _this._storage = storage;
        _this._margin = 2;
        _this.padding = 0;
        _this.createContents();
        _this.makeCommandList();
        _this.refresh();
        _this.deactivate();
        _this.frameVisible = false;
        return _this;
    }
    Window_DeckCaterogy.prototype.maxCols = function () {
        return 6;
    };
    Window_DeckCaterogy.prototype.makeCommandList = function () {
        this.addCommand('All', CardType.all, true, null);
        this.addCommand(TextManager.deckCategoryAttack, CardType.attack, true, null);
        this.addCommand(TextManager.deckCategoryGuard, CardType.guard, true, null);
        this.addCommand(TextManager.deckCategorySkill, CardType.skill, true, null);
        this.addCommand(TextManager.deckCategoryFinish, CardType.finish, true, null);
        this.addCommand(TextManager.deckCategoryPower, CardType.power, true, null);
    };
    Window_DeckCaterogy.prototype.left = function () {
        var index = this.index() - 1;
        if (index < 0) {
            index = this._list.length - 1;
        }
        this.select(index);
    };
    Window_DeckCaterogy.prototype.right = function () {
        var index = this.index() + 1;
        if (index >= this._list.length) {
            index = 0;
        }
        this.select(index);
    };
    Window_DeckCaterogy.prototype.resetFontSettings = function () {
        this.contents.fontFace = $gameSystem.mainFontFace();
        this.contents.fontSize = 19;
        this.resetTextColor();
    };
    return Window_DeckCaterogy;
}(Window_ClickableCommand));
var Window_DeckCardPreview = /** @class */ (function (_super) {
    __extends(Window_DeckCardPreview, _super);
    function Window_DeckCardPreview(storage, helpWindow, helpWindow2, helpWindow3, helpWindow4) {
        var _this = this;
        var r = new Rectangle(665, 90, 244, 382);
        _this = _super.call(this, r) || this;
        _this._effectHelpWindow = helpWindow;
        _this._effectHelpWindow2 = helpWindow2;
        _this._effectHelpWindow3 = helpWindow3;
        _this._effectHelpWindow4 = helpWindow4;
        _this._storage = storage;
        return _this;
    }
    Window_DeckCardPreview.prototype.setPosition = function (x, y, verticalOnly) {
        if (verticalOnly === void 0) { verticalOnly = true; }
        this.x = x;
        this.y = y;
        this.show();
        this._effectHelpWindow.x = x - 224;
        if (ConfigManager.isEn()) {
            this._effectHelpWindow.x -= 58;
        }
        this._effectHelpWindow2.x = this._effectHelpWindow.x;
        var interval = 120;
        this._effectHelpWindow.y = y;
        this._effectHelpWindow2.y = y + interval;
        if (verticalOnly) {
            this._effectHelpWindow3.x = this._effectHelpWindow.x;
            this._effectHelpWindow3.y = y + interval * 2;
            this._effectHelpWindow4.x = this._effectHelpWindow.x;
            this._effectHelpWindow4.y = y + interval * 3;
        }
        else {
            this._effectHelpWindow3.x = x - 480;
            this._effectHelpWindow3.y = y;
            this._effectHelpWindow4.x = x - 480;
            this._effectHelpWindow4.y = y + interval;
        }
        this.refreshHelp();
    };
    Window_DeckCardPreview.prototype.setIsMaseki = function (b) {
        this._isMaseki = b;
    };
    Window_DeckCardPreview.prototype.setCardSet = function (set, isDeck) {
        this._set = set;
        this._isDeck = isDeck;
        this.refresh();
    };
    Window_DeckCardPreview.prototype.maxCols = function () {
        return 1;
    };
    Window_DeckCardPreview.prototype.itemHeight = function () {
        return 350;
    };
    Window_DeckCardPreview.prototype.maxItems = function () {
        return 1;
    };
    Window_DeckCardPreview.prototype.refresh = function () {
        this.refreshHelp();
        _super.prototype.refresh.call(this);
    };
    Window_DeckCardPreview.prototype.refreshHelp = function () {
        if (!this._set) {
            this._effectHelpWindow.hide();
            this._effectHelpWindow2.hide();
            this._effectHelpWindow3.hide();
            this._effectHelpWindow4.hide();
            return;
        }
        if (!this.visible) {
            return;
        }
        var effects = this._set.effects();
        this._effectHelpWindow.visible = false;
        this._effectHelpWindow2.visible = false;
        this._effectHelpWindow3.visible = false;
        this._effectHelpWindow4.visible = false;
        if (effects.length == 0) {
            return;
        }
        this._effectHelpWindow.showHelp(effects[0]);
        if (effects.length == 1) {
            return;
        }
        this._effectHelpWindow2.showHelp(effects[1]);
        if (effects.length == 2) {
            return;
        }
        this._effectHelpWindow3.showHelp(effects[2]);
        if (effects.length == 3) {
            return;
        }
        this._effectHelpWindow4.showHelp(effects[3]);
    };
    Window_DeckCardPreview.prototype.hideAll = function () {
        this.hide();
        this._effectHelpWindow.visible = false;
        this._effectHelpWindow2.visible = false;
        this._effectHelpWindow3.visible = false;
        this._effectHelpWindow4.visible = false;
    };
    Window_DeckCardPreview.prototype.drawItem = function (index) {
        var rect = this.itemRect(index);
        var set = this._set;
        if (!set) {
            return;
        }
        this.drawCardItem(rect, set.card());
        if (this._isMaseki) {
            return;
        }
        this.drawCardNum(rect, set.num(), this._storage.num(set.skillId()));
    };
    Window_DeckCardPreview.prototype.itemRect = function (index) {
        var r = _super.prototype.itemRect.call(this, index);
        r.y += 7;
        return r;
    };
    Window_DeckCardPreview.prototype.drawCardNum = function (rect, num, maxNum) {
        this.changeTextColor(ColorManager.normalColor());
        this.contents.fontSize = 22;
        var xx = rect.x + 60;
        var yy = rect.y + rect.height - 38;
        this.drawText(maxNum, rect.x, yy, rect.width - 60, 'right');
        var deckNum;
        if (this._isDeck) {
            deckNum = num;
        }
        else {
            deckNum = maxNum - num;
        }
        this.drawIcon(16, xx, yy + 2);
        this.drawText(deckNum, xx, yy, 32, 'center');
    };
    Window_DeckCardPreview.prototype.update = function () {
        _super.prototype.update.call(this);
        if (!this.visible) {
            this._effectHelpWindow.visible = false;
            this._effectHelpWindow2.visible = false;
            this._effectHelpWindow3.visible = false;
            this._effectHelpWindow4.visible = false;
        }
    };
    return Window_DeckCardPreview;
}(Window_BaisyunCardList));
var Sprite_CardEffectHelp = /** @class */ (function (_super) {
    __extends(Sprite_CardEffectHelp, _super);
    function Sprite_CardEffectHelp(y, maxWait) {
        if (y === void 0) { y = 460; }
        if (maxWait === void 0) { maxWait = 0; }
        var _this = _super.call(this) || this;
        _this.x = 645;
        _this.y = y;
        _this._maxWait = maxWait;
        _this.bitmap = new Bitmap(300, 120);
        if (ConfigManager.isEn()) {
            _this._maxTextWidth = 280;
        }
        else {
            _this._maxTextWidth = 188;
        }
        return _this;
    }
    Sprite_CardEffectHelp.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateWait();
    };
    Sprite_CardEffectHelp.prototype.updateWait = function () {
        if (this._wait > 0) {
            this._wait--;
            if (this._wait == 0) {
                this.showAndRefresh();
            }
        }
    };
    Sprite_CardEffectHelp.prototype.showHelp = function (help) {
        this._help = help;
        if (help) {
            if (this._maxWait == 0) {
                this.showAndRefresh();
            }
            else {
                this._wait = this._maxWait;
            }
        }
        else {
            this.hide();
        }
    };
    Sprite_CardEffectHelp.prototype.hide = function () {
        this._wait = 0;
        _super.prototype.hide.call(this);
    };
    Sprite_CardEffectHelp.prototype.showAndRefresh = function () {
        this.show();
        this.refresh();
    };
    Sprite_CardEffectHelp.prototype.refresh = function () {
        this.bitmap.clear();
        this.drawBg();
        this.bitmap.fontSize = 22;
        this.bitmap.outlineWidth = 7;
        this.bitmap.outlineColor = '#361800';
        this.bitmap.drawText(this._help.name(), 16, 12, this._maxTextWidth, 32);
        this.bitmap.fontSize = 15;
        var yy = 50;
        for (var _i = 0, _a = this._help.descriptions(); _i < _a.length; _i++) {
            var t = _a[_i];
            this.bitmap.drawText(t, 18, yy, this._maxTextWidth, 32);
            yy += 22;
        }
    };
    Sprite_CardEffectHelp.prototype.drawBg = function () {
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        var x = ConfigManager.isJp() ? 0 : 110;
        if (ConfigManager.isEn()) {
            this.bitmap.blt(bitmap, 250, 400, 280, 130, 0, 0);
        }
        else {
            this.bitmap.blt(bitmap, 0, 400, 220, 130, 0, 0);
        }
    };
    return Sprite_CardEffectHelp;
}(Sprite));
var Window_CardNum = /** @class */ (function (_super) {
    __extends(Window_CardNum, _super);
    function Window_CardNum() {
        var r = new Rectangle(414, 200, 400, 190);
        return _super.call(this, r) || this;
    }
    Window_CardNum.prototype.setCardSet = function (set, maxNum) {
        this._set = set;
        this._maxNum = maxNum;
        this._initialNum = set.num();
        this.show();
        this.refresh();
        this.activate();
        this.select(set.num());
        $gameTemp.confirmWindowActive = true;
    };
    Window_CardNum.prototype.setPosition = function (x, y) {
        this.x = x;
        this.y = y;
    };
    Window_CardNum.prototype.itemHeight = function () {
        return 50;
    };
    Window_CardNum.prototype.itemRect = function (index) {
        var r = _super.prototype.itemRect.call(this, index);
        r.y += 50;
        if (index == 5) {
            r.x = 95;
            r.y += 5;
            r.width = 190;
        }
        return r;
    };
    Window_CardNum.prototype.maxItems = function () {
        return 6;
    };
    Window_CardNum.prototype.maxCols = function () {
        return 5;
    };
    Window_CardNum.prototype.isEnabled = function (index) {
        if (!this._set) {
            return false;
        }
        if (index == 5) {
            return true;
        }
        return index <= this._maxNum;
    };
    Window_CardNum.prototype.drawItem = function (index) {
        var r = this.itemRect(index);
        var text = index + '';
        if (index == 5) {
            text = TextManager.deckBack;
        }
        this.changePaintOpacity(true);
        if (index == this._initialNum) {
            this.drawCurrentArrow(r.x - 15, r.y - 55);
        }
        this.contents.textColor = ColorManager.normalColor();
        this.contents.fontSize = 24;
        this.contents.fontBold = true;
        this.changePaintOpacity(this.isEnabled(index));
        this.drawText(text, r.x, r.y + 5, r.width, 'center');
    };
    Window_CardNum.prototype.drawCurrentArrow = function (x, y) {
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        var yy = 0;
        if (ConfigManager.isEn()) {
            yy = 50;
        }
        this.contents.blt(bitmap, 450, yy, 100, 50, x, y);
    };
    Window_CardNum.prototype.hide = function () {
        _super.prototype.hide.call(this);
        $gameTemp.confirmWindowActive = false;
    };
    Window_CardNum.prototype.translucentOpacity = function () {
        return 60;
    };
    Window_CardNum.prototype.set = function () {
        return this._set;
    };
    Window_CardNum.prototype.isCurrentItemEnabled = function () {
        return this.isEnabled(this.index());
    };
    return Window_CardNum;
}(Window_Selectable));
