var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Sprite_DisturbanceEffect = /** @class */ (function (_super) {
    __extends(Sprite_DisturbanceEffect, _super);
    function Sprite_DisturbanceEffect() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Sprite_DisturbanceEffect.prototype.start = function (cardList, battle) {
        AudioManager.playSe({ name: 'card_DrawFantasyEastern', volume: 80, pitch: 100, pan: 0 });
        this._cardList = cardList;
        this.makeUiList(battle);
    };
    Sprite_DisturbanceEffect.prototype.makeUiList = function (battle) {
        this._uiList = [];
        var x = 200;
        var y = 300;
        var index = 0;
        for (var _i = 0, _a = this._cardList; _i < _a.length; _i++) {
            var card = _a[_i];
            var ui = new Sprite_DisturbanceCardUi(card, battle, index, x, y);
            ui.setFinishHandler(this.onFinish.bind(this));
            this.addChild(ui);
            this._uiList.push(ui);
            x += 228;
            index++;
        }
    };
    Sprite_DisturbanceEffect.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateUi();
    };
    Sprite_DisturbanceEffect.prototype.updateUi = function () {
        if (!this._uiList) {
            return;
        }
        for (var _i = 0, _a = this._uiList; _i < _a.length; _i++) {
            var ui = _a[_i];
            ui.update();
        }
    };
    Sprite_DisturbanceEffect.prototype.onFinish = function (ui) {
        this.removeChild(ui);
        this._uiList.remove(ui);
    };
    return Sprite_DisturbanceEffect;
}(Sprite));
var Sprite_DisturbanceCardUi = /** @class */ (function (_super) {
    __extends(Sprite_DisturbanceCardUi, _super);
    function Sprite_DisturbanceCardUi(card, battle, index, x, y) {
        var _this = _super.call(this) || this;
        _this._card = card;
        _this._battle = battle;
        _this._index = index;
        _this.x = x;
        _this.y = y;
        _this.scale.x = _this.scale.y = 0.8;
        _this.alpha = 0.1;
        _this.initCard();
        _this.initFilter();
        _this.initEvents();
        return _this;
    }
    Sprite_DisturbanceCardUi.prototype.setFinishHandler = function (f) {
        this._finishHandler = f;
    };
    Sprite_DisturbanceCardUi.prototype.initFilter = function () {
        var filter = new PIXI.filters.GlowFilter({ distance: 24, outerStrength: 12, color: 0x000000, quality: 0.1 });
        this.filters = [filter];
        filter.alpha = 0.6;
    };
    Sprite_DisturbanceCardUi.prototype.initCard = function () {
        this._cardSprite = new Sprite_BattleCard(this._battle);
        var innerRect = new Rectangle(0, 0, CARD_WIDTH, CARD_HEIGHT);
        var scale = 1;
        this._cardSprite.drawCardItem(innerRect, this._card, scale);
        this.addChild(this._cardSprite);
    };
    Sprite_DisturbanceCardUi.prototype.initEvents = function () {
        this._eventList = [];
        this._eventList.push(this.createAppearEvent(this.x, this.y));
        this._eventList.push(new CardMoveEvent(this, 80 + this._index * 10, this.x, this.y, 1, 1));
        if (this._index == 0) {
            this._eventList.push(new CardSeEvent());
        }
        if (this._card.skill().meta['toTrash']) {
            this._eventList.push(this.createMoveEvent(900, 750));
        }
        else {
            this._eventList.push(this.createMoveEvent(30, 750));
        }
    };
    Sprite_DisturbanceCardUi.prototype.createAppearEvent = function (toX, toY) {
        var e = new CardMoveEvent(this, 25, this.x, this.y, this.scale.x, 0.1);
        e.setDestination(toX, toY, 1, 1);
        return e;
    };
    Sprite_DisturbanceCardUi.prototype.createMoveEvent = function (toX, toY) {
        var e = new CardMoveEvent(this, 35, this.x, this.y, 1);
        var targetScale = 0.2;
        e.setDestination(toX, toY, targetScale);
        return e;
    };
    Sprite_DisturbanceCardUi.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateEvent();
    };
    Sprite_DisturbanceCardUi.prototype.updateEvent = function () {
        if (!this._eventList) {
            return;
        }
        var currentEvent = this._eventList[0];
        if (!currentEvent) {
            return;
        }
        var remove = currentEvent.update();
        if (remove) {
            this._eventList.shift();
            if (this._eventList.length == 0) {
                this.callFinishHandler();
            }
            else {
                this.updateEvent();
            }
        }
    };
    Sprite_DisturbanceCardUi.prototype.callFinishHandler = function () {
        if (!this._finishHandler) {
            return;
        }
        this._finishHandler.call(this, this);
    };
    return Sprite_DisturbanceCardUi;
}(Sprite));
var CardEvent = /** @class */ (function () {
    function CardEvent() {
    }
    CardEvent.prototype.update = function () {
        return true;
    };
    return CardEvent;
}());
var CardSeEvent = /** @class */ (function (_super) {
    __extends(CardSeEvent, _super);
    function CardSeEvent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CardSeEvent.prototype.update = function () {
        AudioManager.playSe({ name: 'card_TurnEndFantasyEastern', volume: 80, pitch: 100, pan: 0 });
        return true;
    };
    return CardSeEvent;
}(CardEvent));
var CardMoveEvent = /** @class */ (function (_super) {
    __extends(CardMoveEvent, _super);
    function CardMoveEvent(ui, duration, fromX, fromY, fromScale, fromAlpha) {
        if (fromAlpha === void 0) { fromAlpha = 1; }
        var _this = _super.call(this) || this;
        _this._speedX = 0;
        _this._speedY = 0;
        _this._speedScale = 0;
        _this._speedAlpha = 0;
        _this._ui = ui;
        _this._duration = duration;
        _this._fromX = fromX;
        _this._fromY = fromY;
        _this._fromScale = fromScale;
        _this._fromAlpha = fromAlpha;
        return _this;
        //ui.x = this._fromX;
        //ui.y = this._fromY;
    }
    CardMoveEvent.prototype.update = function () {
        if (this._duration <= 0) {
            return true;
        }
        this._duration--;
        this.move();
        return false;
    };
    CardMoveEvent.prototype.move = function () {
        this._ui.x += this._speedX;
        this._ui.y += this._speedY;
        this._ui.alpha += this._speedAlpha;
        this._ui.scale.x += this._speedScale;
        this._ui.scale.y += this._speedScale;
    };
    CardMoveEvent.prototype.setDestination = function (x, y, scale, alpha) {
        if (alpha === void 0) { alpha = 1; }
        this._targetX = x;
        this._targetY = y;
        this._targetScale = scale;
        this._targetAlpha = alpha;
        this.calcSpeed();
    };
    CardMoveEvent.prototype.calcSpeed = function () {
        this._speedX = (this._targetX - this._fromX) / this._duration;
        this._speedY = (this._targetY - this._fromY) / this._duration;
        this._speedScale = (this._targetScale - this._fromScale) / this._duration;
        this._speedAlpha = (this._targetAlpha - this._fromAlpha) / this._duration;
    };
    return CardMoveEvent;
}(CardEvent));
