var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var GOLD_PLUS_PER_LEVEL = 2;
var SHOTA_SW = 151;
var MAX_DAMAGE = 999;
var BaisyunEnemy = /** @class */ (function () {
    function BaisyunEnemy(enemyId) {
        this._stateMap = {};
        $gameTroop.setup(enemyId);
        this._enemyId = enemyId;
        this._shield = 0;
        this._voltage = 0;
        this._voltageC = this.enemy().params[0];
        this._voltageB = this.enemy().params[4];
        this._voltageA = this.enemy().params[5];
        this._voltageS = this.enemy().params[6];
        this.initDifficulty();
        this.initTaikenban();
        this.initShotaFlag();
        this._patience = this.enemy().params[1];
        this.calcMaxRankCount();
    }
    BaisyunEnemy.prototype.onBaisyunStart = function (actorId, player) {
        var manId = this.enemyId() - MAN_ID_ENEMY_OFFSET;
        var param = $baisyunManParamManager.findManParam(actorId, manId, true);
        param.ability1().onBattleStart(this, player, param.ability1Value());
        param.ability2().onBattleStart(this, player, param.ability2Value());
        if (this.isNotMan()) {
            var state = new BaisyunState(BaisyunStateType.douseiai, 1);
            this.addState(state);
        }
    };
    BaisyunEnemy.prototype.isNotMan = function () {
        var manId = this.enemyId() - MAN_ID_ENEMY_OFFSET;
        switch (manId) {
            case 111: // メイヴィス１回目
            case 121: // メイヴィス２回目
                return true;
        }
        return false;
    };
    BaisyunEnemy.prototype.initShotaFlag = function () {
        $gameSwitches.setValue(SHOTA_SW, false);
        var manId = this._enemyId - MAN_ID_ENEMY_OFFSET;
        var manParam = $baisyunManParamManager.findManParamByManId(manId);
        if (!manParam) {
            console.error(manId + 'の男情報が見つかりません');
            return;
        }
        p(manParam);
        $gameSwitches.setValue(SHOTA_SW, manParam.isShota());
    };
    BaisyunEnemy.prototype.gameEnemy = function () {
        return $gameTroop.members()[0];
    };
    BaisyunEnemy.prototype.initDifficulty = function () {
        return;
        if ($gameSystem.difficulty() == Difficulty.NORMAL) {
            return;
        }
        var hpRate = $gameSystem.difficulty() == Difficulty.EASY ? 0.75 : 0.25;
        this._voltageC = Math.round(this._voltageC * hpRate);
        this._voltageB = Math.round(this._voltageB * hpRate);
        this._voltageA = Math.round(this._voltageA * hpRate);
        this._voltageS = Math.round(this._voltageS * hpRate);
    };
    BaisyunEnemy.prototype.initTaikenban = function () {
        if (!Nore.isTaikenban()) {
            return;
        }
        if ($gameSystem.difficulty() == Difficulty.STORY) {
            return;
        }
        if (!this.isBoss()) {
            return;
        }
        // 体験版のボスはHP７０％
        var hpRate = 0.7;
        this._voltageC = Math.round(this._voltageC * hpRate);
        this._voltageB = Math.round(this._voltageB * hpRate);
        this._voltageA = Math.round(this._voltageA * hpRate);
        this._voltageS = Math.round(this._voltageS * hpRate);
    };
    BaisyunEnemy.prototype.calcMaxRankCount = function () {
        this._maxRankCount = 1;
        if (this._voltageC < this._voltageB) {
            this._maxRankCount++;
        }
        if (this._voltageB < this._voltageA) {
            this._maxRankCount++;
        }
    };
    BaisyunEnemy.prototype.imageFile = function () {
        return this.enemy().battlerName;
    };
    BaisyunEnemy.prototype.isBoss = function () {
        return this.enemy().meta['boss'] != null;
    };
    BaisyunEnemy.prototype.enemy = function () {
        return $dataEnemies[this._enemyId];
    };
    BaisyunEnemy.prototype.enemyId = function () {
        return this._enemyId;
    };
    BaisyunEnemy.prototype.name = function () {
        return this.enemy().name;
    };
    BaisyunEnemy.prototype.voltage = function () {
        return this._voltage;
    };
    BaisyunEnemy.prototype.patience = function () {
        return this._patience;
    };
    BaisyunEnemy.prototype.voltageC = function () {
        return this._voltageC;
    };
    BaisyunEnemy.prototype.voltageB = function () {
        return this._voltageB;
    };
    BaisyunEnemy.prototype.voltageA = function () {
        return this._voltageA;
    };
    BaisyunEnemy.prototype.voltageS = function () {
        return this._voltageS;
    };
    BaisyunEnemy.prototype.voltageRank = function () {
        if (this._voltage < this.voltageC()) {
            return VoltageRank.D;
        }
        var maxRankCount = this.maxRankCount();
        if (maxRankCount == 1) {
            return VoltageRank.C;
        }
        if (this._voltage < this.voltageB()) {
            return VoltageRank.C;
        }
        if (maxRankCount == 2) {
            return VoltageRank.B;
        }
        if (this._voltage < this.voltageA()) {
            return VoltageRank.B;
        }
        return VoltageRank.A;
    };
    BaisyunEnemy.prototype.isNamaOnlyFail = function (player, card) {
        if (!this.hasState(BaisyunStateType.namaOnly)) {
            return false;
        }
        if (card && card.isNama()) {
            return false;
        }
        if (player.hasState(BaisyunStateType.nama)) {
            return false;
        }
        if (this._voltage >= MAX_DAMAGE) {
            // 即死ダメージなら許可
            return false;
        }
        return true;
    };
    BaisyunEnemy.prototype.voltageDamageRate = function (rank) {
        switch (rank) {
            case VoltageResult.D:
                {
                    var max = this.voltageC();
                    return this._voltage / max;
                }
            case VoltageResult.C:
                {
                    var min = this.voltageC();
                    var max = this.voltageB();
                    if (max == min) {
                        return 1;
                    }
                    return (this._voltage - min) / (max - min);
                }
            case VoltageResult.B:
                {
                    var min = this.voltageB();
                    var max = this.voltageA();
                    return (this._voltage - min) / (max - min);
                }
        }
        return 0;
    };
    BaisyunEnemy.prototype.isMaxRank = function (player) {
        var rank = this.voltageRank();
        if (rank == VoltageRank.A) {
            if (this.isNamaConditionNotClear(player)) {
                return false;
            }
            return true;
        }
        var maxRankCount = this.maxRankCount();
        if (maxRankCount == 1) {
            return (rank == VoltageRank.C);
        }
        if (maxRankCount == 2) {
            return (rank == VoltageRank.B);
        }
        return false;
    };
    BaisyunEnemy.prototype.isNamaConditionNotClear = function (player) {
        if (!player) {
            return false;
        }
        if (this.hasState(BaisyunStateType.namaOnly)) {
            if (!player.hasState(BaisyunStateType.nama)) {
                // 生の条件を満たしていない
                if (this._voltage >= MAX_DAMAGE) {
                    return false;
                }
                return true;
            }
        }
        return false;
    };
    BaisyunEnemy.prototype.maxRank = function () {
        var maxRankCount = this.maxRankCount();
        if (maxRankCount == 1) {
            return VoltageRank.C;
        }
        if (maxRankCount == 2) {
            return VoltageRank.B;
        }
        return VoltageRank.A;
    };
    BaisyunEnemy.prototype.plusVoltage = function (n) {
        if (this._shield > 0) {
            if (this._shield > n) {
                this._shield -= n;
                return;
            }
            n -= this._shield;
            this._shield = 0;
        }
        this._voltage += n;
        this.updateVoltageState();
    };
    BaisyunEnemy.prototype.updateVoltageState = function () {
        if (!this.hasState(BaisyunStateType.poverty)) {
            return;
        }
        this.clearState(BaisyunStateType.atkUp);
        var value = Math.floor(this._voltage / 10);
        if (value > 0) {
            this.addState(new BaisyunState(BaisyunStateType.atkUp, value));
        }
    };
    BaisyunEnemy.prototype.calcReward = function () {
        var base = this.enemy().gold;
        return Math.round(base * this.voltageRate());
    };
    BaisyunEnemy.prototype.voltageRate = function () {
        if (this.hasAbility(14)) {
            // 金持ち
            switch (this.voltageRank()) {
                case VoltageRank.D: return 0;
                case VoltageRank.C: return 0.7;
                case VoltageRank.B: return 1;
                case VoltageRank.A: return 1.3;
                case VoltageRank.S: return 1.6;
            }
        }
        else {
            switch (this.voltageRank()) {
                case VoltageRank.D: return 0;
                case VoltageRank.C: return 0.7;
                case VoltageRank.B: return 1;
                case VoltageRank.A: return 1.2;
                case VoltageRank.S: return 1.4;
            }
        }
    };
    BaisyunEnemy.prototype.onTurnStart = function () {
        this.updateStates();
        var enemy = this.gameEnemy();
        enemy.onActionStart();
        enemy.clearActions();
        enemy.makeActions();
        this.clearShield();
        this.invokeAbility();
        this._dirty = true;
    };
    BaisyunEnemy.prototype.clearShield = function () {
        this._shield = 0;
    };
    BaisyunEnemy.prototype.invokeAbility = function () {
        if (this.hasState(BaisyunStateType.tsundere)) {
            var value = this.stateValue(BaisyunStateType.tsundere);
            this.gainShield(value);
        }
    };
    BaisyunEnemy.prototype.gainShield = function (n) {
        this._shield += n;
    };
    BaisyunEnemy.prototype.shield = function () {
        return this._shield;
    };
    BaisyunEnemy.prototype.onPlayerTurnEnd = function () {
        this.gainVoltageAuto();
    };
    BaisyunEnemy.prototype.onEnemyTurnEnd = function () {
        this.addStateAuto();
    };
    BaisyunEnemy.prototype.gainVoltageAuto = function () {
        if (this.hasState(BaisyunStateType.gainVoltage)) {
            this.plusVoltage(this.stateValue(BaisyunStateType.gainVoltage));
        }
    };
    BaisyunEnemy.prototype.addStateAuto = function () {
        if (this.hasState(BaisyunStateType.impulsive)) {
            var value = this.stateValue(BaisyunStateType.impulsive);
            this.addState(new BaisyunState(121, value));
        }
        if (this.hasState(BaisyunStateType.shihaiyoku)) {
            var value = this.stateValue(BaisyunStateType.shihaiyoku);
            this.addState(new BaisyunState(115, value));
        }
        if (this.hasState(BaisyunStateType.sobou)) {
            var value = this.stateValue(BaisyunStateType.sobou);
            this.addState(new BaisyunState(115, value));
        }
        if (this.hasState(BaisyunStateType.inki)) {
            var value = this.stateValue(BaisyunStateType.inki);
            this.addState(new BaisyunState(115, value));
        }
    };
    BaisyunEnemy.prototype.isWeakness = function () {
        return this.hasState(BaisyunStateType.weakness);
    };
    BaisyunEnemy.prototype.hasState = function (stateType) {
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.type() == stateType) {
                return state.value() > 0;
            }
        }
        return false;
    };
    BaisyunEnemy.prototype.stateValue = function (stateType) {
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.type() == stateType) {
                return state.value();
            }
        }
        return 0;
    };
    BaisyunEnemy.prototype.updateStates = function () {
        this.minusState(BaisyunStateType.atkDown, 1);
        this.minusState(BaisyunStateType.yuuwaku, 1);
        this.minusState(BaisyunStateType.weakness, 1);
        //this.minusState(BaisyunStateType.defDownEnemy, 1);
    };
    BaisyunEnemy.prototype.clearState = function (stateType) {
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.type() == stateType) {
                state.clear();
                return;
            }
        }
    };
    BaisyunEnemy.prototype.minusState = function (stateType, num) {
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.type() == stateType) {
                state.minusValue(num);
                return;
            }
        }
    };
    BaisyunEnemy.prototype.action = function () {
        return this.gameEnemy().currentAction();
    };
    BaisyunEnemy.prototype.hp = function () {
        if (this.isMaxRank(null)) {
            return this.mhp();
        }
        switch (this.voltageRank()) {
            case VoltageRank.D: return this._voltage;
            case VoltageRank.C: return this._voltage - this._voltageC;
            case VoltageRank.B:
            case VoltageRank.A:
                var n = this._voltage - this._voltageB;
                if (n > this.mhp()) {
                    return this.mhp();
                }
                return n;
        }
    };
    BaisyunEnemy.prototype.mhp = function () {
        var rank = this.voltageRank();
        if (this.isMaxRank(null)) {
            rank = this.maxRank();
            if (rank == VoltageRank.C) {
                return this._voltageC;
            }
        }
        switch (rank) {
            case VoltageRank.D: return this._voltageC;
            case VoltageRank.C: return this._voltageB - this._voltageC;
            case VoltageRank.B:
            case VoltageRank.A:
                return this._voltageA - this._voltageB;
        }
    };
    BaisyunEnemy.prototype.calcGold = function (voltageResult, damageRate, finishCard, rewardUp) {
        var gold = this.gameEnemy().gold();
        var goldRate = 1;
        switch (voltageResult) {
            case VoltageResult.D:
                return 0;
            case VoltageResult.C:
                goldRate = 1 + (0.3 * damageRate);
                break;
            case VoltageResult.B:
                goldRate = 1.5 + (0.3 * damageRate);
                break;
            case VoltageResult.A:
                goldRate = 2;
                break;
        }
        var finishRate = finishCard ? 1.3 : 1;
        var goldPlus = this.goldPlus();
        p('goldRate:' + goldRate + ' goldPlus:' + goldPlus);
        var finalRate = finishRate + rewardUp / 100;
        return Math.round(gold * goldRate * finalRate) + goldPlus;
    };
    BaisyunEnemy.prototype.goldPlus = function () {
        var actor = $gameSystem.baisyunActor();
        var level = actor.baisyunLevel();
        return (level.level() - 1) * GOLD_PLUS_PER_LEVEL;
    };
    BaisyunEnemy.prototype.calcExp = function (voltageResult) {
        var exp = this.gameEnemy().exp();
        switch (voltageResult) {
            case VoltageResult.D:
                break;
            case VoltageResult.C:
                break;
            case VoltageResult.B:
                exp *= 1.5;
                break;
            case VoltageResult.A:
                exp *= 2;
                break;
        }
        return Math.round(exp);
    };
    BaisyunEnemy.prototype.addState = function (s) {
        if (!this.stateAddable(s)) {
            return;
        }
        s.setValue(this.calcStateValue(s));
        if (this._stateMap[s.stateId()]) {
            this._stateMap[s.stateId()].addValue(s.value());
        }
        else {
            this._stateMap[s.stateId()] = s;
        }
        this._dirty = true;
    };
    BaisyunEnemy.prototype.addStateList = function (list) {
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var s = list_1[_i];
            this.addState(s);
        }
    };
    BaisyunEnemy.prototype.stateAddable = function (s) {
        if (s.selectType() == BaisyunStateType.weakness) {
            if (this.hasState(BaisyunStateType.strong)) {
                return false;
            }
        }
        return true;
    };
    BaisyunEnemy.prototype.calcStateValue = function (s) {
        if (s.isPassive()) {
            return s.value();
        }
        if (s.type() == BaisyunStateType.atkUp) {
            return s.value();
        }
        if (this.hasAbility(3)) {
            // バカアビリティ
            return s.value() + 1;
        }
        return s.value();
    };
    BaisyunEnemy.prototype.stateList = function () {
        var result = [];
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.value() > 0) {
                result.push(state);
            }
        }
        result = result.sort(function (a, b) {
            return b.orderId() - a.orderId();
        });
        return result;
    };
    BaisyunEnemy.prototype.isDirty = function () {
        return this._dirty;
    };
    BaisyunEnemy.prototype.clearDirty = function () {
        this._dirty = false;
    };
    BaisyunEnemy.prototype.atkDown = function () {
        for (var key in this._stateMap) {
            var state = this._stateMap[key];
            if (state.type() == BaisyunStateType.atkDown) {
                return state.value();
            }
        }
        return 0;
    };
    BaisyunEnemy.prototype.maxRankCount = function () {
        return this._maxRankCount;
    };
    BaisyunEnemy.prototype.hasAbility = function (abilityId) {
        var manParam = $baisyunManParamManager.findManParamByManId(this._enemyId - MAN_ID_ENEMY_OFFSET);
        return manParam.hasAbilityId(abilityId);
    };
    BaisyunEnemy.prototype.isBlockFinish = function () {
        return this.hasState(BaisyunStateType.nenchakushitsu);
    };
    BaisyunEnemy.prototype.isMan = function () {
        return !this.hasState(BaisyunStateType.douseiai);
    };
    BaisyunEnemy.prototype.maxManaPlus = function () {
        if (this.hasState(BaisyunStateType.kikijouzu)) {
            return 1;
        }
        return 0;
    };
    BaisyunEnemy.prototype.handPlus = function () {
        if (this.hasState(BaisyunStateType.MILFLover)) {
            return 1;
        }
        if (this.hasState(BaisyunStateType.lolicon)) {
            return 1;
        }
        if (this.hasState(BaisyunStateType.otokonokoLover)) {
            return 1;
        }
        return 0;
    };
    return BaisyunEnemy;
}());
var Sprite_BaisyunEnemyAction = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunEnemyAction, _super);
    function Sprite_BaisyunEnemyAction(enemy) {
        var _this = _super.call(this) || this;
        _this._enemy = enemy;
        _this.bitmap = new Bitmap(500, 200);
        _this.refresh();
        return _this;
    }
    Sprite_BaisyunEnemyAction.prototype.refresh = function () {
        this.bitmap.clear();
        this.removeChildren();
        var action = this._enemy.action();
        this._lastAction = action;
        if (!action || !action.isValid()) {
            return;
        }
        var success = this.drawDamage(action);
        this.drawActionIcon(action, success);
    };
    Sprite_BaisyunEnemyAction.prototype.drawActionIcon = function (action, drawDamage) {
        this.drawIcon(action.item().iconIndex, drawDamage ? 30 : 50, 10);
    };
    Sprite_BaisyunEnemyAction.prototype.drawDamage = function (action) {
        var d = this.makeDamageValue(action);
        if (d <= 0) {
            return false;
        }
        this.bitmap.fontSize = 36;
        var atkDown = this._enemy.atkDown();
        if (atkDown == 0) {
            this.bitmap.textColor = ColorManager.normalColor();
        }
        else {
            this.bitmap.textColor = '#999999';
        }
        this.drawNumber(d, 74, 0, 100, 'left', 13);
        // this.bitmap.drawText(d + '', 40, 10, 120, 32, 'center');
        return true;
    };
    Sprite_BaisyunEnemyAction.prototype.makeDamageValue = function (action) {
        if (!action.isDamage()) {
            return 0;
        }
        var actor = $gameActors.actor(100);
        var damage = Math.floor(action.makeDamageValue(actor, false));
        var atkDown = this._enemy.atkDown();
        return damage - atkDown;
    };
    Sprite_BaisyunEnemyAction.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Sprite_BaisyunEnemyAction.prototype.isChanged = function () {
        var action = this._enemy.action();
        if (this._lastAction == null) {
            if (action == null) {
                return false;
            }
            return true;
        }
        return action.item() != this._lastAction.item();
    };
    return Sprite_BaisyunEnemyAction;
}(Sprite));
var Window_BaisyunMiniEnemyStatus = /** @class */ (function (_super) {
    __extends(Window_BaisyunMiniEnemyStatus, _super);
    function Window_BaisyunMiniEnemyStatus(battle, enemy, actionSprite) {
        var _this = _super.call(this) || this;
        _this.y = 350;
        _this.bitmap = new Bitmap(400, 140);
        _this._battle = battle;
        _this._enemy = enemy;
        _this._actionSprite = actionSprite;
        _this._voltageSprite = new Sprite_Voltage(enemy);
        _this._voltageSprite.x = 10;
        _this._voltageSprite.y = 4;
        _this.addChild(_this._voltageSprite);
        _this._numberSprite = new Sprite();
        _this.addChild(_this._numberSprite);
        _this.refresh();
        return _this;
    }
    Window_BaisyunMiniEnemyStatus.prototype.refresh = function () {
        this._lastTime = this._battle.remainTime();
        this.bitmap.clear();
        this.bitmap.fontSize = 26;
        this._numberSprite.removeChildren();
        this.draBg();
        this.draVoltageText();
        this._enemy.clearDirty();
        this.drawStates();
        this._actionSprite.refresh();
    };
    Window_BaisyunMiniEnemyStatus.prototype.draBg = function () {
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        this.bitmap.blt(bitmap, 0, 130, 400, 140, 0, 0);
    };
    Window_BaisyunMiniEnemyStatus.prototype.draVoltageText = function () {
        var bitmap = ImageManager.loadSystem('baisyun_ui');
        var y = ConfigManager.isJp() ? 300 : 325;
        this.bitmap.blt(bitmap, 0, y, 150, 25, 191, 32);
    };
    Window_BaisyunMiniEnemyStatus.prototype.drawStates = function () {
        var index = 0;
        var states = this._enemy.stateList();
        for (var _i = 0, states_1 = states; _i < states_1.length; _i++) {
            var s = states_1[_i];
            this.drawState(index, s);
            index++;
        }
    };
    Window_BaisyunMiniEnemyStatus.prototype.drawState = function (index, state) {
        var x = index * this.stateWidth() + 14;
        var y = 80;
        this.drawIcon(state.iconIndex(), x, y);
        //if (! state.isPassive()) {
        this._numberSprite.drawNumber(state.value(), x + 10, y + 15, 30, 'left', 1);
        //}
    };
    Window_BaisyunMiniEnemyStatus.prototype.stateWidth = function () {
        return 28;
    };
    Window_BaisyunMiniEnemyStatus.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this.isChanged()) {
            this.refresh();
        }
    };
    Window_BaisyunMiniEnemyStatus.prototype.isChanged = function () {
        if (!this._enemy) {
            return false;
        }
        if (this._enemy.isDirty()) {
            return true;
        }
        return this._lastTime != this._battle.remainTime();
    };
    return Window_BaisyunMiniEnemyStatus;
}(Sprite));
