var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var BaisyunEventList = /** @class */ (function () {
    function BaisyunEventList() {
        this._list = [];
    }
    BaisyunEventList.prototype.update = function (battle, scene) {
        if (this._list.length == 0) {
            return;
        }
        var event = this._list[0];
        if (!event.isStarted()) {
            event.start(battle, scene);
            while (this._list[0] != event) {
                event = this._list[0];
                event.start(battle, scene);
            }
        }
        var finish = event.update(battle, scene);
        if (finish) {
            this._list.shift();
        }
    };
    BaisyunEventList.prototype.inEvent = function () {
        return this._list.length > 0;
    };
    BaisyunEventList.prototype.useCard = function (card) {
        this._list.push(new BaisyunCardStartCardAnimeEvent(card));
        this._list.push(new BaisyunCardCostEvent(card));
        this._list.push(new BaisyunWaitEvent(this.waitFrame()));
        this._list.push(new BaisyunCardPlaySeEvent(card));
        this._list.push(new BaisyunRemoveCardUiEvent(card));
        this._list.push(new BaisyunDiscardAllEvent(card));
        this._list.push(new BaisyunCardStockFillEvent(card));
        this._list.push(new BaisyunCardSelectCardEvent(card));
        this._list.push(new BaisyunCardDiscardCardEvent(card));
        this._list.push(new BaisyunCardMedalEvent(card));
        //this._list.push(new BaisyunCardBeforeCostumeEvent(card));  脱いでから着るのはやっぱりおかしい？
        this._list.push(new BaisyunCardCostumeEvent(card));
        this._list.push(new BaisyunCardNamaEvent(card));
        this._list.push(new BaisyunCardScenarioEvent(card));
        this._list.push(this.makeTalkEvent(card));
        //this._list.push(new BaisyunCardSyaseiEvent(card));
        this._list.push(new BaisyunWaitEvent(this.waitFrame()));
        this._list.push(new BaisyunCardEvent(card));
        if (card.attackCount() == 2) {
            this._list.push(new BaisyunWaitEvent(40));
            this._list.push(new BaisyunCardEvent(card, true));
        }
        this._list.push(new BaisyunCardEndSyaseiEvent(card));
        this._list.push(this.makeManTalkEvent(card));
        this._list.push(new BaisyunCardCostumeStateEvent(card));
        this._list.push(new BaisyunWaitTalkEvent());
        this._list.push(new BaisyunCardScenario2Event(card));
    };
    BaisyunEventList.prototype.waitFrame = function () {
        if ($gameTemp.isBaisyunSpeedUp()) {
            //return 4;
        }
        return 14;
    };
    BaisyunEventList.prototype.insertNext = function (event) {
        if (this._list.length == 0) {
            console.error('イベントリストが空です');
            return;
        }
        this._list.splice(1, 0, event);
    };
    BaisyunEventList.prototype.insertTop = function (event) {
        this._list.splice(0, 0, event);
    };
    BaisyunEventList.prototype.makeTalkEvent = function (card) {
        return new BaisyunTalkEvent(card);
    };
    BaisyunEventList.prototype.makeManTalkEvent = function (card) {
        return new BaisyunManTalkEvent(card);
    };
    BaisyunEventList.prototype.enemyAction = function (battle) {
        var enemy = battle.enemy();
        var action = enemy.action();
        this._list.push(new BaisyunDisturbanceCardEvent(battle));
        this._list.push(new BaisyunManActionTalkEvent(action));
        var wait = $gameTemp.isBaisyunSpeedUp() ? 5 : 20;
        this._list.push(new BaisyunWaitEvent(wait));
        this._list.push(new BaisyunManActionEvent(action));
        this._list.push(new BaisyunManAddDisturbanceEvent(action));
        this._list.push(new BaisyunWaitTalkEvent());
        this._list.push(new BaisyunWaitEvent(5));
        this._list.push(new BaisyunLastChanceEvent());
        this._list.push(new BaisyunNextTurnEvent());
        this._list.push(new BaisyunFinishEroEvent());
    };
    BaisyunEventList.prototype.isActive = function () {
        return this._list.length > 0;
    };
    return BaisyunEventList;
}());
var BaisyunEvent = /** @class */ (function () {
    function BaisyunEvent() {
    }
    BaisyunEvent.prototype.isStarted = function () {
        return this._started;
    };
    BaisyunEvent.prototype.start = function (battle, scene) {
        this._started = true;
    };
    return BaisyunEvent;
}());
var BaisyunTalkEvent = /** @class */ (function (_super) {
    __extends(BaisyunTalkEvent, _super);
    function BaisyunTalkEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunTalkEvent.prototype.update = function (battle, scene) {
        var baisyun = battle.baisyun();
        baisyun.setHoppeId(this._card.hoppeId());
        baisyun.setFaceId(this._card.faceId());
        battle.setBaisyunTalk(this.makeTalk(battle));
        return true;
    };
    BaisyunTalkEvent.prototype.makeTalk = function (battle) {
        return new BaisyunTalk(true, this._card.message1(battle.actorId()));
    };
    return BaisyunTalkEvent;
}(BaisyunEvent));
var BaisyunManTalkEvent = /** @class */ (function (_super) {
    __extends(BaisyunManTalkEvent, _super);
    function BaisyunManTalkEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunManTalkEvent.prototype.update = function (battle) {
        return this.makeActorReactionTalk(battle);
    };
    BaisyunManTalkEvent.prototype.makeActorReactionTalk = function (battle) {
        if (!this._card.isAttack()) {
            return true;
        }
        var voltageRank = battle.enemy().voltageRank();
        var enemyId = battle.enemy().enemyId() - MAN_ID_ENEMY_OFFSET;
        if (battle.isFinished()) {
            var talk_1 = this.makeFinishTalk(voltageRank, enemyId);
            battle.setBaisyunManTalk(talk_1);
            return true;
        }
        var talk = this.makeTalk(voltageRank, enemyId);
        battle.setBaisyunManTalk(talk);
        return true;
    };
    BaisyunManTalkEvent.prototype.makeTalk = function (voltageRank, enemyId) {
        var actorId = this._card.actorId();
        return ManTalkManager.manTalk(actorId, voltageRank, enemyId);
    };
    BaisyunManTalkEvent.prototype.makeFinishTalk = function (voltageRank, enemyId) {
        var actorId = this._card.actorId();
        return ManTalkManager.makeFinishTalk(actorId, voltageRank, enemyId);
    };
    return BaisyunManTalkEvent;
}(BaisyunEvent));
var BaisyunDisturbanceCardEvent = /** @class */ (function (_super) {
    __extends(BaisyunDisturbanceCardEvent, _super);
    function BaisyunDisturbanceCardEvent(battle) {
        var _this = _super.call(this) || this;
        _this._actionList = battle.disturbanceActions();
        _this._wait = 30;
        return _this;
    }
    BaisyunDisturbanceCardEvent.prototype.start = function (battle, scene) {
        _super.prototype.start.call(this, battle, scene);
        for (var _i = 0, _a = this._actionList; _i < _a.length; _i++) {
            var action = _a[_i];
            battle.startAnime(this.animeId(battle, action), false);
            // アニメは一回だけ
            break;
        }
        for (var _b = 0, _c = this._actionList; _b < _c.length; _b++) {
            var action = _c[_b];
            battle.executeAction(action);
        }
    };
    BaisyunDisturbanceCardEvent.prototype.animeId = function (battle, action) {
        var damage = battle.forecastEnemyDamage(action);
        var shield = battle.player().shield();
        if (shield >= damage) {
            return GUARD_ATTACK_ANIME_ID;
        }
        return NORMAL_ATTACK_ANIME_ID;
    };
    BaisyunDisturbanceCardEvent.prototype.update = function (battle) {
        if (this._actionList.length == 0) {
            return true;
        }
        this._wait--;
        if (this._wait <= 0) {
            return true;
        }
        return false;
    };
    return BaisyunDisturbanceCardEvent;
}(BaisyunEvent));
var BaisyunManActionTalkEvent = /** @class */ (function (_super) {
    __extends(BaisyunManActionTalkEvent, _super);
    function BaisyunManActionTalkEvent(action) {
        var _this = _super.call(this) || this;
        _this._action = action;
        return _this;
    }
    BaisyunManActionTalkEvent.prototype.update = function (battle) {
        var enemyId = battle.enemy().enemyId() - MAN_ID_ENEMY_OFFSET;
        var actorId = battle.actorId();
        var action = battle.enemy().action();
        var isSkill = this.isSkill(battle);
        if (isSkill) {
            var talk = ManTalkManager.makeSkillTalk(actorId, enemyId);
            battle.setBaisyunManTalk(talk);
        }
        else {
            var talk = ManTalkManager.makeAttackTalk(actorId, enemyId);
            battle.setBaisyunManTalk(talk);
        }
        return true;
    };
    BaisyunManActionTalkEvent.prototype.isSkill = function (battle) {
        var action = battle.enemy().action();
        if (!action) {
            return false;
        }
        if (!action.isValid()) {
            return false;
        }
        var animeId = action.item().animationId;
        return !this.normalAttackAnimeIds().contains(animeId);
    };
    BaisyunManActionTalkEvent.prototype.normalAttackAnimeIds = function () {
        return [221, 222];
    };
    return BaisyunManActionTalkEvent;
}(BaisyunEvent));
var BaisyunWaitEvent = /** @class */ (function (_super) {
    __extends(BaisyunWaitEvent, _super);
    function BaisyunWaitEvent(wait) {
        var _this = _super.call(this) || this;
        _this._wait = wait;
        return _this;
    }
    BaisyunWaitEvent.prototype.update = function (battle) {
        this._wait--;
        if ($gameTemp.isBaisyunSpeedUp()) {
            this._wait -= 3;
        }
        if (this._wait <= 0) {
            return true;
        }
        return false;
    };
    return BaisyunWaitEvent;
}(BaisyunEvent));
var BaisyunDiscardAllEvent = /** @class */ (function (_super) {
    __extends(BaisyunDiscardAllEvent, _super);
    function BaisyunDiscardAllEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunDiscardAllEvent.prototype.start = function (battle, scene) {
        _super.prototype.start.call(this, battle, scene);
        if (this._card.discardAll()) {
            var cardList = battle.hand().cardList();
            battle.executeDiscardAll(this._card);
            scene._handListWindow.discardAll();
            for (var _i = 0, cardList_1 = cardList; _i < cardList_1.length; _i++) {
                var c = cardList_1[_i];
                battle.executeDiscardEffect(c);
            }
        }
    };
    BaisyunDiscardAllEvent.prototype.update = function (battle) {
        return true;
    };
    return BaisyunDiscardAllEvent;
}(BaisyunEvent));
var BaisyunRemoveCardUiEvent = /** @class */ (function (_super) {
    __extends(BaisyunRemoveCardUiEvent, _super);
    function BaisyunRemoveCardUiEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunRemoveCardUiEvent.prototype.start = function (battle, scene) {
        _super.prototype.start.call(this, battle, scene);
        var isFinished = false;
        if (this._card.isFinish()) {
            if (battle.canFinish()) {
                isFinished = true;
            }
        }
        scene._handListWindow.removeRemovedCardUi(this._card, isFinished);
    };
    BaisyunRemoveCardUiEvent.prototype.update = function (battle) {
        return true;
    };
    return BaisyunRemoveCardUiEvent;
}(BaisyunEvent));
var BaisyunWaitTalkEvent = /** @class */ (function (_super) {
    __extends(BaisyunWaitTalkEvent, _super);
    function BaisyunWaitTalkEvent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BaisyunWaitTalkEvent.prototype.update = function (battle) {
        if (battle.baisyunTalk()) {
            return false;
        }
        if (battle.baisyunManTalk()) {
            return false;
        }
        return true;
    };
    return BaisyunWaitTalkEvent;
}(BaisyunEvent));
var NORMAL_ATTACK_ANIME_ID = 221;
var GUARD_ATTACK_ANIME_ID = 222;
var BaisyunManAddDisturbanceEvent = /** @class */ (function (_super) {
    __extends(BaisyunManAddDisturbanceEvent, _super);
    function BaisyunManAddDisturbanceEvent(action) {
        var _this = _super.call(this) || this;
        _this._action = action;
        _this._waitFrame = 0;
        return _this;
    }
    BaisyunManAddDisturbanceEvent.prototype.update = function (battle, scene) {
        this._waitFrame--;
        return this._waitFrame <= 0;
    };
    BaisyunManAddDisturbanceEvent.prototype.start = function (battle, scene) {
        _super.prototype.start.call(this, battle, scene);
        var skill = this._action.item();
        if (skill.meta['addDisturbanceCard']) {
            var addCard = parseInt(skill.meta['addDisturbanceCard']);
            var addCardNum = parseInt(skill.meta['addDisturbanceCardNum']);
            this.execute(battle, scene, addCard, addCardNum);
        }
    };
    BaisyunManAddDisturbanceEvent.prototype.execute = function (battle, scene, cardId, num) {
        this._waitFrame = 70;
        var cardList = [];
        var toStock = true;
        for (var i = 0; i < num; i++) {
            var card = new BaisyunCard(1, cardId);
            card.setId(battle.nextCardId());
            cardList.push(card);
            if (card.skill().meta['toStock']) {
                toStock = true;
            }
            else if (card.skill().meta['toTrash']) {
                toStock = false;
            }
            else {
                console.error('お邪魔カードの行き先が指定されていません:' + cardId);
            }
        }
        if (toStock) {
            battle.stock().addDisturbanceCardList(cardList);
        }
        else {
            battle.trashCan().addDisturbanceCardList(cardList);
        }
        scene.startDisturbanceCardEffect(cardList);
    };
    return BaisyunManAddDisturbanceEvent;
}(BaisyunEvent));
var BaisyunManActionEvent = /** @class */ (function (_super) {
    __extends(BaisyunManActionEvent, _super);
    function BaisyunManActionEvent(action) {
        var _this = _super.call(this) || this;
        _this._action = action;
        return _this;
    }
    BaisyunManActionEvent.prototype.update = function (battle, scene) {
        battle.startAnime(this.animeId(battle), this._action.isForUser());
        battle.executeAction(this._action);
        scene.clearForecast();
        return true;
    };
    BaisyunManActionEvent.prototype.isNormalAttack = function (item) {
        if (this._action.isForUser()) {
            return false;
        }
        return item.animationId == NORMAL_ATTACK_ANIME_ID;
    };
    BaisyunManActionEvent.prototype.animeId = function (battle) {
        if (!this.isNormalAttack(this._action.item())) {
            return this._action.item().animationId;
        }
        var damage = battle.forecastEnemyDamage(this._action);
        var shield = battle.player().shield();
        if (shield >= damage) {
            return GUARD_ATTACK_ANIME_ID;
        }
        return NORMAL_ATTACK_ANIME_ID;
    };
    return BaisyunManActionEvent;
}(BaisyunEvent));
var BaisyunNextTurnEvent = /** @class */ (function (_super) {
    __extends(BaisyunNextTurnEvent, _super);
    function BaisyunNextTurnEvent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BaisyunNextTurnEvent.prototype.update = function (battle, scene) {
        scene.nextTurn();
        if (battle.isTimeOver()) {
            return true;
        }
        if (battle.isShuffled()) {
            var nextEvent = new BaisyunWaitShuffleEvent();
            battle.baisyunEventList().insertNext(nextEvent);
        }
        else {
            scene.activateHandWindow();
        }
        return true;
    };
    return BaisyunNextTurnEvent;
}(BaisyunEvent));
var BaisyunLastChanceEvent = /** @class */ (function (_super) {
    __extends(BaisyunLastChanceEvent, _super);
    function BaisyunLastChanceEvent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BaisyunLastChanceEvent.prototype.start = function (battle, scene) {
        _super.prototype.start.call(this, battle, scene);
        if (battle.player().hp() <= 0) {
            return;
        }
        if (battle.remainTime() == 0) {
            this._lastChance = true;
        }
    };
    BaisyunLastChanceEvent.prototype.update = function (battle, scene) {
        if (!this._lastChance) {
            return true;
        }
        var scenario = '売春ラストチャンス_01';
        scene.playCardScenario(scenario);
        var waitEevnt = new BaisyunWaitEvent(90);
        battle.baisyunEventList().insertNext(waitEevnt);
        var card = new BaisyunCard($gameSystem.baisyunActorId(), 1128);
        var nextEvent = new BaisyunCardEvent(card);
        battle.baisyunEventList().insertNext(nextEvent);
        var talkEvent = new BaisyunTalkEvent(card);
        battle.baisyunEventList().insertNext(talkEvent);
        var waitEevnt2 = new BaisyunWaitEvent(60);
        battle.baisyunEventList().insertNext(waitEevnt2);
        return true;
    };
    return BaisyunLastChanceEvent;
}(BaisyunEvent));
var BaisyunWaitShuffleEvent = /** @class */ (function (_super) {
    __extends(BaisyunWaitShuffleEvent, _super);
    function BaisyunWaitShuffleEvent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BaisyunWaitShuffleEvent.prototype.start = function (battle, scene) {
        battle.gainShuffleMana();
        scene.startShuffleEffect();
        _super.prototype.start.call(this, battle, scene);
    };
    BaisyunWaitShuffleEvent.prototype.update = function (battle, scene) {
        if (scene.cardShuffleSprite()) {
            return false;
        }
        else {
            battle.endShuffle();
            return true;
        }
    };
    return BaisyunWaitShuffleEvent;
}(BaisyunEvent));
var BaisyunCardEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardEvent, _super);
    function BaisyunCardEvent(card, isDoubleAttack) {
        if (isDoubleAttack === void 0) { isDoubleAttack = false; }
        var _this = _super.call(this) || this;
        _this._card = card;
        _this._isDoubleAttack = isDoubleAttack;
        return _this;
    }
    BaisyunCardEvent.prototype.start = function (battle, scene) {
        _super.prototype.start.call(this, battle, scene);
        /* if (this._card.drawCardNum() > 0) {
             const stock = battle.stock();
             if (stock.remain() < this._card.drawCardNum()) {
                 stock.fill();
                 const event = new BaisyunWaitShuffleEvent();
                 battle.baisyunEventList().insertTop(event);
             }
         }*/
    };
    BaisyunCardEvent.prototype.update = function (battle, scene) {
        this.execute(battle, scene);
        return true;
    };
    BaisyunCardEvent.prototype.execute = function (battle, scene) {
        battle.executeCard(this._card, this._isDoubleAttack);
        battle.hand().refreshAll();
        if (this._card.isAttack()) {
            battle.startAnime(this._card.animationId(), true);
        }
        else {
            battle.startAnime(this._card.animationId(), false);
        }
    };
    return BaisyunCardEvent;
}(BaisyunEvent));
var BaisyunCardMedalEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardMedalEvent, _super);
    function BaisyunCardMedalEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardMedalEvent.prototype.update = function (battle, scene) {
        if (this._card.isFella()) {
            $gameMedals.onFella(battle.actorId());
        }
        return true;
    };
    return BaisyunCardMedalEvent;
}(BaisyunEvent));
var BaisyunCardStockFillEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardStockFillEvent, _super);
    function BaisyunCardStockFillEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardStockFillEvent.prototype.start = function (battle, scene) {
        _super.prototype.start.call(this, battle, scene);
        if (this.needStockNum() == 0) {
            return;
        }
        var stock = battle.stock();
        if (stock.remain() < this.needStockNum()) {
            stock.fill();
            var event_1 = new BaisyunWaitShuffleEvent();
            battle.baisyunEventList().insertTop(event_1);
        }
    };
    BaisyunCardStockFillEvent.prototype.needStockNum = function () {
        if (this._card.selectCard() > 0) {
            return this._card.selectCard();
        }
        if (this._card.drawCardNum() > 0) {
            return this._card.drawCardNum();
        }
        return 0;
    };
    BaisyunCardStockFillEvent.prototype.update = function (battle, scene) {
        return true;
    };
    return BaisyunCardStockFillEvent;
}(BaisyunEvent));
var BaisyunCardSelectCardEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardSelectCardEvent, _super);
    function BaisyunCardSelectCardEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardSelectCardEvent.prototype.start = function (battle, scene) {
        _super.prototype.start.call(this, battle, scene);
        if (this._card.selectCard() == 0) {
            return;
        }
        var cardList = battle.stock().randomCardList(this._card.selectCard());
        scene.selectCard(cardList);
        this._isWindowShown = true;
        //battle.hand().refreshAll();
    };
    BaisyunCardSelectCardEvent.prototype.update = function (battle, scene) {
        if (scene.isSelectCardWindowActive()) {
            return false;
        }
        if (this._isWindowShown) {
            scene.activateHandWindow();
        }
        return true;
    };
    return BaisyunCardSelectCardEvent;
}(BaisyunEvent));
var BaisyunCardDiscardCardEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardDiscardCardEvent, _super);
    function BaisyunCardDiscardCardEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardDiscardCardEvent.prototype.start = function (battle, scene) {
        _super.prototype.start.call(this, battle, scene);
        if (this._card.discardNum() == 0) {
            return;
        }
        scene.setDiscardSelect(true);
        //battle.hand().refreshAll();
    };
    BaisyunCardDiscardCardEvent.prototype.update = function (battle, scene) {
        if (battle.inDiscardSelect()) {
            return false;
        }
        return true;
    };
    return BaisyunCardDiscardCardEvent;
}(BaisyunEvent));
var BaisyunCardScenarioEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardScenarioEvent, _super);
    function BaisyunCardScenarioEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardScenarioEvent.prototype.update = function (battle, scene) {
        if (this._card.isManOnly() && !battle.enemy().isMan()) {
            return true;
        }
        var scenario = this._card.scenario(battle);
        if (scenario) {
            scene.playCardScenario(scenario);
        }
        else {
            if (this.isEroEventRunning()) {
                if (battle.player().hasEroEventState()) {
                    // エロイベント続行
                    $gameSwitches.setValue(35, true);
                }
                else {
                    scene.playCardScenario('endEro');
                }
            }
        }
        return true;
    };
    BaisyunCardScenarioEvent.prototype.isEroEventRunning = function () {
        return $gameSwitches.value(29);
    };
    return BaisyunCardScenarioEvent;
}(BaisyunEvent));
var BaisyunStayEroAnimeEvent = /** @class */ (function (_super) {
    __extends(BaisyunStayEroAnimeEvent, _super);
    function BaisyunStayEroAnimeEvent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BaisyunStayEroAnimeEvent.prototype.update = function (battle, scene) {
        if (this.isEroEventRunning()) {
            var scenario = battle.player().stayEroScenario();
            if (scenario) {
                scene.playCardScenario(scenario);
            }
        }
        return true;
    };
    BaisyunStayEroAnimeEvent.prototype.isEroEventRunning = function () {
        return $gameSwitches.value(29);
    };
    return BaisyunStayEroAnimeEvent;
}(BaisyunEvent));
var BaisyunCardScenario2Event = /** @class */ (function (_super) {
    __extends(BaisyunCardScenario2Event, _super);
    function BaisyunCardScenario2Event(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardScenario2Event.prototype.update = function (battle, scene) {
        var scenario = this._card.scenario2(battle);
        if (scenario) {
            scene.playCardScenario2(scenario);
        }
        return true;
    };
    BaisyunCardScenario2Event.prototype.isEroEventRunning = function () {
        return $gameSwitches.value(29);
    };
    return BaisyunCardScenario2Event;
}(BaisyunEvent));
var BaisyunFinishEroEvent = /** @class */ (function (_super) {
    __extends(BaisyunFinishEroEvent, _super);
    function BaisyunFinishEroEvent() {
        return _super.call(this) || this;
    }
    BaisyunFinishEroEvent.prototype.update = function (battle, scene) {
        if (this.isStateEroEventRunning()) {
            if (battle.player().hasEroEventState()) {
                // エロイベント続行
            }
            else {
                scene.playCardScenario('endEro');
            }
        }
        return true;
    };
    BaisyunFinishEroEvent.prototype.isStateEroEventRunning = function () {
        return $gameSwitches.value(35);
    };
    return BaisyunFinishEroEvent;
}(BaisyunEvent));
var BaisyunCardPlaySeEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardPlaySeEvent, _super);
    function BaisyunCardPlaySeEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardPlaySeEvent.prototype.update = function (battle) {
        this.execute(battle);
        return true;
    };
    BaisyunCardPlaySeEvent.prototype.execute = function (battle) {
        if (this._card.isFinish()) {
            AudioManager.playSe({ name: 'LNSM_SE18_Select6', volume: 90, pitch: 100, pan: 0 });
        }
        else {
            AudioManager.playSe({ name: 'LNSM_SE01_Sense1', volume: 80, pitch: 120, pan: 0 });
        }
    };
    return BaisyunCardPlaySeEvent;
}(BaisyunEvent));
var BaisyunCardStartCardAnimeEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardStartCardAnimeEvent, _super);
    function BaisyunCardStartCardAnimeEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardStartCardAnimeEvent.prototype.update = function (battle) {
        this.execute(battle);
        return true;
    };
    BaisyunCardStartCardAnimeEvent.prototype.execute = function (battle) {
        battle.hand().onUseCard(this._card);
    };
    return BaisyunCardStartCardAnimeEvent;
}(BaisyunEvent));
var BaisyunCardCostEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardCostEvent, _super);
    function BaisyunCardCostEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardCostEvent.prototype.update = function (battle) {
        this.execute(battle);
        return true;
    };
    BaisyunCardCostEvent.prototype.execute = function (battle) {
        battle.consumeCost(this._card);
    };
    return BaisyunCardCostEvent;
}(BaisyunEvent));
var BaisyunCardBeforeCostumeEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardBeforeCostumeEvent, _super);
    function BaisyunCardBeforeCostumeEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        _this._wait = 0;
        _this._executed = false;
        return _this;
    }
    BaisyunCardBeforeCostumeEvent.prototype.update = function (battle) {
        this.execute(battle);
        this.updateWait();
        return this._wait == 0;
    };
    BaisyunCardBeforeCostumeEvent.prototype.execute = function (battle) {
        if (this._executed) {
            return;
        }
        var changed = battle.executeCardBeforeCostume(this._card);
        if (changed) {
            this._wait = 15;
        }
        this._executed = true;
    };
    BaisyunCardBeforeCostumeEvent.prototype.updateWait = function () {
        if (this._wait > 0) {
            this._wait--;
        }
    };
    return BaisyunCardBeforeCostumeEvent;
}(BaisyunEvent));
var BaisyunCardNamaEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardNamaEvent, _super);
    function BaisyunCardNamaEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardNamaEvent.prototype.update = function (battle) {
        this.execute(battle);
        return true;
    };
    BaisyunCardNamaEvent.prototype.execute = function (battle) {
        if (this._card.isNama()) {
            battle.setNama();
            battle.player().addState(new BaisyunState(BaisyunStateType.nama, 99));
        }
    };
    return BaisyunCardNamaEvent;
}(BaisyunEvent));
var BaisyunCardCostumeEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardCostumeEvent, _super);
    function BaisyunCardCostumeEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardCostumeEvent.prototype.update = function (battle) {
        this.execute(battle);
        return true;
    };
    BaisyunCardCostumeEvent.prototype.execute = function (battle) {
        var changed = battle.executeCardCostume(this._card);
        if (changed) {
            var nextEvent = new BaisyunStayEroAnimeEvent();
            battle.baisyunEventList().insertNext(nextEvent);
        }
    };
    return BaisyunCardCostumeEvent;
}(BaisyunEvent));
var BaisyunCardCostumeStateEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardCostumeStateEvent, _super);
    function BaisyunCardCostumeStateEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardCostumeStateEvent.prototype.update = function (battle, scene) {
        this.execute(battle, scene);
        return true;
    };
    BaisyunCardCostumeStateEvent.prototype.execute = function (battle, scene) {
        battle.executeCardCostumeState(this._card);
        battle.hand().setDirty();
    };
    return BaisyunCardCostumeStateEvent;
}(BaisyunEvent));
var BaisyunCardSyaseiEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardSyaseiEvent, _super);
    function BaisyunCardSyaseiEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardSyaseiEvent.prototype.update = function (battle) {
        if (this._wait > 0) {
            this._wait--;
            if (this._wait <= 0) {
                return true;
            }
            return false;
        }
        if (!this._card.isSyasei()) {
            return true;
        }
        if (battle.player().canSyasei()) {
            this.execute(battle);
            this._wait = 40;
            return false;
        }
        return true;
    };
    BaisyunCardSyaseiEvent.prototype.execute = function (battle) {
        SoundManager.playSyasei();
        battle.baisyun().syasei();
    };
    return BaisyunCardSyaseiEvent;
}(BaisyunEvent));
var BaisyunCardEndSyaseiEvent = /** @class */ (function (_super) {
    __extends(BaisyunCardEndSyaseiEvent, _super);
    function BaisyunCardEndSyaseiEvent(card) {
        var _this = _super.call(this) || this;
        _this._card = card;
        return _this;
    }
    BaisyunCardEndSyaseiEvent.prototype.update = function (battle) {
        var baisyun = battle.baisyun();
        baisyun.endSyasei();
        return true;
    };
    return BaisyunCardEndSyaseiEvent;
}(BaisyunEvent));
