/*:ja
 * @target MZ
 * @author ル
 *
 * @command updateFlag
 * @text 売春フラグ更新
 * @des 売春フラグ更新
 *
 *
 * @command resetFlag
 * @text 売春フラグリセット
 * @des 売春フラグリセット
 * @arg actorId
 * @type number
 *
 * @command resetFlagTutorial
 * @text 売春フラグリセット(チュートリアル用)
 * @des 売春フラグリセット(チュートリアル用)
 *
 * @command baisyun
 * @text 再度売春
 * @des 再度売春
 *
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_BaisyunFlag';
    PluginManager.registerCommand(pluginName, 'updateFlag', function (args) {
        var argManId = $gameSystem.baisyun().manId();
        var result = $gameVariables.value(BAISYUN_RESULT_VAR_ID);
        var gold = $gameVariables.value(BAISYUN_GOLD_VAR_ID);
        var damageRate = $gameVariables.value(BAISYUN_RESULT_DAMAGE_RATE_ID);
        var rewardUp = $gameVariables.value(BAISYUN_RESULT_REWARD_UP_ID);
        var param = $baisyunManParamManager.findManParamByManId(argManId);
        var manId = argManId;
        if (param.sameManId() > 0) {
            manId = param.sameManId();
        }
        p('売春フラグ:' + argManId + ' ' + result);
        $baisyunFlagManager.onBaisyun(manId, result);
        var actor = $gameSystem.baisyunActor();
        actor.baisyunHistory().onBaisyun(manId, result, gold, damageRate, rewardUp);
        $gameVariables.setValue(BAISYUN_RESULT_VAR_ID, 0);
        $gameVariables.setValue(BAISYUN_GOLD_VAR_ID, 0);
    });
    PluginManager.registerCommand(pluginName, 'resetFlag', function (args) {
        var actorId = parseInt(args.actorId);
        $baisyunFlagManager.clearAllFlags(actorId);
    });
    PluginManager.registerCommand(pluginName, 'resetFlagTutorial', function (args) {
        $baisyunFlagManager.clearAllFlagsTutorial();
    });
    PluginManager.registerCommand(pluginName, 'baisyun', function (args) {
        var manId = $gameSystem.baisyun().manId();
        var actor = $gameSystem.baisyun().actor();
        var result = actor.baisyunHistory().lastResult(manId);
        var baisyunBattle = new BaisyunBattle(actor.baisyunPlayer(), $gameSystem.baisyun().troopId());
        var damageRate = result.damageRate();
        var exp = baisyunBattle.enemy().calcExp(result.rank());
        var gold = baisyunBattle.enemy().calcGold(result.rank(), damageRate, false, result.rewardUp());
        actor.baisyunPlayer().baisyunLevel().gainExp(exp);
        $gameVariables.setValue(BAISYUN_RESULT_VAR_ID, result.rank());
        $gameVariables.setValue(BAISYUN_GOLD_VAR_ID, gold);
        $gameParty.addBaisyunGold(gold);
    });
})(Nore || (Nore = {}));
var ManFlag;
(function (ManFlag) {
    ManFlag[ManFlag["normal"] = 0] = "normal";
    ManFlag[ManFlag["already"] = 1] = "already";
    ManFlag[ManFlag["success"] = 2] = "success";
    ManFlag[ManFlag["failure"] = 3] = "failure";
})(ManFlag || (ManFlag = {}));
var BaisyunFlagManager = /** @class */ (function () {
    function BaisyunFlagManager() {
    }
    BaisyunFlagManager.prototype.clearAllFlags = function (actorId) {
        var actor = $gameActors.actor(actorId);
        var history = actor.baisyunHistory();
        for (var i = 100; i < 200; i++) {
            var varId = this.manVarId(i);
            var flag = history.count(i) == 0 ? ManFlag.normal : ManFlag.already;
            $gameVariables.setValue(varId, flag);
        }
    };
    BaisyunFlagManager.prototype.clearAllFlagsTutorial = function () {
        var actor = $gameActors.actor(2);
        var history = actor.baisyunHistory();
        history.clear();
        for (var i = 100; i < 200; i++) {
            var varId = this.manVarId(i);
            var flag = ManFlag.normal;
            $gameVariables.setValue(varId, flag);
        }
    };
    BaisyunFlagManager.prototype.manVarId = function (manId) {
        if (manId < 100) {
            console.error('不正な男IDです:' + manId);
            return -1;
        }
        return manId + 100;
    };
    BaisyunFlagManager.prototype.onBaisyun = function (manId, result) {
        if (result == VoltageResult.D) {
            this.onFailure(manId);
        }
        else {
            this.onSuccess(manId);
        }
    };
    BaisyunFlagManager.prototype.onSuccess = function (manId) {
        var varId = this.manVarId(manId);
        $gameVariables.setValue(varId, ManFlag.success);
        /*
        if (manId == 11) {
            // パティの初回
            $gameSwitches.setValue(405, true);

        }*/
    };
    BaisyunFlagManager.prototype.onFailure = function (manId) {
        var varId = this.manVarId(manId);
        $gameVariables.setValue(varId, ManFlag.failure);
    };
    BaisyunFlagManager.prototype.isFailure = function (manId) {
        var varId = this.manVarId(manId);
        return $gameVariables.value(varId) == ManFlag.failure;
    };
    BaisyunFlagManager.prototype.isSuccess = function (manId) {
        var varId = this.manVarId(manId);
        return $gameVariables.value(varId) == ManFlag.success;
    };
    return BaisyunFlagManager;
}());
var $baisyunFlagManager;
(function (Nore) {
    var _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _DataManager_createGameObjects.call(this);
        $baisyunFlagManager = new BaisyunFlagManager();
    };
})(Nore || (Nore = {}));
