var BaisyunForecast = /** @class */ (function () {
    function BaisyunForecast(battle) {
        this._battle = battle;
        this._forecastDamage = 0;
    }
    BaisyunForecast.prototype.update = function () {
        if (!this._reservedCard) {
            return;
        }
        if (this._battle.isEventRunning()) {
            return;
        }
        this.forecast(this._reservedCard);
        this._reservedCard = null;
    };
    BaisyunForecast.prototype.forecast = function (card) {
        if (this._battle.isEventRunning() && card) {
            this._reservedCard = card;
            return;
        }
        var before = this._battle.player().hp();
        var clone = JsonEx.makeDeepCopy(this._battle);
        clone.player().setClone(true);
        clone.executeForecast(card);
        clone.executeDisturbanceDamage();
        var after = clone.player().hp();
        this._forecastDamage = before - after;
    };
    BaisyunForecast.prototype.forecastDamage = function () {
        return this._forecastDamage;
    };
    BaisyunForecast.prototype.clear = function () {
        this._reservedCard = null;
        this._forecastDamage = 0;
    };
    return BaisyunForecast;
}());
