var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Sprite_BaisyunHandCard = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunHandCard, _super);
    function Sprite_BaisyunHandCard(card, hand, battle, initialX, onErace) {
        var _this = _super.call(this) || this;
        _this._targetScale = 0.75;
        _this._targetAngle = 0;
        _this._angle = 0;
        _this._targetOpacity = 255;
        _this._discardSpeedY = 2;
        _this._opacitySpeed = 2;
        _this._discardSpeedScale = 0.1;
        _this._card = card;
        _this._hand = hand;
        _this._battle = battle;
        _this._onErace = onErace;
        _this.createFilterSprite();
        _this.createBackSprite();
        _this.createCardSprite(battle);
        _this._targetX = _this.x = initialX;
        _this._targetY = _this.y = _this.baseY();
        _this._selectedFilter = new PIXI.filters.OutlineFilter(0, 0xEDCC90);
        _this._specialEffectFilter = new PIXI.filters.OutlineFilter(8, 0xE44175);
        _this._canUseFilter = new PIXI.filters.OutlineFilter(0, 0xEDCC90);
        _this._canUseSpecialEffectFilter = new PIXI.filters.OutlineFilter(5, 0xE44175);
        _this.refresh();
        return _this;
    }
    Sprite_BaisyunHandCard.prototype.card = function () {
        return this._card;
    };
    Sprite_BaisyunHandCard.prototype.drawBg = function () {
        this.bitmap = new Bitmap(CARD_WIDTH, CARD_HEIGHT);
        var r = new Rectangle(0, 0, CARD_WIDTH, CARD_HEIGHT);
        this.anchor.x = 0.5;
        this.anchor.y = 0.5;
        this.bitmap.fillRect(r.x, r.y, r.width, r.height, '#333333');
    };
    Sprite_BaisyunHandCard.prototype.createFilterSprite = function () {
        this._filterSprite = new Sprite();
        this.addChild(this._filterSprite);
        this._filterSprite.bitmap = new Bitmap(CARD_WIDTH, CARD_HEIGHT);
        var r = new Rectangle(0, 0, CARD_WIDTH, CARD_HEIGHT);
        this._filterSprite.anchor.x = 0.5;
        this._filterSprite.anchor.y = 0.5;
        this._filterSprite.bitmap.fillRect(r.x, r.y, r.width, r.height, '#3333F3');
    };
    Sprite_BaisyunHandCard.prototype.createBackSprite = function () {
        this._backSprite = new Sprite();
        this.addChild(this._backSprite);
        this._backSprite.bitmap = new Bitmap(CARD_WIDTH, CARD_HEIGHT);
        var r = new Rectangle(0, 0, CARD_WIDTH, CARD_HEIGHT);
        this._backSprite.anchor.x = 0.5;
        this._backSprite.anchor.y = 0.5;
        this._backSprite.bitmap.fillRect(r.x, r.y, r.width, r.height, '#333333');
    };
    Sprite_BaisyunHandCard.prototype.createCardSprite = function (battle) {
        this._cardSprite = new Sprite_BattleCard(battle);
        this.addChild(this._cardSprite);
    };
    Sprite_BaisyunHandCard.prototype.cardId = function () {
        return this._card.id();
    };
    Sprite_BaisyunHandCard.prototype.setIndex = function (index, maxItems, selectedIndex) {
        if (this._removeEffect) {
            this._index = index;
            this._maxItems = maxItems;
            return;
        }
        var offsetCenter = (index - (maxItems - 1) / 2);
        this._targetX = this.calcX(index, maxItems, selectedIndex);
        this._targetAngle = this.calcAngle(index, maxItems, selectedIndex, offsetCenter);
        this._targetY = this.calcY(index, maxItems, selectedIndex, offsetCenter);
        this._targetScale = this.calcScale(index, selectedIndex);
        this._index = index;
        this._maxItems = maxItems;
    };
    Sprite_BaisyunHandCard.prototype.index = function () {
        return this._index;
    };
    Sprite_BaisyunHandCard.prototype.calcScale = function (index, selectedIndex) {
        if (index == selectedIndex) {
            return this.selectedScale();
        }
        return this.normalScale();
    };
    Sprite_BaisyunHandCard.prototype.selectedScale = function () {
        return 1;
    };
    Sprite_BaisyunHandCard.prototype.normalScale = function () {
        return 0.75;
    };
    Sprite_BaisyunHandCard.prototype.calcAngle = function (index, maxItems, selectedIndex, offsetCenter) {
        if (index == selectedIndex) {
            return 0;
        }
        return offsetCenter * 3;
    };
    Sprite_BaisyunHandCard.prototype.calcX = function (index, maxItems, selectedIndex) {
        var center = 530;
        var offset = this.calcOffset(maxItems);
        var x = Math.round(center + (index - maxItems / 2) * offset);
        if (selectedIndex < 0) {
            return x;
        }
        if (index == selectedIndex) {
            x += this.offsetSelectedCardX(index, maxItems);
        }
        else {
            x += this.offsetCardXAwayFromSelectedCard(index, maxItems, selectedIndex);
        }
        return x;
    };
    Sprite_BaisyunHandCard.prototype.offsetCardXAwayFromSelectedCard = function (index, maxItems, selectedIndex) {
        var offset = 0;
        if (index < selectedIndex) {
            offset -= 16;
            if (maxItems >= 8) {
                offset -= 5;
            }
        }
        else if (index > selectedIndex) {
            offset += 21;
            if (maxItems >= 8) {
                offset += 25;
            }
        }
        return offset;
    };
    Sprite_BaisyunHandCard.prototype.offsetSelectedCardX = function (index, maxItems) {
        if (maxItems < 8) {
            return 0;
        }
        var center = maxItems / 2;
        if (index < center) {
            return -10;
        }
        else if (index > center) {
            return 10;
        }
        return 0;
    };
    Sprite_BaisyunHandCard.prototype.calcY = function (index, maxItems, selectedIndex, offsetCenter) {
        var base = this.baseY();
        if (index == selectedIndex) {
            return base - 40;
        }
        var abs = Math.abs(offsetCenter);
        var rate = 1;
        for (var i = 0; i < offsetCenter; i++) {
            rate -= 0.05;
        }
        return base + abs * 5 * rate;
    };
    Sprite_BaisyunHandCard.prototype.baseY = function () {
        return 170;
    };
    Sprite_BaisyunHandCard.prototype.calcOffset = function (maxItems) {
        switch (maxItems) {
            case 1: return 0;
            case 2: return 150;
            case 3: return 140;
            case 4: return 140;
            case 5: return 120;
            default:
                return 610 / maxItems;
        }
    };
    Sprite_BaisyunHandCard.prototype.isUsed = function (cardList) {
        for (var _i = 0, cardList_1 = cardList; _i < cardList_1.length; _i++) {
            var c = cardList_1[_i];
            if (this._card.id() == c.id()) {
                return false;
            }
        }
        return true;
    };
    Sprite_BaisyunHandCard.prototype.selectCard = function () {
        this._selected = true;
        if (this._card.canUse(this._battle)) {
            if (this._card.isSpecialEffectAvailable(this._battle)) {
                this._filterSprite.filters = [this._specialEffectFilter];
            }
            else {
                this._filterSprite.filters = [this._selectedFilter];
            }
        }
        else {
            this._filterSprite.filters = [];
        }
        this._targetScale = this.selectedScale();
    };
    Sprite_BaisyunHandCard.prototype.deselectCard = function () {
        this._selected = false;
        if (this._card.canUse(this._battle)) {
            if (this._card.isSpecialEffectAvailable(this._battle)) {
                this._filterSprite.filters = [this._canUseSpecialEffectFilter];
            }
            else {
                this._filterSprite.filters = [this._canUseFilter];
            }
        }
        else {
            this._filterSprite.filters = [];
        }
        this._targetScale = this.normalScale();
    };
    Sprite_BaisyunHandCard.prototype.update = function () {
        _super.prototype.update.call(this);
        this.movePosition();
        this.updateAngle();
        this.updateScale();
        this.updateOpacity();
        this.updateFilter();
    };
    Sprite_BaisyunHandCard.prototype.updateFilter = function () {
        if (!this._card.isSpecialEffectAvailable(this._battle)) {
            this._filterSprite.opacity = 255;
            return;
        }
        var speed = 5;
        if (this._filterOpacityIncrease) {
            if (this._filterSprite.opacity < 255) {
                this._filterSprite.opacity += speed;
            }
            else {
                this._filterOpacityIncrease = false;
            }
        }
        else {
            if (this._filterSprite.opacity > 120) {
                this._filterSprite.opacity -= speed;
            }
            else {
                this._filterOpacityIncrease = true;
            }
        }
    };
    Sprite_BaisyunHandCard.prototype.updateScale = function () {
        var speed = this.calcScaleSpeed();
        if (Math.abs(this._targetScale - this.scale.x) <= speed) {
            this.scale.x = this.scale.y = this._targetScale;
        }
        else if (this._targetScale > this.scale.x) {
            this.scale.x += speed;
            this.scale.y += speed;
        }
        else if (this._targetScale < this.scale.x) {
            this.scale.x -= speed;
            this.scale.y -= speed;
        }
    };
    Sprite_BaisyunHandCard.prototype.calcScaleSpeed = function () {
        if (this._discard || this._exhaust) {
            return this._discardSpeedScale;
        }
        return 0.1;
    };
    Sprite_BaisyunHandCard.prototype.movePosition = function () {
        this.movePositionX();
        this.movePositionY();
    };
    Sprite_BaisyunHandCard.prototype.movePositionY = function () {
        var speed = this.calcYSpeed();
        if (Math.abs(this._targetY - this.y) <= speed) {
            this.y = this._targetY;
        }
        else if (this._targetY > this.y) {
            this.y += speed;
        }
        else if (this._targetY < this.y) {
            this.y -= speed;
        }
    };
    Sprite_BaisyunHandCard.prototype.calcYSpeed = function () {
        if (this._discard) {
            return this._discardSpeedY;
        }
        if (this._finished) {
            return 25;
        }
        return 15;
    };
    Sprite_BaisyunHandCard.prototype.movePositionX = function () {
        var speed = this.calcXSpeed();
        if (Math.abs(this._targetX - this.x) <= speed) {
            this.x = this._targetX;
            if (!this._initialized) {
                this._initialized = true;
                AudioManager.playSe({ name: 'Book1', volume: 80, pitch: 150, pan: 0 });
            }
            if (this._discard) {
                this.removeFromParent();
            }
        }
        else if (this._targetX > this.x) {
            this.x += speed;
        }
        else if (this._targetX < this.x) {
            this.x -= speed;
        }
    };
    Sprite_BaisyunHandCard.prototype.calcXSpeed = function () {
        if (!this._initialized) {
            return 25;
        }
        if (Math.abs(this.targetX() - this.x) > 200) {
            return 25;
        }
        if (this._discard) {
            return 20;
        }
        if (this._selected) {
            return 15;
        }
        return 8;
    };
    Sprite_BaisyunHandCard.prototype.updateAngle = function () {
        var speed = this.calcAngleSpeed();
        if (Math.abs(this._targetAngle - this._angle) <= speed) {
            this._angle = this._targetAngle;
        }
        else if (this._targetAngle > this._angle) {
            this._angle += speed;
        }
        else if (this._targetAngle < this._angle) {
            this._angle -= speed;
        }
        this.rotation = this.toRadian(this._angle);
    };
    Sprite_BaisyunHandCard.prototype.calcAngleSpeed = function () {
        if (this._discard) {
            return 14;
        }
        if (this._finished) {
            return 14;
        }
        if (this._selected) {
            return 3;
        }
        return 2;
    };
    Sprite_BaisyunHandCard.prototype.toRadian = function (angle) {
        return angle * (Math.PI / 180);
    };
    Sprite_BaisyunHandCard.prototype.updateOpacity = function () {
        if (this.opacity <= this._targetOpacity) {
            return;
        }
        this.opacity -= this.calcOpacitySpeed();
        if (this._exhaust && this.opacity <= this._targetOpacity) {
            this.removeFromParent();
        }
    };
    Sprite_BaisyunHandCard.prototype.calcOpacitySpeed = function () {
        return this._opacitySpeed;
    };
    Sprite_BaisyunHandCard.prototype.removeFromParent = function () {
        if (this._onErace) {
            this._onErace.call(this, this);
        }
    };
    Sprite_BaisyunHandCard.prototype.refresh = function () {
        this._cardSprite.bitmap.clear();
        var scale = CardScale.big;
        var innerRect = new Rectangle(0, 0, CARD_WIDTH, CARD_HEIGHT);
        this._cardSprite.drawCardItem(innerRect, this._card, scale, this._battle);
    };
    Sprite_BaisyunHandCard.prototype.contains = function (cx, cy) {
        if (this._maxItems <= 5) {
            return this.itemRect().contains(cx, cy);
        }
        if (this.index() == this._maxItems - 1) {
            return this.itemRect().contains(cx, cy);
        }
        var itemRect = this.itemRect();
        itemRect.width -= 20;
        if (this._selected) {
            itemRect.width -= 25;
            itemRect.x += 20;
        }
        return itemRect.contains(cx, cy);
    };
    Sprite_BaisyunHandCard.prototype.itemRect = function () {
        var w = CARD_WIDTH * this._targetScale;
        var h = CARD_HEIGHT * this._targetScale;
        var xx = this._targetX - w / 2 - 15;
        var yy = this.baseY() - h / 2 - 50;
        var r = new Rectangle(xx, yy, w, 350);
        if (this.isFirstCard() && this._targetScale == 1) {
            r.x -= 20;
            r.width += 20;
        }
        if (this.isLastCard() && this._targetScale == 1) {
            r.width += 20;
        }
        return r;
    };
    Sprite_BaisyunHandCard.prototype.isFirstCard = function () {
        return this._index == 0;
    };
    Sprite_BaisyunHandCard.prototype.isLastCard = function () {
        return this._index + 1 == this._maxItems;
    };
    Sprite_BaisyunHandCard.prototype.targetX = function () {
        return this._targetX;
    };
    Sprite_BaisyunHandCard.prototype.removeEffect = function () {
        this._removeEffect = true;
        this._targetY -= 50;
        this._targetScale = 1.2;
    };
    Sprite_BaisyunHandCard.prototype.isRemoved = function () {
        return this._removeEffect;
    };
    Sprite_BaisyunHandCard.prototype.hideEffect = function (finish) {
        if (this._discard || this._exhaust || this._finished) {
            return;
        }
        if (finish) {
            this.finishEffect();
            return;
        }
        if (this._card.isExhaust() || this._card.isTemporary()) {
            this.exhaustEffect();
            return;
        }
        this.discardEffect();
    };
    Sprite_BaisyunHandCard.prototype.finishEffect = function () {
        this._finished = true;
        this._targetOpacity = 0;
        this._targetScale = 0.2;
        this._targetAngle = 7200;
        this._opacitySpeed = 8;
        this._targetX = 490;
        this._targetY = -225;
        var frame = (this._targetX - this.x) / this.calcXSpeed();
        var dis = this._targetY - this.y;
        this._discardSpeedY = dis / frame;
        this._discardSpeedScale = 1 / frame;
    };
    Sprite_BaisyunHandCard.prototype.exhaustEffect = function () {
        this._exhaust = true;
        AudioManager.playSe({ name: 'card_DiscardFantasyEastern', volume: 100, pitch: 100, pan: 0 });
        this._targetOpacity = 0;
        this._targetScale = 0.2;
        this._discardSpeedScale = 0.07;
        this._opacitySpeed = 48;
    };
    Sprite_BaisyunHandCard.prototype.discardEffect = function () {
        this._discard = true;
        AudioManager.playSe({ name: 'card_DrawFantasyEastern', volume: 100, pitch: 100, pan: 0 });
        this._targetOpacity = 0;
        this._targetScale = 0.2;
        this._targetAngle = 7200;
        this._targetX = 905;
        this._targetY = 232;
        var frame = (this._targetX - this.x) / this.calcXSpeed();
        var dis = this._targetY - this.y;
        this._discardSpeedY = dis / frame;
        this._discardSpeedScale = 1 / frame;
    };
    Sprite_BaisyunHandCard.prototype.isRetain = function () {
        return this._card.isRetain();
    };
    return Sprite_BaisyunHandCard;
}(Sprite));
var Window_BaisyunCardHandList = /** @class */ (function (_super) {
    __extends(Window_BaisyunCardHandList, _super);
    function Window_BaisyunCardHandList(battle) {
        var _this = this;
        var h = 284;
        var r = new Rectangle(-4, Graphics.height - h, 948, h);
        _this = _super.call(this, r) || this;
        _this._battle = battle;
        _this._padding = 4;
        _this.createContents();
        _this.backOpacity = 0;
        _this.frameVisible = false;
        _this._cardUiList = [];
        _this._removeCardUiList = [];
        return _this;
    }
    Window_BaisyunCardHandList.prototype.rowSpacing = function () {
        return 0;
    };
    Window_BaisyunCardHandList.prototype.colSpacing = function () {
        return 2;
    };
    Window_BaisyunCardHandList.prototype.itemHeight = function () {
        return this.height - 8;
    };
    Window_BaisyunCardHandList.prototype.gameStart = function (hand) {
        this._hand = hand;
        this.refreshAll();
    };
    Window_BaisyunCardHandList.prototype.maxCols = function () {
        return 99;
    };
    Window_BaisyunCardHandList.prototype.onTurnStart = function () {
    };
    Window_BaisyunCardHandList.prototype.maxItems = function () {
        if (!this._data) {
            return 0;
        }
        return this._data.length;
    };
    Window_BaisyunCardHandList.prototype.maxCardItems = function () {
        if (!this._cardUiList) {
            return 0;
        }
        return this._cardUiList.length;
    };
    Window_BaisyunCardHandList.prototype.refreshTurnEnd = function () {
        this.saveCurrentGameInfo();
        this.clearCardList();
        this._index = 0;
    };
    Window_BaisyunCardHandList.prototype.refreshAll = function () {
        this.saveCurrentGameInfo();
        this.refreshRemovedCard();
        _super.prototype.refresh.call(this);
        this.refreshPosition();
        this.reselectAuto();
        var ui = this._cardUiList[this.index()];
        if (ui) {
            this.toFront(ui);
        }
        this.callHandler('change');
        //this.drawDebugHitTest();
    };
    Window_BaisyunCardHandList.prototype.refreshPosition = function () {
        for (var i = 0; i < this._cardUiList.length; i++) {
            var ui = this._cardUiList[i];
            this.setInitialPosition(i, ui);
        }
    };
    Window_BaisyunCardHandList.prototype.redraw = function () {
        this.saveCurrentGameInfo();
        for (var _i = 0, _a = this._cardUiList; _i < _a.length; _i++) {
            var ui = _a[_i];
            ui.refresh();
        }
    };
    Window_BaisyunCardHandList.prototype.saveCurrentGameInfo = function () {
        this._lastMana = this._battle.mana();
        this._lastBokki = this._battle.player().bokki();
        this._data = this._hand.cardList();
        this._hand.clearDirty();
    };
    Window_BaisyunCardHandList.prototype.drawDebugHitTest = function () {
        for (var _i = 0, _a = this._cardUiList; _i < _a.length; _i++) {
            var ui = _a[_i];
            ui._targetOpacity = 128;
            var r = ui.itemRect();
            this.contents.fillRect(r.x, r.y, r.width, r.height, '#222222');
            this.contents.fillRect(r.x + 1, r.y + 1, r.width - 2, r.height - 2, '#FFFF77');
        }
    };
    Window_BaisyunCardHandList.prototype.reselectAuto = function () {
        if (this._removeCardUiList.length > 0) {
            return;
        }
        if (this.active) {
            if (this.maxCardItems() == 0) {
                this.cursorUp(true);
                return;
            }
            if (this.index() >= this._cardUiList.length) {
                this.select(this._cardUiList.length - 1);
            }
            else {
                this.select(this.index());
            }
        }
    };
    Window_BaisyunCardHandList.prototype.discardAll = function () {
        for (var _i = 0, _a = this._cardUiList; _i < _a.length; _i++) {
            var ui = _a[_i];
            ui.hideEffect(false);
        }
        this._cardUiList = [];
    };
    Window_BaisyunCardHandList.prototype.clearCardList = function () {
        if (!this._hand.inTurnEnd()) {
            return;
        }
        var usedList = [];
        for (var _i = 0, _a = this._cardUiList; _i < _a.length; _i++) {
            var ui = _a[_i];
            if (ui.isRetain()) {
                continue;
            }
            if (ui.isUsed(this._data)) {
                usedList.push(ui);
            }
        }
        for (var _b = 0, usedList_1 = usedList; _b < usedList_1.length; _b++) {
            var ui = usedList_1[_b];
            ui.hideEffect(false);
            this._cardUiList.remove(ui);
        }
    };
    Window_BaisyunCardHandList.prototype.refreshRemovedCard = function () {
        var usedList = [];
        for (var _i = 0, _a = this._cardUiList; _i < _a.length; _i++) {
            var ui = _a[_i];
            if (!this._data.contains(ui.card())) {
                usedList.push(ui);
            }
        }
        for (var _b = 0, usedList_2 = usedList; _b < usedList_2.length; _b++) {
            var ui = usedList_2[_b];
            var index = this._cardUiList.indexOf(ui);
            this._cardUiList.splice(index, 1);
            if (this.index() > index) {
                // 削除したことで選択状態が１つずれるため
                this.select(this.index() - 1);
            }
        }
    };
    Window_BaisyunCardHandList.prototype.removeUsedCard = function () {
        var card = this._hand.usedCard();
        this._hand.clearCardUsed();
        for (var _i = 0, _a = this._cardUiList; _i < _a.length; _i++) {
            var ui = _a[_i];
            if (card == ui.card()) {
                ui.removeEffect();
                this._removeCardUiList.push(ui);
                return;
            }
        }
    };
    Window_BaisyunCardHandList.prototype.removeEffectUi = function (ui) {
        ui.removeEffect();
        this._removeCardUiList.push(ui);
        this._cardUiList.remove(ui);
    };
    Window_BaisyunCardHandList.prototype.removeUi = function (ui) {
        this.removeChild(ui);
        this._cardUiList.remove(ui);
    };
    Window_BaisyunCardHandList.prototype.drawItem = function (index) {
        var card = this._data[index];
        var ui = this.findCardUi(card);
        if (ui) {
            ui.refresh();
        }
        else {
            ui = this.makeNewCardUi(card);
        }
    };
    Window_BaisyunCardHandList.prototype.makeNewCardUi = function (card) {
        var ui = new Sprite_BaisyunHandCard(card, this._hand, this._battle, 200, this.onErase.bind(this));
        this._cardUiList.push(ui);
        this.addChild(ui);
        return ui;
    };
    Window_BaisyunCardHandList.prototype.setInitialPosition = function (index, ui) {
        var selectedIndex = this.index();
        if (!this.active) {
            selectedIndex = -1;
        }
        ui.setIndex(index, this.maxCardItems(), selectedIndex);
    };
    Window_BaisyunCardHandList.prototype.findCardUi = function (card) {
        for (var _i = 0, _a = this._cardUiList; _i < _a.length; _i++) {
            var ui = _a[_i];
            if (ui.cardId() == card.id()) {
                return ui;
            }
        }
        return null;
    };
    Window_BaisyunCardHandList.prototype.canUse = function (card) {
        return card.canUse(this._battle);
    };
    Window_BaisyunCardHandList.prototype.selectedCard = function () {
        var ui = this._cardUiList[this.index()];
        if (ui) {
            if (ui.isRemoved()) {
                return null;
            }
            return ui.card();
        }
        return null;
    };
    Window_BaisyunCardHandList.prototype.isCursorMovable = function () {
        if (this._battle.isTurnEndReserved()) {
            return false;
        }
        if (this._battle.isFinished()) {
            return false;
        }
        return (this.isOpenAndActive() &&
            !this._cursorFixed &&
            !this._cursorAll);
    };
    Window_BaisyunCardHandList.prototype.cursorDown = function (wrap) {
        if (!this.isCursorMovable()) {
            return;
        }
        this.callHandler('down');
    };
    Window_BaisyunCardHandList.prototype.cursorUp = function (wrap) {
        if (!this.isCursorMovable()) {
            return;
        }
        this.callHandler('up');
    };
    Window_BaisyunCardHandList.prototype.cursorLeft = function (wrap) {
        if (!this.isCursorMovable()) {
            return;
        }
        if (this.index() == 0) {
            this.playCursorSound();
            this.callHandler('left');
            this.deactivate(true);
        }
        else {
            _super.prototype.cursorLeft.call(this, true);
        }
    };
    Window_BaisyunCardHandList.prototype.cursorRight = function (wrap) {
        if (!this.isCursorMovable()) {
            return;
        }
        if (this.index() == this.maxCardItems() - 1) {
            this.playCursorSound();
            this.deactivate(true);
            this.callHandler('right');
        }
        else {
            var index = this.index();
            var maxItems = this.maxCardItems();
            var maxCols = this.maxCols();
            var horizontal = this.isHorizontal();
            if (maxCols >= 2 && (index < maxItems - 1 || (wrap && horizontal))) {
                this.smoothSelect((index + 1) % maxItems);
            }
        }
    };
    Window_BaisyunCardHandList.prototype.update = function () {
        _super.prototype.update.call(this);
        if (!this.isChanged()) {
            return;
        }
        if (this._hand.inTurnEnd()) {
            this.refreshTurnEnd();
        }
        else if (this._hand.isRefreshAll()) {
            this.refreshAll();
        }
        else if (this._hand.isCardUsed()) {
            this.removeUsedCard();
            if (this._hand.isOtherButtonSelected()) {
                return;
            }
            if (!this._hand.inTurnEnd()) {
                this.activate();
            }
        }
        else {
            this.redraw();
        }
    };
    Window_BaisyunCardHandList.prototype.removeRemovedCardUi = function (card, useFinishCard) {
        var ui = this.findRemovedCardUi(card);
        if (!ui) {
            return;
        }
        ui.hideEffect(useFinishCard);
        this._removeCardUiList.remove(ui);
    };
    Window_BaisyunCardHandList.prototype.findRemovedCardUi = function (card) {
        for (var _i = 0, _a = this._removeCardUiList; _i < _a.length; _i++) {
            var ui = _a[_i];
            if (ui.card() == card) {
                return ui;
            }
        }
        return null;
    };
    Window_BaisyunCardHandList.prototype.isChanged = function () {
        if (this._hand) {
            if (this._hand.isCardAnime()) {
                return false;
            }
            if (this._hand.inGameEnd()) {
                return false;
            }
            if (this._hand.isDirty()) {
                return true;
            }
        }
        if (this._lastMana != this._battle.mana()) {
            return true;
        }
        if (this._lastBokki != this._battle.player().bokki()) {
            return true;
        }
        return false;
    };
    Window_BaisyunCardHandList.prototype.baisyunPlayer = function () {
        return this._battle.player();
    };
    Window_BaisyunCardHandList.prototype.baisyunBattle = function () {
        return this._battle;
    };
    Window_BaisyunCardHandList.prototype.select = function (index) {
        if (this._battle.isTurnEndReserved()) {
            return;
        }
        if (this.maxItems() == 0) {
            this.cursorUp(true);
            return;
        }
        if (!this.active) {
            _super.prototype.select.call(this, index);
            return;
        }
        if (!this._cardUiList || this._cardUiList.length == 0) {
            _super.prototype.select.call(this, index);
            return;
        }
        if (this._hand.inGameEnd()) {
            return false;
        }
        var selectedUi = this.refreshCardPosition(index);
        this.toFront(selectedUi);
        _super.prototype.select.call(this, index);
    };
    Window_BaisyunCardHandList.prototype.index = function () {
        if (this._battle.isTurnEndReserved()) {
            return -1;
        }
        return _super.prototype.index.call(this);
    };
    Window_BaisyunCardHandList.prototype.toFront = function (selectedUi) {
        if (selectedUi) {
            this.addChild(selectedUi);
        }
    };
    Window_BaisyunCardHandList.prototype.hitTest = function (x, y) {
        if (this.innerRect.contains(x, y)) {
            var cx = this.origin.x + x - this.padding;
            var cy = this.origin.y + y - this.padding;
            var sortList = this._cardUiList.sort(function (a, b) {
                return a.targetX() - b.targetX();
            });
            for (var i = 0; i < sortList.length; i++) {
                var ui = sortList[i];
                if (ui && ui.contains(cx, cy)) {
                    return ui.index();
                }
            }
        }
        return -1;
    };
    Window_BaisyunCardHandList.prototype.isOpenAndActive = function () {
        if (!this.isOpen()) {
            return false;
        }
        if (!this._battle.isPlayerTurn()) {
            return false;
        }
        if (!this._battle.isButtonActive()) {
            return false;
        }
        return true;
    };
    Window_BaisyunCardHandList.prototype.onTouchSelect = function (trigger) {
        this._doubleTouch = false;
        if (this.isCursorMovable()) {
            var lastIndex = this.index();
            var hitIndex = this.hitIndex();
            if (hitIndex >= 0) {
                if (hitIndex === this.index()) {
                    this._doubleTouch = true;
                }
                this.select(hitIndex);
                this.callHandler('select');
            }
            else {
                this.select(-1);
            }
            if (trigger && this.index() !== lastIndex) {
                this.playCursorSound();
            }
        }
    };
    Window_BaisyunCardHandList.prototype.itemRect = function (index) {
        if (!this._cardUiList || this._cardUiList.length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        var ui = this._cardUiList[index];
        if (!ui) {
            return new Rectangle(0, 0, 0, 0);
        }
        return ui.itemRect();
    };
    Window_BaisyunCardHandList.prototype.helpWindowX = function (index) {
        if (!this._cardUiList || this._cardUiList.length == 0) {
            return 0;
        }
        var ui = this._cardUiList[index];
        if (!ui) {
            return 0;
        }
        var rect = ui.itemRect();
        var max = this._cardUiList.length;
        var center = max / 2;
        var diff = Math.abs(index - center);
        return Math.round(rect.x + diff * 5) + this.helpWindowOffset(index, max);
    };
    Window_BaisyunCardHandList.prototype.helpWindowOffset = function (index, max) {
        // 微調整用
        if (index == 0) {
            if (max >= 4) {
                return 16;
            }
        }
        return 0;
    };
    Window_BaisyunCardHandList.prototype.inCardUseAnime = function () {
        return this._data.length != this._cardUiList.length;
    };
    Window_BaisyunCardHandList.prototype.refreshCardPosition = function (selectedIndex) {
        //p('refreshCardPosition:' + selectedIndex)
        var selectedUi = null;
        for (var i = 0; i < this._cardUiList.length; i++) {
            var ui = this._cardUiList[i];
            if (i == selectedIndex) {
                selectedUi = ui;
                ui.selectCard();
            }
            else {
                ui.deselectCard();
            }
            ui.setIndex(i, this.maxCardItems(), selectedIndex);
            this.addChild(ui);
        }
        if (!this.active) {
            return null;
        }
        return selectedUi;
    };
    Window_BaisyunCardHandList.prototype.activate = function () {
        if (this.active) {
            return;
        }
        if (this._hand.inGameEnd()) {
            return;
        }
        _super.prototype.activate.call(this);
        if (!this._cardUiList || this._cardUiList.length == 0) {
            return;
        }
        if (this.index() < 0) {
            this.select(0);
        }
        else {
            _super.prototype.reselect.call(this);
        }
        this.callHandler('change');
    };
    Window_BaisyunCardHandList.prototype.deactivate = function (deactivateHandSelection) {
        if (deactivateHandSelection === void 0) { deactivateHandSelection = false; }
        if (!this.active) {
            return;
        }
        _super.prototype.deactivate.call(this);
        if (!this._cardUiList || this._cardUiList.length == 0) {
            return;
        }
        if (deactivateHandSelection && !this.inCardUseAnime()) {
            this.refreshCardPosition(-1);
        }
        this.callHandler('change');
    };
    Window_BaisyunCardHandList.prototype.onErase = function (ui) {
        this._removeCardUiList.remove(ui);
        this.removeChild(ui);
    };
    Window_BaisyunCardHandList.prototype.reselect = function () {
        // 選択状態はこちらで全て管理します
    };
    Window_BaisyunCardHandList.prototype.playOkSound = function () {
        // 音声は別クラスで制御します
    };
    Window_BaisyunCardHandList.prototype.setCursorRect = function () {
        // do nothing   
    };
    Window_BaisyunCardHandList.prototype.drawItemBackground = function (index) {
        // do nothing   
    };
    Window_BaisyunCardHandList.prototype.processOk = function () {
        if (!this.active) {
            return;
        }
        if (this.isCurrentItemEnabled()) {
            this.playOkSound();
            this.updateInputData();
            //this.deactivate();
            this.callOkHandler();
        }
        else {
            this.playBuzzerSound();
        }
    };
    return Window_BaisyunCardHandList;
}(Window_Selectable));
