var BaisyunHistory = /** @class */ (function () {
    function BaisyunHistory(actorId) {
        this._baisyunMap = {};
        this._actorId = actorId;
    }
    BaisyunHistory.prototype.onBaisyun = function (manId, rank, gold, damageRate, rewardUp) {
        var list = this._baisyunMap[manId];
        if (!list) {
            list = [];
            this._baisyunMap[manId] = list;
        }
        var condom = !$gameTemp.notUseCondom;
        var sotodashi = $gameTemp.sotodashi;
        var seiekiValue = 1;
        var actorId = $gameSystem.baisyunActorId();
        var param = $baisyunManParamManager.findManParam(actorId, manId);
        if (param.hasZetsurinAbility()) {
            seiekiValue++;
        }
        if (param.hasLoveBonusAbility(this._actorId)) {
            seiekiValue += 2;
        }
        var seieki = new Seieki(manId, condom, sotodashi, seiekiValue);
        var nama = $gameSwitches.value(BAISYUN_MANA_SW_ID);
        var result = new BaisyunResult(this._actorId, manId, rank, gold, seieki, nama, damageRate, rewardUp);
        list.push(result);
        $gameTemp.lastBaisyunResult = result;
    };
    BaisyunHistory.prototype.lastResult = function (manId) {
        var list = this._baisyunMap[manId];
        if (!list) {
            return null;
        }
        return list[list.length - 1];
    };
    BaisyunHistory.prototype.count = function (manId) {
        var list = this._baisyunMap[manId];
        if (!list) {
            return 0;
        }
        return list.length;
    };
    BaisyunHistory.prototype.maxCount = function (manId) {
        var list = this._baisyunMap[manId];
        if (!list) {
            return 0;
        }
        var n = 0;
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var r = list_1[_i];
            if (r.rank() == VoltageResult.A) {
                n++;
            }
        }
        return n;
    };
    BaisyunHistory.prototype.clear = function () {
        this._baisyunMap = {};
    };
    BaisyunHistory.prototype.totalBaisyunCount = function () {
        var n = 0;
        for (var key in this._baisyunMap) {
            var resultList = this._baisyunMap[key];
            for (var _i = 0, resultList_1 = resultList; _i < resultList_1.length; _i++) {
                var r = resultList_1[_i];
                if (r.rank() != VoltageResult.D) {
                    n++;
                }
            }
        }
        return n;
    };
    BaisyunHistory.prototype.baisyunResultManList = function () {
        var result = [];
        for (var key in this._baisyunMap) {
            var resultList = this._baisyunMap[key];
            if (resultList.length == 0) {
                continue;
            }
            var man = this.makeBaisyunResultMan(resultList);
            result.push(man);
        }
        return result;
    };
    BaisyunHistory.prototype.makeBaisyunResultMan = function (list) {
        if (list.length == 0) {
            return null;
        }
        var first = list[0];
        var man = new BaisyunResultMan(first.actorId(), first.manId());
        for (var _i = 0, list_2 = list; _i < list_2.length; _i++) {
            var r = list_2[_i];
            //const seiekiValue = r.seieki().value();
            //man.plusSeieki(seiekiValue);
            //man.plusBaisyunCount();
            man.setRank(r.rank());
        }
        return man;
    };
    BaisyunHistory.prototype.maxRank = function (list) {
        var max = VoltageResult.D;
        for (var _i = 0, list_3 = list; _i < list_3.length; _i++) {
            var result = list_3[_i];
            if (result.rank() > max) {
                max = result.rank();
            }
        }
        return max;
    };
    BaisyunHistory.prototype.calcFame = function () {
        var n = 0;
        var list = this.makeBaisyunManList();
        for (var _i = 0, list_4 = list; _i < list_4.length; _i++) {
            var man = list_4[_i];
            n += man.result().maxRank();
        }
        return n;
    };
    BaisyunHistory.prototype.makeBaisyunManList = function () {
        var baisyunManList = [];
        var list = this.baisyunResultManList();
        var paramList = $baisyunManParamManager.list(this._actorId);
        for (var _i = 0, paramList_1 = paramList; _i < paramList_1.length; _i++) {
            var param = paramList_1[_i];
            if (param.sameManId() > 0) {
                continue;
            }
            if (!param.isVisible()) {
                continue;
            }
            var result = this.findResult(param.manId(), list);
            var status_1 = new BaisyunStatusMan(this._actorId, param, result);
            baisyunManList.push(status_1);
        }
        return baisyunManList;
    };
    BaisyunHistory.prototype.findResult = function (manId, list) {
        for (var _i = 0, list_5 = list; _i < list_5.length; _i++) {
            var result = list_5[_i];
            if (result.manId() == manId) {
                return result;
            }
        }
        return null;
    };
    return BaisyunHistory;
}());
var BaisyunResult = /** @class */ (function () {
    function BaisyunResult(_actorId, _manId, _rank, _gold, _seieki, _nama, _damageRate, _rewardUp) {
        this._actorId = _actorId;
        this._manId = _manId;
        this._rank = _rank;
        this._gold = _gold;
        this._seieki = _seieki;
        this._nama = _nama;
        this._damageRate = _damageRate;
        this._rewardUp = _rewardUp;
        this._day = $gameSystem.day();
    }
    BaisyunResult.prototype.actorId = function () {
        return this._actorId;
    };
    BaisyunResult.prototype.rank = function () {
        return this._rank;
    };
    BaisyunResult.prototype.seieki = function () {
        return this._seieki;
    };
    BaisyunResult.prototype.manId = function () {
        return this._manId;
    };
    BaisyunResult.prototype.gold = function () {
        return this._gold;
    };
    BaisyunResult.prototype.isNama = function () {
        return this._nama;
    };
    BaisyunResult.prototype.damageRate = function () {
        return this._damageRate || 0;
    };
    BaisyunResult.prototype.rewardUp = function () {
        return this._rewardUp || 0;
    };
    return BaisyunResult;
}());
var BaisyunResultMan = /** @class */ (function () {
    function BaisyunResultMan(_actorId, _manId) {
        this._actorId = _actorId;
        this._manId = _manId;
        this._seiekiValue = 0;
        this._sexCount = 0;
        this._baisyunCount = 0;
        this._maxRank = 0;
        this._ninshinCount = 0;
    }
    BaisyunResultMan.prototype.plusSeieki = function (n) {
        this._seiekiValue += n;
    };
    BaisyunResultMan.prototype.plusBaisyunCount = function () {
        this._baisyunCount++;
    };
    BaisyunResultMan.prototype.plusSexCount = function (n) {
        this._sexCount += n;
    };
    BaisyunResultMan.prototype.seiekiValue = function () {
        return this._seiekiValue;
    };
    BaisyunResultMan.prototype.name = function () {
        return $gameActors.actor(this._manId).name();
    };
    BaisyunResultMan.prototype.sexCount = function () {
        return this._sexCount;
    };
    BaisyunResultMan.prototype.baisyunCount = function () {
        return this._baisyunCount;
    };
    BaisyunResultMan.prototype.iconIndex = function () {
        return $gameActors.actor(this._manId).iconIndex();
    };
    BaisyunResultMan.prototype.ninshinCount = function () {
        return this._ninshinCount;
    };
    BaisyunResultMan.prototype.plusNinshin = function () {
        this._ninshinCount++;
    };
    BaisyunResultMan.prototype.manId = function () {
        return this._manId;
    };
    BaisyunResultMan.prototype.setRank = function (rank) {
        if (this._maxRank < rank) {
            this._maxRank = rank;
        }
    };
    BaisyunResultMan.prototype.maxRank = function () {
        if (this._manId == 2) {
            return 0;
        }
        if (this._manId == 3) {
            return 0;
        }
        if (this._manId == 32) {
            if (this._actorId == 1) {
                return this.maxRankClericActor1();
            }
            if (this._actorId == 2) {
                return this.maxRankClericActor2();
            }
        }
        if (this._manId == 107) {
            return this.maxRankRex();
        }
        if (this._manId == 108) {
            return this.maxRankCoco();
        }
        if (this._manId == 110) {
            return this.maxRankXeno();
        }
        if (this._manId == 111) {
            return this.maxRankMavis();
        }
        if (this._manId == 116) {
            return this.maxRankKyokon();
        }
        if (this._manId == 117) {
            return this.maxRankZlatanActor1();
        }
        if (this._manId == 118) {
            return this.maxRankXenoActor1();
        }
        if (this._manId == 119) {
            return this.maxRankTakumi();
        }
        if (this._manId == 136) {
            return this.maxRankSM();
        }
        if (this._manId == 146) {
            return this.maxRankDamnedActor1();
        }
        if (this._manId == 150) {
            return this.maxRankGoblinActor1();
        }
        return this._maxRank;
    };
    BaisyunResultMan.prototype.maxRankClericActor1 = function () {
        if ($gameSwitches.value(1403)) {
            return 3;
        }
        return 0;
    };
    BaisyunResultMan.prototype.maxRankClericActor2 = function () {
        if ($gameSwitches.value(1048)) {
            return 3;
        }
        if ($gameSwitches.value(1046)) {
            return 1;
        }
        return 0;
    };
    BaisyunResultMan.prototype.maxRankCoco = function () {
        if ($gameSwitches.value(1328)) {
            return 3;
        }
        if ($gameSwitches.value(1331)) {
            return 2;
        }
        return 0;
    };
    BaisyunResultMan.prototype.maxRankKyokon = function () {
        if ($gameSwitches.value(1319)) {
            return 3;
        }
        if ($gameSwitches.value(1304)) {
            return 1;
        }
        return 0;
    };
    BaisyunResultMan.prototype.maxRankZlatanActor1 = function () {
        if ($gameSwitches.value(1401)) {
            return 3;
        }
        return 0;
    };
    BaisyunResultMan.prototype.maxRankXenoActor1 = function () {
        if ($gameSwitches.value(1413)) {
            return 3;
        }
        if ($gameSwitches.value(1410)) {
            return 1;
        }
        return 0;
    };
    BaisyunResultMan.prototype.maxRankXeno = function () {
        if ($gameSwitches.value(1037)) {
            return 3;
        }
        return Math.min(this._maxRank, 1);
    };
    BaisyunResultMan.prototype.maxRankRex = function () {
        if ($gameSwitches.value(1122)) {
            return 3;
        }
        if ($gameSwitches.value(1022)) {
            return 2;
        }
        return Math.min(this._maxRank, 1);
    };
    BaisyunResultMan.prototype.maxRankMavis = function () {
        if ($gameSwitches.value(1134)) {
            return 3;
        }
        if ($gameSwitches.value(1128)) {
            return 2;
        }
        return Math.min(this._maxRank, 1);
    };
    BaisyunResultMan.prototype.maxRankDamnedActor1 = function () {
        if ($gameSwitches.value(1428)) {
            return 3;
        }
        if ($gameSwitches.value(1407)) {
            return 2;
        }
        if ($gameSwitches.value(1446)) {
            return 1;
        }
        return 0;
    };
    BaisyunResultMan.prototype.maxRankTakumi = function () {
        if ($gameSwitches.value(1346)) {
            return 3;
        }
        if ($gameSwitches.value(1340)) {
            return 1;
        }
        return 0;
    };
    BaisyunResultMan.prototype.maxRankSM = function () {
        if ($gameSwitches.value(1317)) {
            return 3;
        }
        if ($gameSwitches.value(1316)) {
            return 1;
        }
        return 0;
    };
    BaisyunResultMan.prototype.maxRankGoblinActor1 = function () {
        if ($gameSwitches.value(1425)) {
            return 3;
        }
        return 0;
    };
    return BaisyunResultMan;
}());
