/*:ja
 * @target MZ
 * @author ル
 *
 *
 *
 * @command gainExp
 * @text EXP獲得
 * @des EXP獲得
 * @arg actorId
 * @type number
 * @arg exp
 * @type number
 *
 * @command gainExpAuto
 * @text EXP獲得(自動で直前の経験値を得る)
 * @des EXP獲得(自動で直前の経験値を得る)
 *
 * @command gainExpAutoLose
 * @text EXP獲得(自動で敗北経験値を得る)
 * @des EXP獲得(自動で敗北経験値を得る)
 *
 * @command hide
 * @text 消す
 * @des 消す
 *
 * @command reset
 * @text チュートリアル失敗用
 * @des チュートリアル失敗用
 *
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Nore;
(function (Nore) {
    var pluginName = 'Nore_BaisyunLevel';
    PluginManager.registerCommand(pluginName, 'gainExp', function (args) {
        var actorId = parseInt(args.actorId);
        var exp = parseInt(args.exp);
        var actor = $gameActors.actor(actorId);
        var baisyunLevel = actor.baisyunLevel();
        var before = JsonEx.makeDeepCopy(baisyunLevel);
        baisyunLevel.gainExp(exp);
        var scene = SceneManager._scene;
        scene.showBaisyunLevel(before, baisyunLevel, exp);
    });
    PluginManager.registerCommand(pluginName, 'gainExpAuto', function (args) {
        var actorId = $gameSystem.baisyunActorId();
        var exp = $gameVariables.value(BAISYUN_EXP_VAR_ID);
        var actor = $gameActors.actor(actorId);
        var baisyunLevel = actor.baisyunLevel();
        var before = JsonEx.makeDeepCopy(baisyunLevel);
        baisyunLevel.gainExp(exp);
        $gameSystem.baisyunManager().initMaxHp(actor.baisyun());
        var scene = SceneManager._scene;
        scene.showBaisyunLevel(before, baisyunLevel, exp);
    });
    PluginManager.registerCommand(pluginName, 'gainExpAutoLose', function (args) {
        var actorId = $gameSystem.baisyunActorId();
        var exp = Math.ceil($gameVariables.value(BAISYUN_EXP_VAR_ID));
        var actor = $gameActors.actor(actorId);
        var baisyunLevel = actor.baisyunLevel();
        var before = JsonEx.makeDeepCopy(baisyunLevel);
        baisyunLevel.gainExp(exp);
        $gameSystem.baisyunManager().initMaxHp(actor.baisyun());
        var scene = SceneManager._scene;
        //scene.showBaisyunLevel(before, baisyunLevel, exp);
    });
    PluginManager.registerCommand(pluginName, 'hide', function (args) {
        var scene = SceneManager._scene;
        scene.hideBaisyunLevel();
        var actorId = $gameSystem.baisyunActorId();
        var actor = $gameActors.actor(actorId);
    });
    PluginManager.registerCommand(pluginName, 'reset', function (args) {
        var actorId = $gameSystem.baisyunActorId();
        var actor = $gameActors.actor(actorId);
        var baisyunLevel = actor.baisyunLevel();
        baisyunLevel.reset();
    });
})(Nore || (Nore = {}));
var BaisyunLevel = /** @class */ (function () {
    function BaisyunLevel(actorId) {
        this._actorId = actorId;
        this._level = 1;
        this._totalExp = 0;
        this.updateLevel();
    }
    BaisyunLevel.prototype.level = function () {
        return Math.min(this._level, this.maxLevel());
    };
    BaisyunLevel.prototype.totalExp = function () {
        return this._totalExp;
    };
    BaisyunLevel.prototype.exp = function () {
        return this._exp;
    };
    BaisyunLevel.prototype.maxLevel = function () {
        return 20;
    };
    BaisyunLevel.prototype.expForLevel = function (level) {
        if (level == 1) {
            return 0;
        }
        return 10 + (level - 2) * 3;
    };
    BaisyunLevel.prototype.updateLevel = function () {
        var level = 1;
        var exp = this._totalExp;
        for (var i = 0; i < 100; i++) {
            var e = this.expForLevel(level + 1);
            if (exp >= e) {
                exp -= e;
                level++;
            }
            else {
                break;
            }
        }
        this._level = level;
        this._exp = exp;
    };
    BaisyunLevel.prototype.expRate = function () {
        if (this.isMaxLevel()) {
            return 1;
        }
        return this._exp / this.expForLevel(this._level + 1);
    };
    BaisyunLevel.prototype.gainExp = function (n) {
        this._totalExp += n;
        var lastLevel = this._level;
        this.updateLevel();
        if (lastLevel != this._level) {
            $relicManager.onChangeLevel(this._actorId, this._level);
        }
    };
    BaisyunLevel.prototype.reset = function () {
        this._totalExp = 0;
        this.updateLevel();
    };
    BaisyunLevel.prototype.isMaxLevel = function () {
        return this.level() == this.maxLevel();
    };
    return BaisyunLevel;
}());
var Window_BaisyunLevel = /** @class */ (function (_super) {
    __extends(Window_BaisyunLevel, _super);
    function Window_BaisyunLevel(before, after, gainExp) {
        var _this = this;
        var r = new Rectangle(600, 535, 290, 100);
        _this = _super.call(this, r) || this;
        _this._gainExp = gainExp;
        _this._before = before;
        _this._after = after;
        _this._per = Math.floor(_this._before.expRate() * 100);
        _this._afterPer = Math.floor(_this._after.expRate() * 100);
        _this._level = _this._before.level();
        _this.refresh();
        return _this;
    }
    Window_BaisyunLevel.prototype.setLevelUpHandler = function (onLevelUp) {
        this._onLevelUp = onLevelUp;
    };
    Window_BaisyunLevel.prototype.update = function () {
        _super.prototype.update.call(this);
        if (this._finished) {
            return;
        }
        if (this._before) {
            this.updateLevel();
        }
    };
    Window_BaisyunLevel.prototype.updateLevel = function () {
        if (this._level == this._after.level() && this._per >= this._afterPer) {
            this._finished = true;
        }
        else {
            this._per++;
            if (this._per >= 100) {
                this._per = 0;
                this._level++;
                AudioManager.playSe({ name: 'LNSM_SE04_Sense4', volume: 90, pitch: 100, pan: 0 });
                if (this._onLevelUp) {
                    this._onLevelUp.call(this);
                }
            }
        }
        this.refresh();
    };
    Window_BaisyunLevel.prototype.refresh = function () {
        this.contents.clear();
        this.contents.fontSize = 20;
        var t = TextManager.baisyunLevel.format(this._level);
        this.drawText(t, 20, 5, 200);
        this.drawGaugeRect(15, 44, 230, 15);
    };
    Window_BaisyunLevel.prototype.drawGaugeRect = function (x, y, width, height) {
        var rate = this._per / 100;
        var fillW = Math.floor((width - 2) * rate);
        var fillH = height - 2;
        var color0 = this.gaugeBackColor();
        var color1 = ColorManager.mpGaugeColor1();
        var color2 = ColorManager.mpGaugeColor2();
        this.contents.fillRect(x, y, width, height, color0);
        this.contents.gradientFillRect(x + 1, y + 1, fillW, fillH, color1, color2);
    };
    Window_BaisyunLevel.prototype.gaugeRate = function () {
        return this._before.expRate();
    };
    Window_BaisyunLevel.prototype.gaugeBackColor = function () {
        return '#000000';
    };
    return Window_BaisyunLevel;
}(Window_Base));
