var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Sprite_BaisyunMan = /** @class */ (function (_super) {
    __extends(Sprite_BaisyunMan, _super);
    function Sprite_BaisyunMan(manId, event) {
        var _this = _super.call(this, event) || this;
        _this._manId = manId;
        _this._medalLayer = new Sprite_CharacterMedal(manId);
        _this.addChild(_this._medalLayer);
        return _this;
    }
    Sprite_BaisyunMan.prototype.updateBitmap = function () {
        if (this.isImageChanged()) {
            this._tilesetId = $gameMap.tilesetId();
            this._tileId = this._character.tileId();
            this._characterName = this.characterName();
            this._characterIndex = this.characterIndex();
            if (this._tileId > 0) {
                this.setTileBitmap();
            }
            else {
                this.setCharacterBitmap();
            }
        }
    };
    Sprite_BaisyunMan.prototype.characterName = function () {
        if (this._character.characterName().length == 0) {
            return '';
        }
        return this.actor().actor().characterName;
    };
    Sprite_BaisyunMan.prototype.characterIndex = function () {
        var index = this.actor().actor().characterIndex;
        if (this.isShitanugi()) {
            return index + 1;
        }
        return index;
    };
    Sprite_BaisyunMan.prototype.isShitanugi = function () {
        if (this._manId == 107) {
            return $gameSwitches.value(84);
        }
        return false;
    };
    Sprite_BaisyunMan.prototype.actor = function () {
        return $gameActors.actor(this.actorId());
    };
    Sprite_BaisyunMan.prototype.updateVisibility = function () {
        _super.prototype.updateVisibility.call(this);
        if ($gameVariables.value(BAISYUN_FOLLOWER_VAR_ID) > 0) {
            this.visible = $gameVariables.value(BAISYUN_FOLLOWER_VAR_ID) != this.actorId();
        }
    };
    Sprite_BaisyunMan.prototype.characterBlockX = function () {
        if (this._isBigCharacter) {
            return 0;
        }
        else {
            var index = this._characterIndex;
            return (index % 4) * 3;
        }
    };
    Sprite_BaisyunMan.prototype.actorId = function () {
        return this._manId;
    };
    return Sprite_BaisyunMan;
}(Sprite_Character));
