var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/*:ja
 * @target MZ
 * @author ル
 *
 * @command showManInfo
 * @text 男の情報を表示
 *
 * @command hideManInfo
 * @text 男の情報を消す
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_BaisyunManInfo';
    PluginManager.registerCommand(pluginName, 'showManInfo', function (args) {
        var eventId = $gameMap._interpreter._eventId;
        var event = $gameMap.eventById(eventId);
        if (!event) {
            return;
        }
        var actorId = $gameSystem.baisyunActorId();
        var manId = parseInt(event.event().meta['manId']);
        var param = $baisyunManParamManager.findManParam(actorId, manId);
        $gameVariables.setValue(BAISYUN_MAN_ID, manId);
        if (SceneManager._scene instanceof Scene_Map2) {
            var scene = SceneManager._scene;
            scene._spriteset.createManInfoWindow();
            scene._spriteset._manInfoWindow.showManInfo(manId);
        }
        $gameSystem.baisyun().setManId(manId);
        var actor = $gameSystem.baisyun().actor();
        var result = actor.baisyunHistory().lastResult(manId);
        if (result) {
            var baisyunBattle = new BaisyunBattle(actor.baisyunPlayer(), $gameSystem.baisyun().troopId());
            var damageRate = result.damageRate();
            var gold = baisyunBattle.enemy().calcGold(result.rank(), damageRate, false, result.rewardUp());
            $gameVariables.setValue(BAISYUN_GOLD_VAR_ID, gold);
            $gameVariables.setValue(BAISYUN_LAST_RANK_ID, result.rank());
        }
    });
    PluginManager.registerCommand(pluginName, 'hideManInfo', function (args) {
        var manId = parseInt(args.manId);
        if (SceneManager._scene instanceof Scene_Map2) {
            var scene = SceneManager._scene;
            scene._spriteset._manInfoWindow.hide();
        }
    });
})(Nore || (Nore = {}));
var Window_BaisyunManInfo = /** @class */ (function (_super) {
    __extends(Window_BaisyunManInfo, _super);
    function Window_BaisyunManInfo() {
        var _this = this;
        var r = new Rectangle(380, 120, 330, 362);
        _this = _super.call(this, r) || this;
        _this.createManSkillWindows();
        return _this;
    }
    Window_BaisyunManInfo.prototype.createManSkillWindows = function () {
        this._manSkillWindow1 = new Nore.Window_ManSkill();
        this.addChild(this._manSkillWindow1);
        this._manSkillWindow2 = new Nore.Window_ManSkill();
        this.addChild(this._manSkillWindow2);
    };
    Window_BaisyunManInfo.prototype.showManInfo = function (manId) {
        this._manId = manId;
        this._enemy = new Game_Enemy2(1000 + manId, 0, 0);
        this.refresh();
        this.show();
        var actorId = $gameSystem.baisyunActorId();
        var param = $baisyunManParamManager.findManParam(actorId, this._manId, true);
        this._manSkillWindow1.showAbility(param.ability1(), param.ability1Value(), 330, 0);
        this._manSkillWindow2.showAbility(param.ability2(), param.ability2Value(), 330, 105);
    };
    Window_BaisyunManInfo.prototype.textWidth = function () {
        return 280;
    };
    Window_BaisyunManInfo.prototype.refresh = function () {
        this.contents.clear();
        var lh = 32;
        var yy = 0;
        this.drawFaceIcon(6, 5);
        this.drawName(46, 5);
        yy += 20;
        var textX = 10;
        if (!this._enemy.isBoss()) {
            this.drawHistory(textX, lh * 1 + yy);
            this.drawBefore(textX, lh * 2 + yy);
        }
        else {
            this.drawBoss(textX, lh * 1 + yy);
        }
        this.drawAbility(textX, lh * 3 + yy + 5);
        yy += 44 + lh;
        this.drawGold(textX, lh * 3 + yy);
        this.drawVoltage(textX, lh * 4 + yy);
        this.drawTime(textX, lh * 5 + yy);
        this.drawDifficulty(textX, lh * 6 + yy);
    };
    Window_BaisyunManInfo.prototype.drawFaceIcon = function (x, y) {
        var iconIndex = $gameActors.actor(this._manId).iconIndex();
        this.drawIcon(iconIndex, x, y);
    };
    Window_BaisyunManInfo.prototype.drawBoss = function (x, y) {
        this.contents.fontSize = 24;
        this.drawText(TextManager.baisyunBoss, x, y, this.textWidth());
    };
    Window_BaisyunManInfo.prototype.drawName = function (x, y) {
        this.changeTextColor(ColorManager.normalColor());
        this.contents.fontSize = 24;
        var name = $gameActors.actor(this._manId).name();
        this.drawText(name, x, y, this.textWidth());
    };
    Window_BaisyunManInfo.prototype.drawAbility = function (x, y) {
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(TextManager.manAbility + ':', x, y, 200);
        this.changeTextColor(ColorManager.normalColor());
        var actorId = $gameSystem.baisyunActorId();
        var param = $baisyunManParamManager.findManParam(actorId, this._manId);
        this.drawText(param.ability1().name(), x + 70, y, 210, 'right');
        this.drawText(param.ability2().name(), x + 70, y + 32, 210, 'right');
    };
    Window_BaisyunManInfo.prototype.drawHistory = function (x, y) {
        this.contents.fontSize = 20;
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(TextManager.baisyunCount, x, y, 220);
        this.changeTextColor(ColorManager.normalColor());
        var count = $gameSystem.baisyun().actor().baisyunHistory().count(this._manId);
        this.drawText(TextManager.baisyunCountValue.format(count), x, y, this.textWidth(), 'right');
    };
    Window_BaisyunManInfo.prototype.drawBefore = function (x, y) {
        this.drawBeforeResult(x, y);
        this.drawBeforeNama(x, y);
    };
    Window_BaisyunManInfo.prototype.drawBeforeResult = function (x, y) {
        this.contents.fontSize = 20;
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(TextManager.baisyunLastResult, x, y, 140);
        this.changeTextColor(ColorManager.normalColor());
        var result = $gameSystem.baisyun().actor().baisyunHistory().lastResult(this._manId);
        if (!result) {
            this.drawText(TextManager.baisyunNone, x, y, this.textWidth(), 'right');
        }
        else {
            var xx = x + 150;
            var yy = y;
            for (var i = 0; i < 3; i++) {
                var icon = 23;
                if (i < result.rank()) {
                    icon = 7;
                }
                this.drawIcon(icon, xx, yy);
                xx += 34;
            }
        }
    };
    Window_BaisyunManInfo.prototype.drawBeforeNama = function (x, y) {
        var result = $gameSystem.baisyun().actor().baisyunHistory().lastResult(this._manId);
        if (!result) {
            return;
        }
        $gameSwitches.setValue(BAISYUN_MANA_SW_ID, result.isNama());
        if (result.isNama()) {
            this.drawIcon(Icon.nama, x + 251, y);
        }
    };
    Window_BaisyunManInfo.prototype.drawSeieki = function (x, y) {
        this.contents.fontSize = 20;
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(TextManager.baisyunSemen, x, y, 250);
        var seieki = this.seiekiItem();
        var text = TextManager.baisyunNone;
        if (seieki) {
            text = getItemName(seieki);
        }
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(text, x, y, this.textWidth(), 'right');
    };
    Window_BaisyunManInfo.prototype.seiekiItem = function () {
        var actor = $gameActors.actor(this._manId);
        if (!actor.actor().meta['seieki']) {
            return null;
        }
        var seiekiItem = parseInt(actor.actor().meta['seieki']);
        var item = $dataItems[seiekiItem];
        return item;
    };
    Window_BaisyunManInfo.prototype.drawGold = function (x, y) {
        this.contents.fontSize = 20;
        var gold = this._enemy.gold();
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(TextManager.baisyunManGold, x, y, 250);
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(gold + 'Ｇ', x, y, this.textWidth(), 'right');
    };
    Window_BaisyunManInfo.prototype.drawVoltage = function (x, y) {
        this.contents.fontSize = 20;
        var voltage1 = this._enemy.params(0);
        var voltage2 = this._enemy.params(5);
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(TextManager.baisyunRequiredVoltage, x, y, 250);
        this.changeTextColor(ColorManager.normalColor());
        var text = voltage1 + '';
        if (voltage1 < voltage2) {
            text = voltage1 + ' ～ ' + voltage2;
        }
        this.drawText(text, x, y, this.textWidth(), 'right');
    };
    Window_BaisyunManInfo.prototype.drawHp = function (x, y) {
        this.contents.fontSize = 20;
        var hp = this._enemy.params(7);
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(TextManager.baisyunSexHp, x, y, 250);
        this.drawText(hp, x, y, this.textWidth(), 'right');
    };
    Window_BaisyunManInfo.prototype.drawTime = function (x, y) {
        this.contents.fontSize = 20;
        var hp = this._enemy.params(1);
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(TextManager.baisyunTime, x, y, 250);
        this.changeTextColor(ColorManager.normalColor());
        this.drawText(hp, x, y, this.textWidth(), 'right');
    };
    Window_BaisyunManInfo.prototype.drawDifficulty = function (x, y) {
        this.contents.fontSize = 20;
        this.changeTextColor(ColorManager.systemColor());
        var level = this._enemy.level();
        this.drawText(TextManager.baisyunDifficulty, x, y, 90);
        var xx = 120;
        var yy = y + 2;
        for (var i = 0; i < 5; i++) {
            if (i < level) {
                this.drawIcon(528, xx, yy);
            }
            else {
                this.drawBlackIcon(528, xx, yy, '#444444');
            }
            xx += 32;
        }
    };
    return Window_BaisyunManInfo;
}(Window_Base));
