var MAN_TALK_MAP = {
    actor_2_中年汎用_1: ['そんなに俺のちんぽがほしいのか？', 'まったく情けない女だよ', 'そうだなぁ', 'なるほどな', 'いいじゃねぇか', 'へへへ、勃起してきたぜ', 'ちょっとノらねぇな……', 'まぁ、買ってやってもいいか', 'いいぜ、買ってやるよ', 'おう、ノってきたぜ！'],
    actor_2_中年汎用_2: ['必死だな、金ねえのか？', '親が見たら悲しむんじゃねぇか', 'うーん', 'ほう', 'エロいな', '', 'ダメだな', 'なくはないか', '今日はお前にするか', 'さあ、早くやろうぜ！'],
    actor_2_中年汎用_3: ['恥ずかしいカッコした女だな', '女はいいよな、楽して稼げて', '足りねぇなぁ', '', '', '', '', '', '', ''],
    actor_2_中年汎用_4: ['チチ以外はいまいちだな', 'どう犯されたい？言ってみろよ', '乳はいいんだがなぁ', '', '', '', '', '', '', ''],
    actor_2_中年汎用_5: ['ケツをもっと見せろよ', '旦那じゃ満足できねえのか？', '人妻は別になぁ…', '', '', '', '', '', '', ''],
    actor_2_中年汎用_6: ['もっと媚びろや', '', 'もう一声欲しいな', 'ほほーう…', '', '', '', '', '', ''],
    actor_2_中年汎用_7: ['誠意が足りねえぞ', '', '', '', '', '', '', '', '', ''],
    actor_2_中年汎用_8: ['若い子と比べて肌荒れてね？', '', '', '', '', '', '', '', '', ''],
    actor_2_青年汎用_1: ['やっぱ若い子のがいいよなぁ', 'おばさんが無理すんなよ', 'どうするかな', '結構いいかもな', 'エロいじゃん', 'キタコレ！', 'やっば若い子がいいな', '今日はおばさんでいいか', 'なかなかやるじゃん', '今日は寝かせないぜ'],
    actor_2_青年汎用_2: ['まんこもゆるそうだなぁ', '必死過ぎウケるぅ', '顔はいいんだけどな', 'ちょっといいな', 'いいじゃん、エロいぜ', '', '', '', '', ''],
    actor_2_青年汎用_3: ['たるんだ体してそうだなぁ', 'トシ考えろよ', '乳はデカいな', 'チチはそそられるな', '', '', '', '', '', ''],
    actor_2_青年汎用_4: ['乳垂れてねえよな？', '人妻？ お古はなぁ…', '尻デカいな', 'いいケツしてんだよな', '', '', '', '', '', ''],
    actor_2_青年汎用_5: ['ダラしねぇ腹してそうだ', '中古感スゲェな', '脚太いな', '脚エロいな', '', '', '', '', '', ''],
    actor_2_青年汎用_6: ['人妻？ お古はなぁ…', 'どんなＨしたいの？言ってみ？', 'もうちょい若けりゃな', '思ったより悪くないかね', '', '', '', '', '', ''],
    actor_2_冒険者_1: ['あの有名人が売春ねぇ', '落ちるとこまで落ちたな', 'そんな誘い方するんだな', 'さすがに引き締まった体だな', '剣もちんぽも好きってか', 'いいじゃねぇか！', 'その筋肉質な体は萎えるな', '記念にヤっとくか', '記念にヤっとくか', '滾ってきたぜぇ'],
    actor_2_冒険者_2: ['こうはなりたくねぇなぁ', '旦那はどう思うのかね？', '人妻のくせにやるじゃねぇか', 'へぇ、そこまで言うならなぁ', '', '', '', '', '', ''],
    actor_2_冒険者_3: ['憧れてたガキに見せてやりてえ', '昔のメンバーにチクってやろうか？', '', '', '', '', '', '', '', ''],
    actor_2_冒険者_4: ['昔も枕してたのかよ？', '知り合いに広めてやろうかな', '', '', '', '', '', '', '', ''],
    actor_2_老人_1: ['ワシを誘うとは、底辺じゃの', 'ワシが嫁にしてやろうか', 'ふむぅ', 'ひひひ、よいぞよいぞ', 'その調子じゃ', 'うむ、心意気は伝わったぞい', 'はぁ、それじゃダメじゃのう', 'まぁ買ってやるかのう', 'よし、買ってやるとしよう', 'うむ、心意気は伝わったぞい'],
    actor_2_老人_2: ['ワシのちんぽがそんな欲しいか？', 'もっと卑屈に誘うんじゃよ', 'どうしようかのう', 'ほう、滾ってきおったわ', '', '', '', '', '', ''],
    actor_2_老人_3: ['チンカス舐め取ってくれるかえ？', 'ケツ穴、舐めてくれるかえ？', '', '', '', '', '', '', '', ''],
    actor_2_老人_4: ['メシも恵んで欲しいのう', 'ションベンは飲めるかえ？', '', '', '', '', '', '', '', ''],
    actor_2_レックス_1: ['ショタコンおばさんキモいよ？', 'おばさん、自分の年齢わかる？', 'あはは、情けないね', 'へぇ、がんばるじゃん', '', '', 'やっばりおばさんじゃダメだね', 'ふうん、まぁまぁじゃん', '', ''],
    actor_2_レックス_2: ['夫もいるんだっけ？', '夫にこの姿見せたいね', 'おばさん、恥ずかしくないの？', '仕方ないなぁ', '', '', 'もっと若い女の子がいいな', '必死過ぎて笑えるね', '', ''],
    actor_2_レックス_3: ['こんな姿、人には見せられないね', 'あはは、情けないすがただね', '冒険者も大変だね', '', '', '', '', '', '', ''],
    actor_2_レックス_4: ['見ていてこっちが恥ずかしいよ', '', '僕みたいな子を誘うなんてね', '', '', '', '', '', '', ''],
    actor_2_ロアン_1: ['でも僕、お金ないから……', 'ご、ごめんなさい…', 'そんな……', 'ううっ', 'すごくエッチだ……', 'わ、わかりました！', 'せっかく誘ってくれたのに……', 'わ、わかりました！', 'すごくエッチだ……', 'も、もう我慢できません！'],
    actor_2_ロアン_2: ['誘ってくれるのは嬉しいけど……', 'お、お断りしても…？', 'やっ！', 'ひゃあっ！', '', '', '', '', '', ''],
    actor_2_ロアン_3: ['今は仕事中なので……', '', 'ちょっといいかも……', 'うう、そそられちゃうよぉ', '', '', '', '', '', ''],
    actor_2_ロアン_4: ['や、やっぱり僕……', '', '', '', '', '', '', '', '', ''],
    actor_2_ロアン_5: ['う、ううん……', '', '', '', '', '', '', '', '', ''],
    actor_2_メイヴィス_1: ['そんなんじゃあたいはノらないよ', '女王様とお呼び！', '必死だねぇ', 'どうやら本気みたいね', '', '', 'あたいを誘うなんて１０年早いよ', 'どうやら本気みたいね', '', ''],
    actor_2_メイヴィス_2: ['魅力が足りないねぇ', 'あたいの奴隷になりな！', 'もっと若けりゃねぇ', 'ま、まぁまぁね', '', '', '１０代のころに誘いな', 'ま、まぁまぁね', '', ''],
    actor_2_メイヴィス_3: ['あんた、自分のトシ考えたら？', '', '色気が足りないねぇ', '', '', '', '', '', '', ''],
    actor_2_メイヴィス_4: ['あたいに比べたら貧相な体だねぇ', '', 'もっとグイグイ来なよ', '', '', '', '', '', '', ''],
    actor_2_メイヴィス_5: ['色気が足りないよ！', 'ほら、靴をお舐め！', '', 'まぁ…悪くないねぇ？', '', '', '', '', '', ''],
    actor_2_メイヴィス_6: ['あんた、それで本気？', 'あたいの鞭、喰らってみるかい？', '', '', '', '', '', '', '', ''],
    actor_2_ゼノ_1: ['まだ売春してるのかい？', '売春婦らしくなってきたね', '売春婦らしくなってきたね', 'ほう、色気は増してきたな', '', '', 'その程度では私は誘えませんよ', 'ふむ、まぁよいでしょう', '', ''],
    actor_2_ゼノ_2: ['キミの初めての男だよ', 'その姿、旦那さんはどう思うかな？', 'ふふ、その意気だよ', 'うむ、いい身体だ', '', '', 'あなたにはがっかりです', '', '', ''],
    actor_2_ゼノ_3: ['思い出すね、初めての時を', '旦那にキミの処女喪失の話をしたいな', 'ふむ……', '', '', '', '', '', '', ''],
    actor_2_ゼノ_4: ['また買ってあげようか？', 'こんな場所に堕ちるなんてね', 'うむ…', '', '', '', '', '', '', ''],
    actor_2_ゴブリン_1: ['ヒヒッ！', 'ゲヒヒヒッ！！', 'ゲヒ！？', 'ゲヒヒ！？', 'ゲヒッ！？', 'ゲヒヒッ♥', '……', 'ゲヒヒ！？', 'ゲヒッ！？', 'ゲヒヒッ♥'],
    actor_2_ゴブリン_2: ['ヒヒ、ゲヒヒ！', 'ゲヒィィッ！', 'ギヒィ！？', 'ゲヒヒッ！？', '', '', '', '', '', ''],
    actor_2_ゴブリン_3: ['ヒーヒヒヒ！', '', 'ゲビッ！？', '', '', '', '', '', '', ''],
    actor_1_中年汎用_1: ['ガキのくせに売春なんてな', 'その年で売春するなんてな', '俺はロリコンじゃねえしな', 'なるほどな', 'いいじゃねぇか', 'へへへ、勃起してきたぜ', 'ちょっとノらねぇな……', 'まぁ、買ってやってもいいか', 'いいぜ、買ってやるよ', 'おおー、ノってきたぜ！'],
    actor_1_中年汎用_2: ['もう少し色気がありゃなあ', '色気がなさすぎないか？', 'そうは言ってもなぁ', 'ほう', 'エロいな', '', 'ダメだな', 'なくはないか', '今日はお前にするか', 'さあ、早くやろうぜ！'],
    actor_1_中年汎用_3: ['貧相な体だなぁ', '胸がねぇんだよな', 'ガキはなぁ……', '意外といいな', '', '', '', '', '', ''],
    actor_1_中年汎用_4: ['乳がもうちっとあればな', 'まだ乳臭そうだぜ', 'うーん…', '悪くねえな', '', '', '', '', '', ''],
    actor_1_中年汎用_5: ['ガキすぎないか？', '俺は巨乳が好きなんだよ', '', 'ふぅん…', '', '', '', '', '', ''],
    actor_1_ロリコン_1: ['キミの蕾にキスさせておくれ', 'ニオイ嗅いでいい？', '健気だねぇ', 'そうそう、いいよ', 'エッチなことを知ってるんだね', 'もう我慢できない！', 'ごめんね……', '小さい子は好きだよ', '早くエッチしよう', 'もうたまらないね！'],
    actor_1_ロリコン_2: ['乳首をぺろぺろさせておくれ', '毛が生えてるか見せてくれる？', 'もっともっと！', 'その調子だ！', '', '', '', '', '', ''],
    actor_1_ロリコン_3: ['キミの年齢がいいんだ', '', '', '', '', '', '', '', '', ''],
    actor_1_ロリコン_4: ['あと１歳下なら…', 'ペロペロしていい？', '', '', '', '', '', '', '', ''],
    actor_1_ロリコン_5: ['下の毛生えてないよね？', '', '', '', '', '', '', '', '', ''],
    actor_1_ダムド_1: ['ガキで売春婦が務まるのか？', 'もっと根性見せろ！', 'その調子だぜ', 'なかなかやるじゃねぇか', '', '', 'ちっ、いまいちだな', 'なかなかやるじゃねぇか', '', ''],
    actor_1_ダムド_2: ['うちの奴らは激しいぜ？', '気合がたりねぇよ！', 'もっと来な！', 'うちの奴らは満足しねぇぞ', '', '', 'もっとグイグイきな！', 'やるじゃねぇか', '', ''],
    actor_1_ゼノ_1: ['まだまた色気が足りませんね', 'さあ、もっと押してきなさい', 'その意気です', 'なかなかですね', '', '', 'その程度では私は誘えませんよ', 'ふむ、まぁよいでしょう', '', ''],
    actor_1_ゼノ_2: ['もっと股を見せなさい', '全然たりませんよ', 'ふむ', 'その意気です', '', '', '', '', '', ''],
    actor_1_ゴブリン_1: ['ヒヒッ！', 'ゲヒヒヒッ！！', 'ゲヒ！？', 'ゲヒヒ！？', 'ゲヒッ！？', 'ゲヒヒッ♥', '……', 'ゲヒヒ！？', 'ゲヒッ！？', 'ゲヒヒッ♥'],
    actor_1_老人_1: ['ずいぶん小さいのう', 'ワシが嫁にしてやろうか', 'ふむぅ', 'ひひひ、よいぞよいぞ', 'その調子じゃ', 'うむ、心意気は伝わったぞい', 'はぁ、それじゃダメじゃのう', 'まぁ買ってやるかのう', 'よし、買ってやるとしよう', 'うむ、心意気は伝わったぞい'],
    actor_1_老人_2: ['孫みたいな感じじゃの', 'ワシのちんぽ奴隷にしてやろか？', 'まだまだじゃの', '悪い気はせんのう', '', '', '', '', '', ''],
    actor_1_老人_3: ['', '', '', '', '', '', '', '', '', ''],
    actor_1_青年汎用_1: ['やっぱりムチムチがいいかな', 'なんだ、ガキかぁ', 'ふむ……', 'ガキもありか', 'なかなかいいな', 'やばい、ヤりたくなってきた', 'やっぱりムチムチがいいかな', 'まぁ、ガキでもいいか', 'ガキもありか', '今日は寝かせないぜ'],
    actor_1_青年汎用_2: ['胸がねぇんだよな', 'おこちゃま体型だな', 'ガキだしなぁ', 'まあ遊んでやるか', '', '', '', '', '', ''],
    actor_1_青年汎用_3: ['彼氏とかいねぇの？', 'かなりまな板だな、胸', '', '', '', '', '', '', '', ''],
    actor_1_ロアン_1: ['でも僕、お金ないから……', 'ご、ごめんなさい…', 'そんな……', 'ううっ', 'すごくエッチだ……', 'わ、わかりました！', 'せっかく誘ってくれたのに……', 'わ、わかりました！', 'すごくエッチだ……', 'も、もう我慢できません！'],
    actor_1_ロアン_2: ['誘ってくれるのは嬉しいけど……', 'お、お断りしても…？', 'やっ！', 'ひゃあっ！', '', '', '', '', '', ''],
    actor_1_ロアン_3: ['今は仕事中なんです', '', 'ちょっといいかも……', 'うう、そそられちゃうよぉ', '', '', '', '', '', ''],
    actor_1_よっぱらい_1: ['ガキのくせに売春なんてな', 'その年で売春するなんてな', '俺はロリコンじゃねえしな', 'なるほどな', 'いいじゃねぇか', 'へへへ、勃起してきたぜ', 'ちょっとノらねぇな……', 'まぁ、買ってやってもいいか', 'いいぜ、買ってやるよ', 'おおー、ノってきたぜ！'],
    actor_1_よっぱらい_2: ['もう少し色気がありゃなあ', '色気がなさすぎないか？', 'そうは言ってもなぁ', 'ほう', 'エロいな', '', 'ダメだな', 'なくはないか', '今日はお前にするか', 'さあ、早くやろうぜ！'],
    actor_1_よっぱらい_3: ['貧相な体だなぁ', '胸がねぇんだよな', 'ガキはなぁ……', '意外といいな', '', '', '', '', '', ''],
    actor_3_中年汎用_1: ['女と思ったぜ', '男としてはもう終わってるな', 'そうだなぁ', 'なるほどな', 'いいじゃねぇか', 'へへへ、勃起してきたぜ', 'ちょっとノらねぇな……', 'まぁ、買ってやってもいいか', 'いいぜ、買ってやるよ', 'おおー、ノってきたぜ！'],
    actor_3_中年汎用_2: ['ちんぽ見せろ！', 'ケツまんこ見せろ！', 'そうは言ってもなぁ', 'ほう', 'エロいな', '', 'ダメだな', 'なくはないか', '今日はお前にするか', 'さあ、早くやろうぜ！'],
    actor_3_中年汎用_3: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_中年汎用_4: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_中年汎用_5: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_中年汎用_6: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_ココ_1: ['そんなふにゃチンじゃダメよ', 'まだ男の娘とは言えないわね', 'もっとがんばんなさい', 'そんなに言われると……', '', '', 'はぁ、全然ダメね', 'えっ、そんなにあたしのことを……？', '', ''],
    actor_3_ココ_2: ['もっとビシッとしなさい！', 'かわいさが足りないわね', 'そんなんじゃ買ってもらえないわ', '', '', '', '', '', '', ''],
    actor_3_ココ_3: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_ココ_4: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_タクミ_1: ['キモくてごめん', 'キモくてごめん', 'うっ♥', 'やっ♥', '', '', 'そっかぁ', 'ええっ！？', '', ''],
    actor_3_タクミ_2: ['本当の女の子みたいだね', 'これが僕の必殺技だよ', '勃起しそう……', '', '', '', '', '', '', ''],
    actor_3_タクミ_3: ['僕のほうが先輩なんだよ', '僕のパンツ見る？', 'はぁはぁ……', '', '', '', '', '', '', ''],
    actor_3_タクミ_4: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_青年汎用_1: ['やっぱり女がいいかな', 'なんだ、男かぁ', 'ふむ……', '男もありか', 'なかなかいいな', 'やばい、ヤりたくなってきた', 'やっぱり女がいいかな', 'まぁ、男でもいいか', '男もありか', '今日は寝かせないぜ'],
    actor_3_青年汎用_2: ['ちんぽついてるんだろ？', 'まんこもねぇくせによ', 'もっと来な！', '今日は男の娘にするか……', '', '', '', '', '', ''],
    actor_3_青年汎用_3: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_青年汎用_4: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_青年汎用_5: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_男の娘好き_1: ['かわいいおちんちんだねぇ', 'やらせてくれよ', '悩ましいな', 'かわいいねぇ', 'エロいねぇ', 'やっぱり男の娘だな！', 'ごめんね……', 'なくはないか', '今日はお前にするか', 'さあ、早くやろうぜ！'],
    actor_3_男の娘好き_2: ['もう勃起してるのかい？', 'しゃぶってもらおうかな', '今日はキミにするか……', '私も勃起してきたよ', '', '', '', '', '', ''],
    actor_3_男の娘好き_3: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_男の娘好き_4: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_男の娘好き_5: ['', '', '', '', '', '', '', '', '', ''],
    actor_3_ロアン_1: ['でも僕、お金ないから……', 'ご、ごめんなさい…', 'そんな……', 'ううっ', 'すごくエッチだ……', 'わ、わかりました！', 'せっかく誘ってくれたのに……', 'わ、わかりました！', 'すごくエッチだ……', 'も、もう我慢できません！'],
    actor_3_ロアン_2: ['誘ってくれるのは嬉しいけど……', 'お、お断りしても…？', 'やっ！', 'ひゃあっ！', '', '', '', '', '', ''],
    actor_3_ロアン_3: ['今は仕事中なんです', '', '', '', '', '', '', '', '', ''],
};
var ManTalk = /** @class */ (function () {
    function ManTalk(manType, index, list) {
        this._manType = manType;
        this._index = index;
        this._attackMessage = list[0];
        this._skillMessage = list[1];
        this._damageMessageMap = {};
        var damageIndex = 2;
        this._damageMessageMap[VoltageRank.D] = list[damageIndex];
        this._damageMessageMap[VoltageRank.C] = list[damageIndex + 1];
        this._damageMessageMap[VoltageRank.B] = list[damageIndex + 2];
        this._damageMessageMap[VoltageRank.A] = list[damageIndex + 3];
        this._finishMessageMap = {};
        var finishIndex = 6;
        this._finishMessageMap[VoltageRank.D] = list[finishIndex];
        this._finishMessageMap[VoltageRank.C] = list[finishIndex + 1];
        this._finishMessageMap[VoltageRank.B] = list[finishIndex + 2];
        this._finishMessageMap[VoltageRank.A] = list[finishIndex + 3];
    }
    ManTalk.prototype.attackMessage = function () {
        return this._attackMessage;
    };
    ManTalk.prototype.skillMessage = function () {
        return this._skillMessage;
    };
    ManTalk.prototype.damageMessage = function (voltage) {
        return this._damageMessageMap[voltage];
    };
    ManTalk.prototype.finishMessage = function (voltage) {
        return this._finishMessageMap[voltage];
    };
    return ManTalk;
}());
var ManTalkParams = /** @class */ (function () {
    function ManTalkParams() {
        this._map = {};
        this.parseMap();
    }
    ManTalkParams.prototype.parseMap = function () {
        for (var key in MAN_TALK_MAP) {
            var list = MAN_TALK_MAP[key];
            this.parse(key, list);
        }
    };
    ManTalkParams.prototype.parse = function (key, list) {
        var keyList = key.split('_');
        if (keyList.length != 4) {
            console.error('不正な男会話IDです:' + key);
            return;
        }
        var actorId = parseInt(keyList[1]);
        this._map[actorId] = this._map[actorId] || new ManTalkActorParams(actorId);
        var manType = keyList[2];
        var index = parseInt(keyList[3]);
        this._map[actorId].parse(manType, index, list);
    };
    ManTalkParams.prototype.selectManAttackMessage = function (actorId, manType) {
        var param = this._map[actorId];
        if (!param) {
            console.error('男攻撃セリフが存在しません actorId:' + actorId);
            return '';
        }
        return param.selectManAttackMessage(manType);
    };
    ManTalkParams.prototype.selectManSkillMessage = function (actorId, manType) {
        var param = this._map[actorId];
        if (!param) {
            console.error('男攻撃セリフが存在しません actorId:' + actorId);
            return '';
        }
        return param.selectManSkillMessage(manType);
    };
    ManTalkParams.prototype.selectManDamageMessage = function (actorId, manType, voltage) {
        var param = this._map[actorId];
        if (!param) {
            console.error('男ダメージセリフが存在しません:' + manType);
            return '';
        }
        return param.selectManDamageMessage(manType, voltage);
    };
    ManTalkParams.prototype.selectManFinishMessage = function (actorId, manType, voltage) {
        var param = this._map[actorId];
        if (!param) {
            console.error('男フィニッシュセリフが存在しません:' + manType);
            return '';
        }
        return param.selectManFinishMessage(manType, voltage);
    };
    return ManTalkParams;
}());
var ManTalkActorParams = /** @class */ (function () {
    function ManTalkActorParams(actorId) {
        this._actorId = actorId;
        this._map = {};
    }
    ManTalkActorParams.prototype.parse = function (manType, index, list) {
        var manTalk = new ManTalk(manType, index, list);
        this._map[manType] = this._map[manType] || [];
        this._map[manType].push(manTalk);
    };
    ManTalkActorParams.prototype.selectManAttackMessage = function (manType) {
        var list = this._map[manType];
        if (!list) {
            console.error('男攻撃セリフが存在しません:' + manType);
            return '';
        }
        var candidates = [];
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var t = list_1[_i];
            var message = t.attackMessage();
            if (message) {
                candidates.push(message);
            }
        }
        if (candidates.length == 0) {
            console.error('男攻撃セリフが存在しません:' + manType);
            return '';
        }
        var dice = Math.randomInt(candidates.length);
        return candidates[dice];
    };
    ManTalkActorParams.prototype.selectManSkillMessage = function (manType) {
        var list = this._map[manType];
        if (!list) {
            console.error('男スキルセリフが存在しません:' + manType);
            return '';
        }
        var candidates = [];
        for (var _i = 0, list_2 = list; _i < list_2.length; _i++) {
            var t = list_2[_i];
            var message = t.skillMessage();
            if (message) {
                candidates.push(message);
            }
        }
        if (candidates.length == 0) {
            console.error('男スキルセリフが存在しません:' + manType);
            return '';
        }
        var dice = Math.randomInt(candidates.length);
        return candidates[dice];
    };
    ManTalkActorParams.prototype.selectManDamageMessage = function (manType, voltage) {
        var list = this._map[manType];
        if (!list) {
            console.error('男ダメージセリフが存在しません:' + manType);
            return '';
        }
        var candidates = [];
        for (var _i = 0, list_3 = list; _i < list_3.length; _i++) {
            var t = list_3[_i];
            var message = t.damageMessage(voltage);
            if (message) {
                candidates.push(message);
            }
        }
        if (candidates.length == 0) {
            console.error('男ダメージセリフが存在しません:' + manType + ' ボルテージ:' + voltage);
            return '';
        }
        var dice = Math.randomInt(candidates.length);
        return candidates[dice];
    };
    ManTalkActorParams.prototype.selectManFinishMessage = function (manType, voltage) {
        var list = this._map[manType];
        if (!list) {
            console.error('男フィニッシュセリフが存在しません:' + manType);
            return '';
        }
        var candidates = [];
        for (var _i = 0, list_4 = list; _i < list_4.length; _i++) {
            var t = list_4[_i];
            var message = t.finishMessage(voltage);
            if (message) {
                candidates.push(message);
            }
        }
        if (candidates.length == 0) {
            console.error('男フィニッシュセリフが存在しません:' + manType + ' ボルテージ:' + voltage);
            return '';
        }
        var dice = Math.randomInt(candidates.length);
        return candidates[dice];
    };
    return ManTalkActorParams;
}());
var $manTalkParams = new ManTalkParams();
