/*:ja
 * @target MZ
 * @author ル
 *
 * @command addMaseki
 * @text 魔石追加
 * @des 魔石追加
 * @arg itemId
 * @type number
 */
var Nore;
(function (Nore) {
    var pluginName = 'Nore_Maseki';
    PluginManager.registerCommand(pluginName, 'addMaseki', function (args) {
        var itemId = parseInt(args.itemId);
        var set = $gameParty.masekiActorSet();
        set.addMaseki(itemId);
    });
})(Nore || (Nore = {}));
var Maseki = /** @class */ (function () {
    function Maseki(actorId, itemId) {
        this._targetCardId = 0;
        this._actorId = actorId;
        this._itemId = itemId;
    }
    Maseki.prototype.actorId = function () {
        return this._actorId;
    };
    Maseki.prototype.itemId = function () {
        return this._itemId;
    };
    Maseki.prototype.name = function () {
        return getItemName(this.item());
    };
    Maseki.prototype.iconIndex = function () {
        return this.item().iconIndex;
    };
    Maseki.prototype.item = function () {
        return $dataItems[this._itemId];
    };
    Maseki.prototype.targetCardId = function () {
        return this._targetCardId;
    };
    Maseki.prototype.setTargetCardId = function (n) {
        this._targetCardId = n;
    };
    Maseki.prototype.clear = function () {
        this._targetCardId = 0;
    };
    Maseki.prototype.effectName = function () {
        if (this.isTenpu()) {
            return TextManager.tenpu;
        }
        if (this.isChien()) {
            return TextManager.chien;
        }
        if (this.isRetain()) {
            return TextManager.retain;
        }
        var voltageUp = this.voltageUp();
        if (voltageUp) {
            return TextManager.masekiVoltage.format(voltageUp);
        }
        var shieldUp = this.shieldUp();
        if (shieldUp) {
            return TextManager.masekiShield.format(shieldUp);
        }
        console.error('魔石の効果名がありません');
        return '';
    };
    Maseki.prototype.isTenpu = function () {
        var item = this.item();
        if (item.meta['tenpu']) {
            return true;
        }
        return false;
    };
    Maseki.prototype.isChien = function () {
        var item = this.item();
        if (item.meta['chien']) {
            return true;
        }
        return false;
    };
    Maseki.prototype.isRetain = function () {
        var item = this.item();
        if (item.meta['retain']) {
            return true;
        }
        return false;
    };
    Maseki.prototype.voltageUp = function () {
        var item = this.item();
        if (item.meta['voltage']) {
            return parseInt(item.meta['voltage']);
        }
        return 0;
    };
    Maseki.prototype.shieldUp = function () {
        var item = this.item();
        if (item.meta['shield']) {
            return parseInt(item.meta['shield']);
        }
        return 0;
    };
    Maseki.prototype.targetCardType = function () {
        var item = this.item();
        if (item.meta['cardType']) {
            switch (item.meta['cardType']) {
                case 'attack': return CardType.attack;
                case 'finish': return CardType.finish;
                case 'guard': return CardType.guard;
                default:
                    console.error('不正なカードタイプです:' + item.meta['cardType']);
            }
        }
        return CardType.all;
    };
    Maseki.prototype.disableType = function () {
        if (this.isRetain()) {
            return DisableType.retain;
        }
        return DisableType.none;
    };
    return Maseki;
}());
var MasekiSet = /** @class */ (function () {
    function MasekiSet(actorId) {
        this._list = [];
        this._actorId = actorId;
    }
    MasekiSet.prototype.actorId = function () {
        return this._actorId;
    };
    MasekiSet.prototype.equip = function (maseki, skillId) {
        this.unEquip(skillId);
        maseki.setTargetCardId(skillId);
    };
    MasekiSet.prototype.unEquip = function (skillId) {
        for (var _i = 0, _a = this._list; _i < _a.length; _i++) {
            var maseki = _a[_i];
            if (maseki.targetCardId() == skillId) {
                maseki.clear();
            }
        }
    };
    MasekiSet.prototype.push = function (itemId) {
        if (this.contains(itemId)) {
            return;
        }
        this._list.push(new Maseki(this._actorId, itemId));
    };
    MasekiSet.prototype.contains = function (itemId) {
        for (var _i = 0, _a = this._list; _i < _a.length; _i++) {
            var m = _a[_i];
            if (m.itemId() == itemId) {
                return true;
            }
        }
        return false;
    };
    MasekiSet.prototype.list = function () {
        return this._list;
    };
    MasekiSet.prototype.findMaseki = function (skillId) {
        for (var _i = 0, _a = this._list; _i < _a.length; _i++) {
            var m = _a[_i];
            if (m.targetCardId() == skillId) {
                return m;
            }
        }
        return null;
    };
    return MasekiSet;
}());
var MasekiActorSet = /** @class */ (function () {
    function MasekiActorSet() {
        this._allMasekiList = [];
        this._masekiMap = {};
    }
    MasekiActorSet.prototype.addMaseki = function (itemId) {
        this._allMasekiList.push(itemId);
    };
    MasekiActorSet.prototype.masekiSet = function (actorId) {
        this._masekiMap[actorId] = this._masekiMap[actorId] || new MasekiSet(actorId);
        var set = this._masekiMap[actorId];
        for (var _i = 0, _a = this._allMasekiList; _i < _a.length; _i++) {
            var itemId = _a[_i];
            set.push(itemId);
        }
        return set;
    };
    return MasekiActorSet;
}());
