var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var DisableType;
(function (DisableType) {
    DisableType["none"] = "none";
    DisableType["retain"] = "retain";
})(DisableType || (DisableType = {}));
var Scene_BaisyunMaseki = /** @class */ (function (_super) {
    __extends(Scene_BaisyunMaseki, _super);
    function Scene_BaisyunMaseki() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene_BaisyunMaseki.prototype.create = function () {
        _super.prototype.create.call(this);
        this._backlogDisabled = true;
        this.setup();
        this.createBackground();
        this.createPreviewWindow();
        this.createMasekiWindow();
        this.createDeckCardListWindow();
        this.createWindowLayer();
        this.createAllWindows();
        this.createLabelWindow();
        this.createIconSprite();
        this.createPageButtons();
    };
    Scene_BaisyunMaseki.prototype.setup = function () {
        this._actor = $gameParty.menuActor();
        this._baisyunPlayer = this._actor.baisyunPlayer();
        this._deck = this._baisyunPlayer.deck();
        this._storage = this._baisyunPlayer.storage();
        this._masekiSet = $gameParty.masekiActorSet().masekiSet(this._actor.actorId());
        this._deckCustom = new BaisyunDeckCustom(this._actor.actorId(), this._deck, this._storage);
    };
    Scene_BaisyunMaseki.prototype.createPageButtons = function () {
        this._pageupButton = new Sprite_Button("pageup");
        this._pageupButton.x = 124;
        this._pageupButton.y = this.buttonY();
        var pageupRight = this._pageupButton.x + this._pageupButton.width;
        this._pagedownButton = new Sprite_Button("pagedown");
        this._pagedownButton.x = pageupRight + 4;
        this._pagedownButton.y = this.buttonY();
        this.addChild(this._pageupButton);
        this.addChild(this._pagedownButton);
        this._pageupButton.setClickHandler(this.onPageUp.bind(this));
        this._pagedownButton.setClickHandler(this.onPageDown.bind(this));
    };
    Scene_BaisyunMaseki.prototype.buttonY = function () {
        return 80;
    };
    Scene_BaisyunMaseki.prototype.onPageUp = function () {
        this.previousActor();
    };
    Scene_BaisyunMaseki.prototype.onPageDown = function () {
        this.nextActor();
    };
    Scene_BaisyunMaseki.prototype.nextActor = function () {
        $gameParty.makeMenuActorNext();
        this.updateActor();
        this.onActorChange();
    };
    Scene_BaisyunMaseki.prototype.previousActor = function () {
        $gameParty.makeMenuActorPrevious();
        this.updateActor();
        this.onActorChange();
    };
    Scene_BaisyunMaseki.prototype.onActorChange = function () {
        SoundManager.playCursor();
    };
    Scene_BaisyunMaseki.prototype.updateActor = function () {
        this.setup();
        this._masekiWindow.setup(this._actor.actorId());
        this._deckCardWindow.setup(this._deckCustom);
        this._iconSprite.setup(this._actor);
        this._deckCardWindow.select(-1);
        this._deckCardWindow.select(0);
    };
    Scene_BaisyunMaseki.prototype.start = function () {
        _super.prototype.start.call(this);
        this.onMasekiChange();
        this.startInitialScenario();
    };
    Scene_BaisyunMaseki.prototype.startInitialScenario = function () {
        if ($gameSwitches.value(238)) {
            return;
        }
        $gameSwitches.setValue(238, true);
        this._masekiWindow.deactivate();
        this.playScenario('魔石画面_説明_01');
    };
    Scene_BaisyunMaseki.prototype.finishScenario = function () {
        _super.prototype.finishScenario.call(this);
        this._masekiWindow.activate();
    };
    Scene_BaisyunMaseki.prototype.createLabelWindow = function () {
        this._labelWindow1 = new Window_Label(TextManager.masekiInfo1, 30, 0, 700);
        this.addChild(this._labelWindow1);
        this._labelWindow2 = new Window_Label(TextManager.masekiInfo2, 30, 30, 700);
        this.addChild(this._labelWindow2);
    };
    Scene_BaisyunMaseki.prototype.createIconSprite = function () {
        this._iconSprite = new Sprite_ActorIcon(60, 90);
        this.addChild(this._iconSprite);
        this._iconSprite.setup(this._actor);
    };
    Scene_BaisyunMaseki.prototype.createBackground = function () {
        this._backgroundSprite = new Sprite();
        this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
        //this.addChild(this._backgroundSprite);
    };
    Scene_BaisyunMaseki.prototype.createMasekiWindow = function () {
        this._masekiWindow = new Window_Maseki();
        this._masekiWindow.setHandler('ok', this.onMasekiOk.bind(this));
        this._masekiWindow.setHandler('cancel', this.onMasekiCancel.bind(this));
        this._masekiWindow.setHandler('change', this.onMasekiChange.bind(this));
        this.addChild(this._masekiWindow);
        this._masekiWindow.setup(this._actor.actorId());
        this._masekiWindow.select(0);
        this._masekiWindow.activate();
    };
    Scene_BaisyunMaseki.prototype.onMasekiChange = function () {
        var maseki = this._masekiWindow.selectedMaseki();
        if (!maseki) {
            return;
        }
        var cardId = maseki.targetCardId();
        if (!cardId) {
            this._previewWindow.hideAll();
            return;
        }
        this._previewWindow.show();
        var set = this._storage.findSet(cardId);
        this._previewWindow.setCardSet(set, true);
    };
    Scene_BaisyunMaseki.prototype.onMasekiOk = function () {
        var maseki = this._masekiWindow.selectedMaseki();
        var type = maseki.targetCardType();
        var disableType = maseki.disableType();
        this._deckCardWindow.setEnableType(type);
        this._deckCardWindow.setDisableType(disableType);
        this._deckCardWindow.activate();
    };
    Scene_BaisyunMaseki.prototype.onMasekiCancel = function () {
        this.popScene();
    };
    Scene_BaisyunMaseki.prototype.createDeckCardListWindow = function () {
        this._deckCardWindow = new Window_DeckCardList();
        this._deckCardWindow.x -= 45;
        this._deckCardWindow.y = 50;
        //this._deckCardWindow.setHandler('shift', this.onDeckListShift.bind(this));
        this._deckCardWindow.setHandler('ok', this.onDeckListOk.bind(this));
        this._deckCardWindow.setHandler('cancel', this.onDeckListCancel.bind(this));
        this._deckCardWindow.setHandler('change', this.onDeckListChange.bind(this));
        this._deckCardWindow.setup(this._deckCustom);
        this._deckCardWindow.setHandler('touchCancel', this.onDeckListTouchCancel.bind(this));
        //this._deckCardWindow.setHandler('pageup', this.onPageup.bind(this));
        //this._deckCardWindow.setHandler('pagedown', this.onPagedown.bind(this));
        this.addChild(this._deckCardWindow);
        this._deckCardWindow.select(0);
    };
    Scene_BaisyunMaseki.prototype.onDeckListTouchCancel = function () {
        this._deckCardWindow.deactivate();
        SoundManager.playCancel();
        this.onDeckListCancel();
    };
    Scene_BaisyunMaseki.prototype.onDeckListChange = function () {
        var set = this._deckCardWindow.selectedSet();
        this._previewWindow.show();
        this._previewWindow.setCardSet(set, true);
    };
    Scene_BaisyunMaseki.prototype.onDeckListOk = function () {
        var set = this._deckCardWindow.selectedSet();
        var maseki = this._masekiWindow.selectedMaseki();
        this._masekiSet.equip(maseki, set.skillId());
        this._masekiWindow.refresh();
        this._masekiWindow.activate();
        this._deckCardWindow.refresh();
        this._previewWindow.refresh();
    };
    Scene_BaisyunMaseki.prototype.onDeckListCancel = function () {
        this._masekiWindow.activate();
    };
    Scene_BaisyunMaseki.prototype.createPreviewWindow = function () {
        var interval = 119;
        var yy = 434;
        this._cardEffectWindow = new Sprite_CardEffectHelp(yy);
        this.addChild(this._cardEffectWindow);
        this._cardEffectWindow2 = new Sprite_CardEffectHelp(yy + interval);
        this.addChild(this._cardEffectWindow2);
        this._cardEffectWindow3 = new Sprite_CardEffectHelp(yy + interval * 2);
        this.addChild(this._cardEffectWindow3);
        this._cardEffectWindow4 = new Sprite_CardEffectHelp(yy + interval * 3);
        this.addChild(this._cardEffectWindow4);
        this._previewWindow = new Window_DeckCardPreview(this._storage, this._cardEffectWindow, this._cardEffectWindow2, this._cardEffectWindow3, this._cardEffectWindow4);
        this.addChild(this._previewWindow);
        var offset = ConfigManager.isJp() ? 0 : -30;
        this._previewWindow.x = 580 + offset;
        this._previewWindow.y = 50;
        this._cardEffectWindow.x = this._previewWindow.x;
        this._cardEffectWindow2.x = this._previewWindow.x;
        this._cardEffectWindow3.x = this._previewWindow.x;
        this._cardEffectWindow4.x = this._previewWindow.x;
        this._previewWindow.setIsMaseki(true);
    };
    Scene_BaisyunMaseki.prototype.update = function () {
        _super.prototype.update.call(this);
        this.updateKey();
    };
    Scene_BaisyunMaseki.prototype.updateKey = function () {
        if (Input.isTriggered('pagedown')) {
            this.onPageDown();
        }
        if (Input.isTriggered('pageup')) {
            this.onPageUp();
        }
    };
    return Scene_BaisyunMaseki;
}(Nore.Scene_Talk));
var Window_Maseki = /** @class */ (function (_super) {
    __extends(Window_Maseki, _super);
    function Window_Maseki() {
        var xx = ConfigManager.isJp() ? 50 : 20;
        var r = new Rectangle(xx, 140, 520, 600);
        return _super.call(this, r) || this;
    }
    Window_Maseki.prototype.setup = function (actorId) {
        this._actorId = actorId;
        this.makeData();
        this.refresh();
    };
    Window_Maseki.prototype.maxItems = function () {
        if (this._itemList) {
            return this._itemList.length;
        }
        return 0;
    };
    Window_Maseki.prototype.makeData = function () {
        var masekiSet = $gameParty.masekiActorSet().masekiSet(this._actorId);
        this._itemList = masekiSet.list();
    };
    Window_Maseki.prototype.maxCols = function () {
        return 1;
    };
    Window_Maseki.prototype.drawItem = function (index) {
        var maseki = this._itemList[index];
        var rect = this.itemRect(index);
        this.drawText(maseki.name(), rect.x + 32, rect.y, 210);
        this.drawIcon(maseki.iconIndex(), rect.x, rect.y);
        var cardId = maseki.targetCardId();
        if (cardId > 0) {
            var skill = $dataSkills[cardId];
            var name_1 = getItemName(skill);
            this.drawText('> ' + name_1, rect.x + 250, rect.y, 220);
        }
        else {
            this.drawText('> ' + TextManager.masekiNotEquipped, rect.x + 250, rect.y, 220);
        }
    };
    Window_Maseki.prototype.selectedMaseki = function () {
        return this._itemList[this.index()];
    };
    return Window_Maseki;
}(Window_Selectable));
var Sprite_ActorIcon = /** @class */ (function (_super) {
    __extends(Sprite_ActorIcon, _super);
    function Sprite_ActorIcon(x, y) {
        var _this = _super.call(this) || this;
        _this.x = x;
        _this.y = y;
        _this.bitmap = new Bitmap(32, 32);
        return _this;
    }
    Sprite_ActorIcon.prototype.setup = function (actor) {
        this.bitmap.clear();
        this.drawIcon(actor.iconIndex(), 0, 0);
    };
    return Sprite_ActorIcon;
}(Sprite));
